package com.kuaike.scrm.common.service.dto.req.qrcode;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * @author Created by chenjiaqiang on 2022/09/15
 **/
@Data
public class GenQrcodeReq implements Serializable {

    private Long bizId;

    private Integer autoPass;

    private String weworkUserNum;

    private String state;

    public void validate() {
        Preconditions.checkArgument(bizId != null ,"bizId不能为空");
        Preconditions.checkArgument(autoPass != null ,"autoPass不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(weworkUserNum),"weworkUserNum不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(state),"state不能为空");
    }
}
