package com.kuaike.scrm.common.service;

import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import com.kuaike.scrm.common.service.dto.resp.NetSchoolAppResp;

import java.util.List;

/**
 * @author sunwen
 *
 * 对外提供dubbo接口服务
 */
public interface ScrmBizService {

    /**
     * 根据企业id获取对应记录的加密id
     *
     * @param corpId 企业id
     * @return 加密id
     */
    String getBizNumByCorpId(String corpId);

    /**
     * 根据加密id获取对应的
     *
     * @param num 加密id
     * @return 企业id
     */
    String getCorpIdByNum(String num);

    /**
     * 获取所有的企业id
     *
     * @return 企业id集合
     */
    List<String> getAllCorpIds();

    /**
     * 获取所有的商户ID
     * @return
     */
    List<BizSimpleDto> getAll();

    /**
     * 根据id查询商户信息
     *
     * @param id
     * @return
     */
    BizSimpleDto getById(Long id);

    /**
     * 根据num查询商户信息
     *
     * @param num
     * @return
     */
    BizSimpleDto getByNum(String num);

    /**
     * 根据corpId查询商户信息
     *
     * @param corpId
     * @return
     */
    BizSimpleDto getByCorpId(String corpId);

    /**
     * 商户是否开通crm
     *
     * @param bizId 商户id
     * @return true:是 false:否
     */
    Boolean isOpenCrm(Long bizId);

    /**
     * 获取商户对应的网校应用信息
     *
     * @param bizId 商户id
     * @return 网校应用信息
     */
    NetSchoolAppResp getNetSchoolAppResp(Long bizId);


    /**
     *  商户是否开通标签同步
     * */
    Boolean isOpenSyncTag(Long bizId);
}
