package com.kuaike.scrm.common.service.dto;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Objects;

@Data
public class PayOrderReq implements Serializable {

    private Long bizId;

    private String corpId;

    private Long opUserId;

    private String orderNo;
    /**
     * 支付能力 1：微信扫码支付；2：微信APP支付；3：微信h5支付; 4:微信公众号支付；5:微信小程序支付； 7：支付宝扫码支付；8：支付宝APP支付；9：支付宝h5支付；10：支付宝pc网站支付
     */
    private Integer payChannelType;
    /**
     * 订单总金额 单位是厘
     */
    private Long totalAmount;
    /**
     * 本次支付金额 单位是厘
     */
    private Long payAmount;

    private String requestId;

    //发起支付后得到的支付信息 类型是OrderData
    private String payInfo;

    public void validate() {
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(corpId), "corpId不能为空");
        Preconditions.checkArgument(opUserId != null, "操作人");
        Preconditions.checkArgument(StringUtils.isNotBlank(orderNo), "orderNo is null or empty");
        Preconditions.checkArgument(Objects.nonNull(totalAmount), "totalAmount is null");
        Preconditions.checkArgument(Objects.nonNull(payAmount), "payAmount is null");
        Preconditions.checkArgument(totalAmount >= payAmount, "totalAmount must bigger then payAmount");
    }
}
