package com.kuaike.scrm.common.service.dto.req;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

@Data
public class ScrmMsgReqDto {
    /**
     * 发送人
     **/
    private String from;
    /**
     * 接收人
     **/
    private String to;
    private Date startTime;
    private Date endTime;

    public boolean validate(){
        if (StringUtils.isAnyBlank(from,to)){
            return false;
        }
        if (startTime == null || endTime == null){
            return false;
        }
        return true;
    }
}
