package com.kuaike.scrm.common.service.dto.resp;

import lombok.Data;

import java.io.Serializable;

/**
 * 公众号信息
 *
 * @author lanye
 */
@Data
public class OfficialResp implements Serializable {
    /**
     * 商户id
     */
    private Long bizId;

    /**
     * 企业id
     */
    private String corpId;

    /**
     * 组织架构id
     */
    private Long nodeId;

    /**
     * 授权方APPID/公众号APPID
     */
    private String appId;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * 头像
     *
     * @Column(name = "head_img")
     * private String headImg;
     * <p>
     * /**
     * 公众号类型：0，订阅号；1，历史老账号升级之后的订阅号；2，服务号；
     */
    private Integer serviceType;

    /**
     * 授权方认证类型：-1，未认证；0，微信认证；1，新浪微博认证；2，腾讯微博认证；3，资质认证通过但还未通过名称认证；4，资质认证通过，还未通过名称认证，但是通过了新浪微博认证；5 资质认证通过，还未通过名称认证，但是通过了腾讯微博认证；
     */
    private Integer verifyType;

    /**
     * 授权方公众号的原始ID
     */
    private String userName;

    /**
     * 公众号主体名称
     */
    private String principalName;

    /**
     * 授权方公众号所设置的微信号，可能为空
     */
    private String alias;
}
