package com.kuaike.scrm.common.service.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.NoticeType;
import com.kuaike.scrm.common.service.dto.req.notice.NoticeExtendParam;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@NoArgsConstructor
@AllArgsConstructor
@Data
public class AddNoticeReq implements Serializable {
    private static final long serialVersionUID = 1981083965739839376L;

    private Long bizId;

    /**
     * 提醒类型
     *
     * @link {com.kuaike.scrm.common.enums.NoticeType}
     */
    private Integer type;

    /**
     * 接收部门, 可以为空
     */
    private Long nodeId;

    /**
     * 接收人
     */
    private Long receiveUserId;

    /**
     * 提醒消息内容
     */
    private String message;

    /**
     * 提醒时间
     */
    private Date noticeTime;

    private String customerNum;

    private NoticeExtendParam noticeExtendParam;

    public void validate() {
        Preconditions.checkArgument(NoticeType.getByType(type) != null, "type 不能为空");
        Preconditions.checkArgument(null != receiveUserId, "receiveUserId不能为空");
        Preconditions.checkArgument(noticeTime != null, "noticeTime不能为空");
    }
}
