/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wwlogin.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.callback.service.SuiteAuthService;
import com.kuaike.scrm.common.enums.WeworkCorpSyncStatus;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.wwlogin.dto.CorpSettings;
import com.kuaike.scrm.wwlogin.dto.req.CheckReq;
import com.kuaike.scrm.wwlogin.dto.req.LoginReq;
import com.kuaike.scrm.wwlogin.dto.resp.ErrorResult;
import com.kuaike.scrm.wwlogin.dto.resp.Member;
import com.kuaike.scrm.wwlogin.dto.resp.QrcodeCheck;
import com.kuaike.scrm.wwlogin.dto.resp.QrcodeKey;
import com.kuaike.scrm.wwlogin.dto.resp.WwResult;
import com.kuaike.scrm.wwlogin.service.WwbotService;
import com.kuaike.scrm.wwlogin.service.WwloginService;
import com.kuaike.scrm.wwlogin.utils.BotLoginUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Deprecated
public class WwloginServiceImpl
implements WwloginService {
    private static final Logger log = LoggerFactory.getLogger(WwloginServiceImpl.class);
    @Autowired
    private WwbotService wwbotService;
    @Autowired
    private SuiteAuthService suiteAuthService;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;

    @Override
    public String admin() {
        Long bizId = LoginUtils.getCurrentUserBizId();
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        BusinessCustomer authBiz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfoByBizIdAndAuthUserId(bizId, authBiz.getApplyWeworkUserId());
        if (weworkUser == null) {
            return null;
        }
        if (Objects.equals(authBiz.getApplyWeworkUserId(), weworkUser.getName())) {
            return "";
        }
        return weworkUser.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String qrcodeKey() {
        log.info("get qrcode_key, operatorId:{}", (Object)LoginUtils.getCurrentUserId());
        BotLoginUtils.clearCookie();
        StringBuilder sb = new StringBuilder();
        sb.append("https://work.weixin.qq.com/wework_admin/wwqrlogin/get_key");
        sb.append("?r=").append(Math.random());
        sb.append("&login_type=login_admin&crossorigin=1");
        String url = sb.toString();
        HttpGet request = new HttpGet(url);
        BotLoginUtils.addBasicHeaders((HttpMessage)request);
        BotLoginUtils.addAjaxHeaders((HttpMessage)request);
        request.setHeader("accept", "*/*");
        request.setHeader("referer", "https://work.weixin.qq.com/wework_admin/wwqrlogin/login_qrcode?login_type=login_admin&callback=wwqrloginCallback_1620733774250&redirect_uri=https%3A%2F%2Fwork.weixin.qq.com%2Fwework_admin%2Floginpage_wx%3Fpagekey%3D1620733774250850%26from%3Dmyhome&crossorigin=1");
        RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        request.setConfig(config);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        String result = null;
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            response.close();
        }
        catch (IOException e) {
            log.error("Failed get qrcodeKey", (Throwable)e);
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {}
        }
        log.info("qrcodeKey result: {}", (Object)result);
        WwResult wwResult = null;
        try {
            wwResult = (WwResult)JacksonUtil.str2Obj((String)result, (TypeReference)new TypeReference<WwResult<QrcodeKey>>(){});
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (wwResult != null && wwResult.getData() != null) {
            return ((QrcodeKey)wwResult.getData()).getQrcodeKey();
        }
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u4e8c\u7ef4\u7801\u5931\u8d25");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QrcodeCheck check(CheckReq params) {
        log.info("check qrcode, params:{}, operatorId:{}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        String qrcodeKey = params.getQrcodeKey();
        String status = params.getStatus();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)qrcodeKey), (Object)"qrcodeKey is blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)status), (Object)"status is blank");
        StringBuilder sb = new StringBuilder();
        sb.append("https://work.weixin.qq.com/wework_admin/wwqrlogin/check");
        sb.append("?qrcode_key=").append(qrcodeKey);
        sb.append("&status=").append(status);
        sb.append("&r=").append(Math.random());
        String url = sb.toString();
        HttpGet request = new HttpGet(url);
        BotLoginUtils.addBasicHeaders((HttpMessage)request);
        BotLoginUtils.addAjaxHeaders((HttpMessage)request);
        request.addHeader("accept", "*/*");
        request.addHeader("referer", "https://work.weixin.qq.com/wework_admin/wwqrlogin/login_qrcode?login_type=login_admin&callback=wwqrloginCallback_1620733774250&redirect_uri=https%3A%2F%2Fwork.weixin.qq.com%2Fwework_admin%2Floginpage_wx%3Fpagekey%3D1620733774250850%26from%3Dmyhome&crossorigin=1");
        RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(30000).build();
        request.setConfig(config);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        String result = null;
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            response.close();
        }
        catch (IOException e) {
            log.error("Failed check qrcode, key:{}", (Object)qrcodeKey, (Object)e);
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {}
        }
        log.info("check result: {}", (Object)result);
        WwResult wwResult = null;
        try {
            wwResult = (WwResult)JacksonUtil.str2Obj((String)result, (TypeReference)new TypeReference<WwResult<QrcodeCheck>>(){});
        }
        catch (IOException e) {
            log.error("Failed parse json:{}", (Object)result, (Object)e);
        }
        if (wwResult != null) {
            ErrorResult err;
            if (wwResult.getData() != null) {
                return (QrcodeCheck)wwResult.getData();
            }
            if (wwResult.getResult() != null && (err = wwResult.getResult()).getErrCode() == -31024) {
                QrcodeCheck check = new QrcodeCheck();
                check.setStatus("QRCODE_SCAN_TIMEOUT");
                log.info("\u9875\u9762\u5df2\u8fc7\u671f");
                return check;
            }
        }
        QrcodeCheck check = new QrcodeCheck();
        check.setStatus("QRCODE_SCAN_TIMEOUT");
        return check;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean login(LoginReq params) {
        log.info("login, params:{}, operatorId:{}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        String qrcodeKey = params.getQrcodeKey();
        String authCode = params.getAuthCode();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)qrcodeKey), (Object)"qrcodeKey is blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)authCode), (Object)"authCode is blank");
        StringBuilder sb = new StringBuilder();
        sb.append("https://work.weixin.qq.com/wework_admin/loginpage_wx");
        sb.append("?pagekey=").append(System.currentTimeMillis()).append((int)(Math.random() * 1000.0));
        sb.append("&code=").append(authCode);
        sb.append("&wwqrlogin=1");
        sb.append("&qrcode_key=").append(qrcodeKey);
        sb.append("&auth_source=SOURCE_FROM_WEWORK");
        String url = sb.toString();
        HttpGet request = new HttpGet(url);
        BotLoginUtils.addBasicHeaders((HttpMessage)request);
        BotLoginUtils.addDocumentHeaders((HttpMessage)request);
        request.setHeader("upgrade-insecure-requests", "1");
        request.setHeader("referer", "https://work.weixin.qq.com/wework_admin/wwqrlogin/login_qrcode?login_type=login_admin&callback=wwqrloginCallback_1620733774250&redirect_uri=https%3A%2F%2Fwork.weixin.qq.com%2Fwework_admin%2Floginpage_wx%3Fpagekey%3D1620733774250850%26from%3Dmyhome&crossorigin=1");
        RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).setCookieSpec("standard").build();
        request.setConfig(config);
        CloseableHttpClient httpClient = HttpClientBuilder.create().disableRedirectHandling().build();
        boolean isFirstLogin = false;
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            log.info("login status: {}", (Object)response.getStatusLine());
            int code = response.getStatusLine().getStatusCode();
            for (int redirects = 0; code == 302 || redirects < 3; ++redirects) {
                BotLoginUtils.cacheCookies(response);
                Header header = response.getFirstHeader("location");
                if (header == null) {
                    log.warn("location not found!!!!");
                    break;
                }
                String location = header.getValue();
                log.info("redirect#{}: {}", (Object)redirects, (Object)location);
                response.close();
                httpClient.close();
                httpClient = null;
                HttpGet redirectRequest = new HttpGet("https://work.weixin.qq.com" + location);
                redirectRequest.setConfig(config);
                BotLoginUtils.addBasicHeaders((HttpMessage)redirectRequest);
                BotLoginUtils.addDocumentHeaders((HttpMessage)redirectRequest);
                BotLoginUtils.addCookieHeader((HttpMessage)redirectRequest);
                redirectRequest.setHeader("upgrade-insecure-requests", "1");
                redirectRequest.setHeader("referer", "https://work.weixin.qq.com/wework_admin/wwqrlogin/login_qrcode?login_type=login_admin&callback=wwqrloginCallback_1620733774250&redirect_uri=https%3A%2F%2Fwork.weixin.qq.com%2Fwework_admin%2Floginpage_wx%3Fpagekey%3D1620733774250850%26from%3Dmyhome&crossorigin=1");
                httpClient = HttpClientBuilder.create().disableRedirectHandling().build();
                response = httpClient.execute((HttpUriRequest)redirectRequest);
                code = response.getStatusLine().getStatusCode();
                if (!location.startsWith("/wework_admin/frame")) continue;
                isFirstLogin = true;
                String html = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                isFirstLogin = this.parseFramePage(html);
                break;
            }
            BotLoginUtils.cacheCookies(response);
        }
        catch (IOException e) {
            log.error("Login failed", (Throwable)e);
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException iOException) {}
        }
        log.info("login result: {}", (Object)isFirstLogin);
        return isFirstLogin;
    }

    private boolean parseFramePage(String html) {
        Pattern pattern = Pattern.compile("window\\.settings\\s*=[^;]+;");
        Matcher matcher = pattern.matcher(html);
        if (!matcher.find()) {
            return false;
        }
        String windowSettings = matcher.group();
        int start = windowSettings.indexOf("{");
        int end = windowSettings.length() - 1;
        String json = windowSettings.substring(start, end);
        log.info("window.settings = {}", (Object)json);
        try {
            BotLoginUtils.getSession().setAttribute("window.settings", (Object)json);
            CorpSettings settings = (CorpSettings)JacksonUtil.str2Obj((String)json, CorpSettings.class);
            BotLoginUtils.getSession().setAttribute("window.settings.encode_corp_id", (Object)settings.getEncodeCorpId());
            log.info("parsed window.settings = {}", (Object)settings);
            return true;
        }
        catch (IOException e) {
            log.error("\u89e3\u6790 window.settings \u5931\u8d25, settings={}", (Object)json, (Object)e);
            return false;
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String initBiz() {
        CorpSettings settings;
        Long bizId = LoginUtils.getCurrentUserBizId();
        Long userId = LoginUtils.getCurrentUserId();
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        log.info("initialize business customer, bizId={}, operatorId={}", (Object)bizId, (Object)userId);
        String json = (String)BotLoginUtils.getSession().getAttribute("window.settings");
        try {
            settings = (CorpSettings)JacksonUtil.str2Obj((String)json, CorpSettings.class);
        }
        catch (IOException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u626b\u7801\u767b\u5f55\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        BusinessCustomer authBiz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        String bizName = authBiz.getName();
        String corpName = settings.getCorpFullName();
        if (StringUtils.isBlank((CharSequence)corpName)) {
            corpName = settings.getCorpAlias();
        }
        if (!bizName.equals(corpName)) {
            log.warn("corp name differs: biz.name={}, corp.name={}", (Object)bizName, (Object)corpName);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u4f7f\u7528\u6388\u6743\u4f01\u4e1a[" + bizName + "]\u7684\u7ba1\u7406\u5458\u8d26\u53f7\u91cd\u65b0\u626b\u7801\u3002");
        }
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfoByBizIdAndAuthUserId(bizId, authBiz.getApplyWeworkUserId());
        if (weworkUser != null && StringUtils.isNotBlank((CharSequence)weworkUser.getName())) {
            String userName = settings.getName();
            String applyUserName = weworkUser.getName();
            if (!applyUserName.equals(userName)) {
                log.warn("admin user name differs: loginUserName={}, applyUserName={}", (Object)userName, (Object)applyUserName);
            }
        }
        String corpId = settings.getEncodeCorpId();
        String authCorpId = authBiz.getAuthCorpId();
        String authUserId = authBiz.getApplyWeworkUserId();
        Member member = null;
        List<Member> list = this.wwbotService.member();
        for (Member it : list) {
            if (!it.getVid().equals(settings.getVid())) continue;
            member = it;
            break;
        }
        String weworkUserId = member == null ? null : member.getAcctid();
        Long existBizId = this.businessCustomerMapper.getExistBizId(corpId);
        if (existBizId != null && !existBizId.equals(bizId)) {
            BusinessCustomer existBiz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)existBizId);
            this.suiteAuthService.resetAuthCorpIdByCorpId(existBiz, authBiz, authCorpId, authUserId, corpId, weworkUserId);
        } else {
            this.suiteAuthService.resetCorpIdByAuthCorpId(bizId, authCorpId, authUserId, corpId, weworkUserId);
            if (authBiz.getSyncStatus().intValue() == WeworkCorpSyncStatus.INIT_SUITE.getValue()) {
                this.suiteAuthService.initBiz(bizId);
                this.businessCustomerMapper.updateSyncStatus(bizId, Integer.valueOf(WeworkCorpSyncStatus.MATCH_CORP_ID.getValue()));
            }
        }
        return authCorpId;
    }
}

