/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.weworkuser.service.impl;

import cn.kinyun.crm.common.service.CrmConfigService;
import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.LeadsStatisticsReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;
import cn.kinyun.crm.common.service.dto.resp.OrderAmountConfResp;
import cn.kinyun.customer.center.dto.req.QueryOrderListReq;
import cn.kinyun.customer.center.dto.req.QueryPayRecordListReq;
import cn.kinyun.customer.center.dto.req.follow.FollowQueryParams;
import cn.kinyun.customer.center.dto.resp.FollowListResp;
import cn.kinyun.customer.center.dto.resp.OrderTotalResp;
import cn.kinyun.customer.center.dto.resp.PagePayRecordResp;
import cn.kinyun.customer.center.dto.resp.PayRecordListResp;
import cn.kinyun.customer.center.service.CcCustomerFollowRecordService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.customer.center.service.CcCustomerPayRecordService;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.WeekDayEnums;
import com.kuaike.scrm.common.enums.WeworkNotifyTypeEnums;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.PriceUtils;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.dto.ContactRelationDto;
import com.kuaike.scrm.dal.wework.dto.ContactRelationParams;
import com.kuaike.scrm.dal.wework.dto.WeworkUserInfo;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkNotify;
import com.kuaike.scrm.dal.wework.entity.WeworkNotifyLog;
import com.kuaike.scrm.dal.wework.entity.WeworkNotifyWeekDetail;
import com.kuaike.scrm.dal.wework.entity.WeworkNotifyWeekDetailCriteria;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkNotifyLogMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkNotifyMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkNotifyWeekDetailMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.event.context.WeworkNotifyEvent;
import com.kuaike.scrm.wework.contact.dto.KeyName;
import com.kuaike.scrm.wework.weworkuser.dto.WeworkNotifyDetailDto;
import com.kuaike.scrm.wework.weworkuser.dto.WeworkNotifyDto;
import com.kuaike.scrm.wework.weworkuser.service.WeworkNotifyService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

@Service
public class WeworkNotifyServiceImpl
implements WeworkNotifyService {
    private static final Logger log = LoggerFactory.getLogger(WeworkNotifyServiceImpl.class);
    private static final String SPLIT_KEY = ",";
    private static final String SELL_DAILY_HEADER = "\u3010\u9500\u552e\u65e5\u62a5\u3011\uff1a\n";
    private static final String MAKE_DEAL_HEADER = "\u3010\u6210\u5355\u559c\u62a5\u3011\uff1a\n";
    private static final String SELL_DAILY_CONTENT = "{username}: \u4eca\u65e5\u65b0\u589e\u5ba2\u6237{addCustomerNum}\u4eba,\u8ddf\u8fdb\u5ba2\u6237{followRecordCount}\u4eba\uff0c\u6210\u4ea4\u8ba2\u5355{addOrderNum}\u5355";
    private static final String MAKE_DEAL_CONTENT = " \u606d\u559c\uff01{username}\u6210\u4ea4\u5ba2\u6237\uff08{customerName}\uff09\uff0c\u6210\u4ea4\u91d1\u989d\u00a5{orderAmount}\u5143\u3002";
    private static final String DEFAULT_NOTIFY_TIME = "17:00";
    private static final String DEFAULT_CRM_LEADS_NOTIFY_TIME = "08:00,22:30";
    @Value(value="${kafka.topic.wework.notify}")
    private String notifyTopic;
    @Autowired
    private WeworkNotifyMapper weworkNotifyMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private OrganizationMapper organizationMapper;
    @Autowired
    private WeworkNotifyWeekDetailMapper weworkNotifyWeekDetailMapper;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private CcCustomerOrderService customerOrderService;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;
    @Autowired
    private CcCustomerFollowRecordService customerFollowRecordService;
    @Autowired
    private CcCustomerNumService customerNumService;
    @Autowired
    private CrmLeadsService crmLeadsService;
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private CrmConfigService crmConfigService;
    @Resource
    private WeworkNotifyLogMapper weworkNotifyLogMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Value(value="${wework.notify.inited:false}")
    private String notifyInited;
    @Resource
    private ScrmBizService scrmBizService;
    @Resource
    private CcCustomerPayRecordService customerPayRecordService;
    @Resource
    private WeworkUserMapper weworkUserMapper;

    @Override
    public void init() {
        List weworkCorps = this.weworkCorpMapper.selectAllAuthed();
        for (WeworkCorp wc : weworkCorps) {
            this.init(wc.getBizId(), wc.getCorpId());
        }
    }

    @Override
    public void init(Long bizId, String corpId) {
        if (Objects.isNull(bizId) || StringUtils.isBlank((CharSequence)corpId)) {
            log.info("bizId \u6216\u8005 corpId\u4e3a\u7a7a \uff1abizId:{},corpID:{}", (Object)bizId, (Object)corpId);
            return;
        }
        List<WeworkNotifyWeekDetail> insertList = this.addWeworkNotify(WeworkNotifyTypeEnums.MAKE_DEAL_NOTIFY, corpId, bizId, true);
        List<WeworkNotifyWeekDetail> sellDailDetails = this.addWeworkNotify(WeworkNotifyTypeEnums.SELL_DAILY_NOTIFY, corpId, bizId, true);
        List<WeworkNotifyWeekDetail> leadsBinds = this.addWeworkNotify(WeworkNotifyTypeEnums.LEADS_BIND_NOTIFY, corpId, bizId, true);
        List<WeworkNotifyWeekDetail> leadsUnBinds = this.addWeworkNotify(WeworkNotifyTypeEnums.LEADS_UNBIND_NOTIFY, corpId, bizId, true);
        insertList.addAll(sellDailDetails);
        insertList.addAll(leadsBinds);
        insertList.addAll(leadsUnBinds);
        if (CollectionUtils.isNotEmpty(insertList)) {
            this.weworkNotifyWeekDetailMapper.insertBatch(insertList);
        }
    }

    @Override
    public List<WeworkNotifyDto> queryList(WeworkNotifyDto notifyDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        WeworkNotify entity = new WeworkNotify();
        entity.setStatus(YnEnum.YES.getValue());
        entity.setBizId(currentUser.getBizId());
        List select = this.weworkNotifyMapper.select((Object)entity);
        return this.entitiesToDtos(select);
    }

    @Override
    public void edit(WeworkNotifyDto notifyDto) {
        notifyDto.validateEdit();
        WeworkNotify weworkNotify = this.dtoToEntityAndSave(notifyDto);
        this.weworkNotifyMapper.updateByPrimaryKeySelective((Object)weworkNotify);
    }

    @Override
    public void startTask() {
        int todayOfWeek = DateUtil.getTodayOfWeek();
        List byWhichWeekday = this.weworkNotifyMapper.getByWhichWeekday(null, null, (Collection)Lists.newArrayList((Object[])new Integer[]{todayOfWeek}));
        List<WeworkNotify> realNotifyEntitys = this.filterByTime(byWhichWeekday);
        if (CollectionUtils.isEmpty(realNotifyEntitys)) {
            log.info("\u3010weworkNotify\u3011\u5f53\u524d\u4efb\u52a1\u65e0\u9700\u8981\u901a\u77e5\u6d88\u606f");
            return;
        }
        log.info("\u3010weworkNotify\u3011\u9700\u8981\u901a\u77e5\u7684\u4f01\u4e1a\u4fe1\u606f\u672a\uff1a{}", (Object)JSON.toJSONString(realNotifyEntitys));
        Map<Long, List<WeworkNotify>> groupByBiz = realNotifyEntitys.stream().collect(Collectors.groupingBy(WeworkNotify::getBizId));
        for (Map.Entry<Long, List<WeworkNotify>> groupByBizNotify : groupByBiz.entrySet()) {
            Map<Integer, List<WeworkNotify>> groupByNotifyType = groupByBizNotify.getValue().stream().collect(Collectors.groupingBy(WeworkNotify::getNotifyType));
            if (MapUtils.isEmpty(groupByNotifyType)) {
                log.info("\u3010weworkNotify\u3011\u6ca1\u6709\u914d\u7f6e\u6d88\u606f\u901a\u77e5\u7c7b\u578b\uff1a{}", (Object)JSON.toJSONString(groupByBizNotify));
                continue;
            }
            List messageFrom = this.userMapper.getUserInfo(groupByBizNotify.getKey(), null, null);
            if (CollectionUtils.isEmpty((Collection)messageFrom)) {
                log.info("\u3010weworkNotify\u3011\u6d88\u606f\u63a5\u53d7\u8005\u4e3a\u7a7a:{}", (Object)JSON.toJSONString((Object)messageFrom));
                continue;
            }
            ArrayList allTargetNotify = Lists.newArrayList();
            for (Map.Entry<Integer, List<WeworkNotify>> notifyType : groupByNotifyType.entrySet()) {
                List<WeworkUserInfo> receiveInfo = this.getReceiveWorkOrderNum(groupByBizNotify.getKey(), notifyType.getValue());
                if (CollectionUtils.isEmpty(receiveInfo)) continue;
                Long notifyId = CollectionUtils.isNotEmpty((Collection)notifyType.getValue()) ? notifyType.getValue().get(0).getId() : null;
                log.info("\u3010weworkNotify\u3011notify receiveInfo:{}", (Object)JSON.toJSONString(receiveInfo));
                WeworkNotifyEvent notify = this.notify(groupByBizNotify.getKey(), WeworkNotifyTypeEnums.get((Integer)notifyType.getKey()), receiveInfo, messageFrom, notifyId);
                if (!Objects.nonNull(notify)) continue;
                allTargetNotify.add(notify);
            }
            log.info("\u3010weworkNotify\u3011\u5f53\u524d\u5546\u6237\u4e0b\u6240\u6709\u901a\u77e5\u6d88\u606f\u4e3a\uff1a:{}", (Object)allTargetNotify);
            if (!CollectionUtils.isNotEmpty((Collection)allTargetNotify)) continue;
            this.kafkaTemplate.send(this.notifyTopic, (Object)JSON.toJSONString((Object)allTargetNotify));
        }
    }

    private WeworkNotifyDto entityToDto(WeworkNotify entity, Map<String, String> userInfos, Map<String, String> depInfos) {
        if (Objects.isNull(entity)) {
            return null;
        }
        WeworkNotifyDto dto = new WeworkNotifyDto();
        dto.setNotifyTypeStr(WeworkNotifyTypeEnums.getWeworkNotifyTypeDesc((Integer)entity.getNotifyType()));
        dto.setNotifyType(entity.getNotifyType());
        dto.setBizId(entity.getBizId());
        dto.setId(entity.getId());
        dto.setNotifySwitch(entity.getNotifySwitch());
        List notifyTimes = Optional.ofNullable(entity.getNotifyTime()).map(item -> Arrays.asList(item.split(SPLIT_KEY))).orElse(Lists.newArrayList());
        dto.setWhichTimes(notifyTimes);
        List weworkNotifyWeekDetails = this.weworkNotifyWeekDetailMapper.queryByNotifyId(LoginUtils.getCurrentUserBizId(), entity.getId());
        List<KeyName<Integer>> weekDays = weworkNotifyWeekDetails.stream().map(item -> {
            KeyName<Integer> week = new KeyName<Integer>();
            Integer weekEnumKey = item.getWeekday();
            week.setKey(weekEnumKey);
            week.setName(WeekDayEnums.getWeekDayDesc((Integer)weekEnumKey));
            return week;
        }).collect(Collectors.toList());
        dto.setWhichWeekdays(weekDays);
        List userIds = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)entity.getUserIds())) {
            userIds = Optional.ofNullable(entity.getUserIds()).map(item -> Arrays.asList(item.split(SPLIT_KEY))).orElse(Lists.newArrayList());
        }
        List depIds = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)entity.getDepIds())) {
            depIds = Optional.ofNullable(entity.getDepIds()).map(item -> Arrays.asList(item.split(SPLIT_KEY))).orElse(Lists.newArrayList());
        }
        List<KeyName<String>> userInfo = userIds.stream().map(item -> {
            String userName = (String)userInfos.get(item);
            KeyName<String> user = new KeyName<String>();
            user.setKey((String)item);
            user.setName(userName);
            return user;
        }).collect(Collectors.toList());
        List<KeyName<String>> depInfo = depIds.stream().map(depId -> {
            String depName = (String)depInfos.get(depId);
            KeyName<String> user = new KeyName<String>();
            user.setKey((String)depId);
            user.setName(depName);
            return user;
        }).collect(Collectors.toList());
        dto.setDepInfo(depInfo);
        dto.setUserInfo(userInfo);
        return dto;
    }

    private List<WeworkNotifyDto> entitiesToDtos(List<WeworkNotify> weworkNotifyList) {
        if (CollectionUtils.isEmpty(weworkNotifyList)) {
            return Lists.newArrayList();
        }
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        List depIds = weworkNotifyList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getDepIds())).map(item -> Arrays.asList(item.getDepIds().split(SPLIT_KEY))).flatMap(Collection::stream).collect(Collectors.toList());
        List userIds = weworkNotifyList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getUserIds())).map(item -> Arrays.asList(item.getUserIds().split(SPLIT_KEY))).flatMap(Collection::stream).collect(Collectors.toList());
        Map userInfos = this.weworkUserMapper.queryWeworkUserNameMapByNums(currentUser.getCorpId(), userIds);
        Map depInfos = this.organizationMapper.getOrgNameByIds(currentUser.getBizId(), depIds);
        return weworkNotifyList.stream().map(weworkNotify -> this.entityToDto((WeworkNotify)weworkNotify, userInfos, depInfos)).collect(Collectors.toList());
    }

    private WeworkNotify dtoToEntityAndSave(WeworkNotifyDto dto) {
        if (Objects.isNull(dto)) {
            return null;
        }
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        WeworkNotify entity = new WeworkNotify();
        if (CollectionUtils.isNotEmpty(dto.getDepInfo())) {
            String depIds = dto.getDepInfo().stream().map(item -> String.valueOf(item.getKey())).collect(Collectors.joining(SPLIT_KEY));
            entity.setDepIds(depIds);
        } else {
            entity.setDepIds("");
        }
        if (CollectionUtils.isNotEmpty(dto.getUserInfo())) {
            String userIds = dto.getUserInfo().stream().map(item -> String.valueOf(item.getKey())).collect(Collectors.joining(SPLIT_KEY));
            entity.setUserIds(userIds);
        } else {
            entity.setUserIds("");
        }
        if (CollectionUtils.isNotEmpty(dto.getWhichTimes())) {
            String notifyTimes = String.join((CharSequence)SPLIT_KEY, dto.getWhichTimes());
            entity.setNotifyTime(notifyTimes);
        } else {
            entity.setNotifyTime("");
        }
        if (CollectionUtils.isNotEmpty(dto.getWhichWeekdays())) {
            List frontWeekdays = dto.getWhichWeekdays().stream().map(KeyName::getKey).collect(Collectors.toList());
            WeworkNotifyWeekDetail notifyWeekDetail = new WeworkNotifyWeekDetail();
            notifyWeekDetail.setBizId(currentUser.getBizId());
            notifyWeekDetail.setNotifyId(dto.getId());
            List existWeekDetails = this.weworkNotifyWeekDetailMapper.select((Object)notifyWeekDetail);
            List existWeekDays = existWeekDetails.stream().map(WeworkNotifyWeekDetail::getWeekday).collect(Collectors.toList());
            ArrayList shouldRemove = Lists.newArrayList(existWeekDays);
            shouldRemove.removeAll(frontWeekdays);
            ArrayList shouldAdd = Lists.newArrayList(frontWeekdays);
            shouldAdd.removeAll(existWeekDays);
            if (CollectionUtils.isNotEmpty((Collection)shouldRemove)) {
                WeworkNotifyWeekDetailCriteria delDetailCri = new WeworkNotifyWeekDetailCriteria();
                delDetailCri.createCriteria().andBizIdEqualTo(currentUser.getBizId()).andNotifyIdEqualTo(dto.getId()).andWeekdayIn((List)shouldRemove);
                this.weworkNotifyWeekDetailMapper.deleteByExample((Object)delDetailCri);
            }
            if (CollectionUtils.isNotEmpty((Collection)shouldAdd)) {
                for (Integer weekDay : shouldAdd) {
                    WeworkNotifyWeekDetail weekDetail = new WeworkNotifyWeekDetail();
                    weekDetail.setNotifyId(dto.getId());
                    weekDetail.setBizId(currentUser.getBizId());
                    weekDetail.setStatus(YnEnum.YES.getValue());
                    weekDetail.setCreateBy(currentUser.getId());
                    weekDetail.setCreateTime(new Date());
                    weekDetail.setUpdateBy(currentUser.getId());
                    weekDetail.setUpdateTime(new Date());
                    weekDetail.setWeekday(weekDay);
                    this.weworkNotifyWeekDetailMapper.insert((Object)weekDetail);
                }
            }
        }
        if (Objects.nonNull(dto.getNotifySwitch())) {
            entity.setNotifySwitch(dto.getNotifySwitch());
        }
        entity.setId(dto.getId());
        entity.setNotifyType(dto.getNotifyType());
        return entity;
    }

    private WeworkNotifyEvent notify(Long bizId, WeworkNotifyTypeEnums notifyTypeEnums, List<WeworkUserInfo> messageReceiver, List<WeworkUserInfo> messageFrom, Long notifyId) {
        if (CollectionUtils.isEmpty(messageReceiver)) {
            return null;
        }
        if (CollectionUtils.isEmpty(messageFrom)) {
            return null;
        }
        log.info("\u3010weworkNotify\u3011\u6d88\u606f\u63a5\u53d7\u8005\u4eba\u6570\uff1a{}", (Object)messageReceiver.size());
        log.info("\u3010weworkNotify\u3011\u6d88\u606f\u6765\u6e90\u4eba\u6570\uff1a{}", (Object)messageFrom.size());
        Map<String, Long> userIdMapByNum = messageFrom.stream().collect(Collectors.toMap(WeworkUser::getNum, WeworkUserInfo::getUserId, (k1, k2) -> k1));
        Map<String, Long> userIdMapByWeworkUserIds = messageFrom.stream().collect(Collectors.toMap(WeworkUser::getWeworkUserId, WeworkUserInfo::getUserId, (k1, k2) -> k1));
        Pair<Map<String, Long>, Map<Long, Long>> userFollowCount = Pair.of(null, null);
        Map<Object, Object> userOrderCounts = Maps.newHashMap();
        Map<Object, Object> totalCustomerMap = Maps.newHashMap();
        if (WeworkNotifyTypeEnums.SELL_DAILY_NOTIFY.equals((Object)notifyTypeEnums)) {
            userFollowCount = this.getUserFollowCount(userIdMapByNum, bizId);
            ArrayList userIds = Lists.newArrayList(userIdMapByNum.values());
            List<CrmLeadsInfoResp> leadsInfo = this.getLeadsInfo(userIds, DateUtil.getTodayStartTime(), DateUtil.getTodayEndTime(), bizId);
            userOrderCounts = this.getTodayOrderCount(bizId, userIds);
            totalCustomerMap = this.getTodayCustomerCount(userIdMapByWeworkUserIds, DateUtil.getTodayStartTime(), DateUtil.getTodayEndTime(), bizId, leadsInfo);
        }
        Map numFollowCount = (Map)Optional.ofNullable(userFollowCount.getLeft()).orElse(Maps.newHashMap());
        Map userIdFollowCount = (Map)Optional.ofNullable(userFollowCount.getRight()).orElse(Maps.newHashMap());
        Map<Long, List<PayRecordListResp>> payRecordList = null;
        if (WeworkNotifyTypeEnums.MAKE_DEAL_NOTIFY.equals((Object)notifyTypeEnums) && MapUtils.isEmpty(payRecordList = this.queryUserOrderInfo(bizId, Lists.newArrayList(userIdMapByNum.values()), DateUtil.getTodayStartTime(), DateUtil.getTodayEndTime()))) {
            return null;
        }
        ArrayList notifyLogDetail = Lists.newArrayList();
        StringBuilder notifyMessage = new StringBuilder();
        for (WeworkUserInfo user : messageFrom) {
            if (WeworkNotifyTypeEnums.SELL_DAILY_NOTIFY.equals((Object)notifyTypeEnums)) {
                Long numRecordCount = numFollowCount.getOrDefault(user.getNum(), 0L);
                Long userIdRecordCount = userIdFollowCount.getOrDefault(user.getUserId(), 0L);
                Integer addCustomerCount = totalCustomerMap.getOrDefault(user.getUserId(), 0);
                long recordCount = numRecordCount + userIdRecordCount;
                Integer orderCount = userOrderCounts.getOrDefault(user.getUserId(), 0);
                if (orderCount == 0 && recordCount == 0L && addCustomerCount == 0) continue;
                WeworkNotifyDetailDto weworkNotifyDetailDto = this.buildNotifyDetailDto(notifyTypeEnums.getValue(), user.getNum(), user.getUserName(), null, orderCount, recordCount, addCustomerCount, null, null, null);
                notifyMessage.append(this.getNotifyMessage(weworkNotifyDetailDto)).append('\n');
                notifyLogDetail.add(weworkNotifyDetailDto);
            }
            if (!WeworkNotifyTypeEnums.MAKE_DEAL_NOTIFY.equals((Object)notifyTypeEnums) || !MapUtils.isNotEmpty(payRecordList)) continue;
            List<PayRecordListResp> orderListResps = payRecordList.getOrDefault(user.getUserId(), Lists.newArrayList());
            List<PayRecordListResp> realNotNotifyOrderList = this.filterOrderList(orderListResps, user.getNum(), bizId, notifyTypeEnums);
            for (PayRecordListResp payRecord : realNotNotifyOrderList) {
                WeworkNotifyDetailDto notifyDetailDto = this.buildNotifyDetailDto(notifyTypeEnums.getValue(), user.getNum(), user.getUserName(), payRecord.getCustomerName(), null, null, null, payRecord.getPayAmount(), payRecord.getOrderNo(), payRecord.getNum());
                notifyMessage.append(this.getNotifyMessage(notifyDetailDto));
                notifyMessage.append('\n');
                notifyLogDetail.add(notifyDetailDto);
            }
        }
        List<String> weworkUserIds = messageReceiver.stream().map(WeworkUser::getWeworkUserId).collect(Collectors.toList());
        if (StringUtils.isEmpty((CharSequence)notifyMessage.toString())) {
            return null;
        }
        String message = this.addNotifyHeader(notifyTypeEnums.getValue(), notifyMessage.toString());
        this.addNotifyLog(weworkUserIds, notifyLogDetail, notifyTypeEnums, bizId, notifyId);
        WeworkNotifyEvent notifyEvent = new WeworkNotifyEvent();
        notifyEvent.setWeworkUserIds(weworkUserIds);
        notifyEvent.setNotifyType(Integer.valueOf(notifyTypeEnums.getValue()));
        notifyEvent.setBizId(bizId);
        notifyEvent.setTopic(this.notifyTopic);
        notifyEvent.setNotifyContent(message);
        log.info("\u3010weworkNotify\u3011\u5f53\u524d\u5546\u6237\u4e0b\u6240\u6709\u901a\u77e5\u6d88\u606f: {}", (Object)JSON.toJSONString((Object)notifyEvent));
        return notifyEvent;
    }

    private String addNotifyHeader(Integer notifyTypeEnums, String content) {
        String message = null;
        if (WeworkNotifyTypeEnums.SELL_DAILY_NOTIFY.getValue() == notifyTypeEnums.intValue()) {
            message = SELL_DAILY_HEADER + content;
        } else if (WeworkNotifyTypeEnums.MAKE_DEAL_NOTIFY.getValue() == notifyTypeEnums.intValue()) {
            message = MAKE_DEAL_HEADER + content;
        }
        return message;
    }

    public List<PayRecordListResp> filterOrderList(List<PayRecordListResp> orderListResps, String weworkNum, Long bizId, WeworkNotifyTypeEnums notifyType) {
        Date todayEndTime;
        if (CollectionUtils.isEmpty(orderListResps)) {
            return orderListResps;
        }
        Date todayStartTime = DateUtil.getTodayStartTime();
        List weworkNotifyLogs = this.weworkNotifyLogMapper.queryCurrentDateLogList(bizId, todayStartTime, todayEndTime = DateUtil.getTodayEndTime(), Integer.valueOf(notifyType.getValue()));
        List hadNotifyOrderInfos = weworkNotifyLogs.stream().map(item -> JSON.parseArray((String)item.getNotifyParam(), WeworkNotifyDetailDto.class)).flatMap(Collection::stream).filter(item -> StringUtils.equals((CharSequence)weworkNum, (CharSequence)item.getWeworkNum())).map(WeworkNotifyDetailDto::getPayNum).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(hadNotifyOrderInfos)) {
            return orderListResps;
        }
        ArrayList notNotifyOrderInfos = Lists.newArrayList();
        for (PayRecordListResp payRecordListResp : orderListResps) {
            if (!StringUtils.isBlank((CharSequence)payRecordListResp.getNum()) && hadNotifyOrderInfos.contains(payRecordListResp.getNum())) continue;
            notNotifyOrderInfos.add(payRecordListResp);
        }
        return notNotifyOrderInfos;
    }

    public String getNotifyMessage(WeworkNotifyDetailDto detailDto) {
        String message;
        if (Objects.isNull(detailDto) || Objects.isNull(detailDto.getNotifyType())) {
            return null;
        }
        if (WeworkNotifyTypeEnums.SELL_DAILY_NOTIFY.getValue() == detailDto.getNotifyType().intValue()) {
            message = SELL_DAILY_CONTENT.replace("{username}", detailDto.getWeworkName());
            message = message.replace("{followRecordCount}", String.valueOf(detailDto.getFollowRecordCount()));
            message = message.replace("{addOrderNum}", String.valueOf(detailDto.getOrderCount()));
            message = message.replace("{addCustomerNum}", String.valueOf(detailDto.getCustomerCount()));
            message = message.replace("{wechatCustomerNum}", String.valueOf(detailDto.getWechatUserCount()));
            message = message.replace("{phoneCustomerNum}", String.valueOf(detailDto.getPhoneUserCount()));
        } else {
            message = MAKE_DEAL_CONTENT.replace("{username}", detailDto.getWeworkName());
            String customerName = StringUtils.isBlank((CharSequence)detailDto.getOrderCustomerName()) ? "" : detailDto.getOrderCustomerName();
            message = message.replace("{customerName}", customerName);
            message = message.replace("{orderAmount}", PriceUtils.priceToStr((Long)detailDto.getOrderAmount(), (Integer)4));
        }
        return message;
    }

    public List<WeworkUserInfo> getReceiveWorkOrderNum(Long bizId, List<WeworkNotify> notifyList) {
        Set departmentIds;
        if (CollectionUtils.isEmpty(notifyList)) {
            return Lists.newArrayList();
        }
        List userInfo = notifyList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getUserIds())).map(item -> Arrays.asList(item.getUserIds().split(SPLIT_KEY))).flatMap(Collection::stream).collect(Collectors.toList());
        List depInfo = notifyList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getDepIds())).map(item -> Arrays.asList(item.getDepIds().split(SPLIT_KEY))).flatMap(Collection::stream).collect(Collectors.toList());
        ArrayList notifyUsers = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(userInfo)) {
            if (userInfo.contains("-1")) {
                List adminUser = this.userMapper.getUserInfo(bizId, YnEnum.YES.getValue(), null);
                notifyUsers.addAll(adminUser);
            } else if (userInfo.contains("all")) {
                List allUsers = this.userMapper.getUserInfo(bizId, YnEnum.NO.getValue(), null);
                notifyUsers.addAll(allUsers);
            } else {
                List chooseUsers = this.userMapper.getUserInfo(bizId, YnEnum.NO.getValue(), userInfo);
                notifyUsers.addAll(chooseUsers);
            }
        }
        if (CollectionUtils.isNotEmpty(depInfo) && CollectionUtils.isNotEmpty((Collection)(departmentIds = this.organizationMapper.queryDepartmentIdsByNum(bizId, depInfo)))) {
            List depUsers = this.weworkDepartmentUserMapper.queryDepartmentUserInfo(bizId, (Collection)departmentIds);
            notifyUsers.addAll(depUsers);
        }
        notifyUsers = Lists.newArrayList(notifyUsers.stream().collect(Collectors.toMap(WeworkUserInfo::getUserId, Function.identity(), (oldV, newV) -> oldV)).values());
        return notifyUsers;
    }

    private List<WeworkNotify> filterByTime(List<WeworkNotify> targetNotifyEntity) {
        ArrayList realNotifyEntity = Lists.newArrayList();
        for (WeworkNotify weworkNotify : targetNotifyEntity) {
            String notifyTimeStr = weworkNotify.getNotifyTime();
            if (StringUtils.isEmpty((CharSequence)notifyTimeStr)) continue;
            List<String> notifyTimes = Arrays.asList(notifyTimeStr.split(SPLIT_KEY));
            Date current = new Date();
            List shouldNotifyTimes = notifyTimes.stream().map(item -> DateUtil.stringTimeToDate((String)item, (Date)current)).filter(notifyTime -> {
                Date before = DateUtil.getDateAddMin((Date)current, (int)-5);
                return Objects.nonNull(notifyTime) && before.before((Date)notifyTime) && notifyTime.before(current);
            }).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(shouldNotifyTimes)) continue;
            realNotifyEntity.add(weworkNotify);
        }
        return realNotifyEntity;
    }

    private List<WeworkNotifyWeekDetail> addWeworkNotify(WeworkNotifyTypeEnums weworkNotifyTypeEnums, String corpId, Long bizId, Boolean generateDetail) {
        if (Objects.isNull(weworkNotifyTypeEnums)) {
            return Lists.newArrayList();
        }
        WeworkNotify weworkNotify = new WeworkNotify();
        weworkNotify.setBizId(bizId);
        weworkNotify.setNotifyType(Integer.valueOf(weworkNotifyTypeEnums.getValue()));
        List list = this.weworkNotifyMapper.select((Object)weworkNotify);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        if (weworkNotifyTypeEnums.getValue() == WeworkNotifyTypeEnums.SELL_DAILY_NOTIFY.getValue() || weworkNotifyTypeEnums.getValue() == WeworkNotifyTypeEnums.MAKE_DEAL_NOTIFY.getValue()) {
            weworkNotify.setNotifyTime(DEFAULT_NOTIFY_TIME);
            weworkNotify.setUserIds("-1");
        } else {
            weworkNotify.setNotifyTime(DEFAULT_CRM_LEADS_NOTIFY_TIME);
            weworkNotify.setUserIds("all");
        }
        weworkNotify.setNotifySwitch(YnEnum.YES.getValue());
        weworkNotify.setCorpId(corpId);
        weworkNotify.setBizId(bizId);
        weworkNotify.setStatus(YnEnum.YES.getValue());
        weworkNotify.setNotifyType(Integer.valueOf(weworkNotifyTypeEnums.getValue()));
        weworkNotify.setCreateBy(Long.valueOf(-1L));
        weworkNotify.setUpdateBy(Long.valueOf(-1L));
        weworkNotify.setCreateTime(new Date());
        weworkNotify.setUpdateTime(new Date());
        this.weworkNotifyMapper.insert((Object)weworkNotify);
        log.info("\u3010weworkNotify\u3011init notifyInfo: notifyType:{}  makeDealNotifyId: {}; ", (Object)weworkNotifyTypeEnums, (Object)weworkNotify.getId());
        if (!Boolean.TRUE.equals(generateDetail)) {
            return Lists.newArrayList();
        }
        return Arrays.stream(WeekDayEnums.values()).map(weekDay -> {
            WeworkNotifyWeekDetail weekDetail = new WeworkNotifyWeekDetail();
            weekDetail.setWeekday(Integer.valueOf(weekDay.getValue()));
            weekDetail.setNotifyId(weworkNotify.getId());
            weekDetail.setStatus(YnEnum.YES.getValue());
            weekDetail.setBizId(bizId);
            weekDetail.setUpdateTime(new Date());
            weekDetail.setUpdateBy(Long.valueOf(-1L));
            weekDetail.setCreateTime(new Date());
            weekDetail.setCreateBy(Long.valueOf(-1L));
            return weekDetail;
        }).collect(Collectors.toList());
    }

    private Pair<Map<String, Long>, Map<Long, Long>> getUserFollowCount(Map<String, Long> userIdMapByNum, Long bizId) {
        FollowListResp followListResp;
        FollowQueryParams followQueryParams = new FollowQueryParams();
        followQueryParams.setBizId(bizId);
        followQueryParams.setEndTime(DateUtil.getTodayEndTime());
        followQueryParams.setStartTime(DateUtil.getTodayStartTime());
        followQueryParams.setUserIds((List)Lists.newArrayList(userIdMapByNum.values()));
        followQueryParams.setWeworkNums((List)Lists.newArrayList(userIdMapByNum.keySet()));
        try {
            log.info("\u3010weworkNotify\u3011getUserFollowCount: request:{}", (Object)JSON.toJSONString((Object)followQueryParams));
            followListResp = this.customerFollowRecordService.countByUserIdOrWeworkNum(followQueryParams);
        }
        catch (Exception e) {
            log.error("\u3010weworkNotify\u3011getUserFollowCount error:", (Throwable)e);
            followListResp = null;
        }
        if (Objects.isNull(followListResp)) {
            return Pair.of((Object)Maps.newHashMap(), (Object)Maps.newHashMap());
        }
        return Pair.of((Object)followListResp.getWeworkNumCount(), (Object)followListResp.getUserIdsCount());
    }

    private void addNotifyLog(List<String> weworkUserId, List<WeworkNotifyDetailDto> detailDtos, WeworkNotifyTypeEnums notifyType, Long bizId, Long notifyId) {
        Date notifyfDay = new Date();
        String notifyTime = DateUtil.getCurDate((String)"HH:mm");
        WeworkNotifyLog notifyLog = new WeworkNotifyLog();
        notifyLog.setNotifyId(notifyId);
        notifyLog.setBizId(bizId);
        notifyLog.setNotifyType(Integer.valueOf(notifyType.getValue()));
        notifyLog.setNotifyDay(notifyfDay);
        notifyLog.setNotifyTime(notifyTime);
        notifyLog.setNotifyReceiver(JSON.toJSONString(weworkUserId));
        notifyLog.setNotifyParam(JSON.toJSONString(detailDtos));
        notifyLog.setCreateBy(Long.valueOf(-1L));
        notifyLog.setUpdateBy(Long.valueOf(-1L));
        notifyLog.setCreateTime(notifyfDay);
        notifyLog.setUpdateTime(notifyfDay);
        try {
            this.weworkNotifyLogMapper.insert((Object)notifyLog);
        }
        catch (Exception e) {
            log.error("\u3010weworkNotify\u3011 \u65b0\u589e\u6d88\u606f\u901a\u77e5\u65e5\u5fd7\u5f02\u5e38\uff1aparam:{},error", (Object)JSON.toJSONString((Object)notifyLog), (Object)e);
        }
    }

    private WeworkNotifyDetailDto buildNotifyDetailDto(Integer notifyType, String weworkNum, String userName, String customerName, Integer orderCount, Long recordCount, Integer customerCount, Long orderAmount, String orderNo, String payNum) {
        WeworkNotifyDetailDto dto = new WeworkNotifyDetailDto();
        dto.setNotifyType(notifyType);
        dto.setWeworkName(userName);
        dto.setWeworkNum(weworkNum);
        dto.setOrderCustomerName(customerName);
        dto.setOrderCount(orderCount);
        dto.setFollowRecordCount(recordCount);
        dto.setWechatUserCount(null);
        dto.setPhoneUserCount(null);
        dto.setCustomerCount(customerCount);
        dto.setOrderAmount(orderAmount);
        if (payNum != null) {
            dto.setPayNum(payNum);
        }
        dto.setOrderNo(orderNo);
        return dto;
    }

    public Map<Long, List<PayRecordListResp>> queryUserOrderInfo(Long bizId, List<Long> userIds, Date startTime, Date endTime) {
        QueryPayRecordListReq queryPayRecordListReq = new QueryPayRecordListReq();
        queryPayRecordListReq.setBizId(bizId);
        queryPayRecordListReq.setPayTimeStart(startTime);
        queryPayRecordListReq.setPayTimeEnd(endTime);
        queryPayRecordListReq.setUserIds(userIds);
        OrderAmountConfResp orderAmountConf = null;
        try {
            Boolean openCrm = this.scrmBizService.isOpenCrm(bizId);
            if (openCrm != null && openCrm.booleanValue()) {
                orderAmountConf = this.crmConfigService.getOrderAmountConf(bizId);
                log.info("\u3010weworkNotify\u3011crmConfigService.getOrderAmountConf(  param:{} result:{}", (Object)JSON.toJSONString((Object)queryPayRecordListReq), (Object)JSON.toJSONString((Object)orderAmountConf));
            }
        }
        catch (Exception e) {
            log.error("\u3010weworkNotify\u3011 \u67e5\u8be2\u91d1\u989d\u914d\u7f6e\u5931\u8d25 param:{}", (Object)JSON.toJSONString((Object)queryPayRecordListReq), (Object)e);
        }
        if (Objects.nonNull(orderAmountConf) && YnEnum.YES.getValue().equals(orderAmountConf.getIsOpen()) && orderAmountConf.getOrderFlushAmount() > 0L) {
            queryPayRecordListReq.setPaidAmountStart(orderAmountConf.getOrderFlushAmount() * 10000L);
        }
        PageDto pageDto = new PageDto();
        queryPayRecordListReq.setPageDto(pageDto);
        PagePayRecordResp pagePayRecordResp = null;
        ArrayList userIdOrderInfos = Lists.newArrayList();
        try {
            List list;
            log.info("\u3010weworkNotify\u3011\u8c03\u7528 customerOrderService.orderList \uff1aparam:{}", (Object)JSON.toJSONString((Object)queryPayRecordListReq));
            pagePayRecordResp = this.customerPayRecordService.queryPayRecordList(queryPayRecordListReq);
            PageDto resultPage = null;
            if (Objects.nonNull(pagePayRecordResp)) {
                resultPage = pagePayRecordResp.getPageDto();
                list = pagePayRecordResp.getList();
                userIdOrderInfos.addAll(list);
            }
            while (Objects.nonNull(resultPage) && resultPage.getTotalPageNum() > pageDto.getPageNum()) {
                pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
                pagePayRecordResp = this.customerPayRecordService.queryPayRecordList(queryPayRecordListReq);
                if (!Objects.nonNull(pagePayRecordResp)) continue;
                resultPage = pagePayRecordResp.getPageDto();
                list = pagePayRecordResp.getList();
                userIdOrderInfos.addAll(list);
            }
        }
        catch (Exception e) {
            log.error("\u3010weworkNotify\u3011\u8c03\u7528 customerOrderService.orderList \u5f02\u5e38\uff1aerror:", (Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)userIdOrderInfos)) {
            return Maps.newHashMap();
        }
        return userIdOrderInfos.stream().filter(item -> Objects.nonNull(item.getUserId())).collect(Collectors.groupingBy(PayRecordListResp::getUserId));
    }

    public Map<Long, Integer> getTodayOrderCount(Long bizId, List<Long> userIds) {
        QueryOrderListReq queryOrderListReq = new QueryOrderListReq();
        queryOrderListReq.setOrderTimeStart(DateUtil.getTodayStartTime());
        queryOrderListReq.setOrderTimeEnd(DateUtil.getTodayEndTime());
        queryOrderListReq.setBizId(bizId);
        queryOrderListReq.setUserIds(userIds);
        OrderTotalResp orderTotalResp = null;
        try {
            orderTotalResp = this.customerOrderService.orderCountGroupByUser(queryOrderListReq);
        }
        catch (Exception e) {
            log.error("\u3010weworkNotify\u3011 \u8c03\u7528 customerOrderService.orderCountGroupByUser \u5f02\u5e38\uff1aerror:", (Throwable)e);
        }
        log.info("\u3010weworkNotify\u3011\u8c03\u7528 customerOrderService.orderCountGroupByUser param:{},response:{}", (Object)JSON.toJSONString((Object)queryOrderListReq), (Object)JSON.toJSONString((Object)orderTotalResp));
        return Optional.ofNullable(orderTotalResp).map(OrderTotalResp::getUserOrderCount).orElse(Maps.newHashMap());
    }

    public Map<String, Integer> getTodayWeworkCustomerNum(Set<String> weworkCustomerNums, Date startTime, Date endTime, Long bizId) {
        if (CollectionUtils.isEmpty(weworkCustomerNums)) {
            return Maps.newHashMap();
        }
        if (Objects.isNull(startTime) || Objects.isNull(endTime) || Objects.isNull(bizId)) {
            return Maps.newHashMap();
        }
        return this.weworkContactRelationMapper.getTodayWeworkCustomerCount(bizId, weworkCustomerNums, startTime, endTime);
    }

    public List<CrmLeadsInfoResp> getLeadsInfo(List<Long> userIds, Date startTime, Date endTime, Long bizId) {
        Boolean openCrm = this.scrmBizService.isOpenCrm(bizId);
        if (openCrm == null || !openCrm.booleanValue()) {
            log.info("\u3010weworkNotify\u3011getTodayPhoneLeadsNum biz not open crm,bizId:{}", (Object)bizId);
            return Collections.emptyList();
        }
        LeadsStatisticsReq req = new LeadsStatisticsReq();
        req.setUserIds(userIds);
        req.setBindStartTime(startTime);
        req.setBindEndTime(endTime);
        req.setBizId(bizId);
        List crmLeadsResps = Lists.newArrayList();
        try {
            crmLeadsResps = this.crmLeadsService.countLeadsByBindUserId(req);
            log.info("\u3010weworkNotify\u3011 getTodayPhoneLeadsNum param:{} resp:{}", (Object)JSON.toJSONString((Object)req), (Object)JSON.toJSONString((Object)crmLeadsResps));
        }
        catch (Exception e) {
            log.error("\u3010weworkNotify\u3011getTodayPhoneLeadsNum error ", (Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)crmLeadsResps)) {
            crmLeadsResps = Lists.newArrayList();
        }
        return crmLeadsResps;
    }

    public Map<Long, Long> getTodayPhoneLeadsNum(List<CrmLeadsInfoResp> crmLeadsResps) {
        if (CollectionUtils.isEmpty(crmLeadsResps)) {
            return Maps.newHashMap();
        }
        return crmLeadsResps.stream().collect(Collectors.groupingBy(CrmLeadsInfoResp::getBindingUserId, Collectors.counting()));
    }

    public Map<Long, Integer> getTodayCustomerCount(Map<String, Long> weworkUserIds, Date startTime, Date endTime, Long bizId, List<CrmLeadsInfoResp> crmLeadsInfoResps) {
        HashMap addUserCount = Maps.newHashMap();
        if (MapUtils.isEmpty(weworkUserIds)) {
            return addUserCount;
        }
        ContactRelationParams params = new ContactRelationParams();
        params.setBizId(bizId);
        params.setAddTimeEnd(endTime);
        params.setAddTimeStart(startTime);
        params.setManagerWeworkUserIds(weworkUserIds.keySet());
        List contactRelationDtos = this.weworkContactRelationMapper.queryContactRelationList(params);
        List contactIds = contactRelationDtos.stream().map(ContactRelationDto::getContactId).collect(Collectors.toList());
        HashMap contactIdMapCustomerNum = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(contactIds)) {
            contactIdMapCustomerNum.putAll(this.customerNumService.butchGetCustomerNumByContactId(bizId, contactIds));
        }
        Map<String, List<ContactRelationDto>> contactGrouyWorkUserIds = contactRelationDtos.stream().filter(item -> Objects.nonNull(item.getWeworkUserId())).collect(Collectors.groupingBy(ContactRelationDto::getWeworkUserId));
        Map<Long, List<CrmLeadsInfoResp>> groupByBindUserId = crmLeadsInfoResps.stream().collect(Collectors.groupingBy(CrmLeadsInfoResp::getBindingUserId));
        for (Map.Entry<String, Long> entity : weworkUserIds.entrySet()) {
            List<ContactRelationDto> currentUserContacts;
            List<CrmLeadsInfoResp> currentUserLeads = groupByBindUserId.get(entity.getValue());
            Set<Object> currentUserCustomerNum = Sets.newHashSet();
            if (CollectionUtils.isNotEmpty(currentUserLeads)) {
                currentUserCustomerNum = currentUserLeads.stream().map(CrmLeadsInfoResp::getCustomerNum).collect(Collectors.toSet());
            }
            if (CollectionUtils.isNotEmpty(currentUserContacts = contactGrouyWorkUserIds.get(entity.getKey()))) {
                List currentUserContactIds = currentUserContacts.stream().map(ContactRelationDto::getContactId).collect(Collectors.toList());
                Set weworkCustomerNums = currentUserContactIds.stream().map(contactIdMapCustomerNum::get).collect(Collectors.toSet());
                currentUserCustomerNum.addAll(weworkCustomerNums);
            }
            addUserCount.put(entity.getValue(), currentUserCustomerNum.size());
        }
        return addUserCount;
    }
}

