/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.weworkuser.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.service.ScrmWeworkUserService;
import com.kuaike.scrm.common.service.dto.OrgUserDto;
import com.kuaike.scrm.common.service.dto.WeworkUserInfo;
import com.kuaike.scrm.common.service.dto.resp.UserBehaviorDataResp;
import com.kuaike.scrm.dal.agent.mapper.AgentWeworkUserMapper;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckLogEs;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.entity.WeworkUserStatisticsRecord;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.wework.department.service.DepartmentService;
import com.kuaike.scrm.wework.insight.service.WeworkInsightService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ScrmWeworkUserServiceImpl
implements ScrmWeworkUserService {
    private static final Logger log = LoggerFactory.getLogger(ScrmWeworkUserServiceImpl.class);
    @Resource
    private OrganizationMapper organizationMapper;
    @Resource
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private AgentWeworkUserMapper agentWeworkUserMapper;
    @Resource
    private WeworkInsightService weworkInsightService;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Value(value="${scrm.elasticsearch.qualityCheckLogIndex}")
    private String index;
    @Autowired
    private RestHighLevelClient restHighLevelClient;

    public List<OrgUserDto> getOrgOfWeworkUser(List<Long> deptIds) {
        if (CollectionUtils.isEmpty(deptIds)) {
            return Lists.newArrayList();
        }
        List orgList = this.organizationMapper.selectOrgByIds(deptIds);
        if (CollectionUtils.isEmpty((Collection)orgList)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)orgList.size());
        for (Organization org : orgList) {
            OrgUserDto orgUserDto = new OrgUserDto();
            orgUserDto.setDeptId(org.getId());
            orgUserDto.setDeptName(org.getName());
            Set<Integer> departments = this.departmentService.getChildDepartment(org.getCorpId(), org.getWeworkDepartmentId(), true);
            Set weworkUserIds = this.weworkDepartmentUserMapper.selectByCorpIdAndDepartmentIds(org.getCorpId(), departments, Boolean.valueOf(true));
            List weworkUsers = this.weworkUserMapper.queryWeworkUserInfoList(org.getCorpId(), (Collection)weworkUserIds);
            ArrayList members = Lists.newArrayListWithCapacity((int)weworkUsers.size());
            weworkUsers.forEach(it -> {
                WeworkUserInfo userInfo = new WeworkUserInfo();
                userInfo.setWeworkUserNum(it.getNum());
                userInfo.setName(it.getName());
                userInfo.setAvatar(it.getAvatar());
                userInfo.setWeworkUserId(it.getWeworkUserId());
                members.add(userInfo);
            });
            orgUserDto.setMembers((List)members);
            result.add(orgUserDto);
        }
        return result;
    }

    public List<WeworkUserInfo> getWeworkUserInfo(String corpId, List<String> weworkUserIds) {
        if (StringUtils.isBlank((CharSequence)corpId) || CollectionUtils.isEmpty(weworkUserIds)) {
            log.warn("getWeworkUserInfo: \u4f20\u5165\u53c2\u6570\u4e3a\u7a7a, corpId:{}, weworkUserIds:{}", (Object)corpId, weworkUserIds);
            return Lists.newArrayList();
        }
        List weworkUsers = this.weworkUserMapper.queryWeworkUserInfoList(corpId, weworkUserIds).stream().filter(a -> a.getIsDeleted() != null && a.getIsDeleted() == 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(weworkUsers)) {
            log.info("getWeworkUserInfo: weworkUsers\u4e3a\u7a7a, corpId:{}, weworkUserIds:{}", (Object)corpId, weworkUserIds);
            return Lists.newArrayList();
        }
        ArrayList weworkUserInfos = Lists.newArrayList();
        for (WeworkUser weworkUser : weworkUsers) {
            WeworkUserInfo userInfo = new WeworkUserInfo();
            userInfo.setWeworkUserNum(weworkUser.getNum());
            userInfo.setName(weworkUser.getName());
            userInfo.setAvatar(weworkUser.getAvatar());
            userInfo.setWeworkUserId(weworkUser.getWeworkUserId());
            weworkUserInfos.add(userInfo);
        }
        return weworkUserInfos;
    }

    public WeworkUserInfo getWeworkUserInfo(String weworkUserNum) {
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(weworkUserNum);
        WeworkUserInfo weworkUserInfo = new WeworkUserInfo();
        if (weworkUser != null) {
            weworkUserInfo.setBizId(weworkUser.getBizId());
            weworkUserInfo.setName(weworkUser.getName());
            weworkUserInfo.setAvatar(weworkUser.getAvatar());
            weworkUserInfo.setWeworkUserNum(weworkUser.getNum());
        }
        return weworkUserInfo;
    }

    public Map<String, String> queryWeworkUserIdsBy(Long bizId, List<String> weworkUserIds) {
        log.info("queryWeworkUserIdsBy bizId: {}, weworkUserIds: {}", (Object)bizId, weworkUserIds);
        if (CollectionUtils.isEmpty(weworkUserIds)) {
            return null;
        }
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByBizId(bizId);
        if (weworkCorp == null) {
            log.info("queryWeworkUserIdsBy get weworkCorp is null");
            return null;
        }
        Integer isNewDKF = weworkCorp.getIsNewDkf();
        if (isNewDKF == 0) {
            log.info("queryWeworkUserIdsBy \u975e\u5f85\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
            return null;
        }
        return this.agentWeworkUserMapper.queryDecryptWeworkUserIds(bizId, weworkUserIds);
    }

    public Map<String, String> queryWeworkUserIdByNums(Long bizId, Collection<String> weworkUserNums) {
        log.info("queryWeworkUserIdByNums,bizId:{},weworkUserNums:{}", (Object)bizId, weworkUserNums);
        if (bizId == null || CollectionUtils.isEmpty(weworkUserNums)) {
            return Collections.emptyMap();
        }
        return this.weworkUserMapper.queryWeworkUserIdMapByNums(weworkUserNums);
    }

    public Map<String, String> queryWeworkUserNumByWeworkUserIds(Long bizId, Collection<String> weworkUserIds) {
        log.info("queryWeworkUserNumByWeworkUserIds,bizId:{},weworkUserIds:{}", (Object)bizId, weworkUserIds);
        if (bizId == null || CollectionUtils.isEmpty(weworkUserIds)) {
            return Collections.emptyMap();
        }
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        if (businessCustomer == null || StringUtils.isBlank((CharSequence)businessCustomer.getCorpId())) {
            return Collections.emptyMap();
        }
        return this.weworkUserMapper.queryUserNumIdMap(businessCustomer.getCorpId(), weworkUserIds);
    }

    public List<UserBehaviorDataResp> pullUserBehaviorData(Long bizId, Date startTime, Date endTime, Collection<String> weworkUserIds) {
        log.info("pullUserBehaviorData,bizId:{},startTime:{},endTime:{},weworkUserIds:{}", new Object[]{bizId, startTime, endTime, weworkUserIds});
        if (bizId == null || startTime == null || endTime == null) {
            return Collections.emptyList();
        }
        List<WeworkUserStatisticsRecord> recordList = this.weworkInsightService.pullUserBehaviorData(bizId, startTime, endTime, weworkUserIds);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        ArrayList<UserBehaviorDataResp> respList = new ArrayList<UserBehaviorDataResp>();
        for (WeworkUserStatisticsRecord userStatisticsRecord : recordList) {
            UserBehaviorDataResp resp = new UserBehaviorDataResp();
            resp.setChatCount(userStatisticsRecord.getChatCount());
            resp.setAvgReplyTime(userStatisticsRecord.getAvgReplyTime());
            resp.setMessageCount(userStatisticsRecord.getMessageCount());
            resp.setReplyPercentage(userStatisticsRecord.getReplyPercentage());
            resp.setNewApplyCont(userStatisticsRecord.getAddApplyCount());
            resp.setWeworkUserId(userStatisticsRecord.getWeworkUserId());
            resp.setStatisticTime(userStatisticsRecord.getStatisticTime());
            respList.add(resp);
        }
        return respList;
    }

    public Map<String, Integer> queryTimeoutUnReply(Long bizId, Date startTime, Date endTime, Collection<String> weworkUserIds) {
        log.info("queryTimeoutUnReply,bizId:{},startTime:{},endTime:{},weworkUserIds:{}", new Object[]{bizId, startTime, endTime, weworkUserIds});
        if (bizId == null || startTime == null || endTime == null) {
            return Collections.emptyMap();
        }
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        List<QualityCheckLogEs> checkLogEs = this.queryQualityCheckLogEsList(businessCustomer.getCorpId(), startTime, endTime, weworkUserIds);
        List<Object> weworkUserIdsRes = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(checkLogEs)) {
            weworkUserIdsRes = checkLogEs.stream().map(QualityCheckLogEs::getSendWeworkUserId).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)weworkUserIdsRes)) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String string : weworkUserIdsRes) {
            Integer count = map.getOrDefault(string, 0);
            count = count + 1;
            map.put(string, count);
        }
        return map;
    }

    public List<QualityCheckLogEs> queryQualityCheckLogEsList(String corpId, Date startTime, Date endTime, Collection<String> weworkUserIds) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"corpId.keyword", (String[])new String[]{corpId}));
        RangeQueryBuilder createTime = QueryBuilders.rangeQuery((String)"createTime");
        if (Objects.nonNull(startTime) && Objects.isNull(createTime.from())) {
            createTime.gte((Object)startTime.getTime());
        }
        if (Objects.nonNull(endTime) && Objects.isNull(createTime.to())) {
            createTime.lte((Object)endTime.getTime());
        }
        if (Objects.nonNull(createTime.from()) || Objects.nonNull(createTime.to())) {
            queryBuilder.must((QueryBuilder)createTime);
        }
        queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sendWeworkUserId.keyword", weworkUserIds));
        queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"triggerBehavior", (Collection)Lists.newArrayList((Object[])new Integer[]{5})));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        log.info("Query queryQualityCheckLogEsList search param :{}", (Object)searchRequest.source().toString());
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            log.error("countLogTimeoutUnReplyMap: es\u67e5\u8be2\u5f02\u5e38\uff0ce = ", (Throwable)e);
        }
        if (searchResponse == null) {
            return Collections.emptyList();
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] hitsHits = hits.getHits();
        List<QualityCheckLogEs> checkLogEs = Stream.of(hitsHits).map(item -> {
            String sourceAsString = item.getSourceAsString();
            try {
                return (QualityCheckLogEs)JacksonUtil.str2Obj((String)sourceAsString, QualityCheckLogEs.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.toList());
        return checkLogEs;
    }
}

