/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.service.impl;

import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CountResult;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.enums.AddWayType;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.CachePhoneService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.OrgService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.dto.CustomerDto;
import com.kuaike.scrm.common.service.dto.resp.BatchPhoneDto;
import com.kuaike.scrm.common.service.dto.resp.OrgListRespDto;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.call.dto.CallRecordQueryParams;
import com.kuaike.scrm.dal.call.entity.CallRecord;
import com.kuaike.scrm.dal.call.mapper.CallRecordMapper;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.contactanalyse.dto.ChannelInfo;
import com.kuaike.scrm.dal.contactanalyse.entity.WeworkContactLog;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkContactLogMapper;
import com.kuaike.scrm.dal.contactstage.entity.WeworkContactStage;
import com.kuaike.scrm.dal.contactstage.mapper.WeworkContactStageMapper;
import com.kuaike.scrm.dal.exporttask.entity.ExportTask;
import com.kuaike.scrm.dal.exporttask.mapper.ExportTaskMapper;
import com.kuaike.scrm.dal.follow.dto.FollowContentInfo;
import com.kuaike.scrm.dal.follow.dto.FollowRecordInfo;
import com.kuaike.scrm.dal.follow.mapper.FollowRecordMapper;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.system.entity.CustomerStage;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import com.kuaike.scrm.dal.wework.dto.ContactRelationDto;
import com.kuaike.scrm.dal.wework.dto.ContactRelationParams;
import com.kuaike.scrm.dal.wework.dto.ContactWeworkPair;
import com.kuaike.scrm.dal.wework.dto.UserContactInfo;
import com.kuaike.scrm.dal.wework.dto.WeworkUserContactDto;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.WeworkTagDto;
import com.kuaike.scrm.follow.dto.FollowInfo;
import com.kuaike.scrm.follow.dto.FollowReqDto;
import com.kuaike.scrm.wework.contact.dto.ContactCallRecordRespDto;
import com.kuaike.scrm.wework.contact.dto.ContactPhoneIdParam;
import com.kuaike.scrm.wework.contact.dto.ContactQueryDto;
import com.kuaike.scrm.wework.contact.dto.ContactRelationDetailDto;
import com.kuaike.scrm.wework.contact.dto.ContactRelationDetailParams;
import com.kuaike.scrm.wework.contact.dto.ContactRelationListDto;
import com.kuaike.scrm.wework.contact.dto.ContactRelationListParams;
import com.kuaike.scrm.wework.contact.dto.PreviewDto;
import com.kuaike.scrm.wework.contact.service.ContactMobileService;
import com.kuaike.scrm.wework.contact.service.ContactRelationService;
import com.kuaike.scrm.wework.contact.service.ContactService;
import com.kuaike.scrm.wework.contact.service.ExportContactService;
import com.kuaike.scrm.wework.contacttag.service.ContactTagService;
import com.kuaike.scrm.wework.department.service.DepartmentService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContactRelationServiceImpl
implements ContactRelationService {
    private static final Logger log = LoggerFactory.getLogger(ContactRelationServiceImpl.class);
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Resource
    private WeworkContactLogMapper weworkContactLogMapper;
    @Resource
    private WeworkContactStageMapper weworkContactStageMapper;
    @Resource
    private FollowRecordMapper followRecordMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private CustomerStageMapper customerStageMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private ExportTaskMapper exportTaskMapper;
    @Autowired
    private WeworkUserService weworkUserService;
    @Autowired
    private ContactMobileService contactMobileService;
    @Autowired
    private ContactTagService contactTagService;
    @Autowired
    private ContactService contactService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private IdGen idGen;
    @Autowired
    private ExportContactService exportContactService;
    @Autowired
    private CachePhoneService cachePhoneService;
    @Autowired
    private CallRecordMapper callRecordMapper;
    @Resource
    private CcCustomerInfoService ccCustomerInfoService;
    @Resource
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private OrgService orgService;
    @Resource
    private NodeService nodeService;
    @Resource
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;
    @Autowired
    private MarketingPlanMapper marketingPlanMapper;

    @Override
    public List<ContactRelationListDto> list(ContactRelationListParams params) {
        ContactRelationParams queryParams = this.convertReqParamToQueryParam(params);
        if (Objects.isNull(queryParams)) {
            return Lists.newArrayList();
        }
        String corpId = queryParams.getCorpId();
        Long bizId = queryParams.getBizId();
        log.info("list queryParams:{}", (Object)queryParams);
        StopWatchDto timer = new StopWatchDto("contact list", true, log);
        if (params.getPageDto() != null) {
            timer.start("queryContactRelationCount");
            queryParams.setQueryCount(YnEnum.YES.getValue());
            int total = this.weworkContactRelationMapper.queryContactRelationCount(queryParams);
            timer.stop();
            params.getPageDto().setCount(Integer.valueOf(total));
        }
        queryParams.setQueryCount(YnEnum.NO.getValue());
        timer.start("queryContactRelationList");
        List list = this.weworkContactRelationMapper.queryContactRelationList(queryParams);
        timer.stop();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        List<String> weworkUserIds = list.stream().map(ContactRelationDto::getWeworkUserId).collect(Collectors.toList());
        List<String> contactIds = list.stream().map(ContactRelationDto::getContactId).collect(Collectors.toList());
        Map contactCustomerNumMap = this.weworkContactMapper.queryContactCustomerNum(corpId, contactIds);
        Map<String, String> weworkUserNameMap = this.weworkUserService.getWeworkUserNameMap(corpId, weworkUserIds);
        Map<String, List<String>> remarkMobileMap = this.contactMobileService.getRemarkMobile(bizId, corpId, weworkUserIds, contactIds);
        Map<String, List<WeworkTagDto>> weworkTagMap = this.contactTagService.getWeworkTagMap(corpId, weworkUserIds, contactIds);
        List contactLogs = this.weworkContactLogMapper.queryListByContactIds(corpId, contactIds);
        Map<String, List<WeworkContactLog>> contactLogMap = contactLogs.stream().collect(Collectors.groupingBy(WeworkContactLog::getContactId));
        Map planIdMap = null;
        if (CollectionUtils.isNotEmpty((Collection)contactLogs)) {
            Set planIds = contactLogs.stream().map(WeworkContactLog::getPlanId).collect(Collectors.toSet());
            log.info("queryDelExternalCount planIds:{}", planIds);
            if (CollectionUtils.isNotEmpty(planIds)) {
                List planList = this.marketingPlanMapper.queryByIds(corpId, planIds);
                planIdMap = planList.stream().collect(Collectors.toMap(MarketingPlan::getId, Function.identity()));
            }
        }
        log.info("queryDelExternalCount planIdMap:{}", planIdMap);
        ArrayList result = Lists.newArrayList();
        boolean mobileEncrypt = this.settingService.getMobileEncrypt(bizId);
        Map weworkUserNumMap = this.weworkUserMapper.selectWeworkUserIdAndNumByWeworkUserIds(corpId, weworkUserIds);
        List contactStages = this.weworkContactStageMapper.queryContactStageList(corpId, weworkUserNumMap.values(), contactIds);
        Map contactStageMap = contactStages.stream().collect(Collectors.toMap(it -> it.getWeworkUserNum() + it.getContactId(), Function.identity()));
        List weworkContactList = this.weworkContactMapper.queryWeworkContactList(corpId, contactIds);
        Map weworkContactMap = weworkContactList.stream().collect(Collectors.toMap(WeworkContact::getContactId, Function.identity()));
        timer.start("build result");
        for (ContactRelationDto contactRelationDto : list) {
            WeworkContactStage stageInfo;
            List<WeworkContactLog> contactLogList;
            List memberContactLogList;
            ContactRelationListDto relationListDto = new ContactRelationListDto();
            String weworkUserId = contactRelationDto.getWeworkUserId();
            String weworkUserNum = (String)weworkUserNumMap.get(contactRelationDto.getWeworkUserId());
            relationListDto.setId(contactRelationDto.getNum());
            relationListDto.setBizId(bizId);
            relationListDto.setContactId(contactRelationDto.getContactId());
            relationListDto.setWeworkUserId(weworkUserNum);
            relationListDto.setAddTime(contactRelationDto.getAddTime());
            relationListDto.setAddWay(contactRelationDto.getAddWay());
            String addWayDesc = AddWayType.UNKNOWN.getDesc();
            if (AddWayType.getType((Integer)contactRelationDto.getAddWay()) != null) {
                addWayDesc = AddWayType.getType((Integer)contactRelationDto.getAddWay()).getDesc();
            }
            relationListDto.setAddWayDesc(addWayDesc);
            if (contactLogMap.containsKey(contactRelationDto.getContactId()) && CollectionUtils.isNotEmpty(memberContactLogList = (contactLogList = contactLogMap.get(contactRelationDto.getContactId())).stream().filter(a -> a.getWeworkUserNum().equals(weworkUserNum)).collect(Collectors.toList()))) {
                MarketingPlan plan;
                WeworkContactLog contactLog = (WeworkContactLog)memberContactLogList.get(0);
                Long planId = contactLog.getPlanId();
                if (planIdMap != null && planId != null && (plan = (MarketingPlan)planIdMap.get(planId)) != null) {
                    relationListDto.setPlanName(plan.getName());
                    relationListDto.setPlanType(plan.getType());
                    relationListDto.setPlanTypeDesc(PlanType.get((int)plan.getType()).getDesc());
                }
            }
            relationListDto.setWeworkUserNickname(weworkUserNameMap.get(weworkUserId));
            relationListDto.setRemarkName(contactRelationDto.getRemark());
            WeworkContact weworkContact = (WeworkContact)weworkContactMap.get(contactRelationDto.getContactId());
            if (weworkContact != null) {
                relationListDto.setAvatar(weworkContact.getAvatar());
                relationListDto.setNickname(weworkContact.getName());
                relationListDto.setCorpName(weworkContact.getCorpName());
                relationListDto.setType(weworkContact.getType());
            }
            if (Objects.nonNull(contactCustomerNumMap)) {
                String customerNum = (String)contactCustomerNumMap.get(contactRelationDto.getContactId());
                relationListDto.setCustomerNum(customerNum);
            }
            String key = contactRelationDto.getWeworkUserId() + contactRelationDto.getContactId();
            List<String> remarkMobiles = remarkMobileMap.get(key);
            List customerMobiles = this.ccCustomerNumService.getMobilesByContactId(bizId, contactRelationDto.getContactId());
            if (mobileEncrypt) {
                MobileUtils.encryptMobile(remarkMobiles);
                MobileUtils.encryptMobile((List)customerMobiles);
            }
            relationListDto.setRemarkMobiles(remarkMobiles);
            relationListDto.setCustomerMobiles(customerMobiles);
            relationListDto.setWeworkTags(weworkTagMap.get(key));
            ChannelInfo channelInfo = this.weworkContactLogMapper.queryChannelInfo(corpId, weworkUserNum, contactRelationDto.getContactId());
            if (channelInfo != null) {
                relationListDto.setChannelId(channelInfo.getChannelId());
                relationListDto.setChannelName(channelInfo.getChannelName());
            }
            if ((stageInfo = (WeworkContactStage)contactStageMap.get(weworkUserNum + contactRelationDto.getContactId())) != null) {
                CustomerStage customerStage = null;
                if (stageInfo.getStatus() == 1 || stageInfo.getStatus() == 0) {
                    customerStage = this.customerStageMapper.queryStageByPrimaryKey(stageInfo.getStageId());
                } else if (stageInfo.getStatus() == 2) {
                    customerStage = this.customerStageMapper.queryStageByPrimaryKey(stageInfo.getFinalStageId());
                }
                if (customerStage != null) {
                    relationListDto.setStageName(customerStage.getStageName());
                    relationListDto.setStageValue(customerStage.getStageValue());
                    relationListDto.setStageType(customerStage.getType());
                }
            }
            List followContentInfos = this.followRecordMapper.queryFollowContentList(corpId, weworkUserNum, contactRelationDto.getContactId());
            Date lastFollowTime = null;
            ArrayList followRecordInfos = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)followContentInfos)) {
                lastFollowTime = ((FollowContentInfo)followContentInfos.get(0)).getFollowTime();
                for (FollowContentInfo contentInfo : followContentInfos) {
                    FollowInfo followInfo;
                    FollowReqDto reqDto;
                    FollowRecordInfo recordInfo = new FollowRecordInfo();
                    followRecordInfos.add(recordInfo);
                    recordInfo.setFollowTime(contentInfo.getFollowTime());
                    if (StringUtils.isBlank((CharSequence)contentInfo.getParam()) || (reqDto = (FollowReqDto)JSON.parseObject((String)contentInfo.getParam(), FollowReqDto.class)) == null || (followInfo = reqDto.getFollowInfo()) == null) continue;
                    recordInfo.setRemark(followInfo.getRemark());
                }
            }
            relationListDto.setLastFollowTime(lastFollowTime);
            relationListDto.setIsZombieFans(contactRelationDto.getIsZombieFans());
            relationListDto.setFollowRecords(followRecordInfos);
            result.add(relationListDto);
        }
        timer.stop();
        timer.print();
        return result;
    }

    @Override
    public CountResult countList(PreviewDto params) {
        log.info("countList: params:{}", (Object)params);
        PreviewDto.TimeType timeType = PreviewDto.TimeType.getByType(params.getTimeType());
        Preconditions.checkArgument((timeType != null ? 1 : 0) != 0, (Object)"\u4e0d\u5408\u6cd5\u7684\u65f6\u95f4\u7c7b\u578b");
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        String corpId = currentUser.getCorpId();
        Long userId = currentUser.getId();
        log.info("countList: bizId:{},userId:{},corpId:{}", new Object[]{bizId, userId, corpId});
        Date startTime = timeType.getStartTime();
        Date endTime = timeType.getTodayEndTime();
        Set manageUserIds = this.userRoleCommonService.getManageUserIds();
        manageUserIds.add(userId);
        if (StringUtils.isNotBlank((CharSequence)params.getUserId())) {
            Long reqUserId = this.userMapper.getIdByNum(params.getUserId());
            if (Objects.nonNull(reqUserId)) {
                manageUserIds.retainAll(Sets.newHashSet((Object[])new Long[]{reqUserId}));
            } else {
                manageUserIds = Sets.newHashSet();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)params.getDeptId())) {
            List orgListRespDtos = this.orgService.selectOrgByNums((List)Lists.newArrayList((Object[])new String[]{params.getDeptId()}), bizId, corpId);
            List flatOrgListResps = this.orgService.getWeworkOrgId(orgListRespDtos);
            List nodeIds = flatOrgListResps.stream().map(OrgListRespDto::getId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(nodeIds)) {
                manageUserIds = Sets.newHashSet();
            } else {
                Set userIds = this.userMapper.queryUserIdsByNodeIds(nodeIds, Boolean.valueOf(true));
                manageUserIds.retainAll(userIds);
            }
        }
        if (CollectionUtils.isEmpty((Collection)manageUserIds)) {
            return new CountResult();
        }
        log.info("countList: bizId:{},userId:{},manageUserIds:{}", new Object[]{bizId, userId, manageUserIds});
        Map weworkUserMap = this.userMapper.queryUserAndWeworkUserMap((Collection)manageUserIds);
        Collection weworkUserIds = Optional.ofNullable(weworkUserMap).map(Map::values).orElse(Lists.newArrayList());
        Map weworkUserNumsMap = this.weworkUserMapper.selectWeworkUserIdAndNumByWeworkUserIds(corpId, weworkUserIds);
        if (MapUtils.isEmpty((Map)weworkUserNumsMap)) {
            return new CountResult();
        }
        Collection weworkUserNums = weworkUserNumsMap.values();
        Map countByWeworkUserNums = this.weworkContactLogMapper.queryAddExternalStatisticMap(corpId, startTime, endTime, weworkUserNums);
        if (MapUtils.isEmpty((Map)countByWeworkUserNums)) {
            return new CountResult();
        }
        long sum = countByWeworkUserNums.values().stream().mapToLong(Integer::longValue).sum();
        CountResult result = new CountResult();
        result.setTotalCount(Long.valueOf(sum));
        return result;
    }

    @Override
    public ContactRelationDetailDto detail(ContactRelationDetailParams params) {
        WeworkContactRelation contactRelation;
        if (params == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)params.getContactId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5ba2\u6237id\u4e0d\u80fd\u662f\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Long bizId = userInfo.getBizId();
        boolean isDimission = false;
        String queryWeworkUserId = null;
        if (StringUtils.isNotEmpty((CharSequence)params.getWeworkUserId())) {
            WeworkUser weworkUser = new WeworkUser();
            weworkUser.setCorpId(corpId);
            weworkUser.setNum(params.getWeworkUserId());
            weworkUser = (WeworkUser)this.weworkUserMapper.selectOne((Object)weworkUser);
            if (weworkUser == null) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u627e\u4e0d\u5230weworkUser, \u8bf7\u68c0\u67e5weworkUserId\u53c2\u6570\u662f\u5426\u6b63\u786e");
            }
            if (weworkUser.getIsDeleted() == 1) {
                isDimission = true;
            }
            queryWeworkUserId = weworkUser.getWeworkUserId();
        }
        if ((contactRelation = this.weworkContactRelationMapper.queryWeworkContactDetail(corpId, queryWeworkUserId, params.getContactId(), YnEnum.YES.getValue())) == null) {
            if (StringUtils.isNotEmpty(queryWeworkUserId)) {
                contactRelation = this.weworkContactRelationMapper.queryWeworkContactDetail(corpId, null, params.getContactId(), null);
            }
            if (contactRelation == null) {
                return null;
            }
        }
        if (queryWeworkUserId != null && contactRelation.getIsDeleted() == 1) {
            isDimission = true;
        }
        WeworkContact weworkContact = new WeworkContact();
        weworkContact.setCorpId(corpId);
        weworkContact.setContactId(contactRelation.getContactId());
        weworkContact.setIsDeleted(Integer.valueOf(0));
        weworkContact = (WeworkContact)this.weworkContactMapper.selectOne((Object)weworkContact);
        if (weworkContact == null) {
            return null;
        }
        String weworkUserId = contactRelation.getWeworkUserId();
        String contactId = contactRelation.getContactId();
        ContactRelationDetailDto result = new ContactRelationDetailDto();
        result.setId(contactRelation.getNum());
        String weweorkUserNum = this.weworkUserService.getWeworkUserNumById(corpId, contactRelation.getWeworkUserId());
        result.setWeworkUserId(weweorkUserNum);
        result.setContactId(contactRelation.getContactId());
        result.setNickname(weworkContact.getName());
        result.setSex(weworkContact.getGender());
        result.setRemarkName(contactRelation.getRemark());
        result.setType(weworkContact.getType());
        result.setCorpName(weworkContact.getCorpName());
        result.setAvatar(weworkContact.getAvatar());
        result.setRegion(contactRelation.getRegion());
        result.setIsDeleted(contactRelation.getIsDeleted());
        result.setIsZombieFans(contactRelation.getIsZombieFans());
        List<String> remarkMobiles = this.contactMobileService.getRemarkMobile(corpId, weworkUserId, contactId, isDimission ? null : Integer.valueOf(0));
        result.setRemarkMobiles(remarkMobiles);
        List customerMobiles = this.ccCustomerNumService.getMobilesByContactId(bizId, contactId);
        result.setCustomerMobiles(customerMobiles);
        List<WeworkTagDto> weworkTags = this.contactTagService.getWeworkTags(corpId, weworkUserId, contactId, isDimission ? null : Integer.valueOf(0));
        result.setWeworkTags(weworkTags);
        ChannelInfo channelInfo = this.weworkContactLogMapper.queryChannelInfo(corpId, weweorkUserNum, contactId);
        if (channelInfo != null) {
            result.setChannelId(channelInfo.getChannelId());
            result.setChannelName(channelInfo.getChannelName());
        }
        result.setDesc(contactRelation.getDescription());
        String addWayDesc = AddWayType.UNKNOWN.getDesc();
        if (AddWayType.getType((Integer)contactRelation.getAddWay()) != null) {
            addWayDesc = AddWayType.getType((Integer)contactRelation.getAddWay()).getDesc();
        }
        result.setAddWay(contactRelation.getAddWay());
        result.setAddWayDesc(addWayDesc);
        result.setWeworkRooms(this.contactService.queryContactAtRooms(corpId, contactId));
        result.setWeworkUsers(this.contactService.queryContactOwnerWeworkUser(corpId, contactId, queryWeworkUserId));
        return result;
    }

    @Override
    public List<WeworkUserContactDto> queryWeworkContactRelationList(ContactRelationListParams params) {
        List channelIds;
        Set<String> weworkUserIdSet = this.getWeworkUserIdRange(params);
        if (CollectionUtils.isEmpty(weworkUserIdSet)) {
            return Lists.newArrayList();
        }
        Long channelId = null;
        if (StringUtils.isNotBlank((CharSequence)params.getChannelId()) && CollectionUtils.isEmpty((Collection)(channelIds = this.channelMapper.queryChannelIdByNum((Collection)Lists.newArrayList((Object[])new String[]{params.getChannelId()}))))) {
            channelId = (Long)channelIds.get(0);
        }
        String followTimeStr = null;
        if (params.getFollowTime() != null) {
            followTimeStr = DateUtil.dateToDateString((Date)params.getFollowTime(), (String)"yyyy-MM-dd");
        }
        ContactRelationParams queryParams = this.buildQueryParams(params, channelId, followTimeStr, weworkUserIdSet, null);
        return this.weworkContactRelationMapper.queryContactRelations(queryParams);
    }

    private Set<String> getWeworkUserIdRange(ContactRelationListParams params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        if (params == null) {
            params = new ContactRelationListParams();
        }
        Set<String> weworkUserIdSet = this.weworkUserService.queryCurManagerWeworkUser();
        if (params.getIsOnlyMe().booleanValue()) {
            String ownerWeworkUserId = this.userMapper.queryWeworkUserIdOfUser(userInfo.getId());
            weworkUserIdSet.clear();
            weworkUserIdSet.add(ownerWeworkUserId);
        }
        HashSet<String> weworkUserIdsByParams = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)params.getWeworkUserId())) {
            String weworkUserId = this.weworkUserService.getWeworkUserIdByNum(params.getWeworkUserId());
            weworkUserIdsByParams.add(weworkUserId);
        }
        if (CollectionUtils.isNotEmpty(params.getWeworkUserIds())) {
            Map<String, String> weworkUserNumAndWeworkUserIdMap = this.weworkUserService.getWeworkUserIdMapByNums(params.getWeworkUserIds());
            Collection<String> weworkUserIdByParams = weworkUserNumAndWeworkUserIdMap.values();
            weworkUserIdsByParams.addAll(weworkUserIdByParams);
        }
        if (CollectionUtils.isNotEmpty(params.getDeptIds())) {
            Set subOrgIds = this.nodeService.getPosterityIds(params.getDeptIds(), userInfo.getBizId());
            Set deptIds = this.orgService.getDepartmentIds(subOrgIds);
            Set weworkUserIdByDeptParams = this.weworkDepartmentUserMapper.selectWeworkUserId(userInfo.getCorpId(), (Collection)deptIds);
            weworkUserIdsByParams.addAll(weworkUserIdByDeptParams);
        }
        if (StringUtils.isNotBlank((CharSequence)params.getWeworkUserId()) || CollectionUtils.isNotEmpty(params.getWeworkUserIds()) || CollectionUtils.isNotEmpty(params.getDeptIds())) {
            weworkUserIdSet.retainAll(weworkUserIdsByParams);
            if (CollectionUtils.isEmpty(weworkUserIdSet)) {
                log.info("getWeworkUserIdRange,\u6839\u636e\u7ba1\u7406\u6743\u9650\u4e0e\u5458\u5de5\u90e8\u95e8\u7b5b\u9009\u7ed3\u679c\u6c42\u4ea4\u96c6\u4e3a\u7a7a");
                return Collections.emptySet();
            }
        }
        return weworkUserIdSet;
    }

    private ContactRelationParams buildQueryParams(ContactRelationListParams params, Long channelId, String followTimeStr, Set<String> weworkUserIdSet, String customerNum) {
        CustomerStage customerStage;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        ContactRelationParams queryParams = new ContactRelationParams();
        queryParams.setBizId(userInfo.getBizId());
        queryParams.setCorpId(userInfo.getCorpId());
        queryParams.setAddTimeStart(params.getAddTimeStart());
        queryParams.setAddTimeEnd(params.getAddTimeEnd());
        queryParams.setAddWay(params.getAddWay());
        queryParams.setChannelId(channelId);
        if (followTimeStr != null) {
            queryParams.setFollowTimeStart(new Date(DateUtil.getTheDateBegin((String)followTimeStr)));
            queryParams.setFollowTimeEnd(new Date(DateUtil.getTheDateEnd((String)followTimeStr)));
        }
        queryParams.setManagerWeworkUserIds(weworkUserIdSet);
        queryParams.setMobile(params.getMobile());
        queryParams.setCustomerNum(customerNum);
        queryParams.setQuery(params.getQuery());
        queryParams.setIsZombieFans(params.getIsZombieFans());
        if (params.getStageId() != null && (customerStage = this.customerStageMapper.queryStageByPrimaryKey(params.getStageId())) != null) {
            queryParams.setStageType(customerStage.getType());
            queryParams.setStageId(params.getStageId());
        }
        queryParams.setWeworkTagIds(params.getWeworkTagIds());
        queryParams.setPageDto(params.getPageDto());
        if ("descend".equals(params.getSortOrder())) {
            queryParams.setSortOrder("desc");
        } else if ("ascend".equals(params.getSortOrder())) {
            queryParams.setSortOrder("asc");
        }
        return queryParams;
    }

    @Override
    public boolean isExternalUserRelation(String corpId, String weworkUserId, String contactId) {
        int count = this.weworkContactRelationMapper.queryExternalUserRelation(corpId, weworkUserId, contactId);
        return count > 0;
    }

    @Override
    public List<UserContactInfo> queryContactInfo(ContactQueryDto queryDto) {
        log.info("queryContactInfo with req={}", (Object)queryDto);
        Preconditions.checkArgument((queryDto != null ? 1 : 0) != 0, (Object)"queryDto \u4e0d\u80fd\u4e3a\u7a7a");
        queryDto.validate();
        return this.weworkContactRelationMapper.queryByWeworkUserIdAndQuery(queryDto.getUseAgent(), queryDto.getCorpId(), queryDto.getBizId(), queryDto.getWeworkUserId(), queryDto.getQuery(), queryDto.getContactIds());
    }

    @Override
    public List<ContactWeworkPair> queryRemain(String corpId, Set<ContactWeworkPair> contactWeworkPairs, Integer onlyVip) {
        if (CollectionUtils.isEmpty(contactWeworkPairs)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        List partition = Lists.partition((List)Lists.newArrayList(contactWeworkPairs), (int)50);
        for (List weworkPairs : partition) {
            List temList = this.weworkContactRelationMapper.queryRemainRelation(corpId, weworkPairs, onlyVip);
            result.addAll(temList);
        }
        return result;
    }

    @Override
    @Transactional
    public ContactRelationParams startExportTask(ContactRelationListParams params) {
        log.info("export task params: {}", (Object)params);
        if (params == null) {
            ExportTask update = new ExportTask();
            update.setErrorMsg("\u53c2\u6570\u4e3a\u7a7a");
            update.setUpdateTime(new Date());
            update.setStatus(Integer.valueOf(2));
            this.exportTaskMapper.updateByPrimaryKeySelective((Object)update);
            return null;
        }
        ContactRelationParams queryParam = this.convertReqParamToQueryParam(params);
        log.info("queryParams: {}", (Object)queryParam);
        return queryParam;
    }

    public ContactRelationParams convertReqParamToQueryParam(ContactRelationListParams params) {
        List channelIds;
        log.info("list params: {}", (Object)params);
        if (params == null) {
            return null;
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        if (userInfo == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long bizId = userInfo.getBizId();
        StopWatchDto timer = new StopWatchDto("contact list", true, log);
        timer.start("getWeworkUserIdRange");
        Set<String> weworkUserIdSet = this.getWeworkUserIdRange(params);
        timer.stop();
        if (CollectionUtils.isEmpty(weworkUserIdSet)) {
            return null;
        }
        Long channelId = null;
        if (StringUtils.isNotBlank((CharSequence)params.getChannelId()) && CollectionUtils.isEmpty((Collection)(channelIds = this.channelMapper.queryChannelIdByNum((Collection)Lists.newArrayList((Object[])new String[]{params.getChannelId()}))))) {
            channelId = (Long)channelIds.get(0);
        }
        String followTimeStr = null;
        if (params.getFollowTime() != null) {
            followTimeStr = DateUtil.dateToDateString((Date)params.getFollowTime(), (String)"yyyy-MM-dd");
        }
        String customerNumQuery = null;
        if (StringUtils.isNotBlank((CharSequence)params.getCustomerMobile()) && StringUtils.isBlank((CharSequence)(customerNumQuery = this.ccCustomerNumService.getContactCustomerNumByMobile(bizId, params.getCustomerMobile())))) {
            return null;
        }
        return this.buildQueryParams(params, channelId, followTimeStr, weworkUserIdSet, customerNumQuery);
    }

    @Override
    public BatchPhoneDto contactPhoneBatchId(ContactPhoneIdParam params) {
        List channelIds;
        log.info("list params: {}", (Object)params);
        if (params == null) {
            return null;
        }
        Preconditions.checkArgument((params.getIsSelectAll() != null ? 1 : 0) != 0, (Object)"\u662f\u5426\u5168\u9009\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        if (userInfo == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String corpId = userInfo.getCorpId();
        Long bizId = userInfo.getBizId();
        StopWatchDto timer = new StopWatchDto("contact list", true, log);
        timer.start("getWeworkUserIdRange");
        Set<String> weworkUserIdSet = this.getWeworkUserIdRange(params);
        timer.stop();
        if (CollectionUtils.isEmpty(weworkUserIdSet)) {
            return null;
        }
        Long channelId = null;
        if (StringUtils.isNotBlank((CharSequence)params.getChannelId()) && CollectionUtils.isEmpty((Collection)(channelIds = this.channelMapper.queryChannelIdByNum((Collection)Lists.newArrayList((Object[])new String[]{params.getChannelId()}))))) {
            channelId = (Long)channelIds.get(0);
        }
        String followTimeStr = null;
        if (params.getFollowTime() != null) {
            followTimeStr = DateUtil.dateToDateString((Date)params.getFollowTime(), (String)"yyyy-MM-dd");
        }
        String customerNumQuery = null;
        if (StringUtils.isNotBlank((CharSequence)params.getCustomerMobile()) && StringUtils.isBlank((CharSequence)(customerNumQuery = this.ccCustomerNumService.getContactCustomerNumByMobile(bizId, params.getCustomerMobile())))) {
            return null;
        }
        ContactRelationParams queryParams = this.buildQueryParams(params, channelId, followTimeStr, weworkUserIdSet, customerNumQuery);
        queryParams.setPageDto(null);
        timer.start("queryContactRelationList");
        List list = this.weworkContactRelationMapper.queryContactRelationList(queryParams);
        timer.stop();
        log.info("contactPhoneBatchId list size: {}", (Object)list.size());
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        List relationIds = list.stream().map(ContactRelationDto::getNum).collect(Collectors.toList());
        log.info("contactPhoneBatchId relationIds: {}", relationIds);
        List<String> weworkUserIds = list.stream().map(ContactRelationDto::getWeworkUserId).collect(Collectors.toList());
        List<String> contactIds = list.stream().map(ContactRelationDto::getContactId).collect(Collectors.toList());
        Map<String, List<String>> remarkMobileMap = this.contactMobileService.getRemarkMobile(bizId, corpId, weworkUserIds, contactIds);
        List weworkContactList = this.weworkContactMapper.queryWeworkContactList(corpId, contactIds);
        Map weworkContactMap = weworkContactList.stream().collect(Collectors.toMap(WeworkContact::getContactId, Function.identity()));
        List<ContactRelationDto> relationList = Lists.newArrayList();
        if (params.getIsSelectAll() == 0) {
            if (CollectionUtils.isNotEmpty(params.getIds())) {
                for (ContactRelationDto relationDto : list) {
                    if (!params.getIds().contains(relationDto.getNum())) continue;
                    relationList.add(relationDto);
                }
            }
        } else {
            relationList = list;
        }
        log.info("contactPhoneBatchId relationList size: {}", (Object)relationList.size());
        ArrayList customers = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(relationList)) {
            for (ContactRelationDto relationDto : relationList) {
                CustomerDto dto = new CustomerDto();
                String key = relationDto.getWeworkUserId() + relationDto.getContactId();
                List<String> mobiles = remarkMobileMap.get(key);
                if (!CollectionUtils.isNotEmpty(mobiles)) continue;
                String phone = mobiles.get(0);
                dto.setPhone(phone);
                WeworkContact weworkContact = (WeworkContact)weworkContactMap.get(relationDto.getContactId());
                String name = relationDto.getRemark();
                dto.setName(StringUtils.isEmpty((CharSequence)name) ? weworkContact.getName() : name);
                customers.add(dto);
            }
        }
        log.info("contactPhoneBatchId customers: {}", (Object)customers);
        return this.cachePhoneService.batchIdByCustomer((List)customers);
    }

    @Override
    public BatchPhoneDto customerPhoneBatchId(ContactPhoneIdParam params) {
        List channelIds;
        log.info("list params: {}", (Object)params);
        if (params == null) {
            return null;
        }
        Preconditions.checkArgument((params.getIsSelectAll() != null ? 1 : 0) != 0, (Object)"\u662f\u5426\u5168\u9009\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        if (userInfo == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String corpId = userInfo.getCorpId();
        Long bizId = userInfo.getBizId();
        StopWatchDto timer = new StopWatchDto("contact list", true, log);
        timer.start("getWeworkUserIdRange");
        Set<String> weworkUserIdSet = this.getWeworkUserIdRange(params);
        timer.stop();
        if (CollectionUtils.isEmpty(weworkUserIdSet)) {
            return null;
        }
        Long channelId = null;
        if (StringUtils.isNotBlank((CharSequence)params.getChannelId()) && CollectionUtils.isEmpty((Collection)(channelIds = this.channelMapper.queryChannelIdByNum((Collection)Lists.newArrayList((Object[])new String[]{params.getChannelId()}))))) {
            channelId = (Long)channelIds.get(0);
        }
        String followTimeStr = null;
        if (params.getFollowTime() != null) {
            followTimeStr = DateUtil.dateToDateString((Date)params.getFollowTime(), (String)"yyyy-MM-dd");
        }
        String customerNumQuery = null;
        if (StringUtils.isNotBlank((CharSequence)params.getCustomerMobile()) && StringUtils.isBlank((CharSequence)(customerNumQuery = this.ccCustomerNumService.getContactCustomerNumByMobile(bizId, params.getCustomerMobile())))) {
            return null;
        }
        ContactRelationParams queryParams = this.buildQueryParams(params, channelId, followTimeStr, weworkUserIdSet, customerNumQuery);
        queryParams.setPageDto(null);
        timer.start("queryContactRelationList");
        List list = this.weworkContactRelationMapper.queryContactRelationList(queryParams);
        timer.stop();
        log.info("customerPhoneBatchId list size: {}", (Object)list.size());
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        List relationIds = list.stream().map(ContactRelationDto::getNum).collect(Collectors.toList());
        log.info("customerPhoneBatchId relationIds: {}", relationIds);
        List contactIds = list.stream().map(ContactRelationDto::getContactId).collect(Collectors.toList());
        List weworkContactList = this.weworkContactMapper.queryWeworkContactList(corpId, contactIds);
        Map weworkContactMap = weworkContactList.stream().collect(Collectors.toMap(WeworkContact::getContactId, Function.identity()));
        List<ContactRelationDto> relationList = Lists.newArrayList();
        if (params.getIsSelectAll() == 0) {
            if (CollectionUtils.isNotEmpty(params.getIds())) {
                for (ContactRelationDto relationDto : list) {
                    if (!params.getIds().contains(relationDto.getNum())) continue;
                    relationList.add(relationDto);
                }
            }
        } else {
            relationList = list;
        }
        log.info("customerPhoneBatchId relationList size: {}", (Object)relationList.size());
        ArrayList customers = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(relationList)) {
            for (ContactRelationDto relationDto : relationList) {
                CustomerDto dto = new CustomerDto();
                List customerMobiles = this.ccCustomerNumService.getMobilesByContactId(bizId, relationDto.getContactId());
                if (!CollectionUtils.isNotEmpty((Collection)customerMobiles)) continue;
                String phone = (String)customerMobiles.get(0);
                dto.setPhone(phone);
                WeworkContact weworkContact = (WeworkContact)weworkContactMap.get(relationDto.getContactId());
                String name = relationDto.getRemark();
                dto.setName(StringUtils.isEmpty((CharSequence)name) ? weworkContact.getName() : name);
                customers.add(dto);
            }
        }
        log.info("customerPhoneBatchId customers: {}", (Object)customers);
        return this.cachePhoneService.batchIdByCustomer((List)customers);
    }

    @Override
    public List<CustomerDto> phoneByBatchId(ContactPhoneIdParam params) {
        log.info("phoneByBatchId params: {}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getBatchId()), (Object)"batchId\u4e0d\u80fd\u4e3a\u7a7a");
        return this.cachePhoneService.getCustomer(params.getBatchId());
    }

    @Override
    public List<ContactCallRecordRespDto> callList(ContactRelationListParams params) {
        boolean mobileEncrypt;
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53c2\u6570\u4e0d\u80fd\u662f\u7a7a");
        }
        String contactId = params.getContactId();
        if (StringUtils.isBlank((CharSequence)contactId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5ba2\u6237id\u4e0d\u80fd\u662f\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Long bizId = userInfo.getBizId();
        log.info("contact callList params:{}, corpId:{}", (Object)params, (Object)corpId);
        String customerNum = this.ccCustomerNumService.getCustomerNumByWeworkContactId(bizId, contactId, null);
        CustomerDetailResp resp = this.ccCustomerInfoService.queryCustomerDetail(bizId, customerNum);
        ArrayList mobiles = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)resp.getMobile1())) {
            mobiles.add(resp.getMobile1());
        }
        if (StringUtils.isNotBlank((CharSequence)resp.getMobile2())) {
            mobiles.add(resp.getMobile2());
        }
        if (CollectionUtils.isEmpty((Collection)mobiles)) {
            return Collections.emptyList();
        }
        CallRecordQueryParams queryParams = new CallRecordQueryParams();
        queryParams.setBizId(bizId);
        queryParams.setPhones((List)mobiles);
        queryParams.setPageDto(params.getPageDto());
        log.info("contact queryList params:{}", (Object)params);
        List records = this.callRecordMapper.queryList(queryParams);
        ArrayList<ContactCallRecordRespDto> resultList = new ArrayList<ContactCallRecordRespDto>();
        String paramValue = this.settingService.getSettingDetail(bizId, SettingEnum.MOBILE_ENCRYPT.getName());
        boolean bl = mobileEncrypt = paramValue != null && paramValue.equals("1");
        if (!CollectionUtils.isEmpty((Collection)records)) {
            for (CallRecord callRecord : records) {
                resultList.add(ContactCallRecordRespDto.from(callRecord, mobileEncrypt));
            }
        }
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(this.callRecordMapper.queryCount(queryParams)));
            params.getPageDto().setCurPageCount(Integer.valueOf(resultList.size()));
        }
        return resultList;
    }
}

