/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.insight.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.kinyun.wework.sdk.api.external.ExternalStatisticClient;
import cn.kinyun.wework.sdk.entity.chat.ChatMsg;
import cn.kinyun.wework.sdk.entity.external.statistic.BehaviorData;
import cn.kinyun.wework.sdk.entity.external.statistic.GroupChatStatisticParam;
import cn.kinyun.wework.sdk.entity.external.statistic.GroupStatisticData;
import cn.kinyun.wework.sdk.entity.external.statistic.GroupStatisticItem;
import cn.kinyun.wework.sdk.entity.external.statistic.GroupStatisticResult;
import cn.kinyun.wework.sdk.entity.external.statistic.OwnerFilterParam;
import cn.kinyun.wework.sdk.entity.external.statistic.UserBehaviorParams;
import com.alibaba.dubbo.rpc.RpcException;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.BDataValueDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.ContactStatisticDataTypeEnum;
import com.kuaike.scrm.common.enums.QualityBehaviorType;
import com.kuaike.scrm.common.enums.QualityCheckType;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.MessageCommonService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.contactanalyse.entity.WeworkContactChangeLog;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkContactChangeLogMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckLog;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckLogMapper;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.WeworkUserQuery;
import com.kuaike.scrm.dal.wework.dto.ChatRoomDataStatisticQuery;
import com.kuaike.scrm.dal.wework.dto.ContactStatisticDataQuery;
import com.kuaike.scrm.dal.wework.entity.ChatRoomDataStatisticRecord;
import com.kuaike.scrm.dal.wework.entity.ContactDistinctStatisticRecord;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.entity.WeworkUserStatisticsRecord;
import com.kuaike.scrm.dal.wework.mapper.ChatRoomDataStatisticRecordMapper;
import com.kuaike.scrm.dal.wework.mapper.ContactDistinctStatisticRecordMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserStatisticsRecordMapper;
import com.kuaike.scrm.wework.department.service.DepartmentService;
import com.kuaike.scrm.wework.insight.dto.ChatRoomStatisticData;
import com.kuaike.scrm.wework.insight.service.WeworkInsightService;
import com.kuaike.scrm.wework.insight.service.dto.ContactStatisticData;
import com.kuaike.scrm.wework.weworkuser.dto.ExternalStatisticMutilParams;
import com.kuaike.scrm.wework.weworkuser.dto.ExternalUserStatisticDto;
import com.kuaike.scrm.wework.weworkuser.dto.StatisticResult;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WeworkInsightServiceImpl
implements WeworkInsightService {
    private static final Logger log = LoggerFactory.getLogger(WeworkInsightServiceImpl.class);
    @Resource
    private IdGen idGen;
    @Resource
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Resource
    private ChatRoomDataStatisticRecordMapper chatRoomDataStatisticRecordMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private OrganizationMapper organizationMapper;
    @Resource
    private NodeService nodeService;
    @Resource
    private WeworkUserStatisticsRecordMapper weworkUserStatisticsRecordMapper;
    @Resource
    private ContactDistinctStatisticRecordMapper contactDistinctStatisticRecordMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private ExternalStatisticClient externalStatisticClient;
    @Resource
    private UserRoleCommonService userRoleCommonService;
    @Resource
    private MessageCommonService messageCommonService;
    @Resource
    private QualityCheckLogMapper qualityCheckLogMapper;
    @Resource
    private WeworkUserService weworkUserService;
    @Resource
    private DepartmentService departmentService;
    @Resource
    private WeworkContactChangeLogMapper weworkContactChangeLogMapper;
    private static final int PROCESSORS = Runtime.getRuntime().availableProcessors();
    private final ExecutorService pullChatRoomDataExecutorService = new ThreadPoolExecutor(PROCESSORS, 2 * PROCESSORS, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("pullChatRoomDataExecutorService"));
    private final ExecutorService pullContactataExecutorService = new ThreadPoolExecutor(PROCESSORS, 2 * PROCESSORS, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("pullContactDataExecutorService"));

    @Override
    public void handleRedPacketMsg(ChatMsg chatMsg) {
        log.info("handleRedPacketMsg,chatMsg:{}", (Object)chatMsg);
        if (chatMsg == null) {
            log.warn("chatMsg is null");
            return;
        }
        if (chatMsg.getRedPacket() == null) {
            log.warn("redPacket is null");
            return;
        }
        long totalAmount = chatMsg.getRedPacket().getTotalAmount() * 100;
        try {
            if (StringUtils.isNotBlank((CharSequence)chatMsg.getRoomId())) {
                this.handleChatRoomRedPacketMsg(chatMsg, totalAmount);
            } else {
                this.handleWeworkContactRedPacketMsg(chatMsg, totalAmount);
            }
        }
        catch (Exception ex) {
            log.error("\u5904\u7406\u7ea2\u5305\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606fid:{},\u5f02\u5e38\u4fe1\u606f:", (Object)chatMsg.getMsgId(), (Object)ex);
        }
    }

    @Override
    public void pullChatRoomStatisticData(Date startTime, Date endTime, Long bizId) {
        log.info("pullChatRoomStatisticData,startTime:{},endTime:{},bizId:{}", new Object[]{startTime, endTime, bizId});
        if (Objects.isNull(startTime) || Objects.isNull(endTime)) {
            log.warn("startTime or endTime is null");
            return;
        }
        List<BusinessCustomer> businessCustomers = this.businessCustomerMapper.queryBizIdAndCorpIdByStatusAndDelFlag(NumberUtils.INTEGER_ONE, NumberUtils.INTEGER_ZERO);
        if (CollectionUtils.isEmpty((Collection)businessCustomers)) {
            log.warn("\u672a\u67e5\u8be2\u5230\u72b6\u6001\u4e3a\u6b63\u5e38\u3001\u672a\u5220\u9664\u7684\u5546\u6237");
            return;
        }
        if (bizId != null && bizId > 0L) {
            BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
            businessCustomers = Collections.singletonList(businessCustomer);
        }
        long betweenDays = DateUtil.betweenDay((Date)startTime, (Date)endTime, (boolean)false);
        for (BusinessCustomer businessCustomer : businessCustomers) {
            this.pullChatRoomDataExecutorService.execute(() -> {
                try {
                    this.pullSingleCorpChatRoomData(businessCustomer, startTime, endTime, betweenDays);
                }
                catch (Exception ex) {
                    log.error("\u62c9\u53d6\u5546\u6237bizId:{},startTime:{},endTime:{}\u7684\u7fa4\u7edf\u8ba1\u6570\u636e\u53d1\u751f\u5f02\u5e38:", new Object[]{businessCustomer.getId(), startTime, endTime, ex});
                }
            });
        }
    }

    @Override
    public void syncChatRoomHistoryRedPacketData(Date startTime, Date endTime) {
        log.info("syncChatRoomHistoryRedPacketData,startTime:{},endTime:{}", (Object)startTime, (Object)endTime);
        if (startTime == null || endTime == null) {
            log.warn("startTime or endTime is null");
            return;
        }
        List businessCustomers = this.businessCustomerMapper.queryBizIdAndCorpIdByStatusAndDelFlag(NumberUtils.INTEGER_ONE, NumberUtils.INTEGER_ZERO);
        if (CollectionUtils.isEmpty((Collection)businessCustomers)) {
            log.warn("\u672a\u67e5\u8be2\u5230\u72b6\u6001\u4e3a\u6b63\u5e38\u3001\u672a\u5220\u9664\u7684\u5546\u6237");
            return;
        }
        long betweenDays = DateUtil.betweenDay((Date)startTime, (Date)endTime, (boolean)false);
        for (BusinessCustomer businessCustomer : businessCustomers) {
            this.pullChatRoomDataExecutorService.execute(() -> {
                try {
                    this.handleChatRoomHistoryRedPacketData(businessCustomer, startTime, endTime, betweenDays);
                }
                catch (Exception ex) {
                    log.error("\u5904\u7406\u5546\u6237bizId:{},startTime:{},endTime:{}\u7684\u7fa4\u5386\u53f2\u7ea2\u5305\u6570\u636e\u53d1\u751f\u5f02\u5e38:", new Object[]{businessCustomer.getId(), startTime, endTime, ex});
                }
            });
        }
    }

    @Override
    public void handleContactRedPacketData(Date startTime, Date endTime) {
        log.info("handleContactRedPacketData,startTime:{},endTime:{}", (Object)startTime, (Object)endTime);
        if (startTime == null || endTime == null) {
            log.warn("startTime or endTime is null");
            return;
        }
        List businessCustomers = this.businessCustomerMapper.queryBizIdAndCorpIdByStatusAndDelFlag(NumberUtils.INTEGER_ONE, NumberUtils.INTEGER_ZERO);
        if (CollectionUtils.isEmpty((Collection)businessCustomers)) {
            log.warn("\u672a\u67e5\u8be2\u5230\u72b6\u6001\u4e3a\u6b63\u5e38\u3001\u672a\u5220\u9664\u7684\u5546\u6237");
            return;
        }
        long betweenDays = DateUtil.betweenDay((Date)startTime, (Date)endTime, (boolean)false);
        for (BusinessCustomer bs : businessCustomers) {
            this.pullContactataExecutorService.execute(() -> {
                try {
                    this.handleContactHistoryRedPacketData(bs, startTime, endTime, betweenDays);
                }
                catch (Exception ex) {
                    log.error("\u5904\u7406\u5546\u6237bizId:{},startTime:{},endTime:{}\u7684\u5355\u804a\u5386\u53f2\u7ea2\u5305\u6570\u636e\u53d1\u751f\u5f02\u5e38:", new Object[]{bs.getId(), startTime, endTime, ex});
                }
            });
        }
    }

    @Override
    public ExternalUserStatisticDto getContactDistinctStatisticData(ExternalStatisticMutilParams params) {
        log.info("getContactDistinctStatisticData,params:{}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((params.getContactStatisticDataType() != null ? 1 : 0) != 0, (Object)"\u5ba2\u6237\u53bb\u91cd\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        params.checkParams();
        ContactStatisticDataTypeEnum contactStatisticDataTypeEnum = ContactStatisticDataTypeEnum.get((int)params.getContactStatisticDataType());
        Preconditions.checkArgument((params.getContactStatisticDataType() != null ? 1 : 0) != 0, (Object)"\u5ba2\u6237\u53bb\u91cd\u6570\u636e\u503c\u4e0d\u5408\u6cd5");
        List statisticRecords = this.contactDistinctStatisticRecordMapper.queryByTime(userInfo.getBizId(), params.getStartTime(), params.getEndTime());
        Map<Object, Object> statisticDate2RecordMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)statisticRecords)) {
            statisticDate2RecordMap = statisticRecords.stream().collect(Collectors.toMap(ContactDistinctStatisticRecord::getStatisticDate, Functions.identity()));
        }
        long betweenDay = DateUtil.betweenDay((Date)params.getStartTime(), (Date)params.getEndTime(), (boolean)false);
        DateTime todayStartTime = DateUtil.beginOfDay((Date)new Date());
        int todayTotalCount = 0;
        if (todayStartTime.before(params.getEndTime()) || todayStartTime.equals(params.getEndTime())) {
            todayTotalCount = this.weworkContactMapper.queryTotalCountByCorpId(userInfo.getCorpId());
        }
        ExternalUserStatisticDto externalUserStatisticDto = new ExternalUserStatisticDto();
        ArrayList contactCountList = Lists.newArrayList();
        Date startTime = params.getStartTime();
        for (long i = 0L; i <= betweenDay; ++i) {
            StatisticResult statisticResult = new StatisticResult();
            contactCountList.add(statisticResult);
            statisticResult.setDay(DateUtil.format((Date)startTime, (String)"yyyy-MM-dd"));
            int count = 0;
            switch (contactStatisticDataTypeEnum) {
                case TOTAL: {
                    if (startTime.equals(todayStartTime)) {
                        count = todayTotalCount;
                        break;
                    }
                    if (!statisticDate2RecordMap.containsKey(startTime)) break;
                    count = ((ContactDistinctStatisticRecord)statisticDate2RecordMap.get(startTime)).getTotal();
                    break;
                }
                case ADD: {
                    if (!statisticDate2RecordMap.containsKey(startTime)) break;
                    count = ((ContactDistinctStatisticRecord)statisticDate2RecordMap.get(startTime)).getNewTotal();
                    break;
                }
                case DEL: {
                    if (!statisticDate2RecordMap.containsKey(startTime)) break;
                    count = ((ContactDistinctStatisticRecord)statisticDate2RecordMap.get(startTime)).getDelTotal();
                    break;
                }
            }
            statisticResult.setCount(count);
            startTime = DateUtil.offsetDay((Date)startTime, (int)1);
        }
        switch (contactStatisticDataTypeEnum) {
            case TOTAL: {
                externalUserStatisticDto.setTotalContactCountList(contactCountList);
                break;
            }
            case ADD: {
                externalUserStatisticDto.setAddContactCountList(contactCountList);
                break;
            }
            case DEL: {
                externalUserStatisticDto.setDelContactCountList(contactCountList);
                break;
            }
        }
        return externalUserStatisticDto;
    }

    @Override
    public List<ChatRoomStatisticData> getChatRoomStatisticData(ExternalStatisticMutilParams params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        log.info("getChatRoomStatisticData,params:{},operatorId:{}", (Object)params, (Object)userInfo.getId());
        params.checkParams();
        Collection<String> weworkUserIds = this.getWeworkUserIdsByNum(userInfo.getCorpId(), params.getWeworkUserIds(), params.getDeptIds());
        if (CollectionUtils.isEmpty(weworkUserIds)) {
            return Collections.emptyList();
        }
        ChatRoomDataStatisticQuery statisticQuery = new ChatRoomDataStatisticQuery();
        statisticQuery.setBizId(userInfo.getBizId());
        statisticQuery.setStartTime(params.getStartTime());
        statisticQuery.setEndTime(params.getEndTime());
        statisticQuery.setWeworkUserIds(weworkUserIds);
        statisticQuery.setPageSize(params.getPageDto().getPageSize());
        statisticQuery.setOffset(Integer.valueOf((params.getPageDto().getPageNum() - 1) * params.getPageDto().getPageSize()));
        List statisticRecords = this.chatRoomDataStatisticRecordMapper.queryListByParams(statisticQuery);
        if (CollectionUtils.isEmpty((Collection)statisticRecords)) {
            log.info("\u6839\u636estatisticQuery:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)statisticQuery);
            return Collections.emptyList();
        }
        int count = this.chatRoomDataStatisticRecordMapper.selectCountByParams(statisticQuery);
        params.getPageDto().setCount(Integer.valueOf(count));
        Date endTime = params.getEndTime();
        if (DateUtil.isSameDay((Date)params.getEndTime(), (Date)new Date())) {
            endTime = DateUtil.offsetDay((Date)params.getEndTime(), (int)-1);
        }
        List resultWeworkUserIds = statisticRecords.stream().map(ChatRoomDataStatisticRecord::getWeworkUserId).collect(Collectors.toList());
        List resultStatisticRecords = this.chatRoomDataStatisticRecordMapper.queryByWeworkUserIdsAndStatisticDate(userInfo.getBizId(), resultWeworkUserIds, endTime);
        Map weworkUserId2NameMap = this.weworkUserMapper.queryWeworkUserNameMap(userInfo.getCorpId(), resultWeworkUserIds);
        return this.buildChatRoomDataStatisticResult(statisticRecords, resultStatisticRecords, weworkUserId2NameMap);
    }

    @Override
    public void pullContactStatisticData(Date startTime, Date endTime, Long bizId) {
        log.info("pullContactStatisticData,startTime:{},endTime:{},bizId: {}", new Object[]{startTime, endTime, bizId});
        if (startTime == null || endTime == null) {
            log.warn("pullContactStatisticData startTime or endTime is null");
            return;
        }
        List<BusinessCustomer> businessCustomers = this.businessCustomerMapper.queryBizIdAndCorpIdByStatusAndDelFlag(NumberUtils.INTEGER_ONE, NumberUtils.INTEGER_ZERO);
        if (CollectionUtils.isEmpty((Collection)businessCustomers)) {
            log.warn("\u672a\u67e5\u8be2\u5230\u72b6\u6001\u4e3a\u6b63\u5e38\u3001\u672a\u5220\u9664\u7684\u5546\u6237");
            return;
        }
        if (bizId != null && bizId > 0L) {
            BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
            businessCustomers = Collections.singletonList(businessCustomer);
        }
        for (BusinessCustomer businessCustomer : businessCustomers) {
            log.info("pullContactStatisticData get data bizId: {}", (Object)businessCustomer.getId());
            this.pullContactataExecutorService.execute(() -> {
                try {
                    this.pullSingleCorpContactData(businessCustomer, startTime, endTime, null);
                }
                catch (Exception ex) {
                    log.error("\u62c9\u53d6\u5546\u6237bizId:{},startTime:{},endTime:{}\u7684\u8054\u7cfb\u4eba\u7edf\u8ba1\u6570\u636e\u53d1\u751f\u5f02\u5e38:", new Object[]{businessCustomer.getId(), startTime, endTime, ex});
                }
            });
        }
    }

    @Override
    public List<ContactStatisticData> getContactStatisticData(ExternalStatisticMutilParams params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        log.info("getContactStatisticData,params:{},operatorId:{}", (Object)params, (Object)userInfo.getId());
        params.checkParams();
        Collection<String> weworkUserIds = this.getWeworkUserIdsByNum(userInfo.getCorpId(), params.getWeworkUserIds(), params.getDeptIds());
        if (CollectionUtils.isEmpty(weworkUserIds)) {
            return Collections.emptyList();
        }
        log.info("getContactStatisticData get weworkUserIds: {}", weworkUserIds);
        ContactStatisticDataQuery query = new ContactStatisticDataQuery();
        query.setBizId(userInfo.getBizId());
        query.setStartTime(params.getStartTime());
        query.setEndTime(params.getEndTime());
        query.setWeworkUserIds(weworkUserIds);
        query.setPageSize(params.getPageDto().getPageSize());
        query.setOffset(Integer.valueOf((params.getPageDto().getPageNum() - 1) * params.getPageDto().getPageSize()));
        List statisticRecords = this.weworkUserStatisticsRecordMapper.queryListByParams(query);
        if (CollectionUtils.isEmpty((Collection)statisticRecords)) {
            log.info("getContactStatisticData \u6839\u636estatisticQuery:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)query);
            return Collections.emptyList();
        }
        int count = this.weworkUserStatisticsRecordMapper.selectCountByParams(query);
        params.getPageDto().setCount(Integer.valueOf(count));
        List resultWeworkUserIds = statisticRecords.stream().map(WeworkUserStatisticsRecord::getWeworkUserId).collect(Collectors.toList());
        Map weworkUserId2NameMap = this.weworkUserMapper.queryWeworkUserNameMap(userInfo.getCorpId(), resultWeworkUserIds);
        log.info("getContactStatisticData get weworkUserId2NameMap: {}", (Object)weworkUserId2NameMap);
        ArrayList statisticDataList = Lists.newArrayList();
        for (WeworkUserStatisticsRecord statisticsRecord : statisticRecords) {
            ContactStatisticData data = new ContactStatisticData();
            statisticDataList.add(data);
            data.setWeworkUserId(statisticsRecord.getWeworkUserId());
            if (MapUtils.isNotEmpty((Map)weworkUserId2NameMap)) {
                data.setWeworkUserName((String)weworkUserId2NameMap.get(statisticsRecord.getWeworkUserId()));
            }
            data.setAddApplyCount(statisticsRecord.getAddApplyCount());
            data.setAddContactCount(statisticsRecord.getAddContactCount());
            data.setZombieFansCount(statisticsRecord.getZombieFansCount());
            data.setChatCount(statisticsRecord.getChatCount());
            data.setMessageCount(statisticsRecord.getMessageCount());
            if (statisticsRecord.getReplyPercentage() != null && statisticsRecord.getReplyPercentage().floatValue() != 0.0f) {
                String percent = String.format("%.2f", statisticsRecord.getReplyPercentage()) + "%";
                data.setReplyPrecent(percent);
            } else {
                data.setReplyPrecent("0");
            }
            if (statisticsRecord.getAvgReplyTime() != null) {
                data.setAvgReplyTime(statisticsRecord.getAvgReplyTime());
            } else {
                data.setAvgReplyTime(0);
            }
            data.setTimeOutReplyCount(statisticsRecord.getTimeOutReplyCount());
            data.setRedPacketCount(statisticsRecord.getRedPacketCount());
            data.setRedPacketAmount(Float.valueOf((float)statisticsRecord.getRedPacketTotalAmount().longValue() / 10000.0f));
            data.setTriggerWordCount(statisticsRecord.getTriggerWordCount());
            data.setTriggerBehaviorCount(statisticsRecord.getTriggerBehaviorCount());
        }
        return statisticDataList;
    }

    @Override
    public void statisticContactDistinctTotalCount() {
        DateTime yesterday = DateUtil.beginOfDay((Date)DateUtil.yesterday());
        List businessCustomers = this.businessCustomerMapper.queryBizIdAndCorpIdByStatusAndDelFlag(NumberUtils.INTEGER_ONE, NumberUtils.INTEGER_ZERO);
        if (CollectionUtils.isEmpty((Collection)businessCustomers)) {
            log.warn("\u672a\u67e5\u8be2\u5230\u72b6\u6001\u4e3a\u6b63\u5e38\u3001\u672a\u5220\u9664\u7684\u5546\u6237");
            return;
        }
        ArrayList corpIds = Lists.newArrayList();
        HashMap corpId2BizIdMap = Maps.newHashMap();
        for (BusinessCustomer businessCustomer : businessCustomers) {
            corpIds.add(businessCustomer.getCorpId());
            corpId2BizIdMap.put(businessCustomer.getCorpId(), businessCustomer.getId());
        }
        ArrayList statisticRecords = Lists.newArrayList();
        Lists.partition((List)corpIds, (int)5).forEach(arg_0 -> this.lambda$statisticContactDistinctTotalCount$4(statisticRecords, corpId2BizIdMap, (Date)yesterday, arg_0));
        if (CollectionUtils.isNotEmpty((Collection)statisticRecords)) {
            log.info("\u4fdd\u5b58\u6570\u636e,size:{}", (Object)statisticRecords.size());
            Lists.partition((List)statisticRecords, (int)100).forEach(partitonStatisticRecords -> this.contactDistinctStatisticRecordMapper.insertOrUpdateTotal((Collection)partitonStatisticRecords));
        }
    }

    @Override
    public List<WeworkUserStatisticsRecord> pullUserBehaviorData(Long bizId, Date startTime, Date endTime, Collection<String> weworkUserIds) {
        log.info("pullUserBehaviorData,bizId:{},startTime:{},endTime:{},weworkUserIds:{}", new Object[]{bizId, startTime, endTime, weworkUserIds});
        if (bizId == null || startTime == null || endTime == null) {
            return Collections.emptyList();
        }
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        if (businessCustomer == null) {
            return Collections.emptyList();
        }
        return this.pullSingleCorpContactData(businessCustomer, startTime, endTime, weworkUserIds);
    }

    private List<WeworkUserStatisticsRecord> pullSingleCorpContactData(BusinessCustomer businessCustomer, Date startTime, Date endTime, Collection<String> weworkUserIds) {
        log.info("\u5f00\u59cb\u62c9\u53d6\u5546\u6237bizId:{},corpId:{},startTime:{},endTime:{}\u533a\u95f4\u7684\u6570\u636e,weworkUserIds:{}", new Object[]{businessCustomer.getId(), businessCustomer.getCorpId(), startTime, endTime, weworkUserIds});
        List pullWeworkUserIds = this.weworkUserMapper.queryIsAgentAuthWeworkUserIdsByCorpId(businessCustomer.getCorpId(), weworkUserIds);
        log.info("pullSingleCorpContactData get weworkUserIds: {}, bizId: {}", (Object)pullWeworkUserIds, (Object)businessCustomer.getId());
        if (CollectionUtils.isEmpty((Collection)pullWeworkUserIds)) {
            log.error("\u5f53\u524d\u4f01\u4e1a\u6ca1\u6709\u627e\u5230\u88ab\u6388\u6743\u7684\u6210\u5458");
            return Collections.emptyList();
        }
        ArrayList statisticsRecordList = Lists.newArrayList();
        for (String weworkUserId : pullWeworkUserIds) {
            UserBehaviorParams params = new UserBehaviorParams();
            params.setUserIds((List)Lists.newArrayList((Object[])new String[]{weworkUserId}));
            params.setStartTime(Long.valueOf(startTime.getTime() / 1000L));
            params.setEndTime(Long.valueOf(endTime.getTime() / 1000L));
            List<BehaviorData> dataLists = Lists.newArrayList();
            try {
                log.info("pullSingleCorpContactData request params:{}", (Object)params);
                dataLists = this.externalStatisticClient.getUserBehaviorData(businessCustomer.getCorpId(), params);
                log.info("pullSingleCorpContactData result:{}, weworkUserId: {}, bizId: {}", new Object[]{dataLists, weworkUserId, businessCustomer.getId()});
            }
            catch (RpcException rpcException) {
                log.error("\u8c03\u7528dubbo\u63a5\u53e3externalStatisticClient.getUserBehaviorData\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)rpcException);
            }
            catch (Exception ex) {
                log.error("\u8c03\u7528getUserBehaviorData dubbo\u63a5\u53e3\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            }
            if (CollectionUtils.isEmpty((Collection)dataLists)) {
                log.info("pullSingleCorpContactData is null");
                continue;
            }
            log.info("pullSingleCorpContactData get dataList size: {}", (Object)dataLists.size());
            if (dataLists.size() <= 0) continue;
            this.convert2ContactDataStatisticRecord(dataLists, businessCustomer, weworkUserId, statisticsRecordList);
        }
        if (CollectionUtils.isNotEmpty((Collection)statisticsRecordList)) {
            log.info("\u4fdd\u5b58\u6570\u636e,size:{}", (Object)statisticsRecordList.size());
            Lists.partition((List)statisticsRecordList, (int)100).forEach(partitonStatisticRecords -> this.weworkUserStatisticsRecordMapper.insertOrUpdateTotal(partitonStatisticRecords));
        }
        return statisticsRecordList;
    }

    private void handleChatRoomRedPacketMsg(ChatMsg chatMsg, long totalAmount) {
        String owner = this.weworkChatRoomMapper.queryOwnerByWeworkRoomId(chatMsg.getBizId(), chatMsg.getRoomId());
        if (StringUtils.isBlank((CharSequence)owner)) {
            log.warn("\u6839\u636ebizId:{},roomId:{}\u672a\u67e5\u8be2\u5230\u7fa4\u4fe1\u606f", (Object)chatMsg.getBizId(), (Object)chatMsg.getRoomId());
            return;
        }
        WeworkUser weworkUser = this.weworkUserMapper.queryByBizIdAndWeworkUserId(chatMsg.getBizId(), owner);
        if (weworkUser == null) {
            log.warn("\u6839\u636ebizId:{},owner:{}\u672a\u67e5\u8be2\u6210\u5458\u4fe1\u606f", (Object)chatMsg.getBizId(), (Object)owner);
            return;
        }
        DateTime msgTime = DateUtil.parse((CharSequence)DateUtil.format((Date)new Date(chatMsg.getMsgTime()), (String)"yyyy-MM-dd"));
        ChatRoomDataStatisticRecord statisticRecord = this.buildChatRoomDataStatisticRecord((Date)msgTime, NumberUtils.INTEGER_ONE, totalAmount, weworkUser.getBizId(), owner);
        this.chatRoomDataStatisticRecordMapper.insertOrUpdateRedPacketData(Collections.singleton(statisticRecord));
    }

    private void handleWeworkContactRedPacketMsg(ChatMsg chatMsg, long totalAmount) {
        WeworkUserStatisticsRecord statisticsRecord = this.convertRedPacketStatisticData(chatMsg.getEncryptFormId(), new Date(chatMsg.getMsgTime()), chatMsg.getBizId(), totalAmount);
        this.weworkUserStatisticsRecordMapper.insertOrUpdateRedPacketData(statisticsRecord);
    }

    private void pullSingleCorpChatRoomData(BusinessCustomer businessCustomer, Date startTime, Date endTime, long betweenDays) {
        log.info("\u5f00\u59cb\u62c9\u53d6\u5546\u6237bizId:{},corpId:{},startTime:{},endTime:{}\u533a\u95f4\u7684\u7fa4\u804a\u7edf\u8ba1\u6570\u636e", new Object[]{businessCustomer.getId(), businessCustomer.getCorpId(), startTime, endTime});
        List weworkUserIds = this.weworkUserMapper.queryAccessWeworkUserIds(businessCustomer.getCorpId());
        if (CollectionUtils.isEmpty((Collection)weworkUserIds)) {
            log.warn("\u6839\u636ecorpId:{}\u672a\u67e5\u8be2\u5230\u4f01\u5fae\u6210\u5458", (Object)businessCustomer.getCorpId());
            return;
        }
        Set owners = this.weworkChatRoomMapper.getOwnersByWeworkUserIds(businessCustomer.getCorpId(), (Collection)weworkUserIds);
        if (CollectionUtils.isEmpty((Collection)owners)) {
            log.warn("\u5546\u6237:{}\u6ca1\u6709\u7fa4\u4e3b\u4e3a\u6210\u5458\u7684\u7fa4", (Object)businessCustomer.getId());
            return;
        }
        weworkUserIds = Lists.newArrayList((Iterable)owners);
        Lists.partition((List)weworkUserIds, (int)100).forEach(partitionWeworkUserIds -> {
            ArrayList statisticRecords = Lists.newArrayList();
            OwnerFilterParam ownerFilterParam = new OwnerFilterParam();
            ownerFilterParam.setUserIdList(partitionWeworkUserIds);
            GroupChatStatisticParam groupChatStatisticParam = new GroupChatStatisticParam();
            groupChatStatisticParam.setOwnerFilter(ownerFilterParam);
            int i = 0;
            while ((long)i <= betweenDays) {
                long dayBeginTime = startTime.getTime() / 1000L + (long)i * 24L * 60L * 60L;
                groupChatStatisticParam.setDayBeginTime(Long.valueOf(dayBeginTime));
                groupChatStatisticParam.setDayEndTime(Long.valueOf(dayBeginTime));
                GroupStatisticResult groupStatisticResult = null;
                try {
                    log.info("request params:{}", (Object)groupChatStatisticParam);
                    groupStatisticResult = this.externalStatisticClient.getGroupStatisticData(businessCustomer.getCorpId(), groupChatStatisticParam);
                    log.info("getGroupStatisticData result:{}", (Object)groupStatisticResult);
                }
                catch (RpcException rpcException) {
                    log.error("\u8c03\u7528dubbo\u63a5\u53e3externalStatisticClient.getGroupStatisticData\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)rpcException);
                }
                catch (Exception ex) {
                    log.error("\u8c03\u7528getGroupStatisticData dubbo\u63a5\u53e3\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
                }
                if (groupStatisticResult == null || CollectionUtils.isEmpty((Collection)groupStatisticResult.getItems())) {
                    log.info("groupStatisticResult is null or groupStatisticResult.getItems() is empty ");
                } else {
                    this.convert2ChatRoomDataStatisticRecord(statisticRecords, groupStatisticResult.getItems(), businessCustomer, dayBeginTime);
                }
                ++i;
            }
            if (CollectionUtils.isNotEmpty((Collection)statisticRecords)) {
                Lists.partition((List)statisticRecords, (int)300).forEach(partitionRecords -> this.chatRoomDataStatisticRecordMapper.batchInsert((Collection)partitionRecords));
            }
        });
    }

    private void handleChatRoomHistoryRedPacketData(BusinessCustomer businessCustomer, Date startTime, Date endTime, long betweenDays) {
        log.info("\u5f00\u59cb\u5904\u7406\u5546\u6237bizId:{},corpId:{},startTime:{},endTime:{}\u533a\u95f4\u7684\u7fa4\u5386\u53f2\u7ea2\u5305\u6570\u636e", new Object[]{businessCustomer.getId(), businessCustomer.getCorpId(), startTime, endTime});
        List weworkUserIds = this.weworkUserMapper.queryAccessWeworkUserIds(businessCustomer.getCorpId());
        if (CollectionUtils.isEmpty((Collection)weworkUserIds)) {
            log.warn("\u6839\u636ecorpId:{}\u672a\u67e5\u8be2\u5230\u4f01\u5fae\u6210\u5458", (Object)businessCustomer.getCorpId());
            return;
        }
        Set owners = this.weworkChatRoomMapper.getOwnersByWeworkUserIds(businessCustomer.getCorpId(), (Collection)weworkUserIds);
        if (CollectionUtils.isEmpty((Collection)owners)) {
            log.warn("\u5546\u6237:{}\u6ca1\u6709\u7fa4\u4e3b\u4e3a\u6210\u5458\u7684\u7fa4", (Object)businessCustomer.getId());
            return;
        }
        weworkUserIds = Lists.newArrayList((Iterable)owners);
        Lists.partition((List)weworkUserIds, (int)100).forEach(partitionWeworkUserIds -> {
            ArrayList statisticRecords = Lists.newArrayList();
            Map owner2RoomIdsMap = this.weworkChatRoomMapper.queryOwnerAndRoomIdsByOwner(businessCustomer.getCorpId(), (Collection)partitionWeworkUserIds);
            HashSet roomIds = Sets.newHashSet();
            owner2RoomIdsMap.forEach((k, v) -> roomIds.addAll(v));
            int i = 0;
            while ((long)i <= betweenDays) {
                long dayBeginTime = startTime.getTime() + (long)i * 24L * 60L * 60L * 1000L;
                long dayEndTime = dayBeginTime + 86400000L;
                List chatMsgs = this.messageCommonService.searchChatRoomHistoryRedPacketMsg(new Date(dayBeginTime), new Date(dayEndTime), (Collection)roomIds);
                log.info("chatMsgs:{}", (Object)chatMsgs);
                if (CollectionUtils.isEmpty((Collection)chatMsgs)) {
                    log.warn("\u6839\u636edayBeginTime:{},dayEndTime:{},weworkRoomIds:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", new Object[]{dayBeginTime, dayEndTime, owner2RoomIdsMap.values()});
                } else {
                    Map<String, List<ChatMsg>> roomId2ChatMsgsMap = chatMsgs.stream().collect(Collectors.groupingBy(ChatMsg::getRoomId));
                    for (Map.Entry entry : owner2RoomIdsMap.entrySet()) {
                        int redPacketCount = 0;
                        long redPacketTotalAmount = 0L;
                        for (String weworkRoomId : (List)entry.getValue()) {
                            if (!roomId2ChatMsgsMap.containsKey(weworkRoomId)) continue;
                            ++redPacketCount;
                            for (ChatMsg chatMsg : roomId2ChatMsgsMap.get(weworkRoomId)) {
                                redPacketTotalAmount += (long)chatMsg.getRedPacket().getTotalAmount().intValue();
                            }
                        }
                        if (redPacketCount == 0 && (redPacketTotalAmount *= 100L) == 0L) continue;
                        ChatRoomDataStatisticRecord statisticRecord = this.buildChatRoomDataStatisticRecord(new Date(dayBeginTime), redPacketCount, redPacketTotalAmount, businessCustomer.getId(), (String)entry.getKey());
                        statisticRecords.add(statisticRecord);
                    }
                }
                ++i;
            }
            if (CollectionUtils.isNotEmpty((Collection)statisticRecords)) {
                this.chatRoomDataStatisticRecordMapper.insertOrUpdateRedPacketData((Collection)statisticRecords);
            }
        });
    }

    private ChatRoomDataStatisticRecord buildChatRoomDataStatisticRecord(Date msgTime, Integer redPacketCount, long totalAmount, Long bizId, String weworkUserId) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(msgTime);
        ChatRoomDataStatisticRecord statisticRecord = new ChatRoomDataStatisticRecord();
        statisticRecord.setBizId(bizId);
        statisticRecord.setNum(this.idGen.getNum());
        statisticRecord.setYear(Integer.valueOf(calendar.get(1)));
        statisticRecord.setMonth(Integer.valueOf(calendar.get(2) + 1));
        statisticRecord.setWeek(Integer.valueOf(calendar.get(3)));
        statisticRecord.setStatisticDate(msgTime);
        statisticRecord.setWeworkUserId(weworkUserId);
        statisticRecord.setRedPacketCount(redPacketCount);
        statisticRecord.setRedPacketTotalAmount(Long.valueOf(totalAmount));
        statisticRecord.setCreateTime(new Date());
        statisticRecord.setUpdateTime(new Date());
        return statisticRecord;
    }

    private void convert2ChatRoomDataStatisticRecord(List<ChatRoomDataStatisticRecord> statisticRecords, List<GroupStatisticItem> items, BusinessCustomer businessCustomer, Long dayBeginTime) {
        Date curDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(dayBeginTime * 1000L));
        for (GroupStatisticItem item : items) {
            GroupStatisticData groupStatisticData = item.getData();
            ChatRoomDataStatisticRecord statisticRecord = new ChatRoomDataStatisticRecord();
            statisticRecord.setBizId(businessCustomer.getId());
            statisticRecord.setNum(this.idGen.getNum());
            statisticRecord.setYear(Integer.valueOf(calendar.get(1)));
            statisticRecord.setMonth(Integer.valueOf(calendar.get(2) + 1));
            statisticRecord.setWeek(Integer.valueOf(calendar.get(3)));
            statisticRecord.setStatisticDate((Date)DateUtil.beginOfDay((Date)calendar.getTime()));
            statisticRecord.setWeworkUserId(item.getOwner());
            statisticRecord.setTotal(groupStatisticData.getChatTotal());
            statisticRecord.setNewCount(groupStatisticData.getNewChatCnt());
            statisticRecord.setHasMsgCount(groupStatisticData.getChatHasMsg());
            statisticRecord.setMemberTotal(groupStatisticData.getMemberTotal());
            statisticRecord.setNewMemberCount(groupStatisticData.getNewMemberCnt());
            statisticRecord.setMemberHasMsgCount(groupStatisticData.getMemberHasMsg());
            statisticRecord.setMsgTotal(groupStatisticData.getMsgTotal());
            statisticRecord.setCreateTime(curDate);
            statisticRecord.setUpdateTime(curDate);
            statisticRecords.add(statisticRecord);
        }
    }

    private void convert2ContactDataStatisticRecord(List<BehaviorData> dataList, BusinessCustomer businessCustomer, String weworkUserId, List<WeworkUserStatisticsRecord> recordList) {
        Date curDate = new Date();
        Calendar calendar = Calendar.getInstance();
        for (BehaviorData data : dataList) {
            if (data.getNewApplyCnt() != 0 || data.getChatCnt() != 0 || data.getMessageCnt() != 0 || data.getAvgReplyTime() != null || data.getReplyPercentage() != null) {
                calendar.setTime(new Date(data.getStatTime() * 1000L));
                WeworkUserStatisticsRecord userStatisticsRecord = new WeworkUserStatisticsRecord();
                userStatisticsRecord.setBizId(businessCustomer.getId());
                userStatisticsRecord.setNum(this.idGen.getNum());
                userStatisticsRecord.setYear(Integer.valueOf(calendar.get(1)));
                userStatisticsRecord.setMonth(Integer.valueOf(calendar.get(2) + 1));
                userStatisticsRecord.setWeek(Integer.valueOf(calendar.get(3)));
                userStatisticsRecord.setStatisticTime((Date)DateUtil.beginOfDay((Date)calendar.getTime()));
                userStatisticsRecord.setWeworkUserId(weworkUserId);
                userStatisticsRecord.setAddApplyCount(data.getNewApplyCnt());
                userStatisticsRecord.setChatCount(data.getChatCnt());
                userStatisticsRecord.setMessageCount(data.getMessageCnt());
                if (data.getReplyPercentage() != null) {
                    userStatisticsRecord.setReplyPercentage(data.getReplyPercentage());
                } else {
                    userStatisticsRecord.setReplyPercentage(Float.valueOf(0.0f));
                }
                if (data.getAvgReplyTime() != null) {
                    userStatisticsRecord.setAvgReplyTime(data.getAvgReplyTime());
                } else {
                    userStatisticsRecord.setAvgReplyTime(Integer.valueOf(0));
                }
                userStatisticsRecord.setCreateTime(curDate);
                userStatisticsRecord.setUpdateTime(curDate);
                log.info("insert data weworkUserId: {}, bizId: {},weworkUserId\uff1a{}, data: {}", new Object[]{weworkUserId, businessCustomer.getId(), weworkUserId, data});
                recordList.add(userStatisticsRecord);
                continue;
            }
            log.info("pullSingleCorpContactData data is null , weworkUserId: {}, bizId: {}", (Object)weworkUserId, (Object)businessCustomer.getId());
        }
    }

    private Collection<String> getWeworkUserIdsByNum(String corpId, String weworkUserNum, String deptNum) {
        Set<String> manageWeworkUserIds = this.weworkUserService.queryCurManagerWeworkUser();
        Set<Object> weworkUserIds = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)weworkUserNum)) {
            ArrayList weworkUserNums = Lists.newArrayList((Object[])weworkUserNum.split(","));
            Set selectedWeworkUserIds = this.weworkUserMapper.getWeworkUserIdsByNums((Collection)weworkUserNums);
            log.info("getWeworkUserIdsByNum get selectedWeworkUserIds: {}", (Object)selectedWeworkUserIds);
            if (CollectionUtils.isNotEmpty((Collection)selectedWeworkUserIds)) {
                for (String weworkUserId : selectedWeworkUserIds) {
                    if (!manageWeworkUserIds.contains(weworkUserId)) continue;
                    weworkUserIds.add(weworkUserId);
                }
            }
        } else if (StringUtils.isNotBlank((CharSequence)deptNum)) {
            ArrayList orgNums = Lists.newArrayList((Object[])deptNum.split(","));
            List weworkDepartmentIds = this.organizationMapper.queryWeworkDepartmentIdsByOrgNums((Collection)orgNums);
            log.info("getWeworkUserIdsByNum orgNums : {}, weworkDepartmentIds: {}", (Object)orgNums, (Object)weworkDepartmentIds);
            HashSet<Integer> departIdSets = new HashSet<Integer>(weworkDepartmentIds);
            Set<Integer> allDepartIds = this.departmentService.getAllFlatDepartment(corpId, departIdSets, true);
            log.info("getWeworkUserIdsByNum allDepartIds: {}", allDepartIds);
            HashSet<String> depUsers = new HashSet<String>();
            for (Integer dId : allDepartIds) {
                Set<String> departmentUserSet = this.departmentService.getDepartmentOfUser(corpId, dId);
                depUsers.addAll(departmentUserSet);
            }
            weworkUserIds = Sets.intersection(manageWeworkUserIds, depUsers);
        } else {
            weworkUserIds = manageWeworkUserIds;
        }
        log.info("getWeworkUserIdsByNum weworkUserIds: {}", (Object)weworkUserIds);
        return weworkUserIds;
    }

    private Collection<String> getWeworkUserIds(String corpId, String weworkUserNum, String deptNum) {
        Long bizId = LoginUtils.getCurrentUserBizId();
        Set manageUserIds = this.userRoleCommonService.getManageUserIds();
        if (CollectionUtils.isEmpty((Collection)manageUserIds)) {
            log.warn("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ba1\u8f96\u7684\u7528\u6237");
            return Collections.emptyList();
        }
        Set weworkUserIds = this.userMapper.queryWeworkUserIdByCorpIdAndUserIds(corpId, (Collection)manageUserIds);
        if (CollectionUtils.isEmpty((Collection)weworkUserIds)) {
            log.warn("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ba1\u8f96\u7684\u4f01\u5fae\u6210\u5458");
            return Collections.emptyList();
        }
        Collection retainWeworkUserIds = weworkUserIds;
        if (StringUtils.isNotBlank((CharSequence)weworkUserNum)) {
            ArrayList weworkUserNums = Lists.newArrayList((Object[])weworkUserNum.split(","));
            Set selectedWeworkUserIds = this.weworkUserMapper.getWeworkUserIdsByNums((Collection)weworkUserNums);
            if (CollectionUtils.isEmpty((Collection)selectedWeworkUserIds)) {
                log.warn("\u6839\u636eweworkUserNums:{}\u672a\u67e5\u8be2\u5230weworkUserIds", (Object)weworkUserNums);
                return Collections.emptyList();
            }
            retainWeworkUserIds = CollectionUtils.retainAll((Collection)weworkUserIds, (Collection)selectedWeworkUserIds);
        }
        if (CollectionUtils.isEmpty((Collection)retainWeworkUserIds)) {
            log.warn("\u7ba1\u8f96\u7684\u6210\u5458\u548c\u7528\u6237\u9009\u62e9\u7684\u6210\u5458\u6ca1\u6709\u4ea4\u96c6");
            return Collections.emptyList();
        }
        if (StringUtils.isNotEmpty((CharSequence)deptNum)) {
            Set weworkDepartmentIds;
            ArrayList orgNums = Lists.newArrayList((Object[])deptNum.split(","));
            Map idByNums = this.nodeService.getIdByNums(bizId, (Collection)orgNums);
            HashSet nodeIds = Sets.newHashSet(idByNums.values());
            if (CollectionUtils.isEmpty((Collection)nodeIds)) {
                return Lists.newArrayList();
            }
            Set posterityIds = this.nodeService.getPosterityIds((Collection)nodeIds, bizId);
            if (CollectionUtils.isNotEmpty((Collection)posterityIds)) {
                nodeIds.addAll(posterityIds);
            }
            if (CollectionUtils.isEmpty((Collection)(weworkDepartmentIds = this.organizationMapper.queryWeworkDepartmentIdsByOrgIds((Collection)nodeIds)))) {
                log.warn("\u6839\u636eorgNums:{}\u672a\u67e5\u8be2\u5230\u4f01\u5fae\u90e8\u95e8id", (Object)orgNums);
                return Collections.emptyList();
            }
            if (CollectionUtils.isEmpty((Collection)(retainWeworkUserIds = this.weworkUserMapper.queryWeworkUserIdsByParams(corpId, retainWeworkUserIds, (Collection)weworkDepartmentIds)))) {
                log.info("\u6839\u636e\u90e8\u95e8ids\u548c\u6210\u5458ids\u672a\u67e5\u8be2\u5230\u8bb0\u5f55");
                return Collections.emptyList();
            }
        }
        return retainWeworkUserIds;
    }

    private List<ChatRoomStatisticData> buildChatRoomDataStatisticResult(List<ChatRoomDataStatisticRecord> statisticRecords, List<ChatRoomDataStatisticRecord> resultStatisticRecords, Map<String, String> weworkUserId2NameMap) {
        Map weworkUserId2RecordMap = resultStatisticRecords.stream().collect(Collectors.toMap(ChatRoomDataStatisticRecord::getWeworkUserId, Functions.identity()));
        ArrayList statisticDataList = Lists.newArrayList();
        for (ChatRoomDataStatisticRecord statisticRecord : statisticRecords) {
            ChatRoomStatisticData statisticData = new ChatRoomStatisticData();
            statisticDataList.add(statisticData);
            String weworkUserId = statisticRecord.getWeworkUserId();
            if (MapUtils.isNotEmpty(weworkUserId2NameMap)) {
                statisticData.setWeworkUserName(weworkUserId2NameMap.get(weworkUserId));
            }
            statisticData.setTotal(statisticRecord.getTotal());
            statisticData.setNewCount(statisticRecord.getNewCount());
            statisticData.setHasMsgCount(statisticRecord.getHasMsgCount());
            statisticData.setMemberTotal(statisticRecord.getMemberTotal());
            statisticData.setNewMemberCount(statisticRecord.getNewMemberCount());
            statisticData.setMemberHasMsgCount(statisticRecord.getMemberHasMsgCount());
            statisticData.setMsgTotal(statisticRecord.getMsgTotal());
            statisticData.setRedPacketCount(statisticRecord.getRedPacketCount());
            statisticData.setRedPacketTotalAmount(Float.valueOf(BigDecimal.valueOf((float)statisticRecord.getRedPacketTotalAmount().longValue() / 10000.0f).setScale(2, RoundingMode.HALF_UP).floatValue()));
            if (MapUtils.isNotEmpty(weworkUserId2RecordMap) && weworkUserId2RecordMap.containsKey(weworkUserId)) {
                statisticData.setTotal(((ChatRoomDataStatisticRecord)weworkUserId2RecordMap.get(weworkUserId)).getTotal());
                statisticData.setMemberTotal(((ChatRoomDataStatisticRecord)weworkUserId2RecordMap.get(weworkUserId)).getMemberTotal());
                continue;
            }
            statisticData.setTotal(NumberUtils.INTEGER_ZERO);
            statisticData.setMemberTotal(NumberUtils.INTEGER_ZERO);
        }
        return statisticDataList;
    }

    public List<BDataValueDto> getBDataOption(String query, PageDto pageDto) {
        String weworkUserId;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        log.info("getBDataOption, userId={}, query={}, pageDto={}", new Object[]{userInfo.getId(), query, pageDto});
        ArrayList result = Lists.newArrayList();
        Set weworkDepartmentIds = null;
        Set manageNodeIds = this.userRoleCommonService.getManageNodeIds();
        if (CollectionUtils.isNotEmpty((Collection)manageNodeIds)) {
            weworkDepartmentIds = this.organizationMapper.queryWeworkDepartmentIdsByOrgIds((Collection)manageNodeIds);
        }
        if (StringUtils.isBlank((CharSequence)(weworkUserId = this.userMapper.getWeworkUserIdByUserId(userInfo.getId()))) && CollectionUtils.isEmpty((Collection)weworkDepartmentIds)) {
            log.info("\u5f53\u524d\u7528\u6237\u4e0d\u662f\u4f01\u5fae\u6210\u5458\u5e76\u4e14\u7ba1\u8f96\u7684\u4f01\u5fae\u90e8\u95e8\u4e3a\u7a7a");
            return result;
        }
        WeworkUserQuery weworkUserQuery = new WeworkUserQuery();
        weworkUserQuery.setQuery(query);
        weworkUserQuery.setWeworkDepartmentIds(weworkDepartmentIds);
        weworkUserQuery.setCorpId(userInfo.getCorpId());
        weworkUserQuery.setOffset(Integer.valueOf(pageDto.getOffset()));
        weworkUserQuery.setLimit(pageDto.getPageSize());
        weworkUserQuery.setWeworkUserId(weworkUserId);
        List weworkUsers = this.weworkUserMapper.queryByParams(weworkUserQuery);
        if (CollectionUtils.isEmpty((Collection)weworkUsers)) {
            log.info("\u6839\u636eweworkUserQuery:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)weworkUserQuery);
            return Collections.emptyList();
        }
        int count = this.weworkUserMapper.countByParams(weworkUserQuery);
        pageDto.setCount(Integer.valueOf(count));
        pageDto.setCurPageCount(Integer.valueOf(weworkUsers.size()));
        for (WeworkUser weworkUser : weworkUsers) {
            BDataValueDto dto = new BDataValueDto();
            dto.setValue(weworkUser.getNum());
            dto.setLabel(weworkUser.getName());
            result.add(dto);
        }
        return result;
    }

    public List<BDataValueDto> getBDataValues(String values) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        log.info("get wework user, userId={}, values={}", (Object)userInfo.getId(), (Object)values);
        ArrayList result = Lists.newArrayList();
        String[] args = StringUtils.split((String)values, (String)",");
        HashSet nums = Sets.newHashSet();
        for (String it : args) {
            if (!StringUtils.isNotBlank((CharSequence)it)) continue;
            nums.add(it.trim());
        }
        List weworkUsers = this.weworkUserMapper.queryWeworkUsersByNums(userInfo.getCorpId(), (Collection)nums);
        if (CollectionUtils.isNotEmpty((Collection)weworkUsers)) {
            for (WeworkUser weworkUser : weworkUsers) {
                BDataValueDto dto = new BDataValueDto();
                dto.setValue(weworkUser.getNum());
                dto.setLabel(weworkUser.getName());
                result.add(dto);
            }
        }
        return result;
    }

    private ContactDistinctStatisticRecord buildContactDistinctStatisticRecord(Long bizId, Integer total, Date statisticDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(statisticDate);
        ContactDistinctStatisticRecord statisticRecord = new ContactDistinctStatisticRecord();
        statisticRecord.setNum(this.idGen.getNum());
        statisticRecord.setBizId(bizId);
        statisticRecord.setYear(Integer.valueOf(calendar.get(1)));
        statisticRecord.setMonth(Integer.valueOf(calendar.get(2) + 1));
        statisticRecord.setWeek(Integer.valueOf(calendar.get(3)));
        statisticRecord.setStatisticDate(statisticDate);
        statisticRecord.setTotal(total);
        statisticRecord.setCreateTime(new Date());
        statisticRecord.setUpdateTime(new Date());
        return statisticRecord;
    }

    @Override
    public void handleContactStatisticQualityCheckLog() {
        List businessCustomers = this.businessCustomerMapper.queryBizIdAndCorpIdByStatusAndDelFlag(NumberUtils.INTEGER_ONE, NumberUtils.INTEGER_ZERO);
        if (CollectionUtils.isEmpty((Collection)businessCustomers)) {
            log.warn("\u672a\u67e5\u8be2\u5230\u72b6\u6001\u4e3a\u6b63\u5e38\u3001\u672a\u5220\u9664\u7684\u5546\u6237");
            return;
        }
        for (BusinessCustomer bs : businessCustomers) {
            log.info("handleContactStatisticQualityCheckLog get data bizId: {}", (Object)bs.getId());
            this.pullContactataExecutorService.execute(() -> {
                try {
                    String corpId = bs.getCorpId();
                    log.info("handleContactStatisticQualityCheckLog start corpId: {}", (Object)corpId);
                    List checkLogs = this.qualityCheckLogMapper.queryListByCorpId(corpId);
                    if (CollectionUtils.isEmpty((Collection)checkLogs)) {
                        log.info("handleContactStatisticQualityCheckLog get checklogs is empty, corpId : {}", (Object)corpId);
                        return;
                    }
                    log.info("handleContactStatisticQualityCheckLog logSize: {}", (Object)checkLogs.size());
                    for (QualityCheckLog cLog : checkLogs) {
                        WeworkUserStatisticsRecord statisticsRecord = new WeworkUserStatisticsRecord();
                        statisticsRecord.setBizId(cLog.getBizId());
                        statisticsRecord.setNum(this.idGen.getNum());
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(cLog.getMsgTime());
                        statisticsRecord.setYear(Integer.valueOf(calendar.get(1)));
                        statisticsRecord.setMonth(Integer.valueOf(calendar.get(2) + 1));
                        statisticsRecord.setWeek(Integer.valueOf(calendar.get(3)));
                        statisticsRecord.setStatisticTime(cLog.getMsgTime());
                        statisticsRecord.setCreateTime(new Date());
                        statisticsRecord.setUpdateTime(new Date());
                        statisticsRecord.setWeworkUserId(cLog.getSendWeworkUserId());
                        log.info("handleContactStatisticQualityCheckLog insert data type: {}, record: {}", (Object)cLog.getType(), (Object)statisticsRecord);
                        if (cLog.getType().equals(QualityCheckType.WORD.getType())) {
                            this.weworkUserStatisticsRecordMapper.insertOrUpdateTriggerWordData(statisticsRecord);
                        }
                        if (!cLog.getType().equals(QualityCheckType.BEHAVIOR.getType())) continue;
                        if (cLog.getTriggerBehavior().equals(QualityBehaviorType.TIMEOUT_UNREPLY.getType())) {
                            this.weworkUserStatisticsRecordMapper.insertOrUpdateTimeOurReplyData(statisticsRecord);
                            continue;
                        }
                        this.weworkUserStatisticsRecordMapper.insertOrUpdateTriggerBehaviorData(statisticsRecord);
                    }
                }
                catch (Exception ex) {
                    log.error("\u62c9\u53d6\u5546\u6237bizId:{} \u6570\u636e\u53d1\u751f\u5f02\u5e38:", (Object)bs.getId(), (Object)ex);
                }
            });
        }
    }

    private void handleContactHistoryRedPacketData(BusinessCustomer bs, Date startTime, Date endTime, long betweenDays) {
        log.info("handleContactHistoryRedPacketData bizId: {}, corpId: {},  startTime: {}, endTime: {}", new Object[]{bs.getId(), bs.getCorpId(), startTime, endTime});
        List weworkUserIds = this.weworkUserMapper.queryWeworkUserIdsByCorpId(bs.getCorpId());
        log.info("pullSingleCorpContactData get weworkUserIds: {}", (Object)weworkUserIds);
        if (CollectionUtils.isEmpty((Collection)weworkUserIds)) {
            return;
        }
        Lists.partition((List)weworkUserIds, (int)200).forEach(pWeworkUserIds -> {
            int i = 0;
            while ((long)i <= betweenDays) {
                long dayEndTime;
                long dayBeginTime = startTime.getTime() + (long)i * 24L * 60L * 60L * 1000L;
                List chatMsgs = this.messageCommonService.searchContactHistoryRedPacketMsh(new Date(dayBeginTime), new Date(dayEndTime = dayBeginTime + 86400000L), (Collection)pWeworkUserIds);
                if (CollectionUtils.isEmpty((Collection)chatMsgs)) {
                    log.warn("\u6839\u636edayBeginTime:{},dayEndTime:{},weworkUserIds:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", new Object[]{dayBeginTime, dayEndTime, weworkUserIds});
                } else {
                    Map<String, List<ChatMsg>> contact2ChatMsgsMap = chatMsgs.stream().collect(Collectors.groupingBy(ChatMsg::getFrom));
                    log.info("pullSingleCorpContactData contact2ChatMsgsMap: {}", contact2ChatMsgsMap);
                    for (ChatMsg msg : chatMsgs) {
                        long totalAmount = msg.getRedPacket().getTotalAmount() * 100;
                        WeworkUserStatisticsRecord statisticsRecord = this.convertRedPacketStatisticData(msg.getFrom(), new Date(dayBeginTime), totalAmount, bs.getId());
                        this.weworkUserStatisticsRecordMapper.insertOrUpdateRedPacketData(statisticsRecord);
                    }
                }
                ++i;
            }
        });
    }

    private WeworkUserStatisticsRecord convertRedPacketStatisticData(String from, Date msgTime, long totalAmount, Long bizId) {
        log.info("convertRedPacketStatisticData from: {}, msgTime: {},  totalAmount: {}, bizId: {}", new Object[]{from, msgTime, totalAmount, bizId});
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(msgTime);
        WeworkUserStatisticsRecord statisticsRecord = new WeworkUserStatisticsRecord();
        statisticsRecord.setBizId(bizId);
        statisticsRecord.setNum(this.idGen.getNum());
        statisticsRecord.setYear(Integer.valueOf(calendar.get(1)));
        statisticsRecord.setMonth(Integer.valueOf(calendar.get(2) + 1));
        statisticsRecord.setWeek(Integer.valueOf(calendar.get(3)));
        statisticsRecord.setStatisticTime(msgTime);
        statisticsRecord.setRedPacketTotalAmount(Long.valueOf(totalAmount));
        statisticsRecord.setCreateTime(new Date());
        statisticsRecord.setUpdateTime(new Date());
        statisticsRecord.setWeworkUserId(from);
        return statisticsRecord;
    }

    private List<String> getDayLists(Date startTime, Date endTime) {
        ArrayList result = Lists.newArrayList();
        String startDateStr = com.kuaike.scrm.common.utils.DateUtil.dateToDateString((Date)startTime, (String)"yyyy-MM-dd");
        String endDateStr = com.kuaike.scrm.common.utils.DateUtil.dateToDateString((Date)endTime, (String)"yyyy-MM-dd");
        result.add(endDateStr);
        Date temp = endTime;
        while (!endDateStr.equals(startDateStr)) {
            temp = com.kuaike.scrm.common.utils.DateUtil.getDateAddDay((Date)temp, (int)-1);
            endDateStr = com.kuaike.scrm.common.utils.DateUtil.dateToDateString((Date)temp, (String)"yyyy-MM-dd");
            result.add(endDateStr);
        }
        return result;
    }

    @Override
    public void updateAddOrDelContactData(Date startTime, Date endTime, Long bizId) {
        log.info("updateAddOrDelContactData, startTime:{},endTime:{},bizId: {}", new Object[]{startTime, endTime, bizId});
        if (startTime == null || endTime == null) {
            log.warn("updateAddOrDelContactData startTime or endTime is null");
            return;
        }
        List<BusinessCustomer> businessCustomers = this.businessCustomerMapper.queryBizIdAndCorpIdByStatusAndDelFlag(NumberUtils.INTEGER_ONE, NumberUtils.INTEGER_ZERO);
        if (CollectionUtils.isEmpty((Collection)businessCustomers)) {
            log.warn("\u672a\u67e5\u8be2\u5230\u72b6\u6001\u4e3a\u6b63\u5e38\u3001\u672a\u5220\u9664\u7684\u5546\u6237");
            return;
        }
        if (bizId != null && bizId > 0L) {
            BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
            businessCustomers = Collections.singletonList(businessCustomer);
        }
        for (BusinessCustomer businessCustomer : businessCustomers) {
            log.info("updateAddOrDelContactData get data bizId: {}", (Object)businessCustomer.getId());
            this.pullContactataExecutorService.execute(() -> {
                try {
                    this.updateAddOrDelContactDataHandle(startTime, endTime, bizId);
                }
                catch (Exception ex) {
                    log.error("\u66f4\u65b0\u5546\u6237bizId:{},startTime:{},endTime:{}\u7684\u8054\u7cfb\u4eba\u7edf\u8ba1\u6570\u636e\u53d1\u751f\u5f02\u5e38:", new Object[]{businessCustomer.getId(), startTime, endTime, ex});
                }
            });
        }
    }

    private void updateAddOrDelContactDataHandle(Date startTime, Date endTime, Long bizId) {
        List<String> dayList = this.getDayLists(startTime, endTime);
        Collections.reverse(dayList);
        log.info("updateAddOrDelContactDataHandle dayList: {}", dayList);
        List changeLogs = this.weworkContactChangeLogMapper.queryListByDayStrList(bizId, dayList);
        Set weworkUserNums = changeLogs.stream().map(WeworkContactChangeLog::getWeworkUserNum).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(weworkUserNums)) {
            log.info("updateAddOrDelContactDataHandle weworkUserNum is null");
            return;
        }
        Map weworkUserMap = this.weworkUserMapper.queryWeworkUserIdMapByNums(weworkUserNums);
        log.info("updateAddOrDelContactDataHandle weworkUserMap: {}", (Object)weworkUserMap);
        Map<String, List<WeworkContactChangeLog>> changeLogMap = changeLogs.stream().collect(Collectors.groupingBy(WeworkContactChangeLog::getStatisticDate));
        ArrayList statisticsRecords = Lists.newArrayList();
        for (String dayStr : dayList) {
            Date date = com.kuaike.common.utils.DateUtil.getDateByStr((String)dayStr);
            List<WeworkContactChangeLog> changeLogList = changeLogMap.get(dayStr);
            if (CollectionUtils.isEmpty(changeLogList)) {
                log.info("updateAddOrDelContactDataHandle changeLogList is empty, dayStr: {}", (Object)dayStr);
                continue;
            }
            Set dayWeworkUserNums = changeLogList.stream().map(WeworkContactChangeLog::getWeworkUserNum).collect(Collectors.toSet());
            Map<String, List<WeworkContactChangeLog>> dayChangeLogMap = changeLogList.stream().collect(Collectors.groupingBy(WeworkContactChangeLog::getWeworkUserNum));
            for (String weworkUserNum : dayWeworkUserNums) {
                String weworkUserId = (String)weworkUserMap.get(weworkUserNum);
                if (StringUtils.isEmpty((CharSequence)weworkUserId)) {
                    log.info("weworkUserId is empty, weworkUserNum: {}", (Object)weworkUserNum);
                    continue;
                }
                List<WeworkContactChangeLog> sChangeLog = dayChangeLogMap.get(weworkUserNum);
                int addNum = 0;
                int delNum = 0;
                if (CollectionUtils.isNotEmpty(sChangeLog)) {
                    for (WeworkContactChangeLog log : sChangeLog) {
                        addNum += log.getAddNum().intValue();
                        delNum += log.getDelNum().intValue();
                    }
                }
                if (addNum == 0 && delNum == 0) continue;
                WeworkUserStatisticsRecord record = this.convertAddOrDelContactStatisticData(weworkUserId, date, addNum, delNum, bizId);
                statisticsRecords.add(record);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)statisticsRecords)) {
            log.info("statisticsRecords size: {}", (Object)statisticsRecords.size());
            Lists.partition((List)statisticsRecords, (int)300).forEach(partitionRecords -> this.weworkUserStatisticsRecordMapper.batchInsertOrUpdateAddOrDelContactCount(partitionRecords));
        }
    }

    private WeworkUserStatisticsRecord convertAddOrDelContactStatisticData(String from, Date msgTime, Integer addNum, Integer delNum, Long bizId) {
        log.info("convertAddOrDelContactStatisticData weworkUserId: {}, msgTime: {}, addNum: {}, delNum: {},  bizId: {}", new Object[]{from, msgTime, addNum, delNum, bizId});
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(msgTime);
        WeworkUserStatisticsRecord statisticsRecord = new WeworkUserStatisticsRecord();
        statisticsRecord.setBizId(bizId);
        statisticsRecord.setNum(this.idGen.getNum());
        statisticsRecord.setYear(Integer.valueOf(calendar.get(1)));
        statisticsRecord.setMonth(Integer.valueOf(calendar.get(2) + 1));
        statisticsRecord.setWeek(Integer.valueOf(calendar.get(3)));
        statisticsRecord.setStatisticTime(msgTime);
        statisticsRecord.setAddContactCount(addNum);
        statisticsRecord.setZombieFansCount(delNum);
        statisticsRecord.setCreateTime(new Date());
        statisticsRecord.setUpdateTime(new Date());
        statisticsRecord.setWeworkUserId(from);
        return statisticsRecord;
    }

    private /* synthetic */ void lambda$statisticContactDistinctTotalCount$4(List statisticRecords, Map corpId2BizIdMap, Date yesterday, List partitionCorpIds) {
        Map corpId2TotalCountMap = this.weworkContactMapper.queryCorpDistinctTotalContact((Collection)partitionCorpIds);
        log.info("corpId2TotalCountMap:{}", (Object)corpId2TotalCountMap);
        for (Map.Entry entry : corpId2TotalCountMap.entrySet()) {
            statisticRecords.add(this.buildContactDistinctStatisticRecord((Long)corpId2BizIdMap.get(entry.getKey()), (Integer)entry.getValue(), yesterday));
        }
    }
}

