/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.department.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.dto.resp.OrgListItemDto;
import com.kuaike.scrm.common.service.dto.resp.OrgListRespDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkDepartmentUser;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.wework.department.dto.DepartmentNode;
import com.kuaike.scrm.wework.department.service.DepartmentService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DepartmentServiceImp
implements DepartmentService {
    private static final Logger log = LoggerFactory.getLogger(DepartmentServiceImp.class);
    @Resource
    private WeworkDepartmentMapper weworkDepartmentMapper;
    @Resource
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private OrganizationMapper organizationMapper;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private UserMapper userMapper;

    @Override
    public List<Integer> getCorpDepartmentIds(String corpId) {
        return this.weworkDepartmentMapper.getDepartmentIdList(corpId);
    }

    @Override
    public List<Integer> getCorpRootOfDepartmentIds(String corpId) {
        return this.weworkDepartmentMapper.getRootDepartmentIdList(corpId);
    }

    @Override
    public Set<Integer> getChildDepartment(String corpId, Integer departmentId, boolean isContainSelf) {
        Map departmentMap = this.weworkDepartmentMapper.queryDepartmentIdMap(corpId);
        HashSet departmentSet = Sets.newHashSet();
        if (isContainSelf) {
            departmentSet.add(departmentId);
        }
        LinkedList<Integer> stack = new LinkedList<Integer>();
        stack.push(departmentId);
        while (!stack.isEmpty()) {
            Integer ele = (Integer)stack.pop();
            List childDeparts = (List)departmentMap.get(ele);
            if (CollectionUtils.isEmpty((Collection)childDeparts)) continue;
            for (Integer childDepart : childDeparts) {
                stack.push(childDepart);
            }
            departmentSet.addAll(childDeparts);
        }
        return departmentSet;
    }

    @Override
    public Set<Integer> getAllFlatDepartment(String corpId, Set<Integer> departmentIds, boolean isContainSelf) {
        Map departmentMap = this.weworkDepartmentMapper.queryDepartmentIdMap(corpId);
        HashSet departmentSet = Sets.newHashSet();
        LinkedList<Integer> stack = new LinkedList<Integer>();
        for (Integer departmentId : departmentIds) {
            stack.push(departmentId);
        }
        HashSet visitSet = Sets.newHashSet();
        while (!stack.isEmpty()) {
            Integer ele = (Integer)stack.pop();
            List childDeparts = (List)departmentMap.get(ele);
            visitSet.add(ele);
            if (CollectionUtils.isEmpty((Collection)childDeparts)) continue;
            for (Integer childDepart : childDeparts) {
                if (visitSet.contains(childDepart)) continue;
                stack.push(childDepart);
            }
            departmentSet.addAll(childDeparts);
        }
        if (isContainSelf) {
            departmentSet.addAll(departmentIds);
        } else {
            departmentSet.removeAll(departmentIds);
        }
        return departmentSet;
    }

    @Override
    public Set<String> getDepartmentOfUser(String corpId, Integer departmentId) {
        return this.weworkDepartmentUserMapper.queryDeparmentOfUser(corpId, departmentId);
    }

    @Override
    public Map<Integer, Integer> queryDepartMap(String corpId) {
        return this.weworkDepartmentMapper.queryDepartMap(corpId);
    }

    @Override
    public Map<Integer, String> queryDepartNameMap(String corpId) {
        return this.weworkDepartmentMapper.queryDepartNameMap(corpId);
    }

    @Override
    public List<List<DepartmentNode>> buildWeworkUser(Long bizId, String corpId, WeworkUser weworkUser, Map<Integer, Integer> departMap, Map<Integer, String> departNameMap) {
        Integer mainDepartmentId = weworkUser.getMainDepartment();
        String weworkUserId = weworkUser.getWeworkUserId();
        List list = this.weworkDepartmentUserMapper.queryUserDeptInfo(corpId, bizId, weworkUserId);
        if (CollectionUtils.isEmpty((Collection)list) || departMap == null || departMap.size() == 0) {
            return null;
        }
        List departmentIdList = list.stream().map(WeworkDepartmentUser::getDepartmentId).collect(Collectors.toList());
        if (mainDepartmentId != null) {
            departmentIdList.remove(mainDepartmentId);
            departmentIdList.add(0, mainDepartmentId);
        }
        ArrayList nodes = Lists.newArrayList();
        for (Integer departmentId : departmentIdList) {
            Integer departId = departmentId;
            if (!departNameMap.containsKey(departId)) continue;
            String departName = departNameMap.get(departId);
            ArrayList nodeList = Lists.newArrayList();
            while (departId != 0) {
                DepartmentNode node = new DepartmentNode();
                node.setId(departId);
                node.setName(departName);
                nodeList.add(node);
                departId = departMap.get(departId);
                if (departId == null) break;
                departName = departNameMap.get(departId);
            }
            Collections.reverse(nodeList);
            nodes.add(nodeList);
        }
        return nodes;
    }

    @Override
    public Map<Long, List<String>> getWeworkUserRegionGroup(String corpId, Collection<String> weworkUserNums) {
        HashMap result = Maps.newHashMap();
        Map<String, Long> userRegionMap = this.getWeworkUserRegionMap(corpId, weworkUserNums);
        for (Map.Entry<String, Long> entry : userRegionMap.entrySet()) {
            String weworkUserNum = entry.getKey();
            Long regionId = entry.getValue();
            if (result.containsKey(regionId)) {
                ((List)result.get(regionId)).add(weworkUserNum);
                continue;
            }
            ArrayList list = Lists.newArrayList();
            list.add(weworkUserNum);
            result.put(regionId, list);
        }
        return result;
    }

    @Override
    public Map<String, Long> getWeworkUserRegionMap(String corpId, Collection<String> weworkUserNums) {
        Map<Integer, Integer> departMap = this.queryDepartMap(corpId);
        List weworkUsers = this.weworkUserMapper.queryInfoListByNums(weworkUserNums);
        HashMap result = Maps.newHashMap();
        Map regionIdMap = this.organizationMapper.queryRegionMap(corpId);
        block0: for (WeworkUser weworkUser : weworkUsers) {
            Integer mainDepartmentId = weworkUser.getMainDepartment();
            String weworkUserNum = weworkUser.getNum();
            if (mainDepartmentId == null) continue;
            Integer departId = mainDepartmentId;
            ArrayList departIds = Lists.newArrayList();
            while (departId != 0) {
                departIds.add(departId);
                if ((departId = departMap.get(departId)) != null) continue;
            }
            if (!CollectionUtils.isNotEmpty((Collection)departIds)) continue;
            ArrayList regionIds = Lists.newArrayList();
            for (Integer departmentId : departIds) {
                regionIds.add(regionIdMap.get(departmentId));
            }
            for (Long regionId : regionIds) {
                if (regionId == null) continue;
                result.put(weworkUserNum, regionId);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public void setUserCountForOrgId(List<OrgListRespDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            log.info("setUserCountForOrgId: list\u4e3a\u7a7a");
            return;
        }
        HashSet orgIds = Sets.newHashSet();
        for (OrgListRespDto respDto : list) {
            this.getOrgIds(respDto, orgIds);
        }
        Map<Long, Integer> userCountMap = this.getWeworkUserCountByOrgId(orgIds, list);
        if (MapUtils.isEmpty(userCountMap)) {
            log.info("setUserCountForOrgId: userCountMap\u4e3a\u7a7a");
            return;
        }
        for (OrgListRespDto respDto : list) {
            this.setUserCountForNodeId(respDto, userCountMap);
        }
    }

    @Override
    public void setUserCountForOrgNum(List<OrgListItemDto> list, Long bizId) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        if (Objects.isNull(bizId)) {
            bizId = userInfo.getBizId();
        }
        if (CollectionUtils.isEmpty(list)) {
            log.info("setUserCountForOrgNum: list\u4e3a\u7a7a");
            return;
        }
        Set<String> orgNums = list.stream().map(OrgListItemDto::getId).collect(Collectors.toSet());
        for (OrgListItemDto itemDto : list) {
            this.getOrgNums(itemDto, orgNums);
        }
        Map id2NumMap = this.organizationMapper.getIdByNums(bizId, orgNums);
        Map<Long, Integer> userCountMap = this.getUserCountByOrgId(id2NumMap, list, bizId);
        if (MapUtils.isEmpty(userCountMap)) {
            log.info("setUserCountForOrgNum: userCountMap\u4e3a\u7a7a");
            return;
        }
        for (OrgListItemDto itemDto : list) {
            this.setUserCountForNodeNum(itemDto, id2NumMap, userCountMap);
        }
    }

    private Map<Long, Integer> getWeworkUserCountByOrgId(Set<Long> orgIds, List<OrgListRespDto> list) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5c5e\u5546\u6237\u4fe1\u606f\u4e0d\u80fd\u7a7a");
        Long bizId = currentUserInfo.getBizId();
        Long userId = currentUserInfo.getId();
        String corpId = currentUserInfo.getCorpId();
        log.info("getWeworkUserCountByOrgId: bizId:{}, corpId:{}, userId:{}, orgIds:{}", new Object[]{bizId, corpId, userId, orgIds});
        if (CollectionUtils.isEmpty(orgIds)) {
            log.info("getWeworkUserCountByOrgId: orgIds\u4e3a\u7a7a\uff0cbizId:{}", (Object)bizId);
            return Maps.newHashMap();
        }
        List orgList = this.organizationMapper.selectOrgByIds(orgIds);
        if (CollectionUtils.isEmpty((Collection)orgList)) {
            log.info("getWeworkUserCountByOrgId: orgList\u4e3a\u7a7a\uff0cbizId:{}, orgIds:{}", (Object)bizId, orgIds);
            return Maps.newHashMap();
        }
        HashMap weworkOrgIdAndSubIdMap = Maps.newHashMap();
        for (OrgListRespDto respDto : list) {
            Map<Integer, Set<Integer>> orgAndChildMap = this.getWeworkOrgAndChildMap(respDto);
            if (!MapUtils.isNotEmpty(orgAndChildMap)) continue;
            weworkOrgIdAndSubIdMap.putAll(orgAndChildMap);
        }
        Map weworkOrgIdAndWeworkUserIdsMap = this.weworkDepartmentUserMapper.queryDeptIdAndWeworkUserIds(corpId);
        HashMap resultMap = Maps.newHashMap();
        for (Organization org : orgList) {
            Set departmentIds = weworkOrgIdAndSubIdMap.getOrDefault(org.getWeworkDepartmentId(), Sets.newHashSet());
            HashSet weworkUserIds = Sets.newHashSet();
            for (Integer deptId : departmentIds) {
                List tmpWeworkUserIds = (List)weworkOrgIdAndWeworkUserIdsMap.get(deptId);
                if (!CollectionUtils.isNotEmpty((Collection)tmpWeworkUserIds)) continue;
                weworkUserIds.addAll(tmpWeworkUserIds);
            }
            resultMap.put(org.getId(), weworkUserIds.size());
        }
        return resultMap;
    }

    private Map<Long, Integer> getUserCountByOrgId(Map<String, Long> id2NumMap, List<OrgListItemDto> list, Long bizId) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5c5e\u5546\u6237\u4fe1\u606f\u4e0d\u80fd\u7a7a");
        HashSet orgIds = Sets.newHashSet(id2NumMap.values());
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            log.info("getUserCountByOrgId: orgIds\u4e3a\u7a7a\uff0cbizId:{}", (Object)bizId);
            return Maps.newHashMap();
        }
        List orgList = this.organizationMapper.selectOrgByIds((Collection)orgIds);
        if (CollectionUtils.isEmpty((Collection)orgList)) {
            log.info("getUserCountByOrgId: orgList\u4e3a\u7a7a\uff0cbizId:{}, orgIds:{}", (Object)bizId, (Object)orgIds);
            return Maps.newHashMap();
        }
        HashMap nodeIdAndSubIdMap = Maps.newHashMap();
        for (OrgListItemDto respDto : list) {
            Map<Long, Set<Long>> nodeAndChildMap = this.getNodeAndChildMap(respDto, id2NumMap);
            if (!MapUtils.isNotEmpty(nodeAndChildMap)) continue;
            nodeIdAndSubIdMap.putAll(nodeAndChildMap);
        }
        Map nodeAndUserIdsMap = this.userMapper.queryNodeIdAndUserIds(bizId);
        HashMap resultMap = Maps.newHashMap();
        for (Organization org : orgList) {
            Set allNodeIds = nodeIdAndSubIdMap.getOrDefault(org.getId(), Sets.newHashSet());
            HashSet userIds = Sets.newHashSet();
            for (Long nodeId : allNodeIds) {
                List tmpUserIds = (List)nodeAndUserIdsMap.get(nodeId);
                if (!CollectionUtils.isNotEmpty((Collection)tmpUserIds)) continue;
                userIds.addAll(tmpUserIds);
            }
            resultMap.put(org.getId(), userIds.size());
        }
        return resultMap;
    }

    private void getOrgIds(OrgListRespDto node, Set<Long> orgIds) {
        orgIds.addAll(node.getIds());
        if (CollectionUtils.isNotEmpty((Collection)node.getChildren())) {
            for (OrgListRespDto child : node.getChildren()) {
                this.getOrgIds(child, orgIds);
            }
        }
    }

    private void getOrgNums(OrgListItemDto node, Set<String> orgNums) {
        orgNums.addAll(node.getIds());
        if (CollectionUtils.isNotEmpty((Collection)node.getChildren())) {
            for (OrgListItemDto child : node.getChildren()) {
                this.getOrgNums(child, orgNums);
            }
        }
    }

    private void setUserCountForNodeId(OrgListRespDto node, Map<Long, Integer> userCountMap) {
        Long orgId = node.getId();
        if (userCountMap.containsKey(orgId)) {
            node.setCount(userCountMap.get(orgId));
        }
        if (CollectionUtils.isNotEmpty((Collection)node.getChildren())) {
            for (OrgListRespDto child : node.getChildren()) {
                this.setUserCountForNodeId(child, userCountMap);
            }
        }
    }

    private void setUserCountForNodeNum(OrgListItemDto node, Map<String, Long> id2NumMap, Map<Long, Integer> userCountMap) {
        Long orgId = id2NumMap.get(node.getId());
        if (orgId != null && userCountMap.containsKey(orgId)) {
            node.setCount(userCountMap.get(orgId));
        }
        if (CollectionUtils.isNotEmpty((Collection)node.getChildren())) {
            for (OrgListItemDto child : node.getChildren()) {
                this.setUserCountForNodeNum(child, id2NumMap, userCountMap);
            }
        }
    }

    public Map<Integer, Set<Integer>> getWeworkOrgAndChildMap(OrgListRespDto root) {
        HashMap map = Maps.newHashMap();
        this.convertChildren(root, map);
        return map;
    }

    private Set<Integer> convertChildren(OrgListRespDto node, Map<Integer, Set<Integer>> map) {
        HashSet childrenIds = Sets.newHashSet();
        childrenIds.add(node.getWeworkOrgId());
        if (CollectionUtils.isNotEmpty((Collection)node.getChildren())) {
            for (OrgListRespDto child : node.getChildren()) {
                childrenIds.add(child.getWeworkOrgId());
                Set<Integer> grandchildrenIds = this.convertChildren(child, map);
                childrenIds.addAll(grandchildrenIds);
            }
        }
        map.put(node.getWeworkOrgId(), childrenIds);
        return childrenIds;
    }

    public Map<Long, Set<Long>> getNodeAndChildMap(OrgListItemDto root, Map<String, Long> id2NumMap) {
        HashMap map = Maps.newHashMap();
        this.convertChildren(root, map, id2NumMap);
        return map;
    }

    private Set<Long> convertChildren(OrgListItemDto node, Map<Long, Set<Long>> map, Map<String, Long> id2NumMap) {
        HashSet childrenIds = Sets.newHashSet();
        Long nodeId = id2NumMap.get(node.getId());
        if (nodeId != null) {
            childrenIds.add(nodeId);
        }
        if (CollectionUtils.isNotEmpty((Collection)node.getChildren())) {
            for (OrgListItemDto child : node.getChildren()) {
                Long childId = id2NumMap.get(child.getId());
                if (childId != null) {
                    childrenIds.add(childId);
                }
                Set<Long> grandchildrenIds = this.convertChildren(child, map, id2NumMap);
                childrenIds.addAll(grandchildrenIds);
            }
        }
        map.put(nodeId, childrenIds);
        return childrenIds;
    }
}

