/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contacttag.service.impl;

import cn.kinyun.wework.sdk.api.external.ExternalTagClient;
import cn.kinyun.wework.sdk.entity.external.croptag.AddCorpTagParams;
import cn.kinyun.wework.sdk.entity.external.croptag.AddCorpTagResp;
import cn.kinyun.wework.sdk.entity.external.croptag.CorpTag;
import cn.kinyun.wework.sdk.entity.external.croptag.CorpTagGroup;
import cn.kinyun.wework.sdk.entity.external.croptag.UpdateCorpTagParams;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.BDataValueDto;
import com.kuaike.scrm.common.dto.BaseDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.AttachTagTaskStatus;
import com.kuaike.scrm.common.enums.FollowRecordType;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.wework.dto.WeworkUserContactDto;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.TagGroupDto;
import com.kuaike.scrm.dal.weworktag.WeworkTagDto;
import com.kuaike.scrm.dal.weworktag.dto.TagGroupPairInfo;
import com.kuaike.scrm.dal.weworktag.dto.TagGroupParams;
import com.kuaike.scrm.dal.weworktag.dto.WeworkTagParams;
import com.kuaike.scrm.dal.weworktag.entity.AttachTagSubTask;
import com.kuaike.scrm.dal.weworktag.entity.AttachTagTask;
import com.kuaike.scrm.dal.weworktag.entity.WeworkContactTag;
import com.kuaike.scrm.dal.weworktag.entity.WeworkTag;
import com.kuaike.scrm.dal.weworktag.entity.WeworkTagGroup;
import com.kuaike.scrm.dal.weworktag.mapper.AttachTagSubTaskMapper;
import com.kuaike.scrm.dal.weworktag.mapper.AttachTagTaskMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagGroupMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.follow.dto.CorpTagDto;
import com.kuaike.scrm.follow.dto.CustomerTagInfo;
import com.kuaike.scrm.follow.dto.FollowReqDto;
import com.kuaike.scrm.follow.service.FollowService;
import com.kuaike.scrm.wework.contact.dto.ContactRelationListParams;
import com.kuaike.scrm.wework.contact.dto.ModifyTagDto;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import com.kuaike.scrm.wework.contact.service.ContactRelationService;
import com.kuaike.scrm.wework.contacttag.dto.AttachTagParams;
import com.kuaike.scrm.wework.contacttag.dto.AttachTagResultDto;
import com.kuaike.scrm.wework.contacttag.dto.SingleAttachTagParams;
import com.kuaike.scrm.wework.contacttag.service.ContactTagService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContactTagServiceImp
implements ContactTagService {
    private static final Logger log = LoggerFactory.getLogger(ContactTagServiceImp.class);
    @Value(value="${kafka.topic.task_attach_tag}")
    private String attachTagTaskTopic;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Resource
    private WeworkTagGroupMapper weworkTagGroupMapper;
    @Resource
    private WeworkTagMapper weworkTagMapper;
    @Resource
    private WeworkContactTagMapper weworkContactTagMapper;
    @Resource
    private AttachTagTaskMapper attachTagTaskMapper;
    @Resource
    private AttachTagSubTaskMapper attachTagSubTaskMapper;
    @Autowired
    private ExternalTagClient externalTagClient;
    @Autowired
    private IdGen idGen;
    @Autowired
    private ContactRelationService contactRelationService;
    @Autowired
    private FollowService followService;
    @Autowired
    private WeworkUserService weworkUserService;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private ContactOpService contactOpService;
    @Autowired
    private WeworkContactMapper contactMapper;
    @Autowired
    private CustomerCenterService customerCenterService;

    public List<BDataValueDto> getBDataOption(String query, PageDto pageDto) {
        Long userId = LoginUtils.getCurrentUserId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        String corpId = LoginUtils.getCurrentUserCorpId();
        log.info("query tag list, bizId={}, userId={}, query={}, pageDto={}", new Object[]{bizId, userId, query, pageDto});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)corpId), (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ArrayList result = Lists.newArrayList();
        List list = this.weworkTagMapper.queryByTagName(corpId, query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (TagGroupPairInfo it : list) {
                BDataValueDto dto = new BDataValueDto();
                dto.setValue(it.getTagId());
                dto.setLabel(it.getTagName());
                result.add(dto);
            }
        }
        return result;
    }

    public List<BDataValueDto> getBDataValues(String values) {
        Long userId = LoginUtils.getCurrentUserId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        String corpId = LoginUtils.getCurrentUserCorpId();
        log.info("query tag list, bizId={}, userId={}, values={}", new Object[]{bizId, userId, values});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)corpId), (Object)"\u7528\u6237\u672a\u767b\u5f55");
        String[] args = StringUtils.split((String)values, (String)",");
        HashSet tagIds = Sets.newHashSet();
        for (String it : args) {
            if (!StringUtils.isNotBlank((CharSequence)it)) continue;
            tagIds.add(it.trim());
        }
        ArrayList result = Lists.newArrayList();
        Map map = this.weworkTagMapper.queryTagIdAndName(corpId, (Collection)tagIds);
        if (map != null && map.size() > 0) {
            map.forEach((tagId, name) -> {
                BDataValueDto dto = new BDataValueDto();
                dto.setValue(tagId);
                dto.setLabel(name);
                result.add(dto);
            });
        }
        return result;
    }

    @Override
    public List<TagGroupDto> list() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        List groupList = this.weworkTagGroupMapper.queryTagGroupList(corpId);
        ArrayList result = Lists.newArrayList();
        for (WeworkTagGroup tagGroup : groupList) {
            TagGroupDto tagGroupDto = new TagGroupDto();
            tagGroupDto.setGroupId(tagGroup.getGroupId());
            tagGroupDto.setGroupName(tagGroup.getGroupName());
            tagGroupDto.setIsSysCreate(Integer.valueOf(1));
            ArrayList tagDtoList = Lists.newArrayList();
            List tagList = this.weworkTagMapper.queryTagList(corpId, tagGroup.getGroupId());
            for (WeworkTag weworkTag : tagList) {
                WeworkTagDto weworkTagDto = new WeworkTagDto();
                weworkTagDto.setId(weworkTag.getTagId());
                weworkTagDto.setName(weworkTag.getName());
                weworkTagDto.setIsSysCreate(Integer.valueOf(1));
                tagDtoList.add(weworkTagDto);
            }
            tagGroupDto.setWeworkTags((List)tagDtoList);
            result.add(tagGroupDto);
        }
        return result;
    }

    @Override
    @Transactional
    public void add(TagGroupParams params) {
        log.info("tag add params: {}", (Object)params);
        if (params == null) {
            log.warn("params is null");
            return;
        }
        params.checkParams();
        if (StringUtils.isBlank((CharSequence)params.getGroupName())) {
            log.warn("tag group name is empty");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5206\u7ec4\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)params.getWeworkTags())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6807\u7b7e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Long bizId = userInfo.getBizId();
        Long userId = userInfo.getId();
        int count = this.weworkTagGroupMapper.queryGroupNameCount(corpId, params.getGroupName().trim());
        if (count > 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b58\u5728\u76f8\u540c\u540d\u5b57\u7684\u5206\u7ec4");
        }
        try {
            CorpTagGroup tagGroup = this.addExternalTag(corpId, params.getGroupId(), params.getGroupName(), params.getWeworkTags());
            this.saveTagGroup(bizId, corpId, userId, tagGroup);
            this.saveTagList(bizId, corpId, userId, tagGroup.getGroupId(), tagGroup.getTagList());
        }
        catch (WeworkException e) {
            this.handleTagException(e);
        }
    }

    @Override
    @Transactional
    public void edit(TagGroupParams params) {
        List weworkTags;
        log.info("tag edit params: {}", (Object)params);
        if (params == null) {
            return;
        }
        params.checkParams();
        if (StringUtils.isBlank((CharSequence)params.getGroupId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6807\u7b7e\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)params.getGroupName())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6807\u7b7e\u5206\u7ec4\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Long bizId = userInfo.getBizId();
        Long userId = userInfo.getId();
        WeworkTagGroup weworkTagGroup = this.weworkTagGroupMapper.queryTagGroupByGroupId(corpId, params.getGroupId());
        if (!weworkTagGroup.getGroupName().equals(params.getGroupName().trim())) {
            int count = this.weworkTagGroupMapper.queryGroupNameCount(corpId, params.getGroupName().trim());
            if (count > 0) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b58\u5728\u76f8\u540c\u540d\u5b57\u7684\u5206\u7ec4");
            }
            try {
                this.updateExternalTag(corpId, params.getGroupId(), params.getGroupName());
                this.weworkTagGroupMapper.updateWeworkTagGroup(bizId, corpId, params.getGroupId(), params.getGroupName(), userId);
            }
            catch (WeworkException e) {
                this.handleTagException(e);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(weworkTags = params.getWeworkTags()))) {
            return;
        }
        ArrayList addTags = Lists.newArrayList();
        ArrayList delTags = Lists.newArrayList();
        ArrayList updateTags = Lists.newArrayList();
        for (WeworkTagParams weworkTagParams : weworkTags) {
            if (weworkTagParams.getId() == null) {
                addTags.add(weworkTagParams);
                continue;
            }
            if (weworkTagParams.getIsDeleted() != null && weworkTagParams.getIsDeleted() == 1) {
                delTags.add(weworkTagParams.getId());
                continue;
            }
            updateTags.add(weworkTagParams);
        }
        if (CollectionUtils.isNotEmpty((Collection)addTags)) {
            try {
                CorpTagGroup corpTagGroup = this.addExternalTag(corpId, params.getGroupId(), null, addTags);
                this.saveTagList(bizId, corpId, userId, corpTagGroup.getGroupId(), corpTagGroup.getTagList());
            }
            catch (WeworkException e) {
                this.handleTagException(e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)delTags)) {
            this.delExternalTag(corpId, null, delTags);
            this.weworkTagMapper.delWeworkTagByTagId(bizId, corpId, (Collection)delTags, userId);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateTags)) {
            Map tagIdNameMap = this.weworkTagMapper.selectTagIdAndNameByCorpIdAndTagIds(corpId, (Collection)updateTags.stream().map(WeworkTagParams::getId).collect(Collectors.toSet()));
            for (WeworkTagParams weworkTagParam : updateTags) {
                String tagName = (String)tagIdNameMap.get(weworkTagParam.getId());
                if (tagName == null || tagName.equals(weworkTagParam.getName().trim())) continue;
                try {
                    this.updateExternalTag(corpId, weworkTagParam.getId(), weworkTagParam.getName());
                    this.weworkTagMapper.updateWeworkTag(bizId, corpId, weworkTagParam.getId(), weworkTagParam.getName(), userId);
                }
                catch (WeworkException e) {
                    this.handleTagException(e);
                }
            }
        }
    }

    @Override
    @Transactional
    public void del(List<String> groupIds) {
        log.info("del params: {}", groupIds);
        if (CollectionUtils.isEmpty(groupIds)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5206\u7ec4id\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        this.delExternalTag(corpId, groupIds, null);
        this.weworkTagGroupMapper.delTagGroup(bizId, corpId, groupIds, userInfo.getId());
        this.weworkTagMapper.delWeworkTagByGroup(bizId, corpId, groupIds, userInfo.getId());
    }

    @Override
    @Transactional
    public String attachTag(AttachTagParams params) {
        List<WeworkUserContactDto> attachContactDtos;
        log.info("attach tag params: {}", (Object)params);
        if (params == null) {
            return null;
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long userId = userInfo.getId();
        List<String> addTags = params.getAddWeworkTagIds();
        List<String> rmTags = params.getRmWeworkTagIds();
        if (CollectionUtils.isEmpty(addTags) && CollectionUtils.isEmpty(rmTags)) {
            return null;
        }
        if (params.getIsSelectAll().booleanValue()) {
            ContactRelationListParams selectParams = params.getSelectParams();
            if (selectParams == null) {
                selectParams = new ContactRelationListParams();
            }
            attachContactDtos = this.contactRelationService.queryWeworkContactRelationList(selectParams);
        } else {
            attachContactDtos = params.getAttachContacts();
        }
        if (CollectionUtils.isNotEmpty(attachContactDtos)) {
            if (Objects.isNull(params.getFollowRecordType())) {
                try {
                    this.addFollowRecord(params.getIsSelectAll(), corpId, attachContactDtos, addTags, rmTags);
                }
                catch (Exception ex) {
                    log.error("\u7ed9\u5ba2\u6237\u6253\u6807\u7b7e\u6dfb\u52a0\u8ddf\u8fdb\u8bb0\u5f55\u53d1\u751f\u5f02\u5e38:", (Throwable)ex);
                }
            }
        } else {
            log.info("attachTag,\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u6210\u5458\u5ba2\u6237\u5173\u7cfb");
        }
        Date curDate = new Date();
        AttachTagTask attachTagTask = new AttachTagTask();
        attachTagTask.setNum(this.idGen.getNum());
        attachTagTask.setBizId(bizId);
        attachTagTask.setCorpId(corpId);
        attachTagTask.setAddTags(JacksonUtil.obj2Str(addTags));
        attachTagTask.setRmTags(JacksonUtil.obj2Str(rmTags));
        attachTagTask.setStatus(Integer.valueOf(0));
        attachTagTask.setCreateBy(userId);
        attachTagTask.setCreateTime(curDate);
        attachTagTask.setUpdateBy(userId);
        attachTagTask.setUpdateTime(curDate);
        this.attachTagTaskMapper.insertSelective((Object)attachTagTask);
        Long taskId = attachTagTask.getId();
        ArrayList subTaskList = Lists.newArrayList();
        for (WeworkUserContactDto attachContactDto : attachContactDtos) {
            WeworkContact contact;
            AttachTagSubTask subTask = new AttachTagSubTask();
            subTask.setBizId(bizId);
            subTask.setCorpId(corpId);
            subTask.setTaskId(taskId);
            String weworkUserNum = attachContactDto.getWeworkUserId();
            if (params.getIsSelectAll().booleanValue()) {
                weworkUserNum = this.weworkUserService.getWeworkUserNumById(corpId, attachContactDto.getWeworkUserId());
            }
            subTask.setWeworkUserNum(weworkUserNum);
            subTask.setContactId(attachContactDto.getContactId());
            subTask.setStatus(Integer.valueOf(0));
            subTask.setCreateBy(userId);
            subTask.setCreateTime(curDate);
            subTask.setUpdateBy(userId);
            subTask.setUpdateTime(curDate);
            subTaskList.add(subTask);
            if (subTaskList.size() >= 100) {
                this.attachTagSubTaskMapper.batchInsert((Collection)subTaskList);
                subTaskList.clear();
            }
            if (!Objects.nonNull(contact = this.contactMapper.queryContactByContactId(corpId, attachContactDto.getContactId()))) continue;
            this.customerCenterService.pushTagRelation(bizId, weworkUserNum, contact.getCustomerNum(), params.getAddWeworkTagIds(), params.getRmWeworkTagIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)subTaskList)) {
            this.attachTagSubTaskMapper.batchInsert((Collection)subTaskList);
        }
        this.kafkaTemplate.send(this.attachTagTaskTopic, (Object)attachTagTask.getNum(), (Object)Long.toString(attachTagTask.getId()));
        return attachTagTask.getNum();
    }

    @Override
    @Transactional
    public void singleAttachTag(SingleAttachTagParams params) {
        WeworkContact contact;
        log.info("single attach tag params: {}", (Object)params);
        if (params == null) {
            return;
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        if (userInfo == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        List<String> addTags = params.getAddWeworkTagIds();
        List<String> rmTags = params.getRmWeworkTagIds();
        if (CollectionUtils.isEmpty(addTags) && CollectionUtils.isEmpty(rmTags)) {
            return;
        }
        String contactId = "";
        if (StringUtils.isNotBlank((CharSequence)params.getCustomerNum()) && Objects.nonNull(contact = this.contactMapper.queryContact(corpId, params.getCustomerNum()))) {
            contactId = contact.getContactId();
        }
        if (StringUtils.isNotBlank((CharSequence)params.getContactId())) {
            contactId = params.getContactId();
        }
        if (StringUtils.isEmpty((CharSequence)params.getWeworkUserId()) || StringUtils.isEmpty((CharSequence)contactId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "weworkUserId\u548ccontactId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String weworkUserId = this.weworkUserService.getWeworkUserIdByNum(params.getWeworkUserId());
        if (!this.contactRelationService.isExternalUserRelation(corpId, weworkUserId, contactId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6210\u5458\u4e0e\u5ba2\u6237\u4e0d\u662f\u597d\u53cb\u5173\u7cfb");
        }
        ModifyTagDto modifyTagDto = new ModifyTagDto();
        modifyTagDto.setBizId(bizId);
        modifyTagDto.setCorpId(corpId);
        modifyTagDto.setWeworkUserId(weworkUserId);
        modifyTagDto.setContactId(contactId);
        modifyTagDto.setAddTagIds(params.getAddWeworkTagIds());
        modifyTagDto.setRemoveTagIds(params.getRmWeworkTagIds());
        log.info("singleAttachTag: \u6253\u6807\u7b7e:{}", (Object)modifyTagDto);
        try {
            this.contactOpService.modifyTag(modifyTagDto);
        }
        catch (WeworkException e) {
            this.handleTagException(e);
        }
    }

    @Override
    public AttachTagResultDto queryAttachTagResult(BaseDto params) {
        log.info("queryAttachTagResult params: {}", (Object)params);
        if (params == null) {
            return null;
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        String num = params.getId();
        AttachTagTask attachTagTask = new AttachTagTask();
        attachTagTask.setBizId(bizId);
        attachTagTask.setCorpId(corpId);
        attachTagTask.setNum(num);
        attachTagTask = (AttachTagTask)this.attachTagTaskMapper.selectOne((Object)attachTagTask);
        if (attachTagTask == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u67e5\u8be2\u53c2\u6570id\u4e0d\u5bf9");
        }
        AttachTagResultDto resultDto = new AttachTagResultDto();
        if (attachTagTask.getStatus().intValue() == AttachTagTaskStatus.FINISH.getValue()) {
            int notHandleSubTaskNum = this.attachTagSubTaskMapper.querySubTaskCount(attachTagTask.getId());
            if (notHandleSubTaskNum == 0) {
                resultDto.setTaskStatus(attachTagTask.getStatus());
            } else {
                resultDto.setTaskStatus(AttachTagTaskStatus.IS_RUNNING.getValue());
            }
        } else {
            resultDto.setTaskStatus(attachTagTask.getStatus());
        }
        if (resultDto.getTaskStatus() == 1 && attachTagTask.getUpdateTime().getTime() + 3600000L < new Date().getTime()) {
            resultDto.setTaskStatus(AttachTagTaskStatus.FINISH.getValue());
        }
        int successSubTaskNum = this.attachTagSubTaskMapper.querySubTaskStatusCount(attachTagTask.getId(), Integer.valueOf(1));
        int failSubTaskNum = this.attachTagSubTaskMapper.querySubTaskStatusCount(attachTagTask.getId(), Integer.valueOf(2));
        resultDto.setAttachTagSuccess(successSubTaskNum);
        resultDto.setAttachTagFail(failSubTaskNum);
        return resultDto;
    }

    private CorpTagGroup addExternalTag(String corpId, String groupId, String groupName, List<WeworkTagParams> weworkTags) {
        AddCorpTagParams addCorpTagParams = new AddCorpTagParams();
        addCorpTagParams.setGroupId(groupId);
        addCorpTagParams.setGroupName(groupName);
        ArrayList tagList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(weworkTags)) {
            for (WeworkTagParams weworkTag : weworkTags) {
                CorpTag corpTag = new CorpTag();
                corpTag.setName(weworkTag.getName());
                tagList.add(corpTag);
            }
        }
        addCorpTagParams.setTagList((List)tagList);
        AddCorpTagResp add = this.externalTagClient.add(corpId, addCorpTagParams);
        return add.getTagGroup();
    }

    private void updateExternalTag(String corpId, String id, String name) {
        UpdateCorpTagParams updateCorpTagGroup = new UpdateCorpTagParams();
        updateCorpTagGroup.setId(id);
        updateCorpTagGroup.setName(name);
        this.externalTagClient.update(corpId, updateCorpTagGroup);
    }

    private void delExternalTag(String corpId, List<String> groupIds, List<String> tagIds) {
        try {
            this.externalTagClient.delete(corpId, groupIds, tagIds);
        }
        catch (WeworkException e) {
            this.handleTagException(e);
        }
    }

    public void saveTagGroup(Long bizId, String corpId, Long userId, CorpTagGroup tagGroup) {
        Date curTime = new Date();
        WeworkTagGroup weworkTagGroup = new WeworkTagGroup();
        weworkTagGroup.setNum(this.idGen.getNum());
        weworkTagGroup.setBizId(bizId);
        weworkTagGroup.setCorpId(corpId);
        weworkTagGroup.setAddTime(new Date(tagGroup.getCreateTime() * 1000L));
        weworkTagGroup.setGroupId(tagGroup.getGroupId());
        weworkTagGroup.setGroupName(tagGroup.getGroupName());
        weworkTagGroup.setOrder(tagGroup.getOrder());
        weworkTagGroup.setCreateBy(userId);
        weworkTagGroup.setCreateTime(curTime);
        weworkTagGroup.setUpdateBy(userId);
        weworkTagGroup.setUpdateTime(curTime);
        weworkTagGroup.setIsDeleted(Integer.valueOf(0));
        this.weworkTagGroupMapper.batchInsert((Collection)Lists.newArrayList((Object[])new WeworkTagGroup[]{weworkTagGroup}));
    }

    public void saveTagList(Long bizId, String corpId, Long userId, String tagGroupId, List<CorpTag> addTags) {
        ArrayList saveTagList = Lists.newArrayList();
        Date curDate = new Date();
        for (CorpTag corpTag : addTags) {
            WeworkTag weworkTag = new WeworkTag();
            weworkTag.setNum(this.idGen.getNum());
            weworkTag.setBizId(bizId);
            weworkTag.setCorpId(corpId);
            weworkTag.setAddTime(new Date(corpTag.getCreateTime() * 1000L));
            weworkTag.setGroupId(tagGroupId);
            weworkTag.setTagId(corpTag.getId());
            weworkTag.setName(corpTag.getName());
            weworkTag.setOrder(corpTag.getOrder());
            weworkTag.setIsDeleted(Integer.valueOf(0));
            weworkTag.setCreateBy(userId);
            weworkTag.setUpdateBy(userId);
            weworkTag.setCreateTime(curDate);
            weworkTag.setUpdateTime(curDate);
            saveTagList.add(weworkTag);
        }
        this.weworkTagMapper.batchInsert((Collection)saveTagList);
    }

    @Override
    public Map<String, List<WeworkTagDto>> getWeworkTagMap(String corpId, List<String> weworkUserIds, List<String> contactIds) {
        HashMap resultMap = Maps.newHashMap();
        List weworkContactTags = this.weworkContactTagMapper.queryWeworkTagList(corpId, weworkUserIds, contactIds);
        for (WeworkContactTag weworkContactTag : weworkContactTags) {
            String key = weworkContactTag.getWeworkUserId() + weworkContactTag.getContactId();
            WeworkTagDto weworkTagDto = new WeworkTagDto();
            weworkTagDto.setId(weworkContactTag.getTagId());
            weworkTagDto.setName(weworkContactTag.getTagName());
            if (resultMap.containsKey(key)) {
                ((List)resultMap.get(key)).add(weworkTagDto);
                continue;
            }
            ArrayList list = Lists.newArrayList((Object[])new WeworkTagDto[]{weworkTagDto});
            resultMap.put(key, list);
        }
        return resultMap;
    }

    @Override
    public List<WeworkTagDto> getWeworkTags(String corpId, String weworkUserId, String contactId, Integer isDeleted) {
        List weworkContactTags = this.weworkContactTagMapper.queryContactTags(corpId, weworkUserId, contactId, isDeleted);
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)weworkContactTags)) {
            return result;
        }
        Set tagIds = weworkContactTags.stream().map(WeworkContactTag::getTagId).collect(Collectors.toSet());
        Map tagNameMap = this.weworkTagMapper.selectTagIdAndNameByCorpIdAndTagIds(corpId, tagIds);
        for (WeworkContactTag contactTag : weworkContactTags) {
            WeworkTagDto weworkTagDto = new WeworkTagDto();
            weworkTagDto.setId(contactTag.getTagId());
            weworkTagDto.setName((String)tagNameMap.get(contactTag.getTagId()));
            result.add(weworkTagDto);
        }
        return result;
    }

    private void addFollowRecord(boolean isSelectAll, String corpId, List<WeworkUserContactDto> attachContactDtos, List<String> addTags, List<String> rmTags) {
        FollowReqDto followReqDto = new FollowReqDto();
        followReqDto.setType(Integer.valueOf(FollowRecordType.EDIT_CONTACT_TAG.getValue()));
        new Thread(() -> {
            for (WeworkUserContactDto weworkUserContactDto : attachContactDtos) {
                CorpTagDto corpTagDto;
                String weworkUserNum;
                String weworkUserId;
                String contactId = weworkUserContactDto.getContactId();
                if (isSelectAll) {
                    weworkUserId = weworkUserContactDto.getWeworkUserId();
                    weworkUserNum = this.weworkUserMapper.queryWeworkUserNumById(corpId, weworkUserId);
                } else {
                    weworkUserNum = weworkUserContactDto.getWeworkUserId();
                    weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(weworkUserNum);
                }
                followReqDto.setWeworkUserNum(weworkUserNum);
                followReqDto.setContactId(contactId);
                HashSet oldTagIds = Sets.newHashSet();
                HashSet newTagIds = Sets.newHashSet();
                Set tagIds = this.weworkContactTagMapper.selectTagIdsByParams(corpId, weworkUserId, contactId);
                if (CollectionUtils.isNotEmpty((Collection)tagIds)) {
                    oldTagIds.addAll(tagIds);
                    newTagIds.addAll(tagIds);
                }
                if (CollectionUtils.isNotEmpty((Collection)addTags)) {
                    for (String tagId : addTags) {
                        if (tagIds.contains(tagId)) continue;
                        oldTagIds.remove(tagId);
                    }
                    newTagIds.addAll(addTags);
                }
                if (CollectionUtils.isNotEmpty((Collection)rmTags)) {
                    oldTagIds.addAll(rmTags);
                    newTagIds.removeAll(rmTags);
                }
                log.info("addFollowRecord,weworkUserId:{},contactId:{},tagIds:{},oldTagIds:{},newTagIds:{}", new Object[]{weworkUserId, contactId, tagIds, oldTagIds, newTagIds});
                if (CollectionUtils.isEmpty((Collection)oldTagIds) && CollectionUtils.isEmpty((Collection)newTagIds)) {
                    log.info("weworkUserId:{},contactId:{}\u4fee\u6539\u524d\u540e\u7684\u6807\u7b7e\u90fd\u4e3a\u7a7a", (Object)weworkUserId, (Object)contactId);
                    continue;
                }
                HashSet allTagIds = Sets.newHashSet();
                allTagIds.addAll(oldTagIds);
                allTagIds.addAll(newTagIds);
                Map tagId2NameMap = this.weworkTagMapper.selectTagIdAndNameByCorpIdAndTagIds(corpId, (Collection)allTagIds);
                if (MapUtils.isEmpty((Map)tagId2NameMap)) {
                    log.warn("\u6839\u636ecorpId:{}, allTagIds:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)corpId, (Object)allTagIds);
                    continue;
                }
                ArrayList oldCorpTagDtos = null;
                ArrayList newCorpTagDtos = null;
                if (CollectionUtils.isNotEmpty((Collection)oldTagIds)) {
                    oldCorpTagDtos = Lists.newArrayList();
                    for (String tagId : oldTagIds) {
                        corpTagDto = new CorpTagDto();
                        oldCorpTagDtos.add(corpTagDto);
                        corpTagDto.setTagId(tagId);
                        corpTagDto.setTagName((String)tagId2NameMap.get(tagId));
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)newTagIds)) {
                    newCorpTagDtos = Lists.newArrayList();
                    for (String tagId : newTagIds) {
                        corpTagDto = new CorpTagDto();
                        newCorpTagDtos.add(corpTagDto);
                        corpTagDto.setTagId(tagId);
                        corpTagDto.setTagName((String)tagId2NameMap.get(tagId));
                    }
                }
                CustomerTagInfo customerTagInfo = new CustomerTagInfo();
                customerTagInfo.setOldTags((List)oldCorpTagDtos);
                customerTagInfo.setNewTags((List)newCorpTagDtos);
                followReqDto.setCustomerTagInfo(customerTagInfo);
                this.followService.saveFollowRecord(followReqDto, LoginUtils.getCurrentUser());
            }
        }).start();
    }

    private void handleTagException(WeworkException weworkException) {
        if (weworkException.getErrorCode() == 40071) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b58\u5728\u76f8\u540c\u6807\u7b7e\u7ec4\u540d\u6216\u8005\u6807\u7b7e\u540d\uff0c \u8bf7\u540c\u6b65\u4f01\u5fae\u6807\u7b7e\u540e\u518d\u64cd\u4f5c");
        }
        if (weworkException.getErrorCode() == 81011) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6807\u7b7e\u4e0d\u662f\u5f53\u524d\u5e94\u7528\u521b\u5efa\u7684\uff0c\u65e0\u6743\u9650\u64cd\u4f5c\u6807\u7b7e");
        }
        if (weworkException.getErrorCode() == 40068) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9009\u62e9\u7684\u6807\u7b7e\u4e2d\u6709\u5df2\u7ecf\u88ab\u5220\u9664\u7684\uff0c\u8bf7\u540c\u6b65\u4f01\u5fae\u6807\u7b7e\u540e\u91cd\u65b0\u5c1d\u8bd5");
        }
        throw weworkException;
    }
}

