/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.service.impl;

import cn.kinyun.customer.center.dto.req.QueryOrderSkuDepPayRecordReportReq;
import cn.kinyun.customer.center.dto.resp.OrderSkuDepPayRecordReportList;
import cn.kinyun.customer.center.dto.resp.OrderSkuDepPayRecordReportResp;
import cn.kinyun.customer.center.dto.resp.PayRecordStatisticsResp;
import cn.kinyun.customer.center.service.CcCustomerPayRecordService;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.enums.ExportTaskType;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.dal.exporttask.entity.ExportTask;
import com.kuaike.scrm.dal.exporttask.mapper.ExportTaskMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.wework.contact.dto.PayRecordReportExportDto;
import com.kuaike.scrm.wework.contact.service.impl.AbstractExportService;
import com.kuaike.scrm.wework.contact.service.impl.CustomPayReportRowWriteHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payRecordReportExport")
public class PayRecordReportExportServiceImpl
extends AbstractExportService {
    private static final Logger log = LoggerFactory.getLogger(PayRecordReportExportServiceImpl.class);
    @Resource
    private ExportTaskMapper exportTaskMapper;
    @Autowired
    private CcCustomerPayRecordService customerPayRecordService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private UserMapper userMapper;

    private String createExportFile(ExportTask task, String json) {
        String corpId = task.getCorpId();
        Long bizId = task.getBizId();
        this.createCorpDir(corpId);
        File dirFile = null;
        String filePath = this.createFilePath(corpId, ExportTaskType.PAY_RECORD_REPORT, "\u56de\u6b3e\u5355\u62a5\u8868\u5bfc\u51fa");
        String sheetName = "\u56de\u6b3e\u5355\u62a5\u8868\u5bfc\u51fa";
        ExcelWriter excelWriter = null;
        HashMap<String, Integer> skuNameRowMap = new HashMap<String, Integer>();
        String url = null;
        try {
            excelWriter = EasyExcel.write((String)filePath, PayRecordReportExportDto.class).build();
            WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)0, (String)sheetName).registerWriteHandler((WriteHandler)new CustomPayReportRowWriteHandler(skuNameRowMap))).build();
            QueryOrderSkuDepPayRecordReportReq queryParam = (QueryOrderSkuDepPayRecordReportReq)JSON.parseObject((String)json, QueryOrderSkuDepPayRecordReportReq.class);
            queryParam.setBizId(bizId);
            OrderSkuDepPayRecordReportResp resp = this.customerPayRecordService.queryOrderSkuDepPayRecordReport(queryParam);
            List list = resp.getList();
            final PayRecordStatisticsResp statistic = resp.getStatistics();
            ArrayList<PayRecordReportExportDto> excelRows = new ArrayList<PayRecordReportExportDto>();
            for (OrderSkuDepPayRecordReportList record : list) {
                this.addRecordToExcelRows(excelRows, record, true, skuNameRowMap);
                if (record.getDepList() == null) continue;
                for (OrderSkuDepPayRecordReportList dep : record.getDepList()) {
                    this.addRecordToExcelRows(excelRows, dep, false, skuNameRowMap);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.addRecordToExcelRows(excelRows, new OrderSkuDepPayRecordReportList(){
                    {
                        this.setSkuNo("");
                        this.setDepartName("\u603b\u5408\u8ba1");
                        this.setOrderCount(statistic.getOrderCount());
                        this.setTotalOrderAmount(statistic.getTotalOrderAmount());
                        this.setTotalPayAmount(statistic.getTotalPayAmount());
                        this.setTotalRemainAmount(statistic.getTotalRemainAmount());
                    }
                }, false, skuNameRowMap);
            }
            excelWriter.write(excelRows, writeSheet);
            excelWriter.finish();
            File file = new File(filePath);
            if (file.exists()) {
                url = this.uploadOss(corpId, file);
            }
        }
        catch (BusinessException e) {
            log.error("export payRecord report BusinessException error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
        catch (Exception e) {
            log.error("export payRecord report error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            File file;
            if (excelWriter != null) {
                excelWriter.finish();
            }
            if ((file = new File(filePath)).exists()) {
                file.delete();
            }
            if (Objects.nonNull(dirFile) && dirFile.exists() && dirFile.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)dirFile);
                    log.info("delete dir:{}", (Object)dirFile.getAbsolutePath());
                }
                catch (IOException e) {
                    log.error("delete dir:{} fail", (Object)dirFile.getAbsolutePath(), (Object)e);
                }
            }
        }
        return url;
    }

    private void addRecordToExcelRows(List<PayRecordReportExportDto> excelRows, OrderSkuDepPayRecordReportList record, boolean isMain, Map<String, Integer> skuNameRowMap) {
        PayRecordReportExportDto row = new PayRecordReportExportDto();
        row.setSkuName(isMain ? record.getSkuName() : null);
        row.setDepartName(isMain ? "\u5408\u8ba1" : record.getDepartName());
        row.setTotalOrderAmount(String.valueOf((double)record.getTotalOrderAmount().longValue() / 10000.0));
        row.setTotalPayAmount(String.valueOf((double)record.getTotalPayAmount().longValue() / 10000.0));
        row.setTotalRemainAmount(String.valueOf((double)record.getTotalRemainAmount().longValue() / 10000.0));
        row.setOrderCount(record.getOrderCount());
        excelRows.add(row);
        if (isMain) {
            skuNameRowMap.put(record.getSkuName() + Double.parseDouble(record.getOrderCount().toString()) + String.valueOf((double)record.getTotalOrderAmount().longValue() / 10000.0), record.getDepList().size());
        }
    }

    @Override
    protected Runnable buildTask(ExportTask task, String json) {
        return () -> {
            if (task == null) {
                log.info("build export pay record report task is null");
                return;
            }
            try {
                log.info("run task num: {},json:{}", (Object)task.getNum(), (Object)json);
                String filePath = this.createExportFile(task, json);
                task.setFilePath(filePath);
            }
            catch (BusinessException e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg(e.getMessage());
            }
            catch (Exception e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
            }
            finally {
                task.setStatus(Integer.valueOf(2));
                task.setUpdateTime(new Date());
                this.exportTaskMapper.updateByPrimaryKeySelective((Object)task);
            }
        };
    }
}

