/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.service.impl;

import cn.kinyun.customer.center.dto.req.QueryPayRecordListReq;
import cn.kinyun.customer.center.dto.resp.PagePayRecordResp;
import cn.kinyun.customer.center.dto.resp.PayRecordListResp;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.customer.center.service.CcCustomerPayRecordService;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.enums.ExportTaskType;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.dal.exporttask.entity.ExportTask;
import com.kuaike.scrm.dal.exporttask.mapper.ExportTaskMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.wework.contact.dto.PayRecordExportDto;
import com.kuaike.scrm.wework.contact.service.impl.AbstractExportService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payRecordExport")
public class PayRecordExportServiceImpl
extends AbstractExportService {
    private static final Logger log = LoggerFactory.getLogger(PayRecordExportServiceImpl.class);
    @Resource
    private ExportTaskMapper exportTaskMapper;
    @Autowired
    private CcCustomerOrderService customerOrderService;
    @Autowired
    private CcCustomerPayRecordService customerPayRecordService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private UserMapper userMapper;

    private String createExportFile(ExportTask task, String json) {
        String corpId = task.getCorpId();
        Long bizId = task.getBizId();
        this.createCorpDir(corpId);
        File dirFile = null;
        String filePath = this.createFilePath(corpId, ExportTaskType.PAY_RECORD, "\u56de\u6b3e\u5355\u5bfc\u51fa");
        String sheetName = "\u56de\u6b3e\u5355\u5bfc\u51fa";
        ExcelWriter excelWriter = null;
        String url = null;
        try {
            Set nodeIds;
            excelWriter = EasyExcel.write((String)filePath, PayRecordExportDto.class).build();
            WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0, (String)sheetName).build();
            QueryPayRecordListReq queryParam = (QueryPayRecordListReq)JSON.parseObject((String)json, QueryPayRecordListReq.class);
            queryParam.setBizId(bizId);
            queryParam.setPageDto(null);
            Set userIds = Sets.newHashSet();
            if (queryParam.getNodeId() != null && CollectionUtils.isEmpty((Collection)(userIds = this.userMapper.queryUserIdsByNodeIds((Collection)(nodeIds = this.nodeService.getPosterityIds(queryParam.getNodeId(), bizId)), Boolean.valueOf(false))))) {
                queryParam.setUserId(Long.valueOf(-1L));
            }
            if (queryParam.getUserId() != null && queryParam.getUserId() > 0L) {
                userIds.add(queryParam.getUserId());
            }
            queryParam.setUserIds((Collection)userIds);
            PagePayRecordResp resp = this.customerPayRecordService.queryPayRecordList(queryParam);
            List list = resp.getList();
            ArrayList result = Lists.newArrayList();
            for (PayRecordListResp payRecordListResp : list) {
                PayRecordExportDto dto = new PayRecordExportDto();
                BeanUtils.copyProperties((Object)payRecordListResp, (Object)dto);
                dto.setPayAmount(String.valueOf((double)payRecordListResp.getPayAmount().longValue() / 10000.0));
                if (payRecordListResp.getOrderAmount() != null) {
                    dto.setTotalAmount(String.valueOf((double)payRecordListResp.getOrderAmount().longValue() / 10000.0));
                }
                if (payRecordListResp.getPaidAmount() != null) {
                    dto.setPaidAmount(String.valueOf((double)payRecordListResp.getPaidAmount().longValue() / 10000.0));
                }
                if (payRecordListResp.getPayAmount() != null) {
                    dto.setPayAmount(String.valueOf((double)payRecordListResp.getPayAmount().longValue() / 10000.0));
                }
                if (payRecordListResp.getTotalRemainAmount() != null) {
                    dto.setTotalRemainAmount(String.valueOf((double)payRecordListResp.getTotalRemainAmount().longValue() / 10000.0));
                }
                if (payRecordListResp.getDiscountAmount() != null) {
                    dto.setDiscountAmount(String.valueOf((double)payRecordListResp.getDiscountAmount().longValue() / 10000.0));
                }
                result.add(dto);
            }
            excelWriter.write((Collection)result, writeSheet);
            excelWriter.finish();
            File file = new File(filePath);
            if (file.exists()) {
                url = this.uploadOss(corpId, file);
            }
        }
        catch (BusinessException e) {
            log.error("export payRecord BusinessException error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
        catch (Exception e) {
            log.error("export payRecord error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            File file;
            if (excelWriter != null) {
                excelWriter.finish();
            }
            if ((file = new File(filePath)).exists()) {
                file.delete();
            }
            if (Objects.nonNull(dirFile) && dirFile.exists() && dirFile.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)dirFile);
                    log.info("delete dir:{}", (Object)dirFile.getAbsolutePath());
                }
                catch (IOException e) {
                    log.error("delete dir:{} fail", (Object)dirFile.getAbsolutePath(), (Object)e);
                }
            }
        }
        return url;
    }

    @Override
    protected Runnable buildTask(ExportTask task, String json) {
        return () -> {
            if (task == null) {
                log.info("build export pay record  task is null");
                return;
            }
            try {
                log.info("run task num: {},json:{}", (Object)task.getNum(), (Object)json);
                String filePath = this.createExportFile(task, json);
                task.setFilePath(filePath);
            }
            catch (BusinessException e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg(e.getMessage());
            }
            catch (Exception e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
            }
            finally {
                task.setStatus(Integer.valueOf(2));
                task.setUpdateTime(new Date());
                this.exportTaskMapper.updateByPrimaryKeySelective((Object)task);
            }
        };
    }
}

