/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.service.impl;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.ExportTaskType;
import com.kuaike.scrm.common.utils.ApplicationContextUtils;
import com.kuaike.scrm.wework.contact.dto.ExportReqDto;
import com.kuaike.scrm.wework.contact.dto.ExportResp;
import com.kuaike.scrm.wework.contact.service.ExportService;
import com.kuaike.scrm.wework.contact.service.impl.AbstractExportService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExportSupport
extends AbstractExportService {
    private static final Logger log = LoggerFactory.getLogger(ExportSupport.class);

    @Override
    public ExportResp export(ExportReqDto exportReqDto) {
        exportReqDto.validate();
        ExportService exportService = this.getExportServiceByType(exportReqDto.getType());
        Preconditions.checkArgument((exportService != null ? 1 : 0) != 0, (Object)"not support type");
        return exportService.export(exportReqDto);
    }

    private ExportService getExportServiceByType(Integer exportTaskType) {
        if (Objects.isNull(exportTaskType)) {
            return null;
        }
        ExportTaskType taskTypeEnum = ExportTaskType.get((Integer)exportTaskType);
        if (Objects.isNull(taskTypeEnum)) {
            return null;
        }
        ExportService exportService = null;
        try {
            exportService = (ExportService)ApplicationContextUtils.getBean((String)taskTypeEnum.getDesc(), ExportService.class);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6bean \u5f02\u5e38\uff1a", (Throwable)e);
        }
        Preconditions.checkArgument((exportService != null ? 1 : 0) != 0, (Object)"not support type");
        return exportService;
    }
}

