/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.enums.ExportTaskType;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingMaterial;
import com.kuaike.scrm.dal.applet.entity.AppletSpreadChannel;
import com.kuaike.scrm.dal.applet.entity.AppletSpreadChannelStaff;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletSpreadChannelMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletSpreadChannelStaffMapper;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.exporttask.entity.ExportTask;
import com.kuaike.scrm.dal.exporttask.mapper.ExportTaskMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.wework.contact.dto.SpreadCodeExportReqDto;
import com.kuaike.scrm.wework.contact.dto.SpreadCodeExportRespDto;
import com.kuaike.scrm.wework.contact.service.impl.AbstractExportService;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="spreadCodeExport")
public class ExportSpreadCodeServiceImpl
extends AbstractExportService {
    private static final Logger log = LoggerFactory.getLogger(ExportSpreadCodeServiceImpl.class);
    @Autowired
    private ExportTaskMapper exportTaskMapper;
    @Autowired
    private AppletSpreadChannelMapper appletSpreadChannelMapper;
    @Autowired
    private AppletSpreadChannelStaffMapper appletSpreadChannelStaffMapper;
    @Autowired
    private AppletMarketingMaterialMapper marketingMaterialMapper;
    @Autowired
    private ChannelMapper channelMapper;
    @Autowired
    private UserMapper userMapper;
    private static final Integer MAX_QRCODE_SIZE = 1000;

    @Override
    protected Runnable buildTask(ExportTask task, String json) {
        return () -> {
            if (Objects.isNull(task)) {
                log.error("build status is null");
                return;
            }
            try {
                log.info("run task num: {},json:{}", (Object)task.getNum(), (Object)json);
                String filePath = this.createExportFile(task, json);
                task.setFilePath(filePath);
            }
            catch (BusinessException e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg(e.getMessage());
            }
            catch (Exception e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg("\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            finally {
                task.setStatus(Integer.valueOf(2));
                task.setUpdateTime(new Date());
                this.exportTaskMapper.updateByPrimaryKeySelective((Object)task);
            }
        };
    }

    private String createExportFile(ExportTask task, String json) {
        String corpId = task.getCorpId();
        this.createCorpDir(corpId);
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(Integer.valueOf(1));
        pageDto.setPageSize(Integer.valueOf(100));
        return this.exportExcel(corpId, task.getBizId(), json, pageDto);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String exportExcel(String corpId, Long bizId, String query, PageDto pageDto) {
        String url = null;
        String filePath = null;
        try {
            SpreadCodeExportReqDto queryParam = (SpreadCodeExportReqDto)JSON.parseObject((String)query, SpreadCodeExportReqDto.class);
            queryParam.setBizId(bizId);
            queryParam.setPageDto(pageDto);
            List<SpreadCodeExportRespDto> data = this.buildExportData(queryParam);
            filePath = this.createFilePath(corpId, ExportTaskType.SPREAD_CODE, null);
            ExcelWriter excelWriter = EasyExcel.write((String)filePath, SpreadCodeExportRespDto.class).build();
            WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0, (String)"\u63a8\u5e7f\u7801").build();
            excelWriter.write(data, writeSheet);
            excelWriter.finish();
            File file = new File(filePath);
            if (file.exists()) {
                url = this.uploadOss(corpId, file);
            }
        }
        catch (BusinessException e) {
            try {
                log.error("\u5bfc\u51fa\u6587\u4ef6\u5f02\u5e38\uff1aexception:{}", (Object)e.getMessage());
                throw e;
                catch (IOException e2) {
                    log.error("createExportFile IOException error: ", (Throwable)e2);
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "json\u683c\u5f0f\u9519\u8bef");
                }
                catch (Exception e3) {
                    log.error("createExportFile error: ", (Throwable)e3);
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
                }
            }
            catch (Throwable throwable) {
                if (!StringUtils.isNotBlank(filePath)) throw throwable;
                File file = new File(filePath);
                if (!file.exists()) throw throwable;
                file.deleteOnExit();
                throw throwable;
            }
        }
        if (!StringUtils.isNotBlank((CharSequence)filePath)) return url;
        File file = new File(filePath);
        if (!file.exists()) return url;
        file.deleteOnExit();
        return url;
    }

    private List<SpreadCodeExportRespDto> buildExportData(SpreadCodeExportReqDto queryParam) throws MalformedURLException {
        List users;
        log.info("buildSpreadCodeExportData,req:{}", (Object)queryParam);
        if (StringUtils.isBlank((CharSequence)queryParam.getMaterialId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8d44\u6599id\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AppletMarketingMaterial marketingMaterial = this.marketingMaterialMapper.selectByNum(queryParam.getMaterialId());
        if (marketingMaterial == null) {
            log.info("buildSpreadCodeExportData,\u6839\u636ematerialNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)queryParam.getMaterialId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8d44\u6599id\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        List spreadChannels = this.appletSpreadChannelMapper.selectByMaterialIdAndChannelIds(queryParam.getBizId(), marketingMaterial.getId(), queryParam.getChannelIds());
        if (CollectionUtils.isEmpty((Collection)spreadChannels)) {
            log.info("\u6839\u636ebizId:{}, materialId:{},channelIds:{}\u672a\u67e5\u8be2\u5230\u6e20\u9053\u63a8\u5e7f\u7801", new Object[]{queryParam.getBizId(), marketingMaterial.getId(), queryParam.getChannelIds()});
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8fd8\u672a\u65b0\u5efa\u63a8\u5e7f\u7801");
        }
        Map<String, List<AppletSpreadChannel>> channelId2SpreadChannelMap = spreadChannels.stream().collect(Collectors.groupingBy(AppletSpreadChannel::getChannelId));
        Map id2SpreadChannelMap = spreadChannels.stream().collect(Collectors.toMap(AppletSpreadChannel::getId, Functions.identity()));
        Set spreadChannelIds = spreadChannels.stream().map(AppletSpreadChannel::getId).collect(Collectors.toSet());
        int size = channelId2SpreadChannelMap.size();
        if (size > MAX_QRCODE_SIZE) {
            log.info("\u6e20\u9053\u63a8\u5e7f\u7801\u4e2a\u6570\u8d85\u8fc7\u6700\u5927\u9650\u5236");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8981\u4e0b\u8f7d\u7684\u63a8\u5e7f\u7801\u6570\u91cf\u8d85\u8fc7" + MAX_QRCODE_SIZE);
        }
        int count = this.appletSpreadChannelStaffMapper.selectCountByMaterialIdAndSpreadChannelIds(queryParam.getBizId(), marketingMaterial.getId(), spreadChannelIds);
        if (size + count > MAX_QRCODE_SIZE) {
            log.info("\u6e20\u9053\u63a8\u5e7f\u7801\u6570\u91cf:{},\u5458\u5de5\u63a8\u5e7f\u7801\u6570\u91cf:{}\u4e4b\u548c\u8d85\u8fc7:{}", new Object[]{size, count, MAX_QRCODE_SIZE});
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8981\u4e0b\u8f7d\u7684\u63a8\u5e7f\u7801\u6570\u91cf\u8d85\u8fc7" + MAX_QRCODE_SIZE);
        }
        List channelNums = spreadChannels.stream().map(AppletSpreadChannel::getChannelId).collect(Collectors.toList());
        Map channelNum2NameMap = this.channelMapper.selectNameByNums(queryParam.getBizId(), channelNums);
        ArrayList respDtos = Lists.newArrayList();
        for (Map.Entry<String, List<AppletSpreadChannel>> entry : channelId2SpreadChannelMap.entrySet()) {
            SpreadCodeExportRespDto respDto = new SpreadCodeExportRespDto();
            respDtos.add(respDto);
            respDto.setUrl(new URL(entry.getValue().get(0).getQrcodeUrl()));
            respDto.setName(channelNum2NameMap != null ? (String)channelNum2NameMap.get(entry.getValue().get(0).getChannelId()) : "");
        }
        int remainSize = MAX_QRCODE_SIZE - size;
        List spreadChannelStaffs = this.appletSpreadChannelStaffMapper.selectListByParams(queryParam.getBizId(), marketingMaterial.getId(), spreadChannelIds, Integer.valueOf(remainSize));
        if (CollectionUtils.isEmpty((Collection)spreadChannelStaffs)) {
            return respDtos;
        }
        List employee = spreadChannelStaffs.stream().filter(staff -> NumberUtils.INTEGER_ONE.equals(staff.getStaffType())).collect(Collectors.toList());
        Map<Object, Object> userNum2NameMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(employee) && CollectionUtils.isNotEmpty((Collection)(users = this.userMapper.getUserInfoByNums((Collection)employee.stream().map(AppletSpreadChannelStaff::getUserId).collect(Collectors.toList()))))) {
            userNum2NameMap = users.stream().collect(Collectors.toMap(User::getNum, User::getName, (k1, k2) -> k2));
        }
        for (AppletSpreadChannelStaff spreadChannelStaff : spreadChannelStaffs) {
            SpreadCodeExportRespDto respDto = new SpreadCodeExportRespDto();
            respDtos.add(respDto);
            respDto.setUrl(new URL(spreadChannelStaff.getQrcodeUrl()));
            AppletSpreadChannel spreadChannel = (AppletSpreadChannel)id2SpreadChannelMap.get(spreadChannelStaff.getSpreadChannelId());
            String name = "";
            name = name + (channelNum2NameMap != null ? (String)channelNum2NameMap.get(spreadChannel.getChannelId()) : "");
            String userName = NumberUtils.INTEGER_ONE.equals(spreadChannelStaff.getStaffType()) ? (String)userNum2NameMap.get(spreadChannelStaff.getUserId()) : spreadChannelStaff.getUserId();
            if (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)userName)) {
                name = name + "_" + userName;
            }
            respDto.setName(name);
        }
        return respDtos;
    }
}

