/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.service.impl;

import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.component.PojoExportExcel;
import com.kuaike.scrm.common.enums.AddWayType;
import com.kuaike.scrm.common.enums.ExportTaskType;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.contactanalyse.dto.ChannelInfo;
import com.kuaike.scrm.dal.contactanalyse.entity.WeworkContactLog;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkContactLogMapper;
import com.kuaike.scrm.dal.contactstage.entity.WeworkContactStage;
import com.kuaike.scrm.dal.contactstage.mapper.WeworkContactStageMapper;
import com.kuaike.scrm.dal.exporttask.entity.ExportTask;
import com.kuaike.scrm.dal.exporttask.mapper.ExportTaskMapper;
import com.kuaike.scrm.dal.follow.dto.FollowRecordInfo;
import com.kuaike.scrm.dal.follow.mapper.FollowRecordMapper;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.system.entity.CustomerStage;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import com.kuaike.scrm.dal.wework.dto.ContactRelationDto;
import com.kuaike.scrm.dal.wework.dto.ContactRelationParams;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.weworktag.WeworkTagDto;
import com.kuaike.scrm.wework.contact.dto.ContactRelationListParams;
import com.kuaike.scrm.wework.contact.dto.ExportContactDto;
import com.kuaike.scrm.wework.contact.dto.ExportTaskDto;
import com.kuaike.scrm.wework.contact.service.ContactMobileService;
import com.kuaike.scrm.wework.contact.service.ContactRelationService;
import com.kuaike.scrm.wework.contact.service.ExportContactService;
import com.kuaike.scrm.wework.contact.service.impl.AbstractExportService;
import com.kuaike.scrm.wework.contacttag.service.ContactTagService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contactExport")
public class ExportContactServiceImpl
extends AbstractExportService
implements ExportContactService {
    private static final Logger log = LoggerFactory.getLogger(ExportContactServiceImpl.class);
    private static final String EXPORT_DIR = "./exportDir/";
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Resource
    private WeworkContactLogMapper weworkContactLogMapper;
    @Resource
    private WeworkContactStageMapper weworkContactStageMapper;
    @Resource
    private FollowRecordMapper followRecordMapper;
    @Resource
    private CustomerStageMapper customerStageMapper;
    @Resource
    private ExportTaskMapper exportTaskMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private ContactTagService contactTagService;
    @Autowired
    private WeworkUserService weworkUserService;
    @Autowired
    private ContactMobileService contactMobileService;
    @Autowired
    private ContactRelationService contactRelationService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private MarketingPlanMapper marketingPlanMapper;
    private final ExecutorService executeService = new ThreadPoolExecutor(5, 5, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(200), (ThreadFactory)new NamedThreadFactory("ExportFileExecuteService"));

    @Override
    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.executeService);
        File fileDir = new File(EXPORT_DIR);
        if (!fileDir.exists()) {
            fileDir.mkdir();
        }
    }

    @Override
    public void runExportTask(ExportTask task, ContactRelationParams queryParams) {
        this.executeService.execute(this.buildTask(task, queryParams));
    }

    @Override
    public ExportTaskDto getExportTaskStatus(String num) {
        if (StringUtils.isEmpty((CharSequence)num)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ExportTask exportTask = new ExportTask();
        exportTask.setNum(num);
        exportTask = (ExportTask)this.exportTaskMapper.selectOne((Object)exportTask);
        if (exportTask == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        return this.getTaskDto(exportTask);
    }

    @Override
    public void getExportFile(String num, HttpServletResponse response) {
        if (StringUtils.isEmpty((CharSequence)num)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ExportTask exportTask = new ExportTask();
        exportTask.setNum(num);
        exportTask = (ExportTask)this.exportTaskMapper.selectOne((Object)exportTask);
        if (exportTask == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        if (exportTask.getStatus() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d");
        }
        if (StringUtils.isEmpty((CharSequence)exportTask.getFilePath())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u83b7\u53d6\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25");
        }
        try {
            PojoExportExcel.writeExportFile((HttpServletResponse)response, (String)exportTask.getFilePath());
        }
        catch (BusinessException e) {
            log.error("get export file error: ", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error("get export file error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u83b7\u53d6\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25");
        }
    }

    @Override
    protected Runnable buildTask(ExportTask exportTask, String json) {
        ContactRelationListParams params = (ContactRelationListParams)JSON.parseObject((String)json, ContactRelationListParams.class);
        ContactRelationParams exportParams = this.contactRelationService.startExportTask(params);
        return this.buildTask(exportTask, exportParams);
    }

    private Runnable buildTask(ExportTask task, ContactRelationParams queryParams) {
        return () -> {
            if (task == null) {
                log.warn("build task is null");
                return;
            }
            try {
                log.info("run task num: {}", (Object)task.getNum());
                String filePath = this.createExportFile(queryParams);
                task.setFilePath(filePath);
            }
            catch (BusinessException e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg(e.getMessage());
            }
            catch (Exception e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
            }
            finally {
                task.setStatus(Integer.valueOf(2));
                task.setUpdateTime(new Date());
                this.exportTaskMapper.updateByPrimaryKeySelective((Object)task);
            }
        };
    }

    private String createExportFile(ContactRelationParams queryParams) {
        this.createCorpDir(queryParams.getCorpId());
        int pageSize = 500;
        queryParams.setQueryCount(YnEnum.YES.getValue());
        int total = this.weworkContactRelationMapper.queryContactRelationCount(queryParams);
        int pages = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        String filePath = this.createFilePath(queryParams.getCorpId(), ExportTaskType.CONTACT, null);
        String sheetName = "\u5fae\u4fe1\u5ba2\u6237";
        PageDto pageDto = queryParams.getPageDto();
        if (pageDto != null || pages <= 1) {
            pages = 1;
        }
        ExcelWriter excelWriter = null;
        String url = null;
        try {
            excelWriter = EasyExcel.write((String)filePath, ExportContactDto.class).build();
            WriteSheet writeSheet = EasyExcel.writerSheet((String)sheetName).build();
            for (int i = 0; i < pages; ++i) {
                if (pages != 1) {
                    pageDto = new PageDto();
                    pageDto.setPageSize(Integer.valueOf(pageSize));
                    pageDto.setPageNum(Integer.valueOf(i + 1));
                }
                queryParams.setPageDto(pageDto);
                queryParams.setQueryCount(YnEnum.NO.getValue());
                List<ExportContactDto> pageList = this.queryPageContact(queryParams);
                excelWriter.write(pageList, writeSheet);
            }
            excelWriter.finish();
            File file = new File(filePath);
            if (file.exists()) {
                url = this.uploadOss(queryParams.getCorpId(), file);
            }
        }
        catch (Exception e) {
            log.error("createExportFile error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            File file;
            if (excelWriter != null) {
                excelWriter.finish();
            }
            if ((file = new File(filePath)).exists()) {
                file.delete();
            }
        }
        return url;
    }

    private List<ExportContactDto> queryPageContact(ContactRelationParams queryParams) {
        Long bizId = queryParams.getBizId();
        String corpId = queryParams.getCorpId();
        List list = this.weworkContactRelationMapper.queryContactRelationList(queryParams);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        List<String> weworkUserIds = list.stream().map(ContactRelationDto::getWeworkUserId).collect(Collectors.toList());
        List<String> contactIds = list.stream().map(ContactRelationDto::getContactId).collect(Collectors.toList());
        Map<String, String> weworkUserNameMap = this.weworkUserService.getWeworkUserNameMap(corpId, weworkUserIds);
        Map<String, List<String>> remarkMobileMap = this.contactMobileService.getRemarkMobile(bizId, corpId, weworkUserIds, contactIds);
        Map<String, List<WeworkTagDto>> weworkTagMap = this.contactTagService.getWeworkTagMap(corpId, weworkUserIds, contactIds);
        List weworkContactList = this.weworkContactMapper.queryWeworkContactList(corpId, contactIds);
        Map weworkContactMap = weworkContactList.stream().collect(Collectors.toMap(WeworkContact::getContactId, Function.identity()));
        List contactLogs = this.weworkContactLogMapper.queryListByContactIds(corpId, contactIds);
        Map<String, List<WeworkContactLog>> contactLogMap = contactLogs.stream().collect(Collectors.groupingBy(WeworkContactLog::getContactId));
        Map planIdMap = null;
        if (CollectionUtils.isNotEmpty((Collection)contactLogs)) {
            Set planIds = contactLogs.stream().map(WeworkContactLog::getPlanId).collect(Collectors.toSet());
            log.info("queryDelExternalCount planIds:{}", planIds);
            if (CollectionUtils.isNotEmpty(planIds)) {
                List planList = this.marketingPlanMapper.queryByIds(corpId, planIds);
                planIdMap = planList.stream().collect(Collectors.toMap(MarketingPlan::getId, Function.identity()));
            }
        }
        log.info("queryDelExternalCount planIdMap:{}", planIdMap);
        ArrayList result = Lists.newArrayList();
        for (ContactRelationDto contactRelationDto : list) {
            WeworkContactStage stageInfo;
            ChannelInfo channelInfo;
            List<WeworkContactLog> contactLogList;
            List memberContactLogList;
            ExportContactDto exportContactDto = new ExportContactDto();
            String weworkUserId = contactRelationDto.getWeworkUserId();
            String weworkUserNum = this.weworkUserService.getWeworkUserNumById(corpId, weworkUserId);
            WeworkContact weworkContact = (WeworkContact)weworkContactMap.get(contactRelationDto.getContactId());
            if (weworkContact != null) {
                exportContactDto.setNickname(weworkContact.getName());
                exportContactDto.setUnionId(weworkContact.getUnionid());
            }
            exportContactDto.setAddTime(contactRelationDto.getAddTime());
            String addWayDesc = AddWayType.UNKNOWN.getDesc();
            if (AddWayType.getType((Integer)contactRelationDto.getAddWay()) != null) {
                addWayDesc = AddWayType.getType((Integer)contactRelationDto.getAddWay()).getDesc();
            }
            exportContactDto.setAddWayDesc(addWayDesc);
            if (contactLogMap.containsKey(contactRelationDto.getContactId()) && CollectionUtils.isNotEmpty(memberContactLogList = (contactLogList = contactLogMap.get(contactRelationDto.getContactId())).stream().filter(a -> a.getWeworkUserNum().equals(weworkUserNum)).collect(Collectors.toList()))) {
                MarketingPlan plan;
                WeworkContactLog contactLog = (WeworkContactLog)memberContactLogList.get(0);
                Long planId = contactLog.getPlanId();
                if (planIdMap != null && planId != null && (plan = (MarketingPlan)planIdMap.get(planId)) != null) {
                    exportContactDto.setPlanName(plan.getName());
                    exportContactDto.setPlanTypeDesc(PlanType.get((int)plan.getType()).getDesc());
                }
            }
            exportContactDto.setWeworkUserNickname(weworkUserNameMap.get(weworkUserId));
            exportContactDto.setRemarkName(contactRelationDto.getRemark());
            List customerMobiles = this.ccCustomerNumService.getMobilesByContactId(bizId, contactRelationDto.getContactId());
            exportContactDto.setCustomerMobiles(customerMobiles);
            String key = contactRelationDto.getWeworkUserId() + contactRelationDto.getContactId();
            List<String> mobiles = remarkMobileMap.get(key);
            exportContactDto.setRemarkMobiles(mobiles);
            if (CollectionUtils.isNotEmpty((Collection)weworkTagMap.get(key))) {
                List<String> tagList = weworkTagMap.get(key).stream().map(WeworkTagDto::getName).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                exportContactDto.setWeworkTags(tagList);
            }
            if ((channelInfo = this.weworkContactLogMapper.queryChannelInfo(corpId, weworkUserNum, contactRelationDto.getContactId())) != null) {
                exportContactDto.setChannelName(channelInfo.getChannelName());
            }
            if ((stageInfo = this.weworkContactStageMapper.queryContactStage(corpId, contactRelationDto.getContactId(), weworkUserNum)) != null) {
                CustomerStage customerStage = null;
                if (stageInfo.getStatus() == 1 || stageInfo.getStatus() == 0) {
                    customerStage = this.customerStageMapper.queryStageByPrimaryKey(stageInfo.getStageId());
                } else if (stageInfo.getStatus() == 2) {
                    customerStage = this.customerStageMapper.queryStageByPrimaryKey(stageInfo.getFinalStageId());
                }
                if (customerStage != null) {
                    if (stageInfo.getStatus() == 1 || stageInfo.getStatus() == 0) {
                        exportContactDto.setStageValue(customerStage.getStageValue());
                    } else if (stageInfo.getStatus() == 2) {
                        exportContactDto.setStageValue(customerStage.getStageName());
                    }
                }
            }
            List followRecordInfos = this.followRecordMapper.queryFollowRecordList(corpId, weworkUserNum, contactRelationDto.getContactId());
            Date lastFollowTime = null;
            if (CollectionUtils.isNotEmpty((Collection)followRecordInfos)) {
                lastFollowTime = ((FollowRecordInfo)followRecordInfos.get(0)).getFollowTime();
            }
            exportContactDto.setLastFollowTime(lastFollowTime);
            List<String> followRecords = followRecordInfos.stream().map(it -> DateUtil.dateToDateString((Date)it.getFollowTime(), (String)"MM-dd") + ": \r\n" + it.getRemark()).collect(Collectors.toList());
            exportContactDto.setFollowRecords(followRecords);
            if (contactRelationDto.getIsDeleted() == 0 && contactRelationDto.getIsZombieFans() == 0) {
                exportContactDto.setAddStatusDesc("\u6b63\u5e38");
            } else if (contactRelationDto.getIsDeleted() == 0 && contactRelationDto.getIsZombieFans() == 1) {
                exportContactDto.setAddStatusDesc("\u5220\u9664\u6210\u5458");
            } else if (contactRelationDto.getIsDeleted() == 1 && contactRelationDto.getIsZombieFans() == 0) {
                exportContactDto.setAddStatusDesc("\u88ab\u6210\u5458\u5220\u9664");
            } else if (contactRelationDto.getIsDeleted() == 1 && contactRelationDto.getIsZombieFans() == 1) {
                exportContactDto.setAddStatusDesc("\u4e92\u76f8\u5220\u9664");
            }
            result.add(exportContactDto);
        }
        return result;
    }
}

