/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.service.impl;

import com.alibaba.excel.write.handler.AbstractRowWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPayReportRowWriteHandler
extends AbstractRowWriteHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomPayReportRowWriteHandler.class);
    private final Map<String, Integer> skuNameRowMap;

    public CustomPayReportRowWriteHandler(Map<String, Integer> skuNameRowMap) {
        this.skuNameRowMap = skuNameRowMap;
    }

    public void afterRowDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Integer relativeRowIndex, Boolean isHead) {
        Sheet sheet = writeSheetHolder.getSheet();
        int rowIndex = row.getRowNum();
        if (rowIndex == 0) {
            return;
        }
        String skuName = CustomPayReportRowWriteHandler.getCellValue(row.getCell(0));
        String orderCount = CustomPayReportRowWriteHandler.getCellValue(row.getCell(2));
        String totalOrderAmount = CustomPayReportRowWriteHandler.getCellValue(row.getCell(3));
        if (skuName != null && !skuName.isEmpty()) {
            Integer spanSize = this.skuNameRowMap.get(skuName + orderCount + totalOrderAmount);
            if (spanSize == null) {
                return;
            }
            CellRangeAddress cellRangeAddress = new CellRangeAddress(rowIndex, rowIndex + spanSize, 0, 0);
            try {
                sheet.addMergedRegion(cellRangeAddress);
            }
            catch (Exception e) {
                log.error("Merge cells error", (Throwable)e);
            }
        }
    }

    private static String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                return String.valueOf(cell.getNumericCellValue());
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case FORMULA: {
                return cell.getCellFormula();
            }
            case BLANK: {
                return "";
            }
        }
        return "";
    }
}

