/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.service.impl;

import cn.kinyun.crm.common.service.CrmLeadsTagService;
import cn.kinyun.customer.center.dto.req.AttachAllTag;
import cn.kinyun.customer.center.service.CcCustomerTagService;
import cn.kinyun.wework.sdk.api.external.ExternalTagClient;
import cn.kinyun.wework.sdk.entity.external.contact.ExternalContactResp;
import cn.kinyun.wework.sdk.entity.external.contact.FollowUser;
import cn.kinyun.wework.sdk.entity.external.contact.Tag;
import cn.kinyun.wework.sdk.entity.external.croptag.MarkTagParams;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.dto.WeworkTagMsg;
import com.kuaike.scrm.common.dto.WeworkTagParam;
import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.service.ScrmTagService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.entity.WeworkContactTag;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import com.kuaike.scrm.wework.contact.service.ContactTagSyncService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

@Service
public class ContactTagSyncServiceImpl
implements ContactTagSyncService {
    private static final Logger log = LoggerFactory.getLogger(ContactTagSyncServiceImpl.class);
    @Autowired
    private SettingService settingService;
    @Autowired
    private CrmLeadsTagService crmLeadsTagService;
    @Autowired
    private WeworkContactTagMapper weworkContactTagMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Value(value="${kafka.topic.wework_tag_sync}")
    private String topic;
    @Autowired
    private ScrmTagService scrmTagService;
    @Autowired
    private WeworkTagMapper weworkTagMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private CcCustomerTagService ccCustomerTagService;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private ContactOpService contactOpService;
    @Autowired
    private IdGen idGen;
    private String SOURCE = "scrm";
    @Autowired
    private ExternalTagClient externalTagClient;
    private final int size = Runtime.getRuntime().availableProcessors();
    private ExecutorService executeService = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(500), (ThreadFactory)new NamedThreadFactory("contactTagSync"), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public void syncTag2Crm(Long bizId, String contactId, Collection<String> tagIds, String weworkUserId) {
        log.info("contactTagToCrm bizId: {}, contactId: {}, weworkUserId: {}", new Object[]{bizId, contactId, weworkUserId});
        String settingValue = this.settingService.getSettingDetail(bizId, SettingEnum.TAG_SYNC.getName());
        if (StringUtils.isEmpty((CharSequence)settingValue) || settingValue.equals("0")) {
            log.info("contactTagToKafka \u4f01\u4e1a\u4e3a\u5f00\u901a\u6807\u7b7e\u540c\u6b65\uff0c bizId: {}", (Object)bizId);
            return;
        }
        List deletedTagIds = this.weworkTagMapper.queryDeletedTagIds(bizId);
        if (CollectionUtils.isNotEmpty((Collection)deletedTagIds)) {
            tagIds.removeAll(deletedTagIds);
        }
        String corpId = this.businessCustomerMapper.getCorpIdById(bizId);
        WeworkTagMsg msg = new WeworkTagMsg();
        msg.setBizId(bizId);
        msg.setCorpId(corpId);
        msg.setContactId(contactId);
        msg.setTagIds(new HashSet<String>(tagIds));
        msg.setWeworkUserId(weworkUserId);
        if (StringUtils.isNotEmpty((CharSequence)weworkUserId)) {
            Long userId = this.userMapper.getUserIdByWeworkUserId(bizId, weworkUserId);
            msg.setUserId(userId);
        }
        log.info("syncTag2Crm msg: {}", (Object)msg);
        this.scrmTagService.contactTagSync(msg);
        this.crmLeadsTagService.updateTagsFromScrm(msg);
    }

    @Override
    public void contactTagToKafka(Long bizId, String contactId, Collection<String> tagIds) {
        log.info("contactTagToKafka bizId: {}, contactId: {}, tagIds: {}", new Object[]{bizId, contactId, tagIds});
        if (StringUtils.isEmpty((CharSequence)contactId)) {
            return;
        }
        String settingValue = this.settingService.getSettingDetail(bizId, SettingEnum.TAG_SYNC.getName());
        if (StringUtils.isEmpty((CharSequence)settingValue) || settingValue.equals("0")) {
            log.info("contactTagToKafka \u4f01\u4e1a\u4e3a\u5f00\u901a\u6807\u7b7e\u540c\u6b65\uff0c bizId: {}", (Object)bizId);
            return;
        }
        String corpId = this.businessCustomerMapper.getCorpIdById(bizId);
        List relationList = this.weworkContactRelationMapper.queryListByContactIdIncloudZoomFans(corpId, contactId);
        List weworkUserIds = relationList.stream().map(WeworkContactRelation::getWeworkUserId).collect(Collectors.toList());
        Map weworkUserIdMap = this.userMapper.queryUserIdByWeworkUserId(bizId, weworkUserIds);
        HashSet<String> addTagIds = new HashSet<String>(tagIds);
        for (WeworkContactRelation relation : relationList) {
            if (addTagIds.contains(null)) {
                addTagIds.removeAll(Collections.singleton(null));
            }
            log.info("syncTag2Crm contactId: {}, addTagIds: {}", (Object)contactId, addTagIds);
            WeworkTagMsg msg = new WeworkTagMsg();
            msg.setBizId(bizId);
            msg.setCorpId(corpId);
            msg.setContactId(contactId);
            msg.setTagIds(addTagIds);
            msg.setWeworkUserId(relation.getWeworkUserId());
            Long userId = (Long)weworkUserIdMap.get(relation.getWeworkUserId());
            msg.setUserId(userId);
            String json = JSON.toJSONString((Object)msg);
            try {
                this.kafkaTemplate.send(this.topic, (Object)json);
                log.info("contactTagToKafka send kafka: {}", (Object)json);
            }
            catch (Exception e) {
                log.error("contactTagToKafka send kafka failed: {}\n", (Object)json, (Object)e);
            }
        }
    }

    @Override
    public void handleExternalCallBackTags(Long bizId, String corpId, List<String> addTagIds, List<String> rmTagIds, String contactId, ExternalContactResp result) {
        log.info("handleExternalCallBackTags bizId: {}, contactId: {}, addTagIds: {}, rmTagIds: {}", new Object[]{bizId, contactId, addTagIds, rmTagIds});
        if (CollectionUtils.isEmpty(addTagIds) && CollectionUtils.isEmpty(rmTagIds)) {
            return;
        }
        String settingValue = this.settingService.getSettingDetail(bizId, SettingEnum.TAG_SYNC.getName());
        if (StringUtils.isEmpty((CharSequence)settingValue) || settingValue.equals("0")) {
            log.info("handleExternalCallBackTags \u4f01\u4e1a\u672a\u5f00\u901a\u6807\u7b7e\u540c\u6b65\uff0c bizId: {}", (Object)bizId);
            return;
        }
        List contactTags = this.weworkContactTagMapper.queryByCorpIdAndContactIdsFilterWeworkUserIds(corpId, (List)Lists.newArrayList((Object[])new String[]{contactId}));
        Map userContactMaps = contactTags.stream().collect(Collectors.groupingBy(WeworkContactTag::getWeworkUserId, Collectors.mapping(WeworkContactTag::getTagId, Collectors.toSet())));
        HashSet allTagIds = Sets.newHashSet();
        ArrayList currWeworkUserIds = Lists.newArrayList();
        for (FollowUser fu : result.getFollowUserList()) {
            if (CollectionUtils.isEmpty((Collection)fu.getTags())) continue;
            Set<String> sTagIds = fu.getTags().stream().map(Tag::getTagId).collect(Collectors.toSet());
            allTagIds.addAll(this.distinctTagIds(sTagIds));
            String weworkUserId = fu.getUserId();
            currWeworkUserIds.add(weworkUserId);
        }
        if (CollectionUtils.isNotEmpty(rmTagIds)) {
            allTagIds.removeAll(rmTagIds);
        }
        log.info("query contact allTagIds: {}, externalUserId: {} ", (Object)allTagIds, (Object)contactId);
        List relationList = this.weworkContactRelationMapper.queryListByContactIdIncloudZoomFans(corpId, contactId);
        List weworkUserIds = relationList.stream().map(WeworkContactRelation::getWeworkUserId).collect(Collectors.toList());
        log.info("handleExternalCallBackTags get WeworkContactRelation weworkUserIds: {}, currWeworkUserIds: {}", weworkUserIds, (Object)currWeworkUserIds);
        ArrayList addTags = Lists.newArrayList();
        HashSet rmIds = Sets.newHashSet();
        HashMap userAddTagIdMap = Maps.newHashMap();
        HashMap userRmTagIdMap = Maps.newHashMap();
        for (String weworkUserId : weworkUserIds) {
            Set dbTagIds = userContactMaps.get(weworkUserId);
            if (CollectionUtils.isNotEmpty((Collection)allTagIds)) {
                ArrayList weworkUserAddTagIds = Lists.newArrayList();
                for (String addTagId : allTagIds) {
                    if (dbTagIds != null && dbTagIds.contains(addTagId)) continue;
                    WeworkContactTag cTag = this.buildContactTag(bizId, corpId, contactId, weworkUserId, addTagId);
                    addTags.add(cTag);
                    weworkUserAddTagIds.add(addTagId);
                }
                userAddTagIdMap.put(weworkUserId, weworkUserAddTagIds);
            }
            if (!CollectionUtils.isNotEmpty(dbTagIds)) continue;
            ArrayList weworkUserRmTagIds = Lists.newArrayList();
            for (String rmTagId : dbTagIds) {
                if (allTagIds.contains(rmTagId)) continue;
                List rmTags = contactTags.stream().filter(a -> a.getContactId().equals(contactId) && a.getWeworkUserId().equals(weworkUserId) && a.getTagId().equals(rmTagId)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(rmTags)) {
                    List ids = rmTags.stream().map(WeworkContactTag::getId).collect(Collectors.toList());
                    rmIds.addAll(ids);
                }
                weworkUserRmTagIds.add(rmTagId);
            }
            userRmTagIdMap.put(weworkUserId, weworkUserRmTagIds);
        }
        log.info("handleExternalCallBackTags addTagSie: {}, rmTagIds: {}", (Object)addTags.size(), (Object)rmIds);
        if (CollectionUtils.isNotEmpty((Collection)addTags)) {
            this.weworkContactTagMapper.batchInsert((List)addTags);
        }
        if (CollectionUtils.isNotEmpty((Collection)rmIds)) {
            this.weworkContactTagMapper.logicDeleteByIds((Collection)rmIds, Long.valueOf(-1L));
        }
        WeworkContact contact = this.weworkContactMapper.queryContactByContactId(corpId, contactId);
        String customerNum = contact.getCustomerNum();
        log.info("handleExternalCallBackTags get contact: {}, customerNum: {}", (Object)contactId, (Object)customerNum);
        Map weworkUserNumMap = this.weworkUserMapper.queryUserNumIdMap(corpId, weworkUserIds);
        for (String weworkUserId : weworkUserIds) {
            this.contactOpService.updateTagCount(corpId, weworkUserId, contactId);
            try {
                WeworkTagMsg msg = new WeworkTagMsg();
                msg.setBizId(bizId);
                msg.setCorpId(corpId);
                msg.setContactId(contactId);
                msg.setTagIds((Set)allTagIds);
                msg.setWeworkUserId(weworkUserId);
                if (StringUtils.isNotEmpty((CharSequence)weworkUserId)) {
                    Long userId = this.userMapper.getUserIdByWeworkUserId(bizId, weworkUserId);
                    msg.setUserId(userId);
                }
                log.info("handleExternalCallBackTags syncTag2Crm msg: {}", (Object)msg);
                this.crmLeadsTagService.updateTagsFromScrm(msg);
            }
            catch (Exception e) {
                log.error("handleExternalCallBackTags syncTag2Crm error: ", (Throwable)e);
            }
            List markRmTagIds = userRmTagIdMap.getOrDefault(weworkUserId, Lists.newArrayList());
            try {
                AttachAllTag tagReq = new AttachAllTag();
                tagReq.setBizId(bizId);
                String weworkUserNum = (String)weworkUserNumMap.get(weworkUserId);
                tagReq.setWeworkUserNum(weworkUserNum);
                tagReq.setCustomerNum(customerNum);
                tagReq.setSource(this.SOURCE);
                tagReq.setAllTagIds(new ArrayList(allTagIds));
                this.ccCustomerTagService.updateAllTag(tagReq);
                log.info("handleExternalCallBackTags update customerCenter tagReq: {}", (Object)tagReq);
            }
            catch (Exception e) {
                log.error("handleExternalCallBackTags to customerCenter error: ", (Throwable)e);
            }
            WeworkTagParam param = new WeworkTagParam();
            param.setCorpId(corpId);
            param.setUserId(weworkUserId);
            param.setExternalUserId(contactId);
            param.setAddTagIds(new ArrayList(allTagIds));
            if (CollectionUtils.isNotEmpty((Collection)markRmTagIds)) {
                param.setRemoveTagIds(markRmTagIds);
            }
            String json = JSON.toJSONString((Object)param);
            try {
                this.kafkaTemplate.send(this.topic, (Object)json);
                log.info("handleExternalCallBackTags send kafka: {}", (Object)json);
            }
            catch (Exception e) {
                log.error("handleExternalCallBackTags send kafka failed: {}\n", (Object)json, (Object)e);
            }
        }
    }

    @Override
    public void consumerExternalCallBackTags(WeworkTagParam param) {
        String corpId = param.getCorpId();
        MarkTagParams tagParams = new MarkTagParams();
        tagParams.setUserId(param.getUserId());
        tagParams.setExternalUserId(param.getExternalUserId());
        tagParams.setAddTagIds(param.getAddTagIds());
        tagParams.setRemoveTagIds(param.getRemoveTagIds());
        log.info("consumerExternalCallBackTags mark Tag: {}, corpId: {}", (Object)tagParams, (Object)corpId);
        this.executeService.submit(this.buildTask(tagParams, corpId));
    }

    private Runnable buildTask(MarkTagParams markTagParams, String corpId) {
        return () -> {
            try {
                log.info("contactTagSync corpId: {}", (Object)corpId);
                this.externalTagClient.markTag(corpId, markTagParams);
            }
            catch (Exception e) {
                log.error("contactTagSync error", (Throwable)e);
            }
        };
    }

    private Set<String> distinctTagIds(Collection<String> tagIds) {
        HashSet<String> set = new HashSet<String>();
        if (CollectionUtils.isEmpty(tagIds)) {
            return set;
        }
        for (String tagId : tagIds) {
            if (!StringUtils.isNotBlank((CharSequence)tagId)) continue;
            set.add(tagId.trim());
        }
        return set;
    }

    private WeworkContactTag buildContactTag(Long bizId, String corpId, String contactId, String weworkUserID, String tagId) {
        WeworkContactTag cTag = new WeworkContactTag();
        cTag.setNum(this.idGen.getNum());
        cTag.setBizId(bizId);
        cTag.setCorpId(corpId);
        cTag.setContactId(contactId);
        cTag.setWeworkUserId(weworkUserID);
        cTag.setTagId(tagId);
        cTag.setType(Integer.valueOf(1));
        cTag.setCreateBy(Long.valueOf(-1L));
        cTag.setCreateTime(new Date());
        cTag.setUpdateBy(Long.valueOf(-1L));
        cTag.setUpdateTime(new Date());
        cTag.setIsDeleted(Integer.valueOf(0));
        return cTag;
    }
}

