/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.wework.entity.WeworkContactMobile;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMobileMapper;
import com.kuaike.scrm.wework.contact.service.ContactMobileService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContactMobileServiceImpl
implements ContactMobileService {
    private static final Logger log = LoggerFactory.getLogger(ContactMobileServiceImpl.class);
    @Resource
    private WeworkContactMobileMapper weworkContactMobileMapper;
    @Autowired
    private IdGen idGen;

    @Override
    public Map<String, List<String>> getRemarkMobile(Long bizId, String corpId, List<String> weworkUserIds, List<String> contactIds) {
        List weworkContactMobiles = this.weworkContactMobileMapper.queryRemarkMobileList(bizId, corpId, weworkUserIds, contactIds);
        HashMap remarkMobileMap = Maps.newHashMap();
        for (WeworkContactMobile contactMobile : weworkContactMobiles) {
            String key = contactMobile.getWeworkUserId() + contactMobile.getContactId();
            if (remarkMobileMap.containsKey(key)) {
                ((List)remarkMobileMap.get(key)).add(contactMobile.getRemarkMobile());
                continue;
            }
            ArrayList list = Lists.newArrayList((Object[])new String[]{contactMobile.getRemarkMobile()});
            remarkMobileMap.put(key, list);
        }
        return remarkMobileMap;
    }

    @Override
    public List<String> getRemarkMobile(String corpId, String weworkUserId, String contactId, Integer isDeleted) {
        Set weworkContactMobiles = this.weworkContactMobileMapper.queryRemarkMobiles(corpId, weworkUserId, contactId, isDeleted);
        if (CollectionUtils.isEmpty((Collection)weworkContactMobiles)) {
            return Lists.newArrayList();
        }
        return weworkContactMobiles.stream().collect(Collectors.toList());
    }

    @Override
    public void saveRemarkMobiles(Long bizId, String corpId, Long userId, String weworkUserId, String contactId, Set<String> remarkMobiles) {
        Set originMobiles = this.weworkContactMobileMapper.queryRemarkMobiles(corpId, weworkUserId, contactId, Integer.valueOf(0));
        Sets.SetView notChange = Sets.intersection(remarkMobiles, (Set)originMobiles);
        Sets.SetView addMobiles = Sets.difference(remarkMobiles, (Set)notChange);
        Sets.SetView delMobiles = Sets.difference((Set)originMobiles, (Set)notChange);
        Date curDate = new Date();
        ArrayList addContactMobiles = Lists.newArrayList();
        for (String mobile : addMobiles) {
            WeworkContactMobile contactMobile = new WeworkContactMobile();
            contactMobile.setNum(this.idGen.getNum());
            contactMobile.setBizId(bizId);
            contactMobile.setCorpId(corpId);
            contactMobile.setWeworkUserId(weworkUserId);
            contactMobile.setContactId(contactId);
            contactMobile.setRemarkMobile(mobile);
            contactMobile.setCreateBy(userId);
            contactMobile.setUpdateBy(userId);
            contactMobile.setCreateTime(curDate);
            contactMobile.setUpdateTime(curDate);
            addContactMobiles.add(contactMobile);
        }
        if (CollectionUtils.isNotEmpty((Collection)addContactMobiles)) {
            this.weworkContactMobileMapper.batchInsert((List)addContactMobiles);
        }
        if (CollectionUtils.isNotEmpty((Collection)delMobiles)) {
            this.weworkContactMobileMapper.delByMobiles(corpId, userId, weworkUserId, contactId, (Collection)delMobiles);
        }
    }
}

