/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.dto;

import com.kuaike.scrm.common.enums.CallTypeEnum;
import com.kuaike.scrm.common.enums.EnumDto;
import com.kuaike.scrm.common.enums.EnumService;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.call.entity.CallRecord;
import com.kuaike.scrm.wework.contact.service.impl.ApiTypeEnum;
import com.kuaike.scrm.wework.contact.service.impl.CanceledEnum;
import com.kuaike.scrm.wework.contact.service.impl.StatusEnum;
import com.kuaike.scrm.wework.contact.service.impl.TypeEnum;
import java.util.Date;

public class ContactCallRecordRespDto {
    private Long id;
    private String num;
    private String customerName;
    private String customerPhone;
    private EnumDto apiType;
    private String apiCallId;
    private Long userId;
    private String userName;
    private String userPhone;
    private String middlePhone;
    private Integer ringingDuration;
    private Integer callDuration;
    private EnumDto type;
    private EnumDto status;
    private String voiceUrl;
    private String orgName;
    private Date createTime;
    private boolean isCallMember;
    private boolean isOpenapi;
    private EnumDto canceled;
    private EnumDto userType;

    public static ContactCallRecordRespDto from(CallRecord callRecord, boolean mobileEncrypt) {
        String customerPhone = callRecord.getCustomerPhone();
        ContactCallRecordRespDto build = ContactCallRecordRespDto.builder().id(callRecord.getId()).num(callRecord.getNum()).customerName(callRecord.getCustomerName()).customerPhone(mobileEncrypt ? MobileUtils.encryptMobile((String)customerPhone) : customerPhone).apiType(EnumDto.from((EnumService)ApiTypeEnum.get(callRecord.getApiType()))).apiCallId(callRecord.getApiCallId()).userId(callRecord.getUserId()).userName(callRecord.getUserName()).userPhone(callRecord.getUserPhone()).middlePhone(callRecord.getMiddlePhone()).ringingDuration(callRecord.getRingingDuration()).callDuration(callRecord.getCallDuration()).type(EnumDto.from((EnumService)TypeEnum.get(callRecord.getType()))).status(EnumDto.from((EnumService)StatusEnum.get(callRecord.getStatus()))).canceled(EnumDto.from((EnumService)CanceledEnum.get(callRecord.getCanceled()))).isOpenapi(callRecord.getIsOpenapi() == 1).voiceUrl(callRecord.getVoiceUrl()).orgName(callRecord.getOrgName()).createTime(callRecord.getCreateTime()).userType(EnumDto.from((EnumService)CallTypeEnum.get((Integer)callRecord.getUserType()))).build();
        if (build.getUserType() != null && build.getUserType().getId() == CallTypeEnum.VOICE.getValue()) {
            build.setUserName("");
            build.setOrgName("");
        }
        return build;
    }

    public ContactCallRecordRespDto() {
    }

    ContactCallRecordRespDto(Long id, String num, String customerName, String customerPhone, EnumDto apiType, String apiCallId, Long userId, String userName, String userPhone, String middlePhone, Integer ringingDuration, Integer callDuration, EnumDto type, EnumDto status, String voiceUrl, String orgName, Date createTime, boolean isCallMember, boolean isOpenapi, EnumDto canceled, EnumDto userType) {
        this.id = id;
        this.num = num;
        this.customerName = customerName;
        this.customerPhone = customerPhone;
        this.apiType = apiType;
        this.apiCallId = apiCallId;
        this.userId = userId;
        this.userName = userName;
        this.userPhone = userPhone;
        this.middlePhone = middlePhone;
        this.ringingDuration = ringingDuration;
        this.callDuration = callDuration;
        this.type = type;
        this.status = status;
        this.voiceUrl = voiceUrl;
        this.orgName = orgName;
        this.createTime = createTime;
        this.isCallMember = isCallMember;
        this.isOpenapi = isOpenapi;
        this.canceled = canceled;
        this.userType = userType;
    }

    public static ContactCallRecordRespDtoBuilder builder() {
        return new ContactCallRecordRespDtoBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getNum() {
        return this.num;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public String getCustomerPhone() {
        return this.customerPhone;
    }

    public EnumDto getApiType() {
        return this.apiType;
    }

    public String getApiCallId() {
        return this.apiCallId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPhone() {
        return this.userPhone;
    }

    public String getMiddlePhone() {
        return this.middlePhone;
    }

    public Integer getRingingDuration() {
        return this.ringingDuration;
    }

    public Integer getCallDuration() {
        return this.callDuration;
    }

    public EnumDto getType() {
        return this.type;
    }

    public EnumDto getStatus() {
        return this.status;
    }

    public String getVoiceUrl() {
        return this.voiceUrl;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public boolean isCallMember() {
        return this.isCallMember;
    }

    public boolean isOpenapi() {
        return this.isOpenapi;
    }

    public EnumDto getCanceled() {
        return this.canceled;
    }

    public EnumDto getUserType() {
        return this.userType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public void setCustomerPhone(String customerPhone) {
        this.customerPhone = customerPhone;
    }

    public void setApiType(EnumDto apiType) {
        this.apiType = apiType;
    }

    public void setApiCallId(String apiCallId) {
        this.apiCallId = apiCallId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUserPhone(String userPhone) {
        this.userPhone = userPhone;
    }

    public void setMiddlePhone(String middlePhone) {
        this.middlePhone = middlePhone;
    }

    public void setRingingDuration(Integer ringingDuration) {
        this.ringingDuration = ringingDuration;
    }

    public void setCallDuration(Integer callDuration) {
        this.callDuration = callDuration;
    }

    public void setType(EnumDto type) {
        this.type = type;
    }

    public void setStatus(EnumDto status) {
        this.status = status;
    }

    public void setVoiceUrl(String voiceUrl) {
        this.voiceUrl = voiceUrl;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setCallMember(boolean isCallMember) {
        this.isCallMember = isCallMember;
    }

    public void setOpenapi(boolean isOpenapi) {
        this.isOpenapi = isOpenapi;
    }

    public void setCanceled(EnumDto canceled) {
        this.canceled = canceled;
    }

    public void setUserType(EnumDto userType) {
        this.userType = userType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContactCallRecordRespDto)) {
            return false;
        }
        ContactCallRecordRespDto other = (ContactCallRecordRespDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCallMember() != other.isCallMember()) {
            return false;
        }
        if (this.isOpenapi() != other.isOpenapi()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$ringingDuration = this.getRingingDuration();
        Integer other$ringingDuration = other.getRingingDuration();
        if (this$ringingDuration == null ? other$ringingDuration != null : !((Object)this$ringingDuration).equals(other$ringingDuration)) {
            return false;
        }
        Integer this$callDuration = this.getCallDuration();
        Integer other$callDuration = other.getCallDuration();
        if (this$callDuration == null ? other$callDuration != null : !((Object)this$callDuration).equals(other$callDuration)) {
            return false;
        }
        String this$num = this.getNum();
        String other$num = other.getNum();
        if (this$num == null ? other$num != null : !this$num.equals(other$num)) {
            return false;
        }
        String this$customerName = this.getCustomerName();
        String other$customerName = other.getCustomerName();
        if (this$customerName == null ? other$customerName != null : !this$customerName.equals(other$customerName)) {
            return false;
        }
        String this$customerPhone = this.getCustomerPhone();
        String other$customerPhone = other.getCustomerPhone();
        if (this$customerPhone == null ? other$customerPhone != null : !this$customerPhone.equals(other$customerPhone)) {
            return false;
        }
        EnumDto this$apiType = this.getApiType();
        EnumDto other$apiType = other.getApiType();
        if (this$apiType == null ? other$apiType != null : !this$apiType.equals(other$apiType)) {
            return false;
        }
        String this$apiCallId = this.getApiCallId();
        String other$apiCallId = other.getApiCallId();
        if (this$apiCallId == null ? other$apiCallId != null : !this$apiCallId.equals(other$apiCallId)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$userPhone = this.getUserPhone();
        String other$userPhone = other.getUserPhone();
        if (this$userPhone == null ? other$userPhone != null : !this$userPhone.equals(other$userPhone)) {
            return false;
        }
        String this$middlePhone = this.getMiddlePhone();
        String other$middlePhone = other.getMiddlePhone();
        if (this$middlePhone == null ? other$middlePhone != null : !this$middlePhone.equals(other$middlePhone)) {
            return false;
        }
        EnumDto this$type = this.getType();
        EnumDto other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        EnumDto this$status = this.getStatus();
        EnumDto other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$voiceUrl = this.getVoiceUrl();
        String other$voiceUrl = other.getVoiceUrl();
        if (this$voiceUrl == null ? other$voiceUrl != null : !this$voiceUrl.equals(other$voiceUrl)) {
            return false;
        }
        String this$orgName = this.getOrgName();
        String other$orgName = other.getOrgName();
        if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        EnumDto this$canceled = this.getCanceled();
        EnumDto other$canceled = other.getCanceled();
        if (this$canceled == null ? other$canceled != null : !this$canceled.equals(other$canceled)) {
            return false;
        }
        EnumDto this$userType = this.getUserType();
        EnumDto other$userType = other.getUserType();
        return !(this$userType == null ? other$userType != null : !this$userType.equals(other$userType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContactCallRecordRespDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCallMember() ? 79 : 97);
        result = result * 59 + (this.isOpenapi() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $ringingDuration = this.getRingingDuration();
        result = result * 59 + ($ringingDuration == null ? 43 : ((Object)$ringingDuration).hashCode());
        Integer $callDuration = this.getCallDuration();
        result = result * 59 + ($callDuration == null ? 43 : ((Object)$callDuration).hashCode());
        String $num = this.getNum();
        result = result * 59 + ($num == null ? 43 : $num.hashCode());
        String $customerName = this.getCustomerName();
        result = result * 59 + ($customerName == null ? 43 : $customerName.hashCode());
        String $customerPhone = this.getCustomerPhone();
        result = result * 59 + ($customerPhone == null ? 43 : $customerPhone.hashCode());
        EnumDto $apiType = this.getApiType();
        result = result * 59 + ($apiType == null ? 43 : $apiType.hashCode());
        String $apiCallId = this.getApiCallId();
        result = result * 59 + ($apiCallId == null ? 43 : $apiCallId.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $userPhone = this.getUserPhone();
        result = result * 59 + ($userPhone == null ? 43 : $userPhone.hashCode());
        String $middlePhone = this.getMiddlePhone();
        result = result * 59 + ($middlePhone == null ? 43 : $middlePhone.hashCode());
        EnumDto $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        EnumDto $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $voiceUrl = this.getVoiceUrl();
        result = result * 59 + ($voiceUrl == null ? 43 : $voiceUrl.hashCode());
        String $orgName = this.getOrgName();
        result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        EnumDto $canceled = this.getCanceled();
        result = result * 59 + ($canceled == null ? 43 : $canceled.hashCode());
        EnumDto $userType = this.getUserType();
        result = result * 59 + ($userType == null ? 43 : $userType.hashCode());
        return result;
    }

    public String toString() {
        return "ContactCallRecordRespDto(id=" + this.getId() + ", num=" + this.getNum() + ", customerName=" + this.getCustomerName() + ", customerPhone=" + this.getCustomerPhone() + ", apiType=" + this.getApiType() + ", apiCallId=" + this.getApiCallId() + ", userId=" + this.getUserId() + ", userName=" + this.getUserName() + ", userPhone=" + this.getUserPhone() + ", middlePhone=" + this.getMiddlePhone() + ", ringingDuration=" + this.getRingingDuration() + ", callDuration=" + this.getCallDuration() + ", type=" + this.getType() + ", status=" + this.getStatus() + ", voiceUrl=" + this.getVoiceUrl() + ", orgName=" + this.getOrgName() + ", createTime=" + this.getCreateTime() + ", isCallMember=" + this.isCallMember() + ", isOpenapi=" + this.isOpenapi() + ", canceled=" + this.getCanceled() + ", userType=" + this.getUserType() + ")";
    }

    public static class ContactCallRecordRespDtoBuilder {
        private Long id;
        private String num;
        private String customerName;
        private String customerPhone;
        private EnumDto apiType;
        private String apiCallId;
        private Long userId;
        private String userName;
        private String userPhone;
        private String middlePhone;
        private Integer ringingDuration;
        private Integer callDuration;
        private EnumDto type;
        private EnumDto status;
        private String voiceUrl;
        private String orgName;
        private Date createTime;
        private boolean isCallMember;
        private boolean isOpenapi;
        private EnumDto canceled;
        private EnumDto userType;

        ContactCallRecordRespDtoBuilder() {
        }

        public ContactCallRecordRespDtoBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public ContactCallRecordRespDtoBuilder num(String num) {
            this.num = num;
            return this;
        }

        public ContactCallRecordRespDtoBuilder customerName(String customerName) {
            this.customerName = customerName;
            return this;
        }

        public ContactCallRecordRespDtoBuilder customerPhone(String customerPhone) {
            this.customerPhone = customerPhone;
            return this;
        }

        public ContactCallRecordRespDtoBuilder apiType(EnumDto apiType) {
            this.apiType = apiType;
            return this;
        }

        public ContactCallRecordRespDtoBuilder apiCallId(String apiCallId) {
            this.apiCallId = apiCallId;
            return this;
        }

        public ContactCallRecordRespDtoBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public ContactCallRecordRespDtoBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public ContactCallRecordRespDtoBuilder userPhone(String userPhone) {
            this.userPhone = userPhone;
            return this;
        }

        public ContactCallRecordRespDtoBuilder middlePhone(String middlePhone) {
            this.middlePhone = middlePhone;
            return this;
        }

        public ContactCallRecordRespDtoBuilder ringingDuration(Integer ringingDuration) {
            this.ringingDuration = ringingDuration;
            return this;
        }

        public ContactCallRecordRespDtoBuilder callDuration(Integer callDuration) {
            this.callDuration = callDuration;
            return this;
        }

        public ContactCallRecordRespDtoBuilder type(EnumDto type) {
            this.type = type;
            return this;
        }

        public ContactCallRecordRespDtoBuilder status(EnumDto status) {
            this.status = status;
            return this;
        }

        public ContactCallRecordRespDtoBuilder voiceUrl(String voiceUrl) {
            this.voiceUrl = voiceUrl;
            return this;
        }

        public ContactCallRecordRespDtoBuilder orgName(String orgName) {
            this.orgName = orgName;
            return this;
        }

        public ContactCallRecordRespDtoBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public ContactCallRecordRespDtoBuilder isCallMember(boolean isCallMember) {
            this.isCallMember = isCallMember;
            return this;
        }

        public ContactCallRecordRespDtoBuilder isOpenapi(boolean isOpenapi) {
            this.isOpenapi = isOpenapi;
            return this;
        }

        public ContactCallRecordRespDtoBuilder canceled(EnumDto canceled) {
            this.canceled = canceled;
            return this;
        }

        public ContactCallRecordRespDtoBuilder userType(EnumDto userType) {
            this.userType = userType;
            return this;
        }

        public ContactCallRecordRespDto build() {
            return new ContactCallRecordRespDto(this.id, this.num, this.customerName, this.customerPhone, this.apiType, this.apiCallId, this.userId, this.userName, this.userPhone, this.middlePhone, this.ringingDuration, this.callDuration, this.type, this.status, this.voiceUrl, this.orgName, this.createTime, this.isCallMember, this.isOpenapi, this.canceled, this.userType);
        }

        public String toString() {
            return "ContactCallRecordRespDto.ContactCallRecordRespDtoBuilder(id=" + this.id + ", num=" + this.num + ", customerName=" + this.customerName + ", customerPhone=" + this.customerPhone + ", apiType=" + this.apiType + ", apiCallId=" + this.apiCallId + ", userId=" + this.userId + ", userName=" + this.userName + ", userPhone=" + this.userPhone + ", middlePhone=" + this.middlePhone + ", ringingDuration=" + this.ringingDuration + ", callDuration=" + this.callDuration + ", type=" + this.type + ", status=" + this.status + ", voiceUrl=" + this.voiceUrl + ", orgName=" + this.orgName + ", createTime=" + this.createTime + ", isCallMember=" + this.isCallMember + ", isOpenapi=" + this.isOpenapi + ", canceled=" + this.canceled + ", userType=" + this.userType + ")";
        }
    }
}

