/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.chatroom.dto.request;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.dal.wework.dto.RoomMemberQueryParams;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RoomMemberReqDto {
    private String weworkRoomId;
    private PageDto pageDto;

    private void validateBaseParams(CurrentUserInfo currentUserInfo) {
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u5546\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateListParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.weworkRoomId), (Object)"\u7fa4id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto), (Object)"\u5206\u9875\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public RoomMemberQueryParams convertToQueryCondition(Long bizId, String corpId, String weworkRoomId) {
        RoomMemberQueryParams params = new RoomMemberQueryParams();
        params.setOffset(Integer.valueOf((this.pageDto.getPageNum() - 1) * this.pageDto.getPageSize()));
        params.setLimit(this.pageDto.getPageSize());
        params.setBizId(bizId);
        params.setCorpId(corpId);
        params.setWeworkRoomId(weworkRoomId);
        return params;
    }

    public String getWeworkRoomId() {
        return this.weworkRoomId;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public void setWeworkRoomId(String weworkRoomId) {
        this.weworkRoomId = weworkRoomId;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoomMemberReqDto)) {
            return false;
        }
        RoomMemberReqDto other = (RoomMemberReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$weworkRoomId = this.getWeworkRoomId();
        String other$weworkRoomId = other.getWeworkRoomId();
        if (this$weworkRoomId == null ? other$weworkRoomId != null : !this$weworkRoomId.equals(other$weworkRoomId)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        return !(this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoomMemberReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $weworkRoomId = this.getWeworkRoomId();
        result = result * 59 + ($weworkRoomId == null ? 43 : $weworkRoomId.hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        return result;
    }

    public String toString() {
        return "RoomMemberReqDto(weworkRoomId=" + this.getWeworkRoomId() + ", pageDto=" + this.getPageDto() + ")";
    }
}

