/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.weworkuser.dto;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.WeworkRoleTypeEnum;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public class WeworkRoleReqDto {
    private List<String> weworkUserNums;
    private Integer weworkRoleType;
    private List<String> manageWeworkUserNums;

    public void validateParams() {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.weworkUserNums), (Object)"\u4f01\u5fae\u6210\u5458\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.weworkRoleType), (Object)"\u4f01\u5fae\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a");
        WeworkRoleTypeEnum weworkRole = WeworkRoleTypeEnum.get((int)this.weworkRoleType);
        Preconditions.checkArgument((boolean)Objects.nonNull(weworkRole), (Object)"\u4f01\u5fae\u89d2\u8272\u503c\u4e0d\u5408\u6cd5");
        if (WeworkRoleTypeEnum.PERSON_IN_CHARGE.getValue() == this.weworkRoleType.intValue()) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.manageWeworkUserNums), (Object)"\u7ba1\u7406\u7684\u6210\u5458\u552f\u4e00\u6807\u8bc6\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public List<String> getWeworkUserNums() {
        return this.weworkUserNums;
    }

    public Integer getWeworkRoleType() {
        return this.weworkRoleType;
    }

    public List<String> getManageWeworkUserNums() {
        return this.manageWeworkUserNums;
    }

    public void setWeworkUserNums(List<String> weworkUserNums) {
        this.weworkUserNums = weworkUserNums;
    }

    public void setWeworkRoleType(Integer weworkRoleType) {
        this.weworkRoleType = weworkRoleType;
    }

    public void setManageWeworkUserNums(List<String> manageWeworkUserNums) {
        this.manageWeworkUserNums = manageWeworkUserNums;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeworkRoleReqDto)) {
            return false;
        }
        WeworkRoleReqDto other = (WeworkRoleReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$weworkRoleType = this.getWeworkRoleType();
        Integer other$weworkRoleType = other.getWeworkRoleType();
        if (this$weworkRoleType == null ? other$weworkRoleType != null : !((Object)this$weworkRoleType).equals(other$weworkRoleType)) {
            return false;
        }
        List<String> this$weworkUserNums = this.getWeworkUserNums();
        List<String> other$weworkUserNums = other.getWeworkUserNums();
        if (this$weworkUserNums == null ? other$weworkUserNums != null : !((Object)this$weworkUserNums).equals(other$weworkUserNums)) {
            return false;
        }
        List<String> this$manageWeworkUserNums = this.getManageWeworkUserNums();
        List<String> other$manageWeworkUserNums = other.getManageWeworkUserNums();
        return !(this$manageWeworkUserNums == null ? other$manageWeworkUserNums != null : !((Object)this$manageWeworkUserNums).equals(other$manageWeworkUserNums));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WeworkRoleReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $weworkRoleType = this.getWeworkRoleType();
        result = result * 59 + ($weworkRoleType == null ? 43 : ((Object)$weworkRoleType).hashCode());
        List<String> $weworkUserNums = this.getWeworkUserNums();
        result = result * 59 + ($weworkUserNums == null ? 43 : ((Object)$weworkUserNums).hashCode());
        List<String> $manageWeworkUserNums = this.getManageWeworkUserNums();
        result = result * 59 + ($manageWeworkUserNums == null ? 43 : ((Object)$manageWeworkUserNums).hashCode());
        return result;
    }

    public String toString() {
        return "WeworkRoleReqDto(weworkUserNums=" + this.getWeworkUserNums() + ", weworkRoleType=" + this.getWeworkRoleType() + ", manageWeworkUserNums=" + this.getManageWeworkUserNums() + ")";
    }
}

