/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.weworkuser.dto;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.WeworkNotifyTypeEnums;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.wework.contact.dto.KeyName;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public class WeworkNotifyDto {
    private Long id;
    private Long bizId;
    private Integer notifyType;
    private String notifyTypeStr;
    private List<KeyName<String>> userInfo;
    private List<KeyName<String>> depInfo;
    private List<KeyName<Integer>> whichWeekdays;
    private List<String> whichTimes;
    private Integer notifySwitch;
    private Integer status;

    public void validateList() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.bizId), (Object)"\u5546\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateEdit() {
        this.validateList();
        Preconditions.checkArgument((boolean)Objects.nonNull(this.notifyType), (Object)"\u901a\u77e5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.id), (Object)"\u4f01\u4e1a\u901a\u77e5id\u672a\u77e5");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.getWhichTimes()), (Object)"\u901a\u77e5\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.getWhichWeekdays()), (Object)"\u901a\u77e5\u5de5\u4f5c\u65e5\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.notifyType.intValue() == WeworkNotifyTypeEnums.LEADS_BIND_NOTIFY.getValue() || this.notifyType.intValue() == WeworkNotifyTypeEnums.LEADS_UNBIND_NOTIFY.getValue()) {
            Preconditions.checkArgument((this.whichTimes.size() == 2 ? 1 : 0) != 0, (Object)"\u9700\u8981\u4e00\u4e2a\u65f6\u95f4\u6bb5");
            Date startTime = DateUtil.stringTimeToDate((String)this.whichTimes.get(0), (Date)new Date());
            Date endTime = DateUtil.stringTimeToDate((String)this.whichTimes.get(1), (Date)new Date());
            Preconditions.checkArgument((boolean)startTime.before(endTime), (Object)"\u5f00\u59cb\u65f6\u95f4\u9700\u65e9\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public void setNotifyType(Integer notifyType) {
        this.notifyType = notifyType;
    }

    public void setNotifyTypeStr(String notifyTypeStr) {
        this.notifyTypeStr = notifyTypeStr;
    }

    public void setUserInfo(List<KeyName<String>> userInfo) {
        this.userInfo = userInfo;
    }

    public void setDepInfo(List<KeyName<String>> depInfo) {
        this.depInfo = depInfo;
    }

    public void setWhichWeekdays(List<KeyName<Integer>> whichWeekdays) {
        this.whichWeekdays = whichWeekdays;
    }

    public void setWhichTimes(List<String> whichTimes) {
        this.whichTimes = whichTimes;
    }

    public void setNotifySwitch(Integer notifySwitch) {
        this.notifySwitch = notifySwitch;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getId() {
        return this.id;
    }

    public Long getBizId() {
        return this.bizId;
    }

    public Integer getNotifyType() {
        return this.notifyType;
    }

    public String getNotifyTypeStr() {
        return this.notifyTypeStr;
    }

    public List<KeyName<String>> getUserInfo() {
        return this.userInfo;
    }

    public List<KeyName<String>> getDepInfo() {
        return this.depInfo;
    }

    public List<KeyName<Integer>> getWhichWeekdays() {
        return this.whichWeekdays;
    }

    public List<String> getWhichTimes() {
        return this.whichTimes;
    }

    public Integer getNotifySwitch() {
        return this.notifySwitch;
    }

    public Integer getStatus() {
        return this.status;
    }
}

