/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.service.impl;

import cn.kinyun.crm.common.dto.StrIdAndNameDto;
import cn.kinyun.crm.common.service.CrmGlobalCustomerService;
import cn.kinyun.crm.common.service.dto.req.global.CrmFollowRecordDto;
import cn.kinyun.crm.common.service.dto.req.global.CrmGlobalCustomerReq;
import cn.kinyun.crm.common.service.dto.req.global.CrmGlobalCustomerResp;
import cn.kinyun.crm.common.service.dto.req.global.CrmGlobalSearchReq;
import cn.kinyun.crm.common.service.dto.req.global.CrmGlobalSearchResp;
import cn.kinyun.crm.common.service.dto.req.global.CrmGlobalSearchResultDto;
import cn.kinyun.crm.common.service.dto.req.global.CrmTHeadCelDto;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.enums.ExportTaskType;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.dal.exporttask.entity.ExportTask;
import com.kuaike.scrm.dal.exporttask.mapper.ExportTaskMapper;
import com.kuaike.scrm.wework.contact.service.impl.AbstractExportService;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="globalExport")
public class ExportGlobalServiceImpl
extends AbstractExportService {
    private static final Logger log = LoggerFactory.getLogger(ExportGlobalServiceImpl.class);
    @Resource
    private ExportTaskMapper exportTaskMapper;
    @Resource
    private CrmGlobalCustomerService crmGlobalCustomerService;
    private static final int LIMIT = 50000;
    private static final String DATE_FORMAT = "MM-dd";

    private String createExportFile(ExportTask task, String json) {
        String corpId = task.getCorpId();
        Long bizId = task.getBizId();
        Long userId = task.getCreateBy();
        this.createCorpDir(corpId);
        String filePath = this.createFilePath(corpId, ExportTaskType.GLOBAL, null);
        String sheetName = "\u5168\u5c40\u5ba2\u6237";
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(Integer.valueOf(1));
        pageDto.setPageSize(Integer.valueOf(50));
        ExcelWriter excelWriter = null;
        String url = null;
        try {
            excelWriter = EasyExcelFactory.write((String)filePath).build();
            WriteSheet writeSheet = EasyExcelFactory.writerSheet((String)sheetName).build();
            WriteTable writeTable = new WriteTable();
            ArrayList headList = new ArrayList();
            ArrayList<String> fields = new ArrayList<String>();
            CrmGlobalSearchReq crmGlobalSearchReq = (CrmGlobalSearchReq)JacksonUtil.str2Obj((String)json, CrmGlobalSearchReq.class);
            List<CrmTHeadCelDto> tHeadCelDtos = this.headInfo(bizId, userId, crmGlobalSearchReq.getProductLineId());
            tHeadCelDtos.forEach(crmTHeadCelDto -> {
                ArrayList<String> headTitle = new ArrayList<String>();
                headTitle.add(crmTHeadCelDto.getName());
                headList.add(headTitle);
                fields.add(crmTHeadCelDto.getFieldName());
            });
            writeTable.setHead(headList);
            CrmGlobalSearchResp crmGlobalSearchResp = this.customerListFromCrm(bizId, userId, crmGlobalSearchReq, pageDto);
            pageDto = crmGlobalSearchResp.getPageDto();
            if (pageDto.getCount() > 50000) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8d85\u8fc7\u6700\u5927\u6761\u657050000");
            }
            List searchResults = crmGlobalSearchResp.getCrmGlobalSearchResultDto();
            List<List<String>> lineList = this.lineList(searchResults, fields);
            excelWriter.write(lineList, writeSheet, writeTable);
            while (pageDto.getTotalPageNum() > pageDto.getPageNum()) {
                pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
                crmGlobalSearchResp = this.customerListFromCrm(bizId, userId, crmGlobalSearchReq, pageDto);
                pageDto = crmGlobalSearchResp.getPageDto();
                searchResults = crmGlobalSearchResp.getCrmGlobalSearchResultDto();
                lineList = this.lineList(searchResults, fields);
                searchResults = null;
                excelWriter.write(lineList, writeSheet, writeTable);
                lineList = null;
            }
            excelWriter.finish();
            File file = new File(filePath);
            if (file.exists()) {
                url = this.uploadOss(corpId, file);
            }
        }
        catch (BusinessException e) {
            log.error("createExportFile BusinessException error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
        catch (IOException e) {
            log.error("createExportFile IOException error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "json\u683c\u5f0f\u9519\u8bef");
        }
        catch (Exception e) {
            log.error("createExportFile error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            File file;
            if (excelWriter != null) {
                excelWriter.finish();
            }
            if ((file = new File(filePath)).exists()) {
                file.delete();
            }
        }
        return url;
    }

    private List<CrmTHeadCelDto> headInfo(Long bizId, Long userId, String productLineNum) {
        CrmGlobalCustomerReq crmGlobalCustomerReq = new CrmGlobalCustomerReq();
        crmGlobalCustomerReq.setBizId(bizId);
        crmGlobalCustomerReq.setUserId(userId);
        crmGlobalCustomerReq.setProductLineNum(productLineNum);
        CrmGlobalCustomerResp crmGlobalCustomerResp = this.crmGlobalCustomerService.tHead(crmGlobalCustomerReq);
        return crmGlobalCustomerResp.getTHeadCelDtos();
    }

    private CrmGlobalSearchResp customerListFromCrm(Long bizId, Long userId, CrmGlobalSearchReq crmGlobalSearchReq, PageDto pageDto) {
        crmGlobalSearchReq.setBizId(bizId);
        crmGlobalSearchReq.setPageDto(pageDto);
        crmGlobalSearchReq.setUserId(userId);
        return this.crmGlobalCustomerService.list(crmGlobalSearchReq);
    }

    private List<List<String>> lineList(List<CrmGlobalSearchResultDto> searchResults, List<String> fields) {
        log.info("lineList searchResults:{}", searchResults);
        ArrayList<List<String>> lineList = new ArrayList<List<String>>();
        searchResults.forEach(searchResult -> {
            ArrayList<String> line = new ArrayList<String>();
            Class<?> aClass = searchResult.getClass();
            for (int i = 0; i < fields.size(); ++i) {
                try {
                    Field declaredField = aClass.getDeclaredField((String)fields.get(i));
                    declaredField.setAccessible(true);
                    Object value = declaredField.get(searchResult);
                    if (value == null) {
                        line.add("");
                        continue;
                    }
                    if (value instanceof Integer) {
                        Integer integer = (Integer)value;
                        if ("isAssociateWework".equals(declaredField.getName()) || "isAssociateOfficial".equals(declaredField.getName()) || "isAssociateApplet".equals(declaredField.getName())) {
                            line.add(integer == 1 ? "\u662f" : "\u5426");
                            continue;
                        }
                        line.add(String.valueOf(integer));
                        continue;
                    }
                    if (value instanceof List) {
                        List list;
                        if ("latestFollowContent".equals(declaredField.getName()) || "trackList".equals(declaredField.getName())) {
                            list = (List)value;
                            StringBuilder stringBuffer = new StringBuilder();
                            for (CrmFollowRecordDto followRecordDto : list) {
                                Date followTime = followRecordDto.getFollowTime();
                                stringBuffer.append(followTime == null ? "" : DateUtil.dateToDateString((Date)followTime, (String)DATE_FORMAT));
                                stringBuffer.append(';');
                                String content = followRecordDto.getContent();
                                stringBuffer.append(content);
                                stringBuffer.append(',');
                            }
                            line.add(stringBuffer.toString());
                            continue;
                        }
                        if ("unionIds".equals(declaredField.getName())) {
                            List unionIds = (List)value;
                            if (CollectionUtils.isNotEmpty((Collection)unionIds)) {
                                line.add((String)unionIds.get(0));
                                continue;
                            }
                            line.add("");
                            continue;
                        }
                        if ("weworkUserList".equals(declaredField.getName())) {
                            list = (List)value;
                            if (CollectionUtils.isNotEmpty((Collection)list)) {
                                Set nameSet = list.stream().map(StrIdAndNameDto::getName).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
                                String userName = StringUtils.join(nameSet, (String)"/");
                                if (StringUtils.isNotBlank((CharSequence)userName)) {
                                    line.add(userName);
                                    continue;
                                }
                                line.add("");
                                continue;
                            }
                            line.add("");
                            continue;
                        }
                        list = (List)value;
                        if (CollectionUtils.isNotEmpty((Collection)list)) {
                            line.add(StringUtils.join((Iterable)list, (String)","));
                            continue;
                        }
                        line.add("");
                        continue;
                    }
                    if (value instanceof Date) {
                        Date date = (Date)value;
                        line.add(DateUtil.dateToDateString((Date)date));
                        continue;
                    }
                    if (value instanceof Long) {
                        Long amount = (Long)value;
                        line.add(String.valueOf((double)amount.longValue() / 10000.0));
                        continue;
                    }
                    line.add(String.valueOf(value));
                    continue;
                }
                catch (NoSuchFieldException e) {
                    log.error("NoSuchFieldException field:{}", fields.get(i));
                    line.add("");
                    continue;
                }
                catch (IllegalAccessException e) {
                    log.error("IllegalAccessException ", (Throwable)e);
                    line.add("");
                }
            }
            lineList.add(line);
        });
        return lineList;
    }

    @Override
    public Runnable buildTask(ExportTask task, String json) {
        return () -> {
            if (task == null) {
                log.info("build task is null");
            }
            try {
                log.info("run task num: {},json:{}", (Object)task.getNum(), (Object)json);
                String filePath = this.createExportFile(task, json);
                task.setFilePath(filePath);
            }
            catch (BusinessException e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg(e.getMessage());
            }
            catch (Exception e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
            }
            finally {
                task.setStatus(Integer.valueOf(2));
                task.setUpdateTime(new Date());
                this.exportTaskMapper.updateByPrimaryKeySelective((Object)task);
            }
        };
    }
}

