/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.service.impl;

import cn.kinyun.crm.common.service.dto.ModBaseInfoDto;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.scrm.common.dto.CommonKafkaMsg;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.enums.AddWayType;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.contactanalyse.dto.ChannelInfo;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkContactLogMapper;
import com.kuaike.scrm.dal.wework.dto.ContactDto;
import com.kuaike.scrm.dal.wework.dto.WeworkRoomDto;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMobileMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.wework.contact.dto.ContactListRespDto;
import com.kuaike.scrm.wework.contact.dto.ContactReqDto;
import com.kuaike.scrm.wework.contact.dto.ModifyRemarkDto;
import com.kuaike.scrm.wework.contact.dto.RemarkMobileUseReq;
import com.kuaike.scrm.wework.contact.dto.UpdateContactRemarkReq;
import com.kuaike.scrm.wework.contact.dto.WeworkUserDto;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import com.kuaike.scrm.wework.contact.service.ContactService;
import com.kuaike.scrm.wework.corp.service.WeworkCorpService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContactServiceImpl
implements ContactService {
    private static final Logger log = LoggerFactory.getLogger(ContactServiceImpl.class);
    @Autowired
    private WeworkChatRoomRelationMapper weworkChatRoomRelationMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private WeworkContactLogMapper weworkContactLogMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkUserService weworkUserService;
    @Autowired
    private WeworkContactMobileMapper weworkContactMobileMapper;
    @Autowired
    private ContactOpService contactOpService;
    @Autowired
    private WeworkCorpService weworkCorpService;
    @Autowired
    private CcCustomerInfoService ccCustomerInfoService;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Value(value="${kafka.topic.scrm_common_msg}")
    private String topic;
    @Autowired
    private ChannelMapper channelMapper;

    @Override
    public List<WeworkContact> selectContactList(Integer useAgent, Long bizId, String weworkUserId, List<String> contactIds) {
        if (CollectionUtils.isEmpty(contactIds)) {
            return Lists.newArrayList();
        }
        return this.weworkContactMapper.queryWeworkContactByUser(useAgent, bizId, weworkUserId, contactIds);
    }

    @Override
    public List<WeworkContact> queryByWeworkUserIdNameQuery(String corpId, Long bizId, String weworkUserId, String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return Lists.newArrayList();
        }
        return this.weworkContactMapper.queryByWeworkUserIdNameQuery(corpId, bizId, weworkUserId, query);
    }

    @Override
    public List<ContactListRespDto> contactList(ContactReqDto req) {
        log.info("contactList req:{}", (Object)JSON.toJSONString((Object)req));
        req.validate();
        StopWatchDto timer = new StopWatchDto("contactListSearch", true, log);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        String corpId = currentUser.getCorpId();
        timer.start("queryCurManagerWeworkUser");
        Set<String> weworkUserIdList = this.weworkUserService.queryCurManagerWeworkUser();
        timer.stop();
        log.info("contactList \u7ba1\u7406\u6743\u9650\u4e0b\u7684\u6210\u5458\u4e3a\uff1a{}", weworkUserIdList);
        WeworkCorp weworkCorp = this.weworkCorpService.getByCorpId(corpId);
        boolean isAgent = false;
        String decryptCorpId = null;
        if (YnEnum.YES.getValue().equals(weworkCorp.getIsNewDkf())) {
            isAgent = true;
            decryptCorpId = this.weworkCorpService.getDecryptCorpId(corpId, YnEnum.YES.getValue(), bizId);
        }
        timer.start("contactListCount");
        Integer count = this.contactListCount(corpId, bizId, req.getQuery(), weworkUserIdList, isAgent, decryptCorpId);
        timer.stop();
        log.info("contactListCount={}", (Object)count);
        req.getPageDto().setCount(count);
        if (Objects.isNull(count) || count == 0) {
            timer.print();
            return Lists.newArrayList();
        }
        timer.start("contactList");
        List<WeworkContact> contactList = this.contactList(corpId, bizId, req.getQuery(), decryptCorpId, weworkUserIdList, isAgent, req.getPageDto());
        timer.stop();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)contactList.size());
        for (WeworkContact contact : contactList) {
            ContactListRespDto respDto = (ContactListRespDto)BeanUtil.convert((Object)contact, ContactListRespDto.class, (String[])new String[0]);
            respDto.setContactName(contact.getName());
            result.add(respDto);
        }
        timer.print();
        return result;
    }

    private List<WeworkContact> contactList(String corpId, Long bizId, String query, String decryptCorpId, Set<String> weworkUserIdList, boolean isAgent, PageDto pageDto) {
        log.info("contactList param:corpId{};bizId:{}; query:{}; decryptCorpId:{};weworkUserId:{};isAgent:{};pageDto:{};", new Object[]{corpId, bizId, decryptCorpId, query, JSON.toJSONString(weworkUserIdList), isAgent, JSON.toJSONString((Object)pageDto)});
        if (isAgent) {
            return this.weworkContactMapper.agentContactList(corpId, decryptCorpId, bizId, query, weworkUserIdList, pageDto);
        }
        return this.weworkContactMapper.contactList(corpId, bizId, query, weworkUserIdList, pageDto);
    }

    private Integer contactListCount(String corpId, Long bizId, String query, Set<String> weworkUserIdList, boolean isAgent, String decryptCorpId) {
        if (isAgent) {
            return this.weworkContactMapper.agentContactListCount(corpId, decryptCorpId, bizId, query, weworkUserIdList);
        }
        return this.weworkContactMapper.contactListCount(corpId, bizId, query, weworkUserIdList);
    }

    @Override
    public List<WeworkRoomDto> queryContactAtRooms(String corpId, String contactId) {
        return this.weworkChatRoomRelationMapper.queryContactAtRooms(corpId, contactId);
    }

    @Override
    public List<WeworkUserDto> queryContactOwnerWeworkUser(String corpId, String contactId, String weworkUserId) {
        List list = this.weworkContactRelationMapper.queryContactOfWeworkUsers(corpId, contactId);
        ArrayList weworkUserIds = Lists.newArrayList();
        for (WeworkContactRelation contactRelation : list) {
            if (contactRelation.getIsDeleted() == 1 && !contactRelation.getWeworkUserId().equals(weworkUserId)) continue;
            weworkUserIds.add(contactRelation.getWeworkUserId());
        }
        List weworkUsers = this.weworkUserMapper.queryWeworkUserInfoList(corpId, (Collection)weworkUserIds);
        Map weworkUserMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getWeworkUserId, Function.identity()));
        ArrayList result = Lists.newArrayList();
        for (WeworkContactRelation contactRelation : list) {
            WeworkUser weworkUser;
            if (contactRelation.getIsDeleted() == 1 && !contactRelation.getWeworkUserId().equals(weworkUserId) || (weworkUser = (WeworkUser)weworkUserMap.get(contactRelation.getWeworkUserId())) == null) continue;
            WeworkUserDto weworkUserDto = new WeworkUserDto();
            weworkUserDto.setWeworkUserId(weworkUser.getNum());
            weworkUserDto.setAddTime(contactRelation.getAddTime());
            Integer addWay = contactRelation.getAddWay();
            String addWayDesc = AddWayType.UNKNOWN.getDesc();
            if (AddWayType.getType((Integer)addWay) != null) {
                addWayDesc = AddWayType.getType((Integer)addWay).getDesc();
            }
            weworkUserDto.setAddWayDesc(addWayDesc);
            weworkUserDto.setAvatar(weworkUser.getAvatar());
            weworkUserDto.setNickname(weworkUser.getName());
            ChannelInfo channelInfo = this.weworkContactLogMapper.queryChannelInfo(corpId, contactRelation.getWeworkUserId(), contactId);
            if (channelInfo != null) {
                weworkUserDto.setChannelName(channelInfo.getChannelName());
            }
            result.add(weworkUserDto);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateContactRemark(UpdateContactRemarkReq params) {
        log.info("updateContactRemark params: {}", (Object)params);
        if (params == null) {
            return;
        }
        params.checkParams();
        if (StringUtils.isBlank((CharSequence)params.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Long bizId = userInfo.getBizId();
        WeworkContactRelation exist = new WeworkContactRelation();
        exist.setCorpId(corpId);
        exist.setNum(params.getId());
        exist = (WeworkContactRelation)this.weworkContactRelationMapper.selectOne((Object)exist);
        if (exist == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "id\u53c2\u6570\u9519\u8bef");
        }
        if (exist.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6210\u5458\u5df2\u7ecf\u79bb\u804c\u6216\u8005\u6210\u5458\u548c\u5ba2\u6237\u7684\u597d\u53cb\u5173\u7cfb\u5df2\u89e3\u9664\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        try {
            ModifyRemarkDto modifyRemarkDto = new ModifyRemarkDto();
            modifyRemarkDto.setBizId(bizId);
            modifyRemarkDto.setCorpId(corpId);
            modifyRemarkDto.setWeworkUserId(exist.getWeworkUserId());
            modifyRemarkDto.setContactId(exist.getContactId());
            modifyRemarkDto.setRemark(params.getRemark());
            modifyRemarkDto.setDescription(params.getDescription());
            modifyRemarkDto.setRemarkMobiles(params.getRemarkMobiles());
            modifyRemarkDto.setRegion(params.getRegion());
            this.contactOpService.modifyRemark(modifyRemarkDto);
        }
        catch (WeworkException e) {
            if (e.getErrorCode() == 40003) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6210\u5458\u5df2\u7ecf\u79bb\u804c\u6216\u6210\u5458id\u9519\u8bef");
            }
            throw e;
        }
        WeworkContact contact = this.weworkContactMapper.queryContactByContactId(corpId, exist.getContactId());
        log.info("updateContactRemark contact : {}", (Object)contact);
        if (contact == null) {
            return;
        }
        CustomerDetailResp detailResp = this.ccCustomerInfoService.queryCustomerDetail(bizId, contact.getCustomerNum());
        log.info("updateContactRemark detailResp : {}", (Object)detailResp);
        if (detailResp == null) {
            return;
        }
        CommonKafkaMsg msg = new CommonKafkaMsg();
        msg.setSys("scrm");
        msg.setType("base_info_edit_callback");
        msg.setBizId(bizId);
        msg.setCorpId(corpId);
        msg.setKey(params.getId());
        Map channelMap = this.channelMapper.selectNameByNums(bizId, (Collection)Lists.newArrayList((Object[])new String[]{detailResp.getChannelId()}));
        ModBaseInfoDto modBaseInfoDto = ModBaseInfoDto.builder().contactId(detailResp.getContactId()).unionId(detailResp.getUnionId()).oldMobile1(detailResp.getMobile1()).oldMobile2(detailResp.getMobile2()).mobile1(detailResp.getMobile1()).mobile2(detailResp.getMobile2()).channel(channelMap.getOrDefault(detailResp.getChannelId(), "")).name(detailResp.getName()).gender(detailResp.getGender()).remarkName(params.getRemark()).updateTime(new Date()).build();
        msg.setData(JacksonUtil.obj2Str((Object)modBaseInfoDto));
        this.kafkaTemplate.send(this.topic, (Object)JacksonUtil.obj2Str((Object)msg));
    }

    @Override
    public ContactDto queryMobileUse(RemarkMobileUseReq params) {
        if (params == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)params.getContactId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)params.getMobile())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6821\u9a8c\u7684\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        return this.weworkContactMobileMapper.queryRemarkMobileUse(corpId, params.getContactId(), params.getMobile());
    }

    @Override
    public List<WeworkContact> queryContactByContactIds(String corpId, Collection<String> contactIds) {
        if (CollectionUtils.isEmpty(contactIds)) {
            return Lists.newArrayList();
        }
        return this.weworkContactMapper.queryWeworkContactList(corpId, contactIds);
    }
}

