/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.service.impl;

import cn.kinyun.customer.center.dto.req.ModMobileReq;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.wework.sdk.api.external.ExternalContactClient;
import cn.kinyun.wework.sdk.api.external.ExternalTagClient;
import cn.kinyun.wework.sdk.entity.external.contact.ExternalContactRemark;
import cn.kinyun.wework.sdk.entity.external.croptag.MarkTagParams;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.FollowRecordType;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMobileMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.entity.WeworkContactTag;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.follow.dto.CorpTagDto;
import com.kuaike.scrm.follow.dto.CustomerTagInfo;
import com.kuaike.scrm.follow.dto.FollowReqDto;
import com.kuaike.scrm.follow.service.FollowService;
import com.kuaike.scrm.wework.contact.dto.ModifyMobileReq;
import com.kuaike.scrm.wework.contact.dto.ModifyRemarkDto;
import com.kuaike.scrm.wework.contact.dto.ModifyTagDto;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import com.kuaike.scrm.wework.contact.service.ContactTagSyncService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContactOpServiceImpl
implements ContactOpService {
    private static final Logger log = LoggerFactory.getLogger(ContactOpServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private ExternalTagClient externalTagClient;
    @Autowired
    private ExternalContactClient externalContactClient;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Resource
    private WeworkContactMobileMapper weworkContactMobileMapper;
    @Autowired
    private WeworkTagMapper weworkTagMapper;
    @Autowired
    private WeworkContactTagMapper weworkContactTagMapper;
    @Autowired
    private FollowService followService;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private CustomerCenterService customerCenterService;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private CcCustomerInfoService ccCustomerInfoService;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private ContactTagSyncService contactTagSyncService;

    @Override
    public void modifyRemark(ModifyRemarkDto params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long operatorId = userInfo == null ? -1L : userInfo.getId();
        log.info("modify contact remark, params:{}, operatorId:{}, mod:{}", new Object[]{params, operatorId, params.getMod()});
        ExternalContactRemark req = new ExternalContactRemark();
        req.setUserId(params.getWeworkUserId());
        req.setExternalUserId(params.getContactId());
        if (StringUtils.isNotBlank((CharSequence)params.getRemark())) {
            req.setRemark(params.getRemark());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getDescription())) {
            req.setDescription(params.getDescription());
        }
        if (params.getRemarkMobiles() != null) {
            req.setRemarkMobiles(params.getRemarkMobiles());
        }
        try {
            this.externalContactClient.remark(params.getCorpId(), req);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5ba2\u6237\u5907\u6ce8\u4fe1\u606f\u5931\u8d25, {}, params:{}", (Object)e.getMessage(), (Object)params);
        }
        String corpId = params.getCorpId();
        String weworkUserId = params.getWeworkUserId();
        String contactId = params.getContactId();
        WeworkContactRelation exist = this.weworkContactRelationMapper.get(corpId, weworkUserId, contactId);
        if (params.getRegion() != null && !com.google.common.base.Objects.equal((Object)params.getRegion(), (Object)exist.getRegion())) {
            exist.setRegion(params.getRegion());
            exist.setUpdateBy(operatorId);
            exist.setUpdateTime(new Date());
            this.weworkContactRelationMapper.updateByPrimaryKey((Object)exist);
        }
        WeworkContact contact = this.weworkContactMapper.queryContactByContactId(corpId, contactId);
        if (CollectionUtils.isNotEmpty(params.getRemarkMobiles())) {
            CustomerDetailResp detailResp = this.ccCustomerInfoService.queryCustomerDetail(exist.getBizId(), contact.getCustomerNum());
            log.info("query customer detail mobile1 : {}, mobile2: {}", (Object)detailResp.getMobile1(), (Object)detailResp.getMobile2());
            if (StringUtils.isNotBlank((CharSequence)detailResp.getMobile1()) && StringUtils.isNotBlank((CharSequence)detailResp.getMobile2())) {
                log.info("query customer detail has two mobile, no need update");
                return;
            }
            String mobile1 = "";
            String mobile2 = "";
            if (StringUtils.isNotBlank((CharSequence)detailResp.getMobile1()) && StringUtils.isBlank((CharSequence)detailResp.getMobile2())) {
                String followMobile;
                mobile1 = detailResp.getMobile1();
                if (mobile1.equals(followMobile = params.getRemarkMobiles().get(0))) {
                    if (params.getRemarkMobiles().size() > 1) {
                        mobile2 = params.getRemarkMobiles().get(1);
                    }
                } else {
                    mobile2 = followMobile;
                }
            }
            if (StringUtils.isBlank((CharSequence)detailResp.getMobile1()) && StringUtils.isBlank((CharSequence)detailResp.getMobile2())) {
                mobile1 = params.getRemarkMobiles().get(0);
                if (params.getRemarkMobiles().size() > 1) {
                    mobile2 = params.getRemarkMobiles().get(1);
                }
            }
            this.modMobileToCustomer(exist.getBizId(), contact.getCustomerNum(), mobile1, mobile2, params);
        } else if (params.getMod().booleanValue()) {
            log.info("delete and unbind mobile, customerNum : {}", (Object)contact.getCustomerNum());
            this.modMobileToCustomer(exist.getBizId(), contact.getCustomerNum(), "", "", params);
        }
    }

    private void modMobileToCustomer(Long bizId, String customerNum, String mobile1, String mobile2, ModifyRemarkDto params) {
        log.info("modMobileToCustomer bizId:{}, customerNum: {}, mobile1: {}, mobile2: {}", new Object[]{bizId, customerNum, mobile1, mobile2});
        ModMobileReq req = new ModMobileReq();
        req.setBizId(bizId);
        if (StringUtils.isNotBlank((CharSequence)mobile1)) {
            req.setMobile1(mobile1);
        }
        if (StringUtils.isNotBlank((CharSequence)mobile2)) {
            req.setMobile2(mobile2);
        }
        req.setCustomerNum(customerNum);
        req.setModuleType(ModuleType.REMARK_MOBILE.getCode());
        req.setSource("scrm");
        if (params.getSyncToCustomer().booleanValue()) {
            req.setName(params.getRemark());
            req.setChannelId(params.getChannelNum());
            req.setDescription(params.getDescription());
        }
        if (Objects.nonNull(params.getDelOldMobile())) {
            req.setDelOldMobile(params.getDelOldMobile());
        }
        this.ccCustomerInfoService.modCustomerMobiles(req);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NESTED)
    public void modifyTag(ModifyTagDto params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long operatorId = userInfo == null ? -1L : userInfo.getId();
        log.info("modify contact tag, params:{}, operatorId:{}", (Object)params, (Object)operatorId);
        MarkTagParams req = new MarkTagParams();
        req.setUserId(params.getWeworkUserId());
        req.setExternalUserId(params.getContactId());
        req.setAddTagIds(params.getAddTagIds());
        req.setRemoveTagIds(params.getRemoveTagIds());
        CustomerTagInfo customerTagInfo = this.buildFollowTagInfo(params);
        try {
            this.externalTagClient.markTag(params.getCorpId(), req);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5ba2\u6237\u4f01\u4e1a\u6807\u7b7e\u5931\u8d25, {}, params:{}", (Object)e.getMessage(), (Object)params);
        }
        try {
            if (Objects.isNull(params.getTagNotLog()) || YnEnum.NO.getValue().equals(params.getTagNotLog())) {
                this.addFollowRecord(params, customerTagInfo, operatorId);
            } else {
                log.info("\u7cfb\u7edf\u6307\u5b9a\u4e0d\u6dfb\u52a0\u8ddf\u8fdb\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)params));
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u8ddf\u8fdb\u8f68\u8ff9\u5931\u8d25", (Throwable)e);
        }
        String weworkUserNum = this.weworkUserMapper.getNumByCorpIdAndWeworkUserId(params.getCorpId(), params.getWeworkUserId());
        WeworkContact contact = this.weworkContactMapper.queryWeworkContact(params.getBizId(), params.getCorpId(), params.getContactId());
        if (contact == null) {
            log.warn("\u6839\u636ebizId:{},contactId:{}\u672a\u67e5\u8be2\u5230contact", (Object)params.getBizId(), (Object)params.getContactId());
            return;
        }
        String customerNum = contact.getCustomerNum();
        if (StringUtils.isEmpty((CharSequence)customerNum)) {
            this.customerCenterService.pushContactCustomer(contact);
            customerNum = contact.getCustomerNum();
        }
        this.customerCenterService.pushTagRelation(params.getBizId(), weworkUserNum, customerNum, params.getAddTagIds(), params.getRemoveTagIds());
        List contactTags = this.weworkContactTagMapper.queryByCorpIdAndContactIdsFilterWeworkUserIds(params.getCorpId(), (List)Lists.newArrayList((Object[])new String[]{params.getContactId()}));
        Set existTagIds = contactTags.stream().map(WeworkContactTag::getTagId).collect(Collectors.toSet());
        HashSet allTagIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(params.getAddTagIds())) {
            allTagIds.addAll(params.getAddTagIds());
        }
        allTagIds.addAll(existTagIds);
        if (CollectionUtils.isNotEmpty(params.getRemoveTagIds())) {
            allTagIds.removeAll(params.getRemoveTagIds());
        }
        log.info("modify contact tag,  existTagIds: {}, addTag: {}, rmTag: {}, allTag: {}", new Object[]{existTagIds, params.getAddTagIds(), params.getRemoveTagIds(), allTagIds});
        this.contactTagSyncService.syncTag2Crm(params.getBizId(), params.getContactId(), allTagIds, params.getWeworkUserId());
    }

    @Override
    public void saveContactTag(ModifyTagDto params, Long operatorId) {
        Long bizId = params.getBizId();
        String corpId = params.getCorpId();
        String weworkUserId = params.getWeworkUserId();
        String contactId = params.getContactId();
        List<String> addTagIds = params.getAddTagIds();
        List<String> removeTagIds = params.getRemoveTagIds();
        List curTags = this.weworkContactTagMapper.queryWeworkTagIds(corpId, weworkUserId, contactId);
        ArrayList addTagList = Lists.newArrayList();
        for (String tagId : addTagIds) {
            if (curTags.contains(tagId)) continue;
            WeworkContactTag weworkContactTag = new WeworkContactTag();
            weworkContactTag.setNum(this.idGen.getNum());
            weworkContactTag.setBizId(bizId);
            weworkContactTag.setCorpId(corpId);
            weworkContactTag.setWeworkUserId(weworkUserId);
            weworkContactTag.setContactId(contactId);
            weworkContactTag.setTagId(tagId);
            weworkContactTag.setType(Integer.valueOf(1));
            weworkContactTag.setCreateBy(operatorId);
            weworkContactTag.setCreateTime(new Date());
            weworkContactTag.setUpdateBy(operatorId);
            weworkContactTag.setUpdateTime(new Date());
            addTagList.add(weworkContactTag);
        }
        if (CollectionUtils.isNotEmpty(removeTagIds)) {
            this.weworkContactTagMapper.delTags(corpId, weworkUserId, contactId, removeTagIds, operatorId);
        }
        if (CollectionUtils.isNotEmpty((Collection)addTagList)) {
            this.weworkContactTagMapper.batchInsert((List)addTagList);
        }
        this.updateTagCount(corpId, weworkUserId, contactId);
    }

    @Override
    public void updateTagCount(String corpId, String weworkUserId, String contactId) {
        List tagIds = this.weworkContactTagMapper.queryWeworkTagIds(corpId, weworkUserId, contactId);
        this.weworkContactRelationMapper.updateTagCount(corpId, weworkUserId, contactId, CollectionUtils.size((Object)tagIds));
        log.info("updateTagCount corpId={},weworkUserId={},contactId={},tagCount={}", new Object[]{corpId, weworkUserId, contactId, CollectionUtils.size((Object)tagIds)});
    }

    private void addFollowRecord(ModifyTagDto params, CustomerTagInfo info, Long operatorId) {
        if (info == null) {
            return;
        }
        String weworkUserNum = this.weworkUserMapper.queryWeworkUserNumById(params.getCorpId(), params.getWeworkUserId());
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            log.error("\u6839\u636ecorpId:{}, weworkUserId:{}\u672a\u83b7\u53d6\u5230weworkUserNum", (Object)params.getCorpId(), (Object)params.getWeworkUserId());
            return;
        }
        FollowReqDto follow = new FollowReqDto();
        follow.setBizId(params.getBizId());
        follow.setCorpId(params.getCorpId());
        follow.setOperatorId(operatorId);
        follow.setType(Integer.valueOf(FollowRecordType.EDIT_CONTACT_TAG.getValue()));
        follow.setWeworkUserNum(weworkUserNum);
        follow.setContactId(params.getContactId());
        follow.setCustomerTagInfo(info);
        this.followService.saveFollowRecord(follow);
    }

    private CustomerTagInfo buildFollowTagInfo(ModifyTagDto params) {
        CorpTagDto corpTagDto;
        String corpId = params.getCorpId();
        String weworkUserId = params.getWeworkUserId();
        String contactId = params.getContactId();
        List<String> addTagIds = params.getAddTagIds();
        List<String> removeTagIds = params.getRemoveTagIds();
        HashSet oldTagIds = Sets.newHashSet();
        HashSet newTagIds = Sets.newHashSet();
        Set tagIds = this.weworkContactTagMapper.selectTagIdsByParams(corpId, weworkUserId, contactId);
        if (CollectionUtils.isNotEmpty((Collection)tagIds)) {
            oldTagIds.addAll(tagIds);
            newTagIds.addAll(tagIds);
        }
        if (CollectionUtils.isNotEmpty(addTagIds)) {
            for (String tagId : addTagIds) {
                if (tagIds.contains(tagId)) continue;
                oldTagIds.remove(tagId);
            }
            newTagIds.addAll(addTagIds);
        }
        if (CollectionUtils.isNotEmpty(removeTagIds)) {
            oldTagIds.addAll(removeTagIds);
            removeTagIds.forEach(newTagIds::remove);
        }
        log.info("addFollowRecord,weworkUserId:{},contactId:{},tagIds:{},oldTagIds:{},newTagIds:{}", new Object[]{weworkUserId, contactId, tagIds, oldTagIds, newTagIds});
        if (CollectionUtils.isEmpty((Collection)oldTagIds) && CollectionUtils.isEmpty((Collection)newTagIds)) {
            log.info("weworkUserId:{},contactId:{}\u4fee\u6539\u524d\u540e\u7684\u6807\u7b7e\u90fd\u4e3a\u7a7a", (Object)weworkUserId, (Object)contactId);
            return null;
        }
        HashSet allTagIds = Sets.newHashSet();
        allTagIds.addAll(oldTagIds);
        allTagIds.addAll(newTagIds);
        Map tagId2NameMap = this.weworkTagMapper.selectTagIdAndNameByCorpIdAndTagIds(corpId, (Collection)allTagIds);
        if (MapUtils.isEmpty((Map)tagId2NameMap)) {
            log.warn("\u6839\u636ecorpId:{}, allTagIds:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)corpId, (Object)allTagIds);
            return null;
        }
        ArrayList oldCorpTagDtos = null;
        ArrayList newCorpTagDtos = null;
        if (CollectionUtils.isNotEmpty((Collection)oldTagIds)) {
            oldCorpTagDtos = Lists.newArrayList();
            for (String tagId : oldTagIds) {
                corpTagDto = new CorpTagDto();
                oldCorpTagDtos.add(corpTagDto);
                corpTagDto.setTagId(tagId);
                corpTagDto.setTagName((String)tagId2NameMap.get(tagId));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)newTagIds)) {
            newCorpTagDtos = Lists.newArrayList();
            for (String tagId : newTagIds) {
                corpTagDto = new CorpTagDto();
                newCorpTagDtos.add(corpTagDto);
                corpTagDto.setTagId(tagId);
                corpTagDto.setTagName((String)tagId2NameMap.get(tagId));
            }
        }
        CustomerTagInfo info = new CustomerTagInfo();
        info.setOldTags((List)oldCorpTagDtos);
        info.setNewTags((List)newCorpTagDtos);
        return info;
    }

    @Override
    public void repairTagCount() {
        log.info("repairTagCount start");
        List weworkCorps = this.weworkCorpMapper.selectAllAuthed();
        for (WeworkCorp weworkCorp : weworkCorps) {
            String corpId = weworkCorp.getCorpId();
            List weworkUsers = this.weworkUserMapper.queryByCorpId(weworkCorp.getCorpId());
            for (WeworkUser weworkUser : weworkUsers) {
                String weworkUserId = weworkUser.getWeworkUserId();
                Map key2Count = this.weworkContactTagMapper.queryByTagCount(corpId, weworkUserId);
                ArrayList list = Lists.newArrayList();
                key2Count.forEach((key, count) -> {
                    String[] arr = key.split("##");
                    WeworkContactRelation relation = new WeworkContactRelation();
                    relation.setCorpId(arr[0]);
                    relation.setWeworkUserId(arr[1]);
                    relation.setContactId(arr[2]);
                    relation.setTagCount(count);
                    list.add(relation);
                });
                if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                this.weworkContactRelationMapper.batchUpdateTagCount((List)list);
            }
            log.info("repair tagCount finish,corpId={}", (Object)corpId);
        }
        log.info("repairTagCount end");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modMobileByAllWeworkUserIds(ModifyMobileReq reqDto) {
        log.info("modify contact remark, reqDto:{}", (Object)reqDto);
        List relations = this.weworkContactRelationMapper.queryListByContactId(reqDto.getCorpId(), reqDto.getContactId());
        if (CollectionUtils.isEmpty((Collection)relations)) {
            log.info("modMobileByAllWeworkUserIds relations get is empty, contactId: {}, corpId: {}", (Object)reqDto.getContactId(), (Object)reqDto.getCorpId());
            return;
        }
        Collection addMobiles = CollectionUtils.subtract(reqDto.getNewMobiles(), reqDto.getExistMobiles());
        Collection delMobiles = CollectionUtils.subtract(reqDto.getExistMobiles(), reqDto.getNewMobiles());
        log.info("modMobileByAllWeworkUserIds addMobiles: {}, delMobiles: {}", (Object)addMobiles, (Object)delMobiles);
        for (WeworkContactRelation relation : relations) {
            Set existMobiles = this.weworkContactMobileMapper.selectContactMobilesByParams(reqDto.getCorpId(), relation.getWeworkUserId(), reqDto.getContactId());
            log.info("modMobileByAllWeworkUserIds get existMobile: {}, weworkUserId: {}, contactId: {}", new Object[]{existMobiles, relation.getWeworkUserId(), reqDto.getContactId()});
            List newMobiles = Lists.newArrayList();
            if (existMobiles != null) {
                existMobiles.remove("");
                newMobiles.addAll(existMobiles);
            }
            if (CollectionUtils.isNotEmpty((Collection)addMobiles)) {
                newMobiles.addAll(addMobiles);
            }
            if (CollectionUtils.isNotEmpty((Collection)delMobiles)) {
                for (String mo : delMobiles) {
                    newMobiles.remove(mo);
                }
            }
            if (newMobiles.size() > 5) {
                newMobiles = newMobiles.subList(0, 4);
            }
            log.info("modMobileByAllWeworkUserIds existMobile: {}, newMobiles: {}", (Object)existMobiles, (Object)newMobiles);
            ExternalContactRemark remark = new ExternalContactRemark();
            remark.setUserId(relation.getWeworkUserId());
            remark.setExternalUserId(reqDto.getContactId());
            remark.setRemarkMobiles(newMobiles);
            log.info("modMobileByAllWeworkUserIds externalContactClient req: {}, corpId: {}", (Object)remark, (Object)reqDto.getCorpId());
            try {
                this.externalContactClient.remark(reqDto.getCorpId(), remark);
            }
            catch (Exception e) {
                log.error("\u4fee\u6539\u5ba2\u6237\u5907\u6ce8\u4fe1\u606f\u5931\u8d25, {}, params:{}", (Object)e.getMessage(), (Object)remark);
            }
        }
    }
}

