/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.service.impl;

import cn.kinyun.crm.common.enums.SourceType;
import cn.kinyun.crm.common.service.CrmConfigService;
import cn.kinyun.crm.common.service.CrmCustomerService;
import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.CrmProductLineService;
import cn.kinyun.crm.common.service.dto.ModBaseInfoDto;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsReq;
import cn.kinyun.crm.common.service.dto.req.CrmModMobileReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;
import cn.kinyun.customer.center.dto.req.CustomerInfoPageReq;
import cn.kinyun.customer.center.dto.req.ModMobileReq;
import cn.kinyun.customer.center.dto.req.QueryBindStatusReq;
import cn.kinyun.customer.center.dto.req.event.EventListQueryParams;
import cn.kinyun.customer.center.dto.req.event.EventQueryParams;
import cn.kinyun.customer.center.dto.req.follow.CsStage;
import cn.kinyun.customer.center.dto.req.follow.FollowInfoDto;
import cn.kinyun.customer.center.dto.req.follow.FollowQueryParams;
import cn.kinyun.customer.center.dto.req.follow.JsonContentDto;
import cn.kinyun.customer.center.dto.req.follow.StageInfoDto;
import cn.kinyun.customer.center.dto.resp.CustomerBasicInfoLog;
import cn.kinyun.customer.center.dto.resp.CustomerBasicInfoLogResp;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.dto.resp.CustomerInheritLog;
import cn.kinyun.customer.center.dto.resp.CustomerInheritLogResp;
import cn.kinyun.customer.center.dto.resp.CustomerOrderInfoResp;
import cn.kinyun.customer.center.dto.resp.CustomerOrderResp;
import cn.kinyun.customer.center.dto.resp.CustomerReleaselog;
import cn.kinyun.customer.center.dto.resp.CustomerReleaselogResp;
import cn.kinyun.customer.center.dto.resp.CustomerStageInfoResp;
import cn.kinyun.customer.center.dto.resp.CustomerTagLog;
import cn.kinyun.customer.center.dto.resp.CustomerTagLogResp;
import cn.kinyun.customer.center.dto.resp.EventListResp;
import cn.kinyun.customer.center.dto.resp.EventResp;
import cn.kinyun.customer.center.dto.resp.FollowListResp;
import cn.kinyun.customer.center.dto.resp.FollowResp;
import cn.kinyun.customer.center.enums.CustomerFollowType;
import cn.kinyun.customer.center.enums.CustomerRouteType;
import cn.kinyun.customer.center.enums.EventType;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerEventService;
import cn.kinyun.customer.center.service.CcCustomerFollowRecordService;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.wework.sdk.api.external.ExternalContactClient;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CommonKafkaMsg;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.AddWayType;
import com.kuaike.scrm.common.enums.FollowRecordType;
import com.kuaike.scrm.common.enums.SysChannelEnum;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.AreaService;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.common.service.ExternalContactModService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmCallService;
import com.kuaike.scrm.common.service.ScrmSmsService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.dto.AppCallRespDto;
import com.kuaike.scrm.common.service.dto.AppSmsRespDto;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import com.kuaike.scrm.common.service.dto.resp.CallRecordDto;
import com.kuaike.scrm.common.service.dto.resp.SmsRecordDto;
import com.kuaike.scrm.common.service.dto.resp.UserSimpleInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.channel.entity.Channel;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.contactanalyse.dto.ChannelInfo;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkContactLogMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.wework.dto.ContactRelationDto;
import com.kuaike.scrm.dal.wework.dto.ContactRelationParams;
import com.kuaike.scrm.dal.wework.dto.WeworkRoomDto;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactMobile;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMobileMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.entity.WeworkContactTag;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.follow.dto.CustomerBaseInfo;
import com.kuaike.scrm.follow.dto.FollowReqDto;
import com.kuaike.scrm.follow.service.FollowService;
import com.kuaike.scrm.wework.contact.dto.ContactAssocaiteReqDto;
import com.kuaike.scrm.wework.contact.dto.ContactAssociateRespDto;
import com.kuaike.scrm.wework.contact.dto.CustomerAreaRespDto;
import com.kuaike.scrm.wework.contact.dto.CustomerBindInfoDto;
import com.kuaike.scrm.wework.contact.dto.CustomerDetailRespDto;
import com.kuaike.scrm.wework.contact.dto.CustomerRouteInfoReqDto;
import com.kuaike.scrm.wework.contact.dto.FollowListReqDto;
import com.kuaike.scrm.wework.contact.dto.FollowListRespDto;
import com.kuaike.scrm.wework.contact.dto.ModMobileReqDto;
import com.kuaike.scrm.wework.contact.dto.ModifyMobileReq;
import com.kuaike.scrm.wework.contact.dto.ModifyRemarkDto;
import com.kuaike.scrm.wework.contact.dto.RemarkContactInfoResp;
import com.kuaike.scrm.wework.contact.dto.RemarkContactReq;
import com.kuaike.scrm.wework.contact.dto.StageDto;
import com.kuaike.scrm.wework.contact.dto.WeworkAppRespDto;
import com.kuaike.scrm.wework.contact.dto.WeworkContactRespDto;
import com.kuaike.scrm.wework.contact.dto.WeworkUserDto;
import com.kuaike.scrm.wework.contact.service.ContactCenterService;
import com.kuaike.scrm.wework.contact.service.ContactService;
import com.kuaike.scrm.wework.contact.service.impl.ContactOpServiceImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ContactCenterServiceImpl
implements ContactCenterService {
    private static final Logger log = LoggerFactory.getLogger(ContactCenterServiceImpl.class);
    @Resource
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private CcCustomerInfoService ccCustomerInfoService;
    @Autowired
    private CrmLeadsService crmLeadsService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private ScrmSmsService scrmSmsService;
    @Autowired
    private ScrmCallService scrmCallService;
    @Autowired
    private ScrmBizService scrmBizService;
    @Resource
    private ScrmUserService scrmUserService;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkContactMobileMapper weworkContactMobileMapper;
    @Autowired
    private WeworkContactTagMapper contactTagMapper;
    @Autowired
    private WeworkTagMapper tagMapper;
    @Autowired
    private ContactService contactService;
    @Autowired
    private CustomerCenterService customerCenterService;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkContactLogMapper weworkContactLogMapper;
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private FollowService followService;
    @Autowired
    private ChannelMapper channelMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private WeworkContactTagMapper weworkContactTagMapper;
    @Autowired
    private AreaService areaService;
    @Autowired
    private ExternalContactClient externalContactClient;
    @Autowired
    private ExternalContactModService externalContactModService;
    @Autowired
    private CcCustomerFollowRecordService ccCustomerFollowRecordService;
    @Resource
    private CcCustomerEventService ccCustomerEventService;
    @Autowired
    private CrmConfigService crmConfigService;
    @Autowired
    private OfficialAccountMapper officialAccountMapper;
    @Autowired
    private AppletInfoMapper appletInfoMapper;
    @Autowired
    private CcCustomerDetailService ccCustomerDetailService;
    @Autowired
    private ContactOpServiceImpl contactOpService;
    @Resource
    private CcCustomerInfoService customerInfoService;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private CrmProductLineService productLineService;
    @Value(value="${kafka.topic.scrm_common_msg}")
    private String topic;
    @Autowired
    private NodeService nodeService;

    @Override
    public CustomerDetailRespDto queryCustomerDetail(String customerNum) {
        List currentUserRemark;
        Channel channel;
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        String corpId = currentUser.getCorpId();
        log.info("get customer detail, bizId:{}, customerNum:{}", (Object)bizId, (Object)customerNum);
        CustomerDetailResp resp = this.ccCustomerInfoService.queryCustomerDetail(bizId, customerNum);
        log.info("get customer detail resp: {}", (Object)resp);
        CustomerDetailRespDto respDto = new CustomerDetailRespDto();
        if (Objects.isNull(resp)) {
            return respDto;
        }
        BeanUtils.copyProperties((Object)resp, (Object)((Object)respDto));
        String channelNum = resp.getChannelId();
        String channelName = "";
        if (StringUtils.isNotBlank((CharSequence)channelNum) && (channel = this.channelMapper.selectByNum(channelNum, bizId, corpId)) != null) {
            channelName = channel.getName();
        }
        respDto.setChannelName(channelName);
        CustomerAreaRespDto dto = new CustomerAreaRespDto();
        if (StringUtils.isNotBlank((CharSequence)resp.getArea())) {
            String areaName = this.areaService.getFullName(resp.getArea());
            dto.setId(resp.getArea());
            dto.setName(areaName);
        }
        respDto.setAreaDto(dto);
        if (Objects.isNull(respDto.getIdType())) {
            return respDto;
        }
        ArrayList customers = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)respDto.getCustomerNum())) {
            customers.add(resp.getCustomerNum());
        }
        if (StringUtils.isNotBlank((CharSequence)respDto.getMainNum())) {
            customers.add(resp.getMainNum());
        }
        if (CollectionUtils.isEmpty((Collection)customers)) {
            return respDto;
        }
        ContactRelationParams params = new ContactRelationParams();
        params.setCustomerNums((List)customers);
        params.setBizId(bizId);
        params.setCorpId(corpId);
        params.setIsDeleted(YnEnum.NO.getValue());
        params.setNotQueryUserId(YnEnum.YES.getValue());
        List contactRelationDtos = this.weworkContactRelationMapper.queryContactRelationList(params);
        if (CollectionUtils.isEmpty((Collection)contactRelationDtos)) {
            return respDto;
        }
        if (StringUtils.isNotBlank((CharSequence)currentUser.getWeworkUserId()) && CollectionUtils.isNotEmpty(currentUserRemark = contactRelationDtos.stream().filter(item -> currentUser.getWeworkUserId().equals(item.getWeworkUserId())).collect(Collectors.toList()))) {
            respDto.setRemark(((ContactRelationDto)currentUserRemark.get(0)).getRemark());
            return respDto;
        }
        List relationDtos = contactRelationDtos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getRemark()) && !StringUtils.equals((CharSequence)item.getRemark(), (CharSequence)respDto.getName())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(relationDtos) && relationDtos.size() == 1) {
            respDto.setRemark(((ContactRelationDto)relationDtos.get(0)).getRemark());
            return respDto;
        }
        WeworkContact weworkContact = this.weworkContactMapper.queryWeworkContact(bizId, corpId, ((ContactRelationDto)contactRelationDtos.get(0)).getContactId());
        if (Objects.nonNull(weworkContact)) {
            respDto.setRemark(weworkContact.getName());
        }
        return respDto;
    }

    @Override
    public CustomerDetailRespDto queryCustomerDetailByContactId(String contactId) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        String customerNum = this.ccCustomerNumService.getCustomerNumByWeworkContactId(bizId, contactId, null);
        log.info("query customerNum :{} , bizId: {}, contactId: {}", new Object[]{customerNum, bizId, contactId});
        if (StringUtils.isBlank((CharSequence)customerNum)) {
            return null;
        }
        return this.queryCustomerDetail(customerNum);
    }

    @Override
    public void pushCustomerDetail(String customerNum) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        String corpId = currentUser.getCorpId();
        log.info("push customer detail, bizId:{}, customerNum:{}", (Object)bizId, (Object)customerNum);
        if (StringUtils.isNotBlank((CharSequence)customerNum)) {
            WeworkContact contact = this.weworkContactMapper.queryContact(corpId, customerNum);
            log.info("pushCustomerDetail contact: {}", (Object)contact);
            this.customerCenterService.pushContactDetail(contact);
        }
    }

    @Override
    public CustomerStageInfoResp queryCustomerStage(String customerNum) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        log.info("get customer stage, bizId:{}, customerNum:{}", (Object)bizId, (Object)customerNum);
        return this.ccCustomerInfoService.queryCustomerStage(bizId, customerNum);
    }

    @Override
    public CustomerOrderResp queryOrderInfo(CustomerInfoPageReq pageReq, String contactId) {
        WeworkContact contact;
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        String corpId = currentUser.getCorpId();
        if (StringUtils.isNotBlank((CharSequence)contactId) && Objects.nonNull(contact = this.weworkContactMapper.queryContactByContactId(corpId, contactId))) {
            pageReq.setCustomerNum(contact.getCustomerNum());
        }
        if (StringUtils.isEmpty((CharSequence)pageReq.getCustomerNum())) {
            log.info("queryOrderInfo get customerNum is null , contactId: {}", (Object)contactId);
            return null;
        }
        pageReq.setBizId(bizId);
        log.info("get customer order list, bizId:{}, customerNum:{}", (Object)bizId, (Object)pageReq.getCustomerNum());
        CustomerOrderResp orderResp = null;
        try {
            orderResp = this.ccCustomerInfoService.queryOrderInfo(pageReq);
        }
        catch (Exception e) {
            log.error("ccCustomerInfoService.queryOrderInfo: req: {}", (Object)JSON.toJSONString((Object)pageReq), (Object)e);
        }
        if (orderResp != null) {
            List orderInfoResps = orderResp.getOrderInfoResps();
            if (CollectionUtils.isNotEmpty((Collection)orderInfoResps)) {
                List createByIds = orderInfoResps.stream().map(CustomerOrderInfoResp::getCreateBy).collect(Collectors.toList());
                Map idNameMap = this.userMapper.selectUserIdAndNameByIds(bizId, corpId, createByIds);
                List userIds = orderInfoResps.stream().map(CustomerOrderInfoResp::getUserId).collect(Collectors.toList());
                Map userIdNameMap = this.userMapper.selectUserIdAndNameByIds(bizId, corpId, userIds);
                orderInfoResps.forEach(a -> {
                    if (idNameMap != null) {
                        String createName = (String)idNameMap.get(a.getCreateBy());
                        a.setCreateName(createName);
                    }
                    if (userIdNameMap != null) {
                        String userName = (String)userIdNameMap.get(a.getUserId());
                        a.setUserName(userName);
                    }
                });
            }
            orderResp.setOrderInfoResps(orderInfoResps);
        }
        return orderResp;
    }

    @Override
    public List<EventResp> queryCustomerRouteInfo(CustomerRouteInfoReqDto routeInfoReq) {
        log.info("queryCustomerRouteInfo routeInfoReq:{}", (Object)routeInfoReq);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        EventQueryParams params = new EventQueryParams();
        params.setBizId(bizId);
        params.setPageDto(routeInfoReq.getPageDto());
        params.setStartTime(routeInfoReq.getStartTime());
        params.setEndTime(routeInfoReq.getEndTime());
        params.setCustomerNum(routeInfoReq.getCustomerNum());
        if (CollectionUtils.isEmpty(routeInfoReq.getRouteTypes())) {
            List<Integer> allTypes = EnumUtils.getEnumList(CustomerRouteType.class).stream().map(CustomerRouteType::getValue).collect(Collectors.toList());
            routeInfoReq.setRouteTypes(allTypes);
        }
        List<EventListQueryParams> eventListQueryParams = this.buildEventListQueryParams(routeInfoReq.getRouteTypes());
        params.setTypeParams(eventListQueryParams);
        log.info("get customer route, bizId:{}, customerNum:{}, req:{}", new Object[]{bizId, routeInfoReq.getCustomerNum(), params});
        EventListResp eventListResp = this.ccCustomerEventService.list(params);
        if (Objects.nonNull(eventListResp)) {
            routeInfoReq.setPageDto(eventListResp.getPageDto());
            return eventListResp.getList();
        }
        return Collections.emptyList();
    }

    private List<EventListQueryParams> buildEventListQueryParams(List<Integer> routeTypes) {
        ArrayList<EventListQueryParams> eventParams = new ArrayList<EventListQueryParams>();
        for (Integer type : routeTypes) {
            CustomerRouteType customerRouteType = CustomerRouteType.getType((Integer)type);
            Preconditions.checkArgument((customerRouteType != null ? 1 : 0) != 0, (Object)"\u672a\u77e5\u7684\u52a8\u6001\u8f68\u8ff9\u7c7b\u578b");
            EventListQueryParams event = new EventListQueryParams();
            switch (customerRouteType) {
                case RADAR: {
                    event.setEventType(EventType.VISIT_PAGE.getCode());
                    event.setModuleTypes(Collections.singletonList(ModuleType.RADAR.getCode()));
                    break;
                }
                case PAY_ORDER: {
                    event.setEventType(EventType.PAY_ORDER.getCode());
                    event.setModuleTypes(Arrays.asList(ModuleType.TRADE.getCode(), ModuleType.SHOP.getCode(), ModuleType.BJY_WX.getCode(), ModuleType.API.getCode()));
                    EventListQueryParams payOtherEvent = new EventListQueryParams();
                    payOtherEvent.setEventType(EventType.PURCHASE_ORDER.getCode());
                    payOtherEvent.setModuleTypes(Arrays.asList(ModuleType.TRADE.getCode(), ModuleType.SHOP.getCode(), ModuleType.BJY_WX.getCode(), ModuleType.API.getCode()));
                    eventParams.add(payOtherEvent);
                    break;
                }
                case DYNAMIC_FORM: {
                    event.setEventType(EventType.VISIT_PAGE.getCode());
                    event.setModuleTypes(Collections.singletonList(ModuleType.DYNAMIC_FORM.getCode()));
                    break;
                }
                case REFRESH_LEADS: {
                    event.setEventType(EventType.ADD_CONTACT.getCode());
                    event.setModuleTypes(Arrays.asList(ModuleType.WEWORK_CONTACT.getCode(), ModuleType.BATCH_ADD_FRIEND.getCode()));
                    EventListQueryParams otherEvent = new EventListQueryParams();
                    otherEvent.setEventType(EventType.ADD_MOBILE.getCode());
                    otherEvent.setModuleTypes((List)Lists.newArrayList((Object[])new String[]{ModuleType.API.getCode()}));
                    eventParams.add(otherEvent);
                    break;
                }
                case DATA_RELATION: {
                    event.setEventType(EventType.BIND_RELATIONS.getCode());
                    event.setModuleTypes(Arrays.asList("0,1", "0,2", "0,3", "2,3", "2,1", "1,2"));
                    break;
                }
                case LIVE: {
                    event.setEventType(EventType.LIVE.getCode());
                    event.setModuleTypes(Collections.singletonList(ModuleType.LIVE.getCode()));
                    break;
                }
                case AD: {
                    event.setEventType(EventType.VISIT_PAGE.getCode());
                    event.setModuleTypes(Collections.singletonList(ModuleType.AD.getCode()));
                    break;
                }
                case MARKETING_PLAN: {
                    event.setEventType(EventType.VISIT_PAGE.getCode());
                    event.setModuleTypes(Collections.singletonList(ModuleType.MARKETING_PLAN.getCode()));
                    EventListQueryParams otherMarkingPlanEvent = new EventListQueryParams();
                    otherMarkingPlanEvent.setEventType(EventType.ADD_CONTACT.getCode());
                    otherMarkingPlanEvent.setModuleTypes(Collections.singletonList(ModuleType.MARKETING_PLAN.getCode()));
                    eventParams.add(otherMarkingPlanEvent);
                    break;
                }
                case MEETING_GOODS_CLICK: {
                    event.setEventType(EventType.VISIT_PAGE.getCode());
                    event.setModuleTypes(Collections.singletonList(ModuleType.MEETING_GOODS.getCode()));
                    break;
                }
            }
            eventParams.add(event);
        }
        return eventParams;
    }

    @Override
    public List<EventResp> queryCustomerRouteInfoByContactId(CustomerRouteInfoReqDto routeInfoReq, String contactId) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        String customerNum = this.ccCustomerNumService.getCustomerNumByWeworkContactId(bizId, contactId, null);
        log.info("queryCustomerRoute customerNum :{} , bizId: {}, contactId: {}", new Object[]{customerNum, bizId, contactId});
        if (StringUtils.isBlank((CharSequence)customerNum)) {
            return null;
        }
        routeInfoReq.setCustomerNum(customerNum);
        return this.queryCustomerRouteInfo(routeInfoReq);
    }

    @Override
    public List<CustomerBasicInfoLogResp> queryBasicLog(CustomerInfoPageReq pageReq) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        log.info("get customer basic log, bizId:{}, customerNum:{}", (Object)bizId, (Object)pageReq.getCustomerNum());
        pageReq.setBizId(bizId);
        CustomerBasicInfoLog infoLog = this.ccCustomerInfoService.queryBasicLog(pageReq);
        if (Objects.nonNull(infoLog)) {
            pageReq.setPageDto(infoLog.getPageDto());
            log.info("queryBasicLog pageDto: {}", (Object)pageReq.getPageDto());
            return infoLog.getInfoLogResps();
        }
        return null;
    }

    @Override
    public List<CustomerTagLogResp> queryTagLog(CustomerInfoPageReq pageReq) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        log.info("get customer tag list, bizId:{}, customerNum:{}", (Object)bizId, (Object)pageReq.getCustomerNum());
        pageReq.setBizId(bizId);
        CustomerTagLog tagLog = this.ccCustomerInfoService.queryTagLog(pageReq);
        if (Objects.nonNull(tagLog)) {
            pageReq.setPageDto(tagLog.getPageDto());
            log.info("queryTagLog pageDto: {}", (Object)pageReq.getPageDto());
            return tagLog.getRespList();
        }
        return null;
    }

    @Override
    public List<CustomerReleaselogResp> queryReleaseLog(CustomerInfoPageReq pageReq) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        log.info("get customer release log, bizId:{}, customerNum:{}", (Object)bizId, (Object)pageReq.getCustomerNum());
        pageReq.setBizId(bizId);
        CustomerReleaselog releaselog = this.ccCustomerInfoService.queryReleaseLog(pageReq);
        if (Objects.nonNull(releaselog)) {
            pageReq.setPageDto(releaselog.getPageDto());
            log.info("queryReleaseLog pageDto: {}", (Object)pageReq.getPageDto());
            return releaselog.getRespList();
        }
        return null;
    }

    @Override
    public List<CustomerInheritLogResp> queryInheritLog(CustomerInfoPageReq pageReq) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        log.info("get customer inherit log, bizId:{}, customerNum:{}", (Object)bizId, (Object)pageReq.getCustomerNum());
        pageReq.setBizId(bizId);
        CustomerInheritLog inheritLog = this.ccCustomerInfoService.queryInheritLog(pageReq);
        if (Objects.nonNull(inheritLog)) {
            pageReq.setPageDto(inheritLog.getPageDto());
            log.info("queryInheritLog pageDto: {}", (Object)pageReq.getPageDto());
            return inheritLog.getLogResps();
        }
        return null;
    }

    @Override
    public List<SmsRecordDto> smsList(CustomerInfoPageReq params) {
        log.info("get sms list, params={}, operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Long bizId = LoginUtils.getCurrentUserBizId();
        params.setBizId(bizId);
        String customerNum = params.getCustomerNum();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)customerNum), (Object)"customerNum is null!");
        CustomerDetailRespDto customerDetailResp = this.queryCustomerDetail(customerNum);
        ArrayList mobiles = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)customerDetailResp.getMobile1())) {
            mobiles.add(customerDetailResp.getMobile1());
        }
        if (StringUtils.isNotBlank((CharSequence)customerDetailResp.getMobile2())) {
            mobiles.add(customerDetailResp.getMobile2());
        }
        if (CollectionUtils.isEmpty((Collection)mobiles)) {
            return Collections.emptyList();
        }
        AppSmsRespDto resp = this.scrmSmsService.recordList((List)mobiles, params.getPageDto());
        if (resp == null) {
            return Collections.emptyList();
        }
        params.setPageDto(resp.getPageDto());
        return resp.getSmsRecordDtoList();
    }

    @Override
    public List<CallRecordDto> callList(CustomerInfoPageReq params) {
        log.info("get call list, params={}, operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Long bizId = LoginUtils.getCurrentUserBizId();
        params.setBizId(bizId);
        String customerNum = params.getCustomerNum();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)customerNum), (Object)"customerNum is null!");
        CustomerDetailRespDto customerDetailResp = this.queryCustomerDetail(customerNum);
        ArrayList mobiles = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)customerDetailResp.getMobile1())) {
            mobiles.add(customerDetailResp.getMobile1());
        }
        if (StringUtils.isNotBlank((CharSequence)customerDetailResp.getMobile2())) {
            mobiles.add(customerDetailResp.getMobile2());
        }
        if (CollectionUtils.isEmpty((Collection)mobiles)) {
            return Collections.emptyList();
        }
        AppCallRespDto resp = this.scrmCallService.recordList((List)mobiles, params.getPageDto());
        if (resp == null) {
            return Collections.emptyList();
        }
        params.setPageDto(resp.getPageDto());
        return resp.getCallRecordDtoList();
    }

    @Override
    public List<ContactAssociateRespDto> queryContactAssociate(ContactAssocaiteReqDto reqDto) {
        Long bizId;
        String corpId;
        log.info("queryContactAssociate reqDto: {}", (Object)reqDto);
        String customerNum = reqDto.getCustomerNum();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)customerNum), (Object)"\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        if (currentUser != null) {
            corpId = currentUser.getCorpId();
            bizId = currentUser.getBizId();
        } else {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getCorpId()), (Object)"corpId\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((reqDto.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
            corpId = reqDto.getCorpId();
            bizId = reqDto.getBizId();
        }
        ArrayList respDtoList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)customerNum)) {
            List appletInfos;
            List officialAccounts;
            boolean hasData = false;
            ContactAssociateRespDto associateRespDto = new ContactAssociateRespDto();
            List officialAppId = null;
            try {
                officialAppId = this.ccCustomerNumService.getOfficialAppId(bizId, customerNum);
            }
            catch (Exception e) {
                log.error(" ccCustomerNumService.getOfficialAppId \u5f02\u5e38\uff1aparam:{}", (Object)customerNum, (Object)e);
            }
            if (CollectionUtils.isNotEmpty((Collection)officialAppId) && CollectionUtils.isNotEmpty((Collection)(officialAccounts = this.officialAccountMapper.getByAppIds((Collection)officialAppId)))) {
                ArrayList officials = Lists.newArrayList();
                for (Object officialAccount : officialAccounts) {
                    WeworkAppRespDto appRespDto = new WeworkAppRespDto();
                    appRespDto.setAppId(officialAccount.getAppId());
                    appRespDto.setAppName(officialAccount.getNickName());
                    officials.add(appRespDto);
                }
                associateRespDto.setOfficials(officials);
                hasData = true;
            }
            List miniAppId = null;
            try {
                miniAppId = this.ccCustomerNumService.getMiniAppId(bizId, customerNum);
            }
            catch (Exception e) {
                log.error(" ccCustomerNumService.getMiniAppId \u5f02\u5e38\uff1aparam:{}", (Object)customerNum, (Object)e);
            }
            if (CollectionUtils.isNotEmpty((Collection)miniAppId) && CollectionUtils.isNotEmpty((Collection)(appletInfos = this.appletInfoMapper.queryAppletInfoListByAppIds((Collection)miniAppId)))) {
                ArrayList minis = Lists.newArrayList();
                for (AppletInfo appletInfo : appletInfos) {
                    WeworkAppRespDto appRespDto = new WeworkAppRespDto();
                    appRespDto.setAppId(appletInfo.getAppId());
                    appRespDto.setAppName(appletInfo.getStoreName());
                    minis.add(appRespDto);
                }
                associateRespDto.setMinis(minis);
                hasData = true;
            }
            List unionIds = this.ccCustomerNumService.getUnionIds(bizId, customerNum);
            associateRespDto.setUnionIds(unionIds);
            String contactId = this.ccCustomerNumService.getWeworkContactId(bizId, customerNum);
            log.info("queryContactAssociate contactId: {} officialAppId: {} miniAppId: {}, customerNum: {}", new Object[]{contactId, officialAppId, miniAppId, customerNum});
            if (StringUtils.isNotBlank((CharSequence)contactId)) {
                WeworkContact contact = this.weworkContactMapper.queryContactByContactId(corpId, contactId);
                if (Objects.nonNull(contact)) {
                    respDtoList.add(associateRespDto);
                    WeworkContactRespDto contactRespDto = this.newWeworkContactResp(contact);
                    associateRespDto.setContactRespDto(contactRespDto);
                    List<WeworkRoomDto> roomDtoList = this.contactService.queryContactAtRooms(corpId, contact.getContactId());
                    associateRespDto.setWeworkRooms(roomDtoList);
                    ArrayList weworkUserDtoList = Lists.newArrayList();
                    List contactRelationList = this.weworkContactRelationMapper.queryContactOfWeworkUsers(corpId, contact.getContactId());
                    log.info("queryContactAssociate contactRelationList: {}", (Object)contactRelationList);
                    if (CollectionUtils.isNotEmpty((Collection)contactRelationList)) {
                        ArrayList weworkUserIds = Lists.newArrayList();
                        for (WeworkContactRelation contactRelation : contactRelationList) {
                            if (contactRelation.getIsDeleted() == 1 || weworkUserIds.contains(contactRelation.getWeworkUserId())) continue;
                            weworkUserIds.add(contactRelation.getWeworkUserId());
                        }
                        log.info("queryContactAssociate weworkUserIds: {}\uff0c corpId: {}", (Object)weworkUserIds, (Object)corpId);
                        if (CollectionUtils.isNotEmpty((Collection)weworkUserIds)) {
                            List weworkUsers = this.weworkUserMapper.queryWeworkUserInfoList(corpId, (Collection)weworkUserIds);
                            Map weworkUserMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getWeworkUserId, Function.identity()));
                            List weworkContactMobileList = this.weworkContactMobileMapper.queryByCorpIdAndContactIds(corpId, Collections.singletonList(contactId));
                            Map<Object, Object> weworkUserRemarkMobileMap = CollectionUtils.isNotEmpty((Collection)weworkContactMobileList) ? weworkContactMobileList.stream().collect(Collectors.groupingBy(WeworkContactMobile::getWeworkUserId, Collectors.mapping(WeworkContactMobile::getRemarkMobile, Collectors.toList()))) : Collections.emptyMap();
                            contactRelationList = contactRelationList.stream().filter(a -> a.getIsDeleted() == 0).collect(Collectors.toList());
                            for (WeworkContactRelation contactRelation : contactRelationList) {
                                List mobiles;
                                String weworkUserId = contactRelation.getWeworkUserId();
                                WeworkUserDto weworkUserDto = new WeworkUserDto();
                                weworkUserDto.setWeworkUserId(weworkUserId);
                                weworkUserDto.setAddTime(contactRelation.getAddTime());
                                Integer addWay = contactRelation.getAddWay();
                                String addWayDesc = AddWayType.UNKNOWN.getDesc();
                                if (AddWayType.getType((Integer)addWay) != null) {
                                    addWayDesc = AddWayType.getType((Integer)addWay).getDesc();
                                }
                                weworkUserDto.setAddWayDesc(addWayDesc);
                                WeworkUser weworkUser = (WeworkUser)weworkUserMap.get(weworkUserId);
                                if (weworkUser == null) {
                                    log.info("query contact info is empty, contactRelation: {}", (Object)contactRelation);
                                    continue;
                                }
                                weworkUserDto.setAvatar(weworkUser.getAvatar());
                                weworkUserDto.setNickname(weworkUser.getName());
                                ChannelInfo channelInfo = this.weworkContactLogMapper.queryChannelInfo(corpId, contactRelation.getWeworkUserId(), contact.getContactId());
                                if (channelInfo != null) {
                                    weworkUserDto.setChannelName(channelInfo.getChannelName());
                                }
                                if (CollectionUtils.isNotEmpty((Collection)(mobiles = (List)weworkUserRemarkMobileMap.get(weworkUserId)))) {
                                    weworkUserDto.setMobiles(mobiles);
                                }
                                weworkUserDtoList.add(weworkUserDto);
                            }
                        }
                        associateRespDto.setWeworkUsers(weworkUserDtoList);
                    }
                }
            } else if (hasData) {
                respDtoList.add(associateRespDto);
            }
        }
        return respDtoList;
    }

    @Override
    public void modContactMobile(ModMobileReqDto reqDto) {
        BizSimpleDto biz;
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        String corpId = currentUser.getCorpId();
        Long operatorId = currentUser.getId();
        log.info("modContactMobile bizId:{}, modMobileReq: {}", (Object)bizId, (Object)reqDto);
        String weworkUserId = reqDto.getWeworkUserId();
        String weworkUserNum = reqDto.getWeworkUserNum();
        log.info("modContactMobile weworkUserId: {}, weworkUserNum: {}", (Object)weworkUserId, (Object)weworkUserNum);
        if (StringUtils.isBlank((CharSequence)weworkUserId) && StringUtils.isBlank((CharSequence)weworkUserNum)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53c2\u6570\u9519\u8bef");
        }
        WeworkUser weworkUser = null;
        if (StringUtils.isNotBlank((CharSequence)weworkUserId) && StringUtils.isBlank((CharSequence)weworkUserNum)) {
            weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, weworkUserId);
        }
        if (StringUtils.isNotBlank((CharSequence)weworkUserNum) && StringUtils.isBlank((CharSequence)weworkUserId)) {
            weworkUser = this.weworkUserMapper.queryWeworkUserByNum(weworkUserNum);
        }
        log.info("modContactMobile get weworkUser: {}", weworkUser);
        if (weworkUser != null) {
            weworkUserId = weworkUser.getWeworkUserId();
            weworkUserNum = weworkUser.getNum();
        }
        Long userId = this.userMapper.getUserIdByWeworkUserId(bizId, weworkUserId);
        log.info("modContactMobile bizId:{}, weworkUserId: {}, weworkUserNum: {}", new Object[]{bizId, weworkUserId, weworkUserNum});
        String customerNum = reqDto.getCustomerNum();
        String contactId = reqDto.getContactId();
        log.info("modContactMobile contactId: {}, customerNum: {}", (Object)contactId, (Object)customerNum);
        if (StringUtils.isBlank((CharSequence)customerNum) && StringUtils.isBlank((CharSequence)contactId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53c2\u6570\u9519\u8bef");
        }
        WeworkContact contact = null;
        if (StringUtils.isNotBlank((CharSequence)contactId)) {
            contact = this.weworkContactMapper.queryContactByContactId(corpId, contactId);
        } else if (StringUtils.isNotBlank((CharSequence)customerNum)) {
            contact = this.weworkContactMapper.queryContact(corpId, customerNum);
        }
        log.info("modContactMobile get contact: {}", (Object)contact);
        if (contact != null) {
            contactId = contact.getContactId();
            customerNum = contact.getCustomerNum();
        }
        log.info("modContactMobile bizId:{},  customerNum: {}, contactId: {}", new Object[]{bizId, customerNum, contactId});
        reqDto.setBizId(bizId);
        reqDto.setCustomerNum(customerNum);
        CustomerDetailResp detailResp = this.ccCustomerInfoService.queryCustomerDetail(bizId, customerNum);
        log.info("modContactMobile detailResp : {}", (Object)detailResp);
        HashSet<String> existMobiles = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)detailResp.getMobile1())) {
            existMobiles.add(detailResp.getMobile1());
        }
        if (StringUtils.isNotBlank((CharSequence)detailResp.getMobile2())) {
            existMobiles.add(detailResp.getMobile2());
        }
        HashSet<String> newMobiles = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)reqDto.getMobile1())) {
            newMobiles.add(reqDto.getMobile1());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getMobile2())) {
            newMobiles.add(reqDto.getMobile2());
        }
        if ((biz = this.scrmBizService.getById(bizId)).getIsOpenCrm() != 0) {
            this.checkNameRepeat(corpId, existMobiles, reqDto);
        }
        Collection addMobiles = CollectionUtils.subtract(newMobiles, existMobiles);
        for (String addMobile : addMobiles) {
            this.customerCenterService.saveAddMobile(bizId, customerNum, addMobile, ModuleType.WEWORK_CONTACT.getCode(), null, null);
        }
        log.info("modContactMobile get exist mobiles: {}", existMobiles);
        FollowReqDto follow = new FollowReqDto();
        follow.setBizId(bizId);
        follow.setCorpId(corpId);
        follow.setOperatorId(operatorId);
        follow.setType(Integer.valueOf(FollowRecordType.EDIT_CONTACT_INFO.getValue()));
        follow.setWeworkUserNum(weworkUserNum);
        if (StringUtils.isNotBlank((CharSequence)contactId)) {
            follow.setContactId(contactId);
        }
        CustomerBaseInfo baseInfo = new CustomerBaseInfo();
        follow.setCustomerBaseInfo(baseInfo);
        if (reqDto.getIsSideBar() != 1) {
            baseInfo.setNewGender(reqDto.getGender());
            baseInfo.setOldGender(detailResp.getGender());
            baseInfo.setNewRemarkName(reqDto.getName());
            baseInfo.setOldRemarkName(detailResp.getName());
            baseInfo.setOldRegion(detailResp.getArea());
            baseInfo.setNewRegion(reqDto.getArea());
        }
        baseInfo.setNewRemarkMobiles(newMobiles);
        baseInfo.setOldRemarkMobiles(existMobiles);
        log.info("modContactMobile follow record: {}", (Object)follow);
        reqDto.setModuleType(ModuleType.REMARK_MOBILE.getCode());
        reqDto.setSource("scrm");
        if (biz.getIsOpenCrm() != 0) {
            if (StringUtils.isBlank((CharSequence)reqDto.getMobile1())) {
                log.info("new mobiles are empty");
            } else {
                this.makeCrmLeads(corpId, bizId, reqDto, contact, userId, detailResp, true);
            }
        }
        this.ccCustomerInfoService.modCustomerMobiles((ModMobileReq)reqDto);
        this.followService.saveFollowRecord(follow, currentUser);
        try {
            ModifyMobileReq dto = new ModifyMobileReq();
            dto.setCorpId(corpId);
            dto.setContactId(contactId);
            dto.setBizId(bizId);
            dto.setExistMobiles(existMobiles);
            dto.setNewMobiles(newMobiles);
            this.contactOpService.modMobileByAllWeworkUserIds(dto);
        }
        catch (Exception e) {
            log.error("modContactMobile error", (Throwable)e);
        }
        CommonKafkaMsg msg = new CommonKafkaMsg();
        msg.setSys("scrm");
        msg.setType("base_info_edit_callback");
        msg.setBizId(bizId);
        msg.setCorpId(corpId);
        msg.setKey(contactId);
        Map channelMap = this.channelMapper.selectNameByNums(bizId, (Collection)Lists.newArrayList((Object[])new String[]{detailResp.getChannelId()}));
        ModBaseInfoDto modBaseInfoDto = ModBaseInfoDto.builder().contactId(detailResp.getContactId()).unionId(detailResp.getUnionId()).oldMobile1(detailResp.getMobile1()).oldMobile2(detailResp.getMobile2()).mobile1(reqDto.getMobile1()).mobile2(reqDto.getMobile2()).name(reqDto.getIsSideBar() == 1 ? detailResp.getName() : reqDto.getName()).gender(reqDto.getIsSideBar() == 1 ? detailResp.getGender() : reqDto.getGender()).channel(channelMap.getOrDefault(detailResp.getChannelId(), "")).updateTime(new Date()).birthday(null).build();
        msg.setData(JacksonUtil.obj2Str((Object)modBaseInfoDto));
        this.kafkaTemplate.send(this.topic, (Object)JacksonUtil.obj2Str((Object)msg));
    }

    private void modWeworkMobile(String corpId, String weworkUserId, String contactId, Set<String> newMobiles) throws IOException {
        log.info("modWeworkMobile corpId: {}, contactId: {}, newMobile: {}", new Object[]{corpId, contactId, newMobiles});
        if (CollectionUtils.isEmpty(newMobiles)) {
            log.info("modWeworkMobile newMobiles is empty,set remarkMobiles empty");
        }
        List addMobiles = Lists.newArrayList();
        addMobiles.addAll(newMobiles);
        if (addMobiles.size() > 5) {
            addMobiles = addMobiles.subList(0, 4);
        }
        log.info("modWeworkMobile addMobile: {}", (Object)addMobiles);
        ModifyRemarkDto remarkDto = new ModifyRemarkDto();
        remarkDto.setWeworkUserId(weworkUserId);
        remarkDto.setContactId(contactId);
        remarkDto.setRemarkMobiles(addMobiles);
        remarkDto.setCorpId(corpId);
        remarkDto.setMod(true);
        try {
            log.info("modWeworkMobile remark req: {}", (Object)remarkDto);
            this.contactOpService.modifyRemark(remarkDto);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5ba2\u6237\u5907\u6ce8\u4fe1\u606f\u5931\u8d25, {}, params:{}", (Object)e.getMessage(), newMobiles);
            throw e;
        }
    }

    @Override
    public CrmLeadsInfoResp checkAndGetCrmLeads(Long bizId, String corpId, CustomerDetailResp detailResp, String expectedMobile) {
        log.info("getCrmLeadsByCustomerDetail, bizId:{}, detail:{}", (Object)bizId, (Object)detailResp);
        CrmLeadsInfoResp resp1 = null;
        CrmLeadsInfoResp resp2 = null;
        CrmLeadsInfoReq req = new CrmLeadsInfoReq();
        req.setCorpId(corpId);
        if (StringUtils.isNotBlank((CharSequence)detailResp.getMobile1())) {
            req.setMobile(detailResp.getMobile1());
            resp1 = this.crmLeadsService.getLeads(req);
        }
        if (StringUtils.isNotBlank((CharSequence)detailResp.getMobile2())) {
            req.setMobile(detailResp.getMobile2());
            resp2 = this.crmLeadsService.getLeads(req);
        }
        if (resp1 == null && resp2 == null) {
            log.info("\u627e\u4e0d\u5230\u7ebf\u7d22, bizId:{}, mobile1:{}, mobile2:{}", new Object[]{bizId, detailResp.getMobile1(), detailResp.getMobile2()});
            return null;
        }
        if (resp1 != null && resp2 == null) {
            log.info("found leads bizId:{}, mobile1:{}, leadsId:{}", new Object[]{bizId, detailResp.getMobile1(), resp1.getId()});
            return resp1;
        }
        if (resp1 == null) {
            log.info("found leads bizId:{}, mobile2:{}, leadsId:{}", new Object[]{bizId, detailResp.getMobile2(), resp2.getId()});
            return resp2;
        }
        if (Objects.equals(resp1.getId(), resp2.getId())) {
            log.error("\u4e24\u4e2a\u624b\u673a\u53f7\u5bf9\u5e94\u540c\u4e00\u6761\u7ebf\u7d22!! mobile1:{}, mobile2:{}, leadsId:{}", new Object[]{detailResp.getMobile1(), detailResp.getMobile2(), resp1.getId()});
            return resp1;
        }
        log.warn("\u67e5\u8be2\u5230\u4e24\u6761\u4e0d\u540c\u7684\u7ebf\u7d22, mobile1:{}, mobile2:{}, leadsId1:{}, leadsId2:{}", new Object[]{detailResp.getMobile1(), detailResp.getMobile2(), resp1.getId(), resp2.getId()});
        if (Objects.equals(expectedMobile, detailResp.getMobile1())) {
            log.info("\u547d\u4e2d\u5ba2\u6237\u4e2d\u5fc3mobile1, \u8fd4\u56de\u7ebf\u7d22\u3002 bizId:{}, mobile1:{}, leadsId:{}", new Object[]{bizId, detailResp.getMobile1(), resp1.getId()});
            return resp1;
        }
        if (Objects.equals(expectedMobile, detailResp.getMobile2())) {
            log.info("\u547d\u4e2d\u5ba2\u6237\u4e2d\u5fc3mobile2, \u8fd4\u56de\u7ebf\u7d22\u3002 bizId:{}, mobile1:{}, leadsId:{}", new Object[]{bizId, detailResp.getMobile1(), resp1.getId()});
            return resp2;
        }
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u624b\u673a\u53f7\u5bf9\u5e94\u591a\u4e2a\u7ebf\u7d22\uff0c\u65e0\u6cd5\u7ed1\u5b9a\u5230\u4e00\u4e2a\u5fae\u4fe1\u5ba2\u6237\u3002\u624b\u673a\u53f7:" + detailResp.getMobile1() + ", " + detailResp.getMobile2());
    }

    @Override
    public CrmLeadsInfoResp getCrmLeadsInfo(Long bizId, String corpId, String mobile) {
        log.info("get crm leads, bizId:{}, mobile:{}", (Object)bizId, (Object)mobile);
        CrmLeadsInfoReq crmLeadsInfoReq = new CrmLeadsInfoReq();
        crmLeadsInfoReq.setCorpId(corpId);
        crmLeadsInfoReq.setMobile(mobile);
        return this.crmLeadsService.getLeads(crmLeadsInfoReq);
    }

    @Override
    public void makeCrmLeads(String corpId, Long bizId, ModMobileReq params, WeworkContact contact, Long userId, CustomerDetailResp detailResp, boolean modLeads) {
        log.info("make crm leads, corpId:{}, params:{}, detailResp:{}", new Object[]{corpId, params, detailResp});
        CrmLeadsInfoResp existsLeads = this.checkAndGetCrmLeads(bizId, corpId, detailResp, params.getMobile1());
        CrmLeadsInfoResp newLeads = this.getCrmLeadsInfo(bizId, corpId, params.getMobile1());
        if (existsLeads != null && newLeads != null) {
            if (!Objects.equals(existsLeads.getId(), newLeads.getId())) {
                log.warn("\u624b\u673a\u53f7\u7ebf\u7d22\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u624b\u673a\u53f7\u3002bizId:{}, mobile:{}", (Object)bizId, (Object)params.getMobile1());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u624b\u673a\u53f7[" + params.getMobile1() + "]\u7ebf\u7d22\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u624b\u673a\u53f7\u3002");
            }
            this.modCrmLeadsMobile(corpId, existsLeads.getNum(), params, modLeads);
        } else if (existsLeads != null) {
            this.modCrmLeadsMobile(corpId, existsLeads.getNum(), params, modLeads);
        } else if (newLeads != null) {
            this.modCrmLeadsMobile(corpId, newLeads.getNum(), params, modLeads);
        }
        Long channelId = null;
        if (StringUtils.isNotBlank((CharSequence)params.getChannelId())) {
            channelId = this.channelMapper.querySysChannelId(params.getChannelId());
        }
        this.addCrmLeads(corpId, params, contact, userId, channelId);
    }

    private void checkNameRepeat(String corpId, Set<String> existMobiles, ModMobileReq params) {
        String mobile;
        log.info("checkNameRepeat, corpId:{}, existMobiles:{} ", (Object)corpId, existMobiles);
        boolean openNameNoRepeat = this.crmConfigService.openNoRepeat(corpId, null);
        if (!openNameNoRepeat) {
            log.info("checkNameRepeat not open, corpId:{}", (Object)corpId);
            return;
        }
        if (StringUtils.isBlank((CharSequence)params.getMobile1()) && CollectionUtils.isEmpty(existMobiles)) {
            log.info("mobile is null, return");
            return;
        }
        String string = mobile = StringUtils.isNotBlank((CharSequence)params.getMobile1()) ? params.getMobile1() : (String)existMobiles.stream().findFirst().get();
        if (StringUtils.isBlank((CharSequence)mobile) || StringUtils.isBlank((CharSequence)params.getName())) {
            log.info("mobile is null, return");
            return;
        }
        CrmLeadsInfoReq req = new CrmLeadsInfoReq();
        req.setCorpId(corpId);
        req.setMobile(mobile);
        CrmLeadsInfoResp resp = this.crmLeadsService.getLeads(req);
        if (resp != null) {
            CrmLeadsInfoReq crmLeadsInfoReq = new CrmLeadsInfoReq();
            crmLeadsInfoReq.setCorpId(corpId);
            crmLeadsInfoReq.setLeadsNum(resp.getNum());
            crmLeadsInfoReq.setName(params.getName());
            boolean existName = this.crmLeadsService.existMobileOrNameByLeadsNum(crmLeadsInfoReq);
            log.info("checkNameRepeat, corpId:{}, existName:{} ", (Object)corpId, (Object)existName);
            Preconditions.checkArgument((!existName || CollectionUtils.isNotEmpty(existMobiles) && !existMobiles.contains(params.getMobile1()) ? 1 : 0) != 0, (Object)("\u5ba2\u6237\u540d\u79f0\"" + params.getName() + "\"\u5df2\u5b58\u5728"));
        } else {
            Optional first = existMobiles.stream().findFirst();
            mobile = first.orElse("");
            if (StringUtils.isNotBlank((CharSequence)mobile)) {
                req = new CrmLeadsInfoReq();
                req.setCorpId(corpId);
                req.setMobile(mobile);
                resp = this.crmLeadsService.getLeads(req);
                if (resp != null) {
                    CrmLeadsInfoReq crmLeadsInfoReq = new CrmLeadsInfoReq();
                    crmLeadsInfoReq.setCorpId(corpId);
                    crmLeadsInfoReq.setLeadsNum(resp.getNum());
                    crmLeadsInfoReq.setName(params.getName());
                    boolean existName = this.crmLeadsService.existMobileOrNameByLeadsNum(crmLeadsInfoReq);
                    log.info("checkNameRepeat, corpId:{}, existName:{} ", (Object)corpId, (Object)existName);
                    Preconditions.checkArgument((!existName ? 1 : 0) != 0, (Object)("\u5ba2\u6237\u540d\u79f0\"" + params.getName() + "\"\u5df2\u5b58\u5728"));
                }
            } else {
                CrmLeadsInfoReq crmLeadsInfoReq = new CrmLeadsInfoReq();
                crmLeadsInfoReq.setCorpId(corpId);
                crmLeadsInfoReq.setName(params.getName());
                boolean existName = this.crmLeadsService.existMobileOrNameByLeadsNum(crmLeadsInfoReq);
                log.info("checkNameRepeat, corpId:{}, existName:{} ", (Object)corpId, (Object)existName);
                Preconditions.checkArgument((!existName ? 1 : 0) != 0, (Object)("\u5ba2\u6237\u540d\u79f0\"" + params.getName() + "\"\u5df2\u5b58\u5728"));
            }
        }
    }

    private void addCrmLeads(String corpId, ModMobileReq params, WeworkContact contact, Long userId, Long channelId) {
        List tags;
        List tagIds = Collections.emptyList();
        if (Objects.isNull(channelId)) {
            Long centerChannelId;
            CustomerDetailResp detailResp;
            channelId = this.channelMapper.querySysChannelId(SysChannelEnum.QY_WEIXIN.getCode());
            String customerNum = this.ccCustomerNumService.getCustomerNumByMobile(contact.getBizId(), params.getMobile1());
            if (StringUtils.isNotBlank((CharSequence)customerNum) && (detailResp = this.ccCustomerDetailService.queryCustomerDetail(contact.getBizId(), customerNum)) != null && StringUtils.isNotBlank((CharSequence)detailResp.getChannelId()) && (centerChannelId = this.channelMapper.getIdByNum(contact.getBizId(), detailResp.getChannelId())) != null) {
                channelId = centerChannelId;
            }
        }
        if (contact != null && CollectionUtils.isNotEmpty((Collection)(tags = this.weworkContactTagMapper.queryByCorpIdAndContactIds(corpId, Collections.singletonList(contact.getContactId()))))) {
            tagIds = tags.stream().map(WeworkContactTag::getTagId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        }
        log.info("add crm leads, corpId:{}, params:{}, tagIds:{}", new Object[]{corpId, params, tagIds});
        CrmLeadsReq crmLeadsReq = new CrmLeadsReq();
        crmLeadsReq.setCorpId(corpId);
        crmLeadsReq.setMobile(params.getMobile1());
        crmLeadsReq.setMobile1(params.getMobile2());
        crmLeadsReq.setName(params.getName());
        crmLeadsReq.setGender(params.getGender());
        crmLeadsReq.setAreaId(params.getArea());
        crmLeadsReq.setTagIds(tagIds);
        crmLeadsReq.setCreatorId(LoginUtils.getCurrentUserId());
        crmLeadsReq.setSourceType(Integer.valueOf(SourceType.SCRM_SYNC.getValue()));
        crmLeadsReq.setAllocUserId(userId);
        crmLeadsReq.setChannelId(channelId);
        try {
            this.crmLeadsService.addLeads(crmLeadsReq);
        }
        catch (Exception e) {
            log.error("addCrmLeads,crmLeadsReq:{}\u53d1\u751f\u5f02\u5e38", (Object)crmLeadsReq, (Object)e);
        }
    }

    private void modCrmLeadsMobile(String corpId, String leadsNum, ModMobileReq params, boolean mod) {
        log.info("mod crm leads mobile, corpId:{}, leadsNum:{}, params:{}, mod:{}", new Object[]{corpId, leadsNum, params, mod});
        CrmModMobileReq req = new CrmModMobileReq();
        req.setCorpId(corpId);
        req.setLeadsNum(leadsNum);
        req.setMobile(params.getMobile1());
        req.setMobile1(params.getMobile2());
        if (mod) {
            req.setName(params.getName());
            req.setGender(params.getGender());
            req.setAreaId(params.getArea());
        }
        try {
            this.crmLeadsService.modMobiles(req);
        }
        catch (Exception e) {
            log.error("modCrmLeadsMobile,req:{}\u53d1\u751f\u5f02\u5e38", (Object)req, (Object)e);
        }
    }

    private WeworkContactRespDto newWeworkContactResp(WeworkContact weworkContact) {
        WeworkContactRespDto resp = new WeworkContactRespDto();
        resp.setCorpId(weworkContact.getCorpId());
        resp.setContactId(weworkContact.getContactId());
        resp.setName(weworkContact.getName());
        resp.setAvatar(weworkContact.getAvatar());
        resp.setMobile(weworkContact.getMobile());
        resp.setGender(weworkContact.getGender());
        resp.setType(weworkContact.getType());
        resp.setCorpName(weworkContact.getCorpName());
        return resp;
    }

    @Override
    public RemarkContactInfoResp queryRemarkContactInfo(RemarkContactReq req) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        String corpId = currentUser.getCorpId();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getCustomerNum()), (Object)"\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getWeworkUserId()), (Object)"\u6210\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("queryRemarkContactInfo bizId: {}, weworkUserId: {}, customerNum: {}", new Object[]{bizId, req.getWeworkUserId(), req.getCustomerNum()});
        RemarkContactInfoResp infoResp = new RemarkContactInfoResp();
        String contactId = this.ccCustomerNumService.getWeworkContactId(bizId, req.getCustomerNum());
        log.info("queryRemarkContactInfo contactId: {}, customerNum: {}", (Object)contactId, (Object)req.getCustomerNum());
        if (StringUtils.isNotBlank((CharSequence)contactId)) {
            WeworkContact contact = this.weworkContactMapper.queryContactByContactId(corpId, contactId);
            if (Objects.nonNull(contact)) {
                contactId = contact.getContactId();
                infoResp.setAvatar(contact.getAvatar());
                infoResp.setName(contact.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)contactId)) {
                List contactMobiles;
                WeworkContactRelation contactRelation = this.weworkContactRelationMapper.queryWeworkContactDetail(corpId, req.getWeworkUserId(), contactId, YnEnum.NO.getValue());
                if (Objects.nonNull(contactRelation)) {
                    infoResp.setRemark(contactRelation.getRemark());
                    infoResp.setDesc(contactRelation.getDescription());
                }
                if (CollectionUtils.isNotEmpty((Collection)(contactMobiles = this.weworkContactMobileMapper.queryContactMobiles(corpId, req.getWeworkUserId(), contactId)))) {
                    ArrayList mobiles = Lists.newArrayList();
                    contactMobiles.forEach(a -> {
                        if (StringUtils.isNotBlank((CharSequence)a.getRemarkMobile())) {
                            mobiles.add(a.getRemarkMobile());
                        }
                    });
                    infoResp.setMobiles(mobiles);
                }
                List weworkContactTags = this.contactTagMapper.queryContactTags(corpId, req.getWeworkUserId(), contactId, Integer.valueOf(0));
                List tagIds = weworkContactTags.stream().map(WeworkContactTag::getTagId).collect(Collectors.toList());
                log.info("queryRemarkContactInfo weworkUserId: {}, contactId: {}, tagIds: {}", new Object[]{req.getWeworkUserId(), contactId, tagIds});
                if (CollectionUtils.isNotEmpty(tagIds)) {
                    ArrayList tagList = Lists.newArrayList();
                    Map tagMaps = this.tagMapper.queryTagIdAndName(corpId, tagIds);
                    weworkContactTags.forEach(a -> {
                        IdAndNameDto dto = new IdAndNameDto();
                        dto.setId(a.getId());
                        if (tagMaps != null && tagMaps.containsKey(a.getTagId())) {
                            String tagName = (String)tagMaps.get(a.getTagId());
                            dto.setName(tagName);
                        }
                        tagList.add(dto);
                    });
                    infoResp.setTagList(tagList);
                }
            }
        }
        return infoResp;
    }

    @Override
    public boolean bindStatus(QueryBindStatusReq reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        log.info("queryBindStatus mobile: {}, customerNum: {}", (Object)reqDto.getMobile(), (Object)reqDto.getCustomerNum());
        reqDto.setBizId(bizId);
        return this.ccCustomerInfoService.queryBindStatus(reqDto);
    }

    @Override
    public List<FollowListRespDto> followList(FollowListReqDto req) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        String corpId = currentUser.getCorpId();
        WeworkContact contact = this.weworkContactMapper.queryContactByContactId(corpId, req.getContactId());
        if (contact == null) {
            return null;
        }
        String customerNum = contact.getCustomerNum();
        log.info("followList corpId: {}, bizId: {}, customerNum: {}", new Object[]{corpId, bizId, customerNum});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)customerNum), (Object)"customerNum \u4e0d\u80fd\u4e3a\u7a7a");
        FollowQueryParams queryParams = new FollowQueryParams();
        queryParams.setPageDto(req.getPageDto());
        queryParams.setBizId(bizId);
        queryParams.setCustomerNum(customerNum);
        queryParams.setFollowTypes((List)Lists.newArrayList((Object[])new Integer[]{CustomerFollowType.USER_FOLLOW.getValue(), CustomerFollowType.MOD_FOLLOW.getValue()}));
        FollowListResp resp = this.ccCustomerFollowRecordService.list(queryParams);
        req.setPageDto(resp.getPageDto());
        List list = resp.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        ArrayList callRecordIds = Lists.newArrayList();
        HashSet userIds = Sets.newHashSet();
        list.forEach(followResp -> {
            JsonContentDto jsonContent = followResp.getJsonContent();
            FollowInfoDto followInfo = jsonContent.getFollowInfo();
            if (StringUtils.isNotBlank((CharSequence)followInfo.getCallRecordId())) {
                callRecordIds.add(followInfo.getCallRecordId());
            }
            userIds.add(followInfo.getCreateBy());
        });
        List callRecords = this.scrmCallService.recordList((List)callRecordIds);
        Map relationDtoMap = callRecords.stream().collect(Collectors.toMap(CallRecordDto::getNum, Function.identity()));
        Map userMap = this.scrmUserService.getNameByIds((Collection)userIds);
        ArrayList result = Lists.newArrayList();
        for (FollowResp followResp2 : list) {
            CallRecordDto callRecordDto;
            String source;
            FollowListRespDto respDto = new FollowListRespDto();
            JsonContentDto jsonContent = followResp2.getJsonContent();
            StageInfoDto stageInfo = jsonContent.getStageInfo();
            FollowInfoDto followInfo = jsonContent.getFollowInfo();
            if (!ObjectUtils.isEmpty((Object)stageInfo)) {
                respDto.setStageBefore(this.toStageDto(stageInfo.getOldStage()));
                respDto.setStageAfter(this.toStageDto(stageInfo.getNewStage()));
            }
            respDto.setFollowUser("crm".equals(source = followResp2.getSource()) ? (String)userMap.get(followInfo.getCreateBy()) : followResp2.getWeworkUserName());
            respDto.setFollowType(followInfo.getType());
            respDto.setCreateTime(followResp2.getFollowTime());
            respDto.setFollowContent(followInfo.getRemark());
            respDto.setAppointmentTime(followInfo.getAppointmentTime());
            if (StringUtils.isNotBlank((CharSequence)followInfo.getCallRecordId()) && !ObjectUtils.isEmpty((Object)(callRecordDto = (CallRecordDto)relationDtoMap.get(followInfo.getCallRecordId())))) {
                respDto.setVideoUrl(callRecordDto.getVoiceUrl());
                respDto.setVideoDuration(callRecordDto.getCallDuration());
            }
            result.add(respDto);
        }
        return result;
    }

    private StageDto toStageDto(CsStage csStage) {
        if (ObjectUtils.isEmpty((Object)csStage)) {
            return null;
        }
        StageDto stageDto = new StageDto();
        stageDto.setStageName(csStage.getStageName());
        stageDto.setStageValue(csStage.getStageValue());
        stageDto.setId(csStage.getStageId());
        stageDto.setType(csStage.getType());
        return stageDto;
    }

    @Override
    public CustomerBindInfoDto getCustomerInfoByMobile(String mobile) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        CrmLeadsInfoReq req = new CrmLeadsInfoReq();
        req.setMobile(mobile);
        req.setCorpId(userInfo.getCorpId());
        CustomerBindInfoDto result = new CustomerBindInfoDto();
        CrmLeadsInfoResp resp = null;
        try {
            resp = this.crmLeadsService.getLeads(req);
        }
        catch (Exception e) {
            log.error("getCustomerInfoByMobile, get leads error: ", (Throwable)e);
        }
        if (resp != null) {
            result.setName(resp.getName());
            if (resp.getBindUserCount() != null && resp.getBindUserCount() == 1) {
                Node node;
                UserSimpleInfo info;
                result.setBindUserId(resp.getBindingUserId());
                if (result.getBindUserId() != null && (info = this.scrmUserService.getById(result.getBindUserId())) != null) {
                    result.setBindUserName(info.getName());
                }
                result.setDepartId(resp.getBindingDeptId());
                if (result.getDepartId() != null && (node = this.nodeService.getNode(result.getDepartId(), userInfo.getBizId())) != null) {
                    result.setDepartName(node.getName());
                }
            }
        }
        return result;
    }
}

