/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.callback.service.impl;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.kuaike.scrm.callback.service.WeworkTabInitService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.wework.entity.WeworkTabSetting;
import com.kuaike.scrm.dal.wework.mapper.WeworkTabSettingMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WeworkTabInitServiceImpl
implements WeworkTabInitService {
    private static final Logger log = LoggerFactory.getLogger(WeworkTabInitServiceImpl.class);
    @Resource
    private WeworkTabSettingMapper tabSettingMapper;
    @Value(value="${tab.setting.list:}")
    private String settingNames;
    @Autowired
    private IdGen idGen;

    @Override
    public void initSystemTab(Long bizId, String corpId) {
        if (StringUtils.isBlank((CharSequence)this.settingNames)) {
            this.settingNames = "\u5ba2\u6237\u8be6\u60c5:\u5f85\u529e\u4e8b\u9879:\u76f4\u64ad\u9884\u7ea6:\u88c2\u53d8\u6d3b\u52a8:\u5feb\u6377\u56de\u590d:\u4f1a\u8bdd\u8bb0\u5f55";
        }
        ArrayList tabSettings = Lists.newArrayList((Iterable)Splitter.on((String)":").split((CharSequence)this.settingNames));
        for (int i = 0; i < tabSettings.size(); ++i) {
            String tabName = (String)tabSettings.get(i);
            if (!StringUtils.isNotBlank((CharSequence)tabName)) continue;
            WeworkTabSetting querySetting = this.tabSettingMapper.querySetting(corpId, tabName);
            if (Objects.isNull(querySetting)) {
                WeworkTabSetting weworkTabSetting = new WeworkTabSetting();
                weworkTabSetting.setNum(this.idGen.getNum());
                weworkTabSetting.setBizId(bizId);
                weworkTabSetting.setCorpId(corpId);
                weworkTabSetting.setTabName(tabName);
                weworkTabSetting.setTabSeq(Integer.valueOf(i + 1));
                weworkTabSetting.setTabType(Integer.valueOf(1));
                weworkTabSetting.setStatus(Integer.valueOf(1));
                weworkTabSetting.setCreateBy(Long.valueOf(-1L));
                weworkTabSetting.setCreateTime(new Date());
                this.tabSettingMapper.insertSelective((Object)weworkTabSetting);
                log.info("initSystemTab insert tabName: {}, corpId: {}", (Object)tabName, (Object)corpId);
                continue;
            }
            log.info("initSystemTab tabName: {} is exit, corpId: {}", (Object)tabName, (Object)corpId);
        }
    }
}

