/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.callback.service.impl;

import cn.kinyun.wework.sdk.api.CustomizedApi;
import cn.kinyun.wework.sdk.api.SuiteApi;
import cn.kinyun.wework.sdk.callback.suite.auth.CancelAuth;
import cn.kinyun.wework.sdk.callback.suite.auth.ChangeAuth;
import cn.kinyun.wework.sdk.callback.suite.auth.CreateAuth;
import cn.kinyun.wework.sdk.entity.suite.Agent;
import cn.kinyun.wework.sdk.entity.suite.AuthAgentInfo;
import cn.kinyun.wework.sdk.entity.suite.AuthCorpInfo;
import cn.kinyun.wework.sdk.entity.suite.AuthInfo;
import cn.kinyun.wework.sdk.entity.suite.AuthUserInfo;
import cn.kinyun.wework.sdk.entity.suite.PermanentCode;
import com.google.common.collect.Lists;
import com.kuaike.common.utils.DateUtil;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.callback.service.SuiteAuthService;
import com.kuaike.scrm.common.enums.BizChannel;
import com.kuaike.scrm.common.enums.CustomerStageEnum;
import com.kuaike.scrm.common.enums.QualityBehaviorType;
import com.kuaike.scrm.common.enums.QualitySenderType;
import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.enums.SystemRoleType;
import com.kuaike.scrm.common.enums.WeworkCorpSyncStatus;
import com.kuaike.scrm.common.enums.WeworkUserSyncStatus;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.accesstoken.entity.CorpSuiteToken;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpSuiteTokenMapper;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.permission.entity.Role;
import com.kuaike.scrm.dal.permission.entity.RoleMenu;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.entity.UserRole;
import com.kuaike.scrm.dal.permission.mapper.RoleMapper;
import com.kuaike.scrm.dal.permission.mapper.RoleMenuMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.permission.mapper.UserRoleMapper;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckBehaviorSetting;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckBehaviorSettingMapper;
import com.kuaike.scrm.dal.quickreply.entity.QuickReplyGroup;
import com.kuaike.scrm.dal.quickreply.mapper.QuickReplyGroupMapper;
import com.kuaike.scrm.dal.radar.entity.MarketingRadarGroup;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarGroupMapper;
import com.kuaike.scrm.dal.system.entity.CustomerStage;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.entity.Setting;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import com.kuaike.scrm.dal.system.mapper.CustomerStageReasonMapper;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.system.mapper.SettingMapper;
import com.kuaike.scrm.dal.system.mapper.SystemRoleMenuMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkTabSetting;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkTabSettingMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagGroupMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.synctask.service.SyncTaskService;
import com.kuaike.scrm.synctask.service.enums.SyncTaskType;
import com.kuaike.scrm.system.service.UserService;
import com.kuaike.scrm.token.service.ProviderTokenService;
import com.kuaike.scrm.wework.corp.service.WeworkCorpService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkNotifyService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SuiteAuthServiceImpl
implements SuiteAuthService {
    private static final Logger log = LoggerFactory.getLogger(SuiteAuthServiceImpl.class);
    private static final String[] INVALID_CUSTOMER_REASONS = new String[]{"\u591a\u6b21\u8054\u7cfb\u4e0d\u4e0a", "\u7a7a\u53f7/\u9519\u53f7/\u505c\u673a", "\u5ba2\u6237\u65e0\u9700\u6c42", "\u5176\u4ed6"};
    private static final String[] SHU_DAN_REASONS = new String[]{"\u5ba2\u6237\u9009\u62e9\u4e86\u5176\u5b83\u673a\u6784", "\u4ea7\u54c1\u65e0\u6cd5\u6ee1\u8db3\u5ba2\u6237\u9700\u6c42", "\u5176\u4ed6"};
    @Value(value="${biz.expire.days:5}")
    private int bizExpireDays;
    @Value(value="${scrm.biz.numCount}")
    private Integer numCount;
    @Autowired
    private ProviderTokenService providerTokenService;
    @Autowired
    private CustomizedApi customizedApi;
    @Autowired
    private SuiteApi suiteApi;
    @Autowired
    private IdGen idGen;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private WeworkCorpService weworkCorpService;
    @Autowired
    private QualityCheckBehaviorSettingMapper qualityCheckBehaviorSettingMapper;
    @Autowired
    private WeworkTabSettingMapper tabSettingMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkTagMapper weworkTagMapper;
    @Autowired
    private WeworkTagGroupMapper weworkTagGroupMapper;
    @Autowired
    private CorpSuiteTokenMapper corpSuiteTokenMapper;
    @Autowired
    private MarketingRadarGroupMapper marketingRadarGroupMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private SystemRoleMenuMapper systemRoleMenuMapper;
    @Autowired
    private RoleMenuMapper roleMenuMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private SettingMapper settingMapper;
    @Autowired
    private CustomerStageMapper customerStageMapper;
    @Autowired
    private CustomerStageReasonMapper customerStageReasonMapper;
    @Autowired
    private QuickReplyGroupMapper replyGroupMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Autowired
    private SyncTaskService syncTaskService;
    @Autowired
    private WeworkNotifyService weworkNotifyService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createAuth(String suiteId, String authCode, String state, String mobile) {
        log.info("createAuth suiteId:{} authCode:{}, state:{}, mobile:{}", new Object[]{suiteId, authCode, state, mobile});
        Date authTime = new Date();
        String corpId = this.createAuth(suiteId, authCode, authTime, BizChannel.HOME_PAGE);
        log.info("auth corpId:{}", (Object)corpId);
        return corpId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createAuth(@NonNull CreateAuth event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        log.info("createAuth:{}", (Object)event);
        String suiteId = event.getSuiteId();
        String authCode = event.getAuthCode();
        Long timestamp = event.getTimestamp();
        Date authTime = new Date(timestamp * 1000L);
        this.createAuth(suiteId, authCode, authTime, BizChannel.APP_STORE);
    }

    private String createAuth(String suiteId, String authCode, Date authTime, BizChannel bizChannel) {
        String suiteAccessToken = this.providerTokenService.getSuiteAccessToken(suiteId);
        if (suiteAccessToken == null) {
            log.warn("\u65e0\u6cd5\u83b7\u53d6\u7b2c\u4e09\u65b9\u5e94\u7528\u7684accessToken");
            return null;
        }
        PermanentCode permanentCode = this.suiteApi.getPermanentCode(suiteAccessToken, authCode);
        log.info("permanentCode:{}", (Object)permanentCode);
        BusinessCustomer biz = this.createBizId(permanentCode, bizChannel);
        this.createWeworkCorp(biz, permanentCode.getAuthCorpInfo(), authTime);
        this.createWeworkUser(biz, permanentCode, authTime);
        this.createCorpSuiteToken(biz, suiteId, permanentCode);
        return biz.getAuthCorpId();
    }

    private BusinessCustomer createBizId(PermanentCode permanentCode, BizChannel bizChannel) {
        BusinessCustomer biz;
        Date now = new Date();
        String num = this.idGen.getNum();
        String corpId = "CORP$" + num;
        AuthCorpInfo corpInfo = permanentCode.getAuthCorpInfo();
        AuthUserInfo userInfo = permanentCode.getAuthUserInfo();
        String authCorpId = corpInfo.getCorpId();
        String applyUserId = userInfo.getUserId();
        if (!authCorpId.startsWith("wp")) {
            String providerAccessToken = this.providerTokenService.getProviderToken();
            String openCorpId = this.customizedApi.getOpenCorpId(providerAccessToken, authCorpId);
            corpId = authCorpId;
            authCorpId = openCorpId;
            log.info("\u53d1\u73b0\u660e\u6587corpId\uff0c{} -> {}", (Object)corpInfo, (Object)openCorpId);
            applyUserId = userInfo.getOpenUserId();
            log.info("\u6388\u6743\u7528\u6237userId, {} -> {}", (Object)userInfo.getUserId(), (Object)userInfo.getOpenUserId());
        }
        Long bizId = (biz = this.businessCustomerMapper.getByAuthCorpId(authCorpId)) == null ? null : biz.getId();
        String name = corpInfo.getCorpFullName();
        if (StringUtils.isBlank((CharSequence)name)) {
            name = corpInfo.getCorpName();
        }
        if (biz == null) {
            biz = new BusinessCustomer();
            biz.setName(name);
            biz.setUpdateTime(now);
            biz.setApplyWeworkUserId(applyUserId);
            biz.setNum(num);
            biz.setCorpId(corpId);
            biz.setAuthCorpId(authCorpId);
            biz.setSyncStatus(Integer.valueOf(WeworkCorpSyncStatus.INIT_SUITE.getValue()));
            biz.setApplyChannel(Integer.valueOf(bizChannel.getValue()));
            biz.setCreateTime(now);
            biz.setNumCount(this.numCount);
            biz.setPkgIds("1");
            biz.setInitPkgIds("1");
            biz.setExpireDate(DateUtil.getDiffDateTime((Date)now, (int)this.bizExpireDays));
            this.businessCustomerMapper.insertSelective((Object)biz);
            bizId = biz.getId();
            log.info("create new business_customer, authCorpId:{}, bizId:{}", (Object)authCorpId, (Object)bizId);
        } else {
            biz.setName(name);
            if (biz.getSyncStatus() > WeworkCorpSyncStatus.MATCH_CORP_ID.getValue()) {
                biz.setSyncStatus(Integer.valueOf(WeworkCorpSyncStatus.MATCH_CORP_ID.getValue()));
            }
            biz.setUpdateTime(now);
            biz.setApplyWeworkUserId(applyUserId);
            this.businessCustomerMapper.updateByPrimaryKeySelective((Object)biz);
            log.info("update exists business_customer, authCorpId:{}, bizId:{}", (Object)authCorpId, (Object)bizId);
        }
        return biz;
    }

    private void createWeworkCorp(BusinessCustomer biz, AuthCorpInfo corpInfo, Date authTime) {
        Date now = new Date();
        Long bizId = biz.getId();
        String corpId = biz.getCorpId();
        String authCorpId = biz.getAuthCorpId();
        boolean createCorp = false;
        WeworkCorp corp = this.weworkCorpMapper.getByAuthCorpId(authCorpId);
        if (corp == null) {
            corp = new WeworkCorp();
            corp.setNum(this.idGen.getNum());
            corp.setBizId(bizId);
            corp.setCorpId(corpId);
            corp.setAuthCorpId(authCorpId);
            corp.setCreateTime(now);
            createCorp = true;
        }
        corp.setCorpName(corpInfo.getCorpName());
        corp.setCorpFullName(corpInfo.getCorpFullName());
        corp.setCorpType(corpInfo.getCorpType());
        corp.setCorpSquareLogoUrl(corpInfo.getCorpSquareLogoUrl());
        corp.setCorpUserMax(corpInfo.getCorpUserMax());
        corp.setCorpAgentMax(corpInfo.getCorpAgentMax());
        if (corpInfo.getVerifiedEndTime() != null) {
            corp.setVerifiedEndTime(new Date(corpInfo.getVerifiedEndTime()));
        }
        corp.setSubjectType(corpInfo.getSubjectType());
        corp.setCorpWxqrcode(corpInfo.getCorpWxqrcode());
        corp.setCorpScale(corpInfo.getCorpScale());
        corp.setCorpIndustry(corpInfo.getCorpIndustry());
        corp.setCorpSubIndustry(corpInfo.getCorpSubIndustry());
        corp.setLocation(corpInfo.getLocation());
        corp.setUpdateTime(now);
        corp.setIsDeleted(Integer.valueOf(0));
        corp.setIsAuth(Integer.valueOf(1));
        corp.setAuthTime(authTime);
        if (createCorp) {
            log.info("save wework_corp, corpId:{}, bizId:{}, corp:{}", new Object[]{authCorpId, bizId, corp});
            this.weworkCorpService.insert(corp);
        } else {
            log.info("update wework_corp, corpId:{}, bizId:{}, corp:{}", new Object[]{authCorpId, bizId, corp});
            this.weworkCorpMapper.updateByPrimaryKeySelective((Object)corp);
        }
    }

    private void createWeworkUser(BusinessCustomer biz, PermanentCode permanentCode, Date authTime) {
        Date now = new Date();
        Long bizId = biz.getId();
        String corpId = biz.getCorpId();
        AuthCorpInfo corpInfo = permanentCode.getAuthCorpInfo();
        AuthUserInfo userInfo = permanentCode.getAuthUserInfo();
        String weworkUserId = userInfo.getUserId();
        String openUserId = userInfo.getOpenUserId();
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfoByBizIdAndAuthUserId(bizId, openUserId);
        boolean create = false;
        String num = this.idGen.getNum();
        if (weworkUser == null) {
            weworkUser = new WeworkUser();
            weworkUser.setNum(num);
            weworkUser.setBizId(bizId);
            weworkUser.setCorpId(corpId);
            weworkUser.setWeworkUserId(weworkUserId);
            weworkUser.setAuthUserId(openUserId);
            weworkUser.setOpenUserId(openUserId);
            weworkUser.setStatus(Integer.valueOf(1));
            if (!corpInfo.getCorpId().startsWith("wp")) {
                weworkUser.setSyncStatus(Integer.valueOf(WeworkUserSyncStatus.SYNCHRONIZED.getValue()));
            } else {
                weworkUser.setSyncStatus(Integer.valueOf(WeworkUserSyncStatus.ONLY_SUITE.getValue()));
            }
            weworkUser.setCreateTime(now);
            create = true;
        }
        weworkUser.setName(userInfo.getName());
        weworkUser.setAvatar(userInfo.getAvatar());
        weworkUser.setUpdateTime(now);
        weworkUser.setIsSuiteAuth(Integer.valueOf(1));
        weworkUser.setSuiteAuthTime(authTime);
        if (create) {
            log.info("save wework_user, corpId:{}, weworkUser:{}", (Object)corpId, (Object)weworkUser);
            this.weworkUserMapper.insertSelective((Object)weworkUser);
        } else {
            log.info("update wework_user, corpId:{}, weworkUser:{}", (Object)corpId, (Object)weworkUser);
            this.weworkUserMapper.updateByPrimaryKeySelective((Object)weworkUser);
        }
        User user = this.userMapper.getByWeworkUserIdAndCorpId(weworkUser.getWeworkUserId(), corpId);
        if (Objects.isNull(user)) {
            log.info("createWeworkUser: \u6210\u5458\u8f6c\u5316\u4e3a\u7528\u6237\uff0cbizId:{}, weworkUser:{}", (Object)bizId, (Object)weworkUser);
            this.userService.insertUser(weworkUser, false);
        }
    }

    private void createCorpSuiteToken(BusinessCustomer biz, String suiteId, PermanentCode permanentCode) {
        Date now = new Date();
        Long bizId = biz.getId();
        String corpId = biz.getCorpId();
        String authCorpId = biz.getAuthCorpId();
        AuthAgentInfo agentInfo = permanentCode.getAuthInfo();
        Agent agent = (Agent)agentInfo.getAgent().get(0);
        CorpSuiteToken corpSuiteToken = this.corpSuiteTokenMapper.getAccessToken(corpId, suiteId);
        boolean create = false;
        if (corpSuiteToken == null) {
            corpSuiteToken = new CorpSuiteToken();
            corpSuiteToken.setCorpId(corpId);
            corpSuiteToken.setSuiteId(suiteId);
            corpSuiteToken.setCreateTime(now);
            create = true;
        }
        corpSuiteToken.setBizId(bizId);
        corpSuiteToken.setAuthCorpId(authCorpId);
        corpSuiteToken.setAgentId(agent.getAgentId());
        corpSuiteToken.setPermanentCode(permanentCode.getPermanentCode());
        corpSuiteToken.setAccessToken(permanentCode.getAccessToken());
        corpSuiteToken.setExpireTime(new Date(now.getTime() + permanentCode.getExpires() * 1000L));
        corpSuiteToken.setUpdateTime(now);
        if (create) {
            this.corpSuiteTokenMapper.insertSelective((Object)corpSuiteToken);
        } else {
            this.corpSuiteTokenMapper.updateByPrimaryKeySelective((Object)corpSuiteToken);
        }
    }

    @Override
    public void changeAuth(ChangeAuth event) {
        String name;
        log.info("changeAuth:{}", (Object)event);
        String suiteId = event.getSuiteId();
        String authCorpId = event.getAuthCorpId();
        Long timestamp = event.getTimestamp();
        Date changeTime = new Date(timestamp * 1000L);
        Long bizId = authCorpId.startsWith("wp") ? this.businessCustomerMapper.getExistIdByAuthCorpId(authCorpId) : this.businessCustomerMapper.getExistBizId(authCorpId);
        if (bizId == null) {
            log.warn("\u5546\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664. authCorpId:{}", (Object)authCorpId);
            return;
        }
        BusinessCustomer biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        String corpId = biz.getCorpId();
        if (biz.getSyncStatus().intValue() == WeworkCorpSyncStatus.INIT_SUITE.getValue()) {
            log.warn("biz is not synchronized, bizId={}, authCorpId={}", (Object)biz.getId(), (Object)authCorpId);
            return;
        }
        WeworkCorp corp = this.weworkCorpMapper.getByBizId(bizId);
        if (corp == null) {
            log.warn("wework_corp is null, authCorpId:{}", (Object)authCorpId);
            return;
        }
        CorpSuiteToken corpSuiteToken = this.corpSuiteTokenMapper.getAccessToken(corpId, suiteId);
        if (corpSuiteToken == null || StringUtils.isBlank((CharSequence)corpSuiteToken.getPermanentCode())) {
            log.warn("\u627e\u4e0d\u5230\u4f01\u4e1a\u6388\u6743\u7ed9\u7b2c\u4e09\u65b9\u5e94\u7528\u7684\u6c38\u4e45\u6388\u6743\u7801");
            return;
        }
        String suiteAccessToken = this.providerTokenService.getSuiteAccessToken(suiteId);
        if (suiteAccessToken == null) {
            log.warn("\u65e0\u6cd5\u83b7\u53d6\u7b2c\u4e09\u65b9\u5e94\u7528\u7684accessToken");
            return;
        }
        String permanentCode = corpSuiteToken.getPermanentCode();
        AuthInfo authInfo = this.suiteApi.getAuthInfo(suiteAccessToken, biz.getAuthCorpId(), permanentCode);
        log.info("authInfo:{}", (Object)authInfo);
        AuthCorpInfo corpInfo = authInfo.getAuthCorpInfo();
        corp.setCorpName(corpInfo.getCorpName());
        corp.setCorpFullName(corpInfo.getCorpFullName());
        corp.setCorpType(corpInfo.getCorpType());
        corp.setCorpSquareLogoUrl(corpInfo.getCorpSquareLogoUrl());
        corp.setCorpUserMax(corpInfo.getCorpUserMax());
        corp.setCorpAgentMax(corpInfo.getCorpAgentMax());
        if (corpInfo.getVerifiedEndTime() != null) {
            corp.setVerifiedEndTime(new Date(corpInfo.getVerifiedEndTime()));
        }
        corp.setSubjectType(corpInfo.getSubjectType());
        corp.setCorpWxqrcode(corpInfo.getCorpWxqrcode());
        corp.setCorpScale(corpInfo.getCorpScale());
        corp.setCorpIndustry(corpInfo.getCorpIndustry());
        corp.setCorpSubIndustry(corpInfo.getCorpSubIndustry());
        corp.setLocation(corpInfo.getLocation());
        corp.setUpdateTime(changeTime);
        this.weworkCorpMapper.updateByPrimaryKey((Object)corp);
        String string = name = corp.getCorpFullName() == null ? corp.getCorpName() : corp.getCorpFullName();
        if (name != null && !name.equals(biz.getName())) {
            biz.setName(name);
            this.businessCustomerMapper.updateByPrimaryKey((Object)biz);
        }
        try {
            Long taskId = this.syncTaskService.start(biz.getId(), biz.getCorpId(), SyncTaskType.SUITE, -1L);
            log.error("Sync userid taskId={}", (Object)taskId);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u7b2c\u4e09\u65b9\u5e94\u7528\u6388\u6743\u8303\u56f4\u5931\u8d25. corpId={}", (Object)biz.getCorpId(), (Object)e);
        }
    }

    @Override
    public void cancelAuth(CancelAuth event) {
        log.info("cancelAuth:{}", (Object)event);
        String suiteId = event.getSuiteId();
        String authCorpId = event.getAuthCorpId();
        Long timestamp = event.getTimestamp();
        Date deauthTime = new Date(timestamp * 1000L);
        BusinessCustomer biz = this.businessCustomerMapper.getByAuthCorpId(authCorpId);
        if (biz == null) {
            log.warn("biz is null, authCorpId:{}", (Object)authCorpId);
            return;
        }
        Date now = new Date();
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByAuthCorpId(authCorpId);
        if (weworkCorp != null) {
            if (deauthTime.before(weworkCorp.getAuthTime())) {
                log.warn("\u4f01\u4e1a\u53d6\u6d88\u6388\u6743\u65f6\u95f4\u65e9\u4e8e\u6388\u6743\u65f6\u95f4\uff0c\u7591\u4f3c\u91cd\u590d\u63a8\u9001cancel_auth\u4e8b\u4ef6\u6216\u8005\u5ef6\u8fdf\u63a8\u9001\uff0c\u4e0d\u6267\u884c\u53d6\u6d88\u6388\u6743\u52a8\u4f5c\u3002authCorpId:{}", (Object)authCorpId);
                weworkCorp.setDeauthTime(deauthTime);
                weworkCorp.setUpdateTime(now);
                this.weworkCorpMapper.updateByPrimaryKeySelective((Object)weworkCorp);
                return;
            }
            weworkCorp.setIsAuth(Integer.valueOf(0));
            weworkCorp.setDeauthTime(deauthTime);
            weworkCorp.setUpdateTime(now);
            this.weworkCorpMapper.updateByPrimaryKeySelective((Object)weworkCorp);
        } else {
            log.warn("Wework_corp not found, corpId:{}, suiteId:{}", (Object)authCorpId, (Object)suiteId);
        }
        this.weworkUserMapper.batchSuiteDeauth(biz.getCorpId(), deauthTime);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void resetCorpIdByAuthCorpId(Long bizId, String authCorpId, String authUserId, String corpId, String weworkUserId) {
        log.info("reset corpId, bizId={}, authCorpId={}, authUserId={}, corpId={}, weworkUserId={}", new Object[]{bizId, authCorpId, authUserId, corpId, weworkUserId});
        this.businessCustomerMapper.updateCorpIdByAuthCorpId(bizId, authCorpId, corpId);
        this.corpSuiteTokenMapper.updateCorpIdByAuthCorpId(bizId, authCorpId, corpId);
        this.weworkCorpMapper.updateCorpIdByAuthCorpId(bizId, authCorpId, corpId);
        this.weworkUserMapper.updateCorpIdByAuthCorpId(bizId, authCorpId, corpId);
        this.userMapper.updateCorpIdByAuthCorpId(bizId, authCorpId, corpId);
        if (StringUtils.isNotBlank((CharSequence)weworkUserId)) {
            WeworkUser exist;
            this.weworkUserMapper.updateSyncStatus(bizId, Integer.valueOf(WeworkUserSyncStatus.SYNCHRONIZED.getValue()), Integer.valueOf(WeworkUserSyncStatus.ONLY_CORP.getValue()));
            if (!authUserId.equals(weworkUserId)) {
                this.userMapper.updateWeworkUserIdByAuthUserId(corpId, weworkUserId, authUserId);
                this.userMapper.updateIdentifierByAuthUserId(corpId, weworkUserId, authUserId);
            }
            if ((exist = this.weworkUserMapper.queryWeworkUserInfo(corpId, weworkUserId)) == null) {
                this.weworkUserMapper.updateWeworkUserIdByAuthUserId(corpId, weworkUserId, authUserId);
            } else {
                WeworkUser auth;
                if (!authUserId.equals(weworkUserId) && (auth = this.weworkUserMapper.queryWeworkUserInfo(corpId, authUserId)) != null) {
                    this.weworkUserMapper.deleteByPrimaryKey((Object)auth.getId());
                }
                this.weworkUserMapper.updateAuthUserIdByWeworkUserId(corpId, weworkUserId, authUserId);
            }
            this.weworkUserMapper.updateSyncStatusByAuthUserId(corpId, authUserId, Integer.valueOf(WeworkUserSyncStatus.SYNCHRONIZED.getValue()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void resetAuthCorpIdByCorpId(BusinessCustomer existBiz, BusinessCustomer authBiz, String authCorpId, String authUserId, String corpId, String weworkUserId) {
        log.info("reset authCorpId, bizId={} authCorpId={}, corpId={}", new Object[]{existBiz.getId(), authCorpId, corpId});
        this.mergeWeworkUser(existBiz, authBiz, authUserId, weworkUserId);
        this.mergeCorpSuiteToken(existBiz, authBiz);
        this.mergeWeworkCorp(existBiz, authBiz);
        this.mergeBiz(existBiz, authBiz);
    }

    private void mergeWeworkUser(BusinessCustomer existBiz, BusinessCustomer authBiz, String authUserId, String weworkUserId) {
        log.info("merge wework user, existBiz={}, authBiz={}", (Object)existBiz.getCorpId(), (Object)authBiz.getCorpId());
        Date now = new Date();
        this.weworkUserMapper.updateSyncStatus(existBiz.getId(), Integer.valueOf(WeworkUserSyncStatus.SYNCHRONIZED.getValue()), Integer.valueOf(WeworkUserSyncStatus.ONLY_CORP.getValue()));
        WeworkUser auth = this.weworkUserMapper.queryWeworkUserInfo(authBiz.getCorpId(), authUserId);
        WeworkUser exist = this.weworkUserMapper.queryWeworkUserInfo(existBiz.getCorpId(), weworkUserId);
        boolean create = false;
        String num = this.idGen.getNum();
        if (exist == null) {
            exist = new WeworkUser();
            exist.setNum(num);
            exist.setBizId(existBiz.getId());
            exist.setCorpId(existBiz.getCorpId());
            exist.setWeworkUserId(weworkUserId);
            exist.setOpenUserId(auth.getOpenUserId());
            exist.setCreateTime(now);
            create = true;
        }
        exist.setAuthUserId(authUserId);
        exist.setSyncStatus(Integer.valueOf(WeworkUserSyncStatus.SYNCHRONIZED.getValue()));
        exist.setName(auth.getName());
        exist.setAvatar(auth.getAvatar());
        exist.setUpdateTime(now);
        exist.setIsSuiteAuth(Integer.valueOf(1));
        exist.setSuiteAuthTime(auth.getSuiteAuthTime());
        if (create) {
            this.weworkUserMapper.insertSelective((Object)exist);
        } else {
            this.weworkUserMapper.updateByPrimaryKeySelective((Object)exist);
        }
        this.weworkUserMapper.deleteByPrimaryKey((Object)auth.getId());
        User existUser = this.userMapper.getByWeworkUserIdAndCorpId(weworkUserId, existBiz.getCorpId());
        User authUser = this.userMapper.getByWeworkUserIdAndCorpId(authUserId, authBiz.getCorpId());
        log.info("createWeworkUser: corpId:{}, existUser:{}, authUser:{}", new Object[]{exist.getCorpId(), existUser, authUser});
        if (existUser == null) {
            log.info("createWeworkUser: \u6210\u5458\u8f6c\u5316\u4e3a\u7528\u6237\uff0cbizId:{}, weworkUserId:{}, weworkUser:{}", new Object[]{exist.getBizId(), exist.getWeworkUserId(), exist});
            this.userService.insertUser(exist, false);
        }
        if (authUser != null) {
            log.info("delete auth user, corpId:{}, authUserId:{}", (Object)authBiz.getCorpId(), (Object)authUserId);
            this.userMapper.deleteByPrimaryKey((Object)authUser.getId());
        }
    }

    private void mergeBiz(BusinessCustomer existBiz, BusinessCustomer authBiz) {
        log.info("merge biz, existBiz={}, authBiz={}", (Object)existBiz.getCorpId(), (Object)authBiz.getCorpId());
        existBiz.setAuthCorpId(authBiz.getAuthCorpId());
        existBiz.setName(authBiz.getName());
        existBiz.setApplyWeworkUserId(authBiz.getApplyWeworkUserId());
        existBiz.setUpdateTime(authBiz.getUpdateTime());
        this.businessCustomerMapper.deleteByPrimaryKey((Object)authBiz.getId());
        this.businessCustomerMapper.updateByPrimaryKeySelective((Object)existBiz);
    }

    private void mergeWeworkCorp(BusinessCustomer existBiz, BusinessCustomer authBiz) {
        log.info("merge wework_corp, existBiz={}, authBiz={}", (Object)existBiz.getCorpId(), (Object)authBiz.getCorpId());
        WeworkCorp existCorp = this.weworkCorpMapper.getByBizId(existBiz.getId());
        WeworkCorp authCorp = this.weworkCorpMapper.getByBizId(authBiz.getId());
        existCorp.setAuthCorpId(authBiz.getAuthCorpId());
        existCorp.setIsAuth(authCorp.getIsAuth());
        existCorp.setAuthTime(authCorp.getAuthTime());
        existCorp.setCorpName(authCorp.getCorpName());
        existCorp.setCorpFullName(authCorp.getCorpFullName());
        existCorp.setCorpType(authCorp.getCorpType());
        existCorp.setCorpSquareLogoUrl(authCorp.getCorpSquareLogoUrl());
        existCorp.setCorpUserMax(authCorp.getCorpUserMax());
        existCorp.setCorpAgentMax(authCorp.getCorpAgentMax());
        if (authCorp.getVerifiedEndTime() != null) {
            existCorp.setVerifiedEndTime(authCorp.getVerifiedEndTime());
        }
        existCorp.setSubjectType(authCorp.getSubjectType());
        existCorp.setCorpWxqrcode(authCorp.getCorpWxqrcode());
        existCorp.setCorpScale(authCorp.getCorpScale());
        existCorp.setCorpIndustry(authCorp.getCorpIndustry());
        existCorp.setCorpSubIndustry(authCorp.getCorpSubIndustry());
        existCorp.setLocation(authCorp.getLocation());
        existCorp.setUpdateTime(authCorp.getUpdateTime());
        existCorp.setIsDeleted(Integer.valueOf(0));
        this.weworkCorpMapper.deleteByPrimaryKey((Object)authCorp.getId());
        this.weworkCorpMapper.updateByPrimaryKeySelective((Object)existCorp);
    }

    private void mergeCorpSuiteToken(BusinessCustomer existBiz, BusinessCustomer authBiz) {
        log.info("merge corp_suite_token, existBiz={}, authBiz={}", (Object)existBiz.getCorpId(), (Object)authBiz.getCorpId());
        CorpSuiteToken exist = this.corpSuiteTokenMapper.getByBizId(existBiz.getId());
        CorpSuiteToken auth = this.corpSuiteTokenMapper.getByBizId(authBiz.getId());
        exist.setAuthCorpId(auth.getAuthCorpId());
        exist.setAgentId(auth.getAgentId());
        exist.setPermanentCode(auth.getPermanentCode());
        exist.setAccessToken(auth.getAccessToken());
        exist.setExpireTime(auth.getExpireTime());
        exist.setUpdateTime(auth.getUpdateTime());
        this.corpSuiteTokenMapper.deleteByPrimaryKey((Object)auth.getId());
        this.corpSuiteTokenMapper.updateByPrimaryKeySelective((Object)exist);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initBiz(Long bizId) {
        BusinessCustomer biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        String corpId = biz.getCorpId();
        Long adminRoleId = this.initSystemDefaultRole(bizId, corpId);
        Long rootOrgId = this.initRootOrg(bizId, corpId, biz.getName());
        this.initMobileEncryptSetting(bizId, corpId);
        this.initCustomerStage(bizId, corpId);
        this.initReplyDefaultGroup(bizId, corpId);
        this.initBehaviorSetting(bizId, corpId);
        this.initWeworkTabSetting(bizId, corpId);
        this.initRadarGroupTab(bizId, corpId);
        this.initSystemUser(bizId, corpId, adminRoleId, rootOrgId);
        this.weworkNotifyService.init(bizId, corpId);
    }

    private Long initSystemDefaultRole(Long bizId, String corpId) {
        Long adminRoleId = null;
        for (SystemRoleType systemRoleType : SystemRoleType.values()) {
            Role role = new Role();
            role.setBizId(bizId);
            role.setCorpId(corpId);
            role.setName(systemRoleType.getDesc());
            role.setRemark(systemRoleType.getDesc());
            role.setIsSystem(NumberUtils.INTEGER_ONE);
            role.setCreateTime(new Date());
            role.setUpdateTime(new Date());
            role.setType(Integer.valueOf(systemRoleType.getValue()));
            this.roleMapper.insertSelective((Object)role);
            Long roleId = role.getId();
            if (SystemRoleType.ADMIN.getValue() == systemRoleType.getValue()) {
                adminRoleId = roleId;
            }
            log.info("\u4e3abizId:{},corpId:{}\u63d2\u5165\u9ed8\u8ba4\u89d2\u8272:{},roleId:{}", new Object[]{bizId, corpId, systemRoleType.getDesc(), roleId});
            this.initSystemDefaultRoleMenu(bizId, corpId, roleId, systemRoleType.getValue());
            log.info("\u4e3a\u89d2\u8272roleId:{}\u521d\u59cb\u5316\u89d2\u8272\u83dc\u5355\u6210\u529f", (Object)roleId);
        }
        return adminRoleId;
    }

    private void initSystemDefaultRoleMenu(Long bizId, String corpId, Long roleId, Integer roleType) {
        Set menuCodes = this.systemRoleMenuMapper.selectByType(roleType);
        if (CollectionUtils.isEmpty((Collection)menuCodes)) {
            log.warn("\u7cfb\u7edf\u8fd8\u672a\u4e3aroleType:{}\u8bbe\u7f6e\u9ed8\u8ba4\u83dc\u5355", (Object)roleType);
            return;
        }
        ArrayList roleMenus = Lists.newArrayList();
        for (String menuCode : menuCodes) {
            RoleMenu roleMenu = new RoleMenu();
            roleMenus.add(roleMenu);
            roleMenu.setRoleId(roleId);
            roleMenu.setMenuCode(menuCode);
            roleMenu.setBizId(bizId);
            roleMenu.setCorpId(corpId);
            roleMenu.setCreateBy(NumberUtils.LONG_MINUS_ONE);
            roleMenu.setUpdateBy(NumberUtils.LONG_MINUS_ONE);
            roleMenu.setCreateTime(new Date());
            roleMenu.setUpdateTime(new Date());
        }
        this.roleMenuMapper.batchInsert((List)roleMenus);
    }

    private Long initRootOrg(Long bizId, String corpId, String corpFullName) {
        log.info("initRootOrg,bizId:{}, corpId:{}, corpFullName:{}", new Object[]{bizId, corpId, corpFullName});
        Organization organization = new Organization();
        organization.setNum(this.idGen.getNum());
        organization.setBizId(bizId);
        organization.setName(corpFullName);
        organization.setPid(NumberUtils.LONG_ZERO);
        organization.setWeworkDepartmentId(NumberUtils.INTEGER_ONE);
        organization.setCorpId(corpId);
        organization.setOrigin(NumberUtils.INTEGER_ONE);
        organization.setCreateBy(NumberUtils.LONG_ZERO);
        organization.setUpdateBy(NumberUtils.LONG_ZERO);
        organization.setCreateTime(new Date());
        organization.setUpdateTime(new Date());
        organization.setIsDeleted(NumberUtils.INTEGER_ZERO);
        this.organizationMapper.insertSelective((Object)organization);
        return organization.getId();
    }

    private void initMobileEncryptSetting(Long bizId, String corpId) {
        Setting setting = new Setting();
        setting.setParamName(SettingEnum.MOBILE_ENCRYPT.getName());
        setting.setParamValue(String.valueOf(NumberUtils.LONG_ONE));
        setting.setDescription(SettingEnum.MOBILE_ENCRYPT.getDesc());
        setting.setType(Long.valueOf(SettingEnum.MOBILE_ENCRYPT.getId()));
        setting.setBizId(bizId);
        setting.setCreateBy(NumberUtils.LONG_MINUS_ONE);
        setting.setCreateTime(new Date());
        setting.setUpdateBy(NumberUtils.LONG_MINUS_ONE);
        setting.setUpdateTime(new Date());
        setting.setCorpId(corpId);
        this.settingMapper.insert((Object)setting);
    }

    private void initCustomerStage(Long bizId, String corpId) {
        CustomerStageEnum[] stageEnums;
        for (CustomerStageEnum stageEnum : stageEnums = CustomerStageEnum.values()) {
            CustomerStage customerStage = new CustomerStage();
            customerStage.setType(stageEnum.getType());
            customerStage.setStageValue(stageEnum.getValue());
            customerStage.setStageName(stageEnum.getDesc());
            customerStage.setCreateTime(new Date());
            customerStage.setUpdateTime(new Date());
            customerStage.setCorpId(corpId);
            customerStage.setBizId(bizId);
            if (stageEnum == CustomerStageEnum.DEAL) {
                customerStage.setUnableMod(Integer.valueOf(1));
            }
            this.customerStageMapper.insertSelective((Object)customerStage);
            if (stageEnum.getType() != 2) continue;
            String[] reasons = stageEnum == CustomerStageEnum.INVALID_CUSTOMER ? INVALID_CUSTOMER_REASONS : SHU_DAN_REASONS;
            this.customerStageReasonMapper.insertByParams(bizId, corpId, reasons, customerStage.getId());
        }
    }

    private void initReplyDefaultGroup(Long bizId, String corpId) {
        log.info("init Reply Default Group.. biz: {}, corpId: {}", (Object)bizId, (Object)corpId);
        QuickReplyGroup replyGroup = new QuickReplyGroup();
        replyGroup.setNum(this.idGen.getNum());
        replyGroup.setBizId(bizId);
        replyGroup.setCorpId(corpId);
        replyGroup.setGroupName("\u9ed8\u8ba4\u5206\u7ec4");
        replyGroup.setVisibleType(Integer.valueOf(1));
        replyGroup.setCreateBy(Long.valueOf(-1L));
        replyGroup.setCreateTime(new Date());
        replyGroup.setUpdateTime(new Date());
        replyGroup.setIsDefault(Integer.valueOf(1));
        this.replyGroupMapper.insertSelective((Object)replyGroup);
    }

    private void initSystemUser(Long bizId, String corpId, Long adminRoleId, Long rootOrgId) {
        User user = new User();
        user.setBizId(bizId);
        user.setCorpId(corpId);
        user.setNum(this.idGen.getNum());
        user.setName("root");
        user.setEnabled(NumberUtils.INTEGER_ONE);
        user.setMobile("root123456789");
        user.setNodeId(rootOrgId);
        user.setIsDeleted(NumberUtils.INTEGER_ZERO);
        user.setCreateBy(NumberUtils.LONG_MINUS_ONE);
        user.setUpdateBy(NumberUtils.LONG_MINUS_ONE);
        user.setCreateTime(new Date());
        user.setUpdateTime(new Date());
        user.setIsSystem(NumberUtils.INTEGER_ONE);
        user.setIsOpen(NumberUtils.INTEGER_ZERO);
        user.setIdentifier(user.getNum());
        this.userMapper.insertSelective((Object)user);
        this.initSystemUserRole(bizId, corpId, user.getId(), adminRoleId, rootOrgId);
    }

    private void initSystemUserRole(Long bizId, String corpId, Long userId, Long roleId, Long manageNodeId) {
        UserRole userRole = new UserRole();
        userRole.setUserId(userId);
        userRole.setRoleId(roleId);
        userRole.setBizId(bizId);
        userRole.setManageNodeId(manageNodeId);
        userRole.setCreateBy(NumberUtils.LONG_MINUS_ONE);
        userRole.setUpdateBy(NumberUtils.LONG_MINUS_ONE);
        userRole.setCreateTime(new Date());
        userRole.setUpdateTime(new Date());
        userRole.setIsDeleted(NumberUtils.INTEGER_ZERO);
        userRole.setCorpId(corpId);
        userRole.setLatestUseTime(new Date());
        this.userRoleMapper.insert((Object)userRole);
    }

    private void initBehaviorSetting(Long bizId, String corpId) {
        Integer[] behaviorSettings;
        for (Integer setting : behaviorSettings = new Integer[]{1, 2, 3, 4}) {
            QualityCheckBehaviorSetting behaviorSetting = new QualityCheckBehaviorSetting();
            behaviorSetting.setBizId(bizId);
            behaviorSetting.setCorpId(corpId);
            behaviorSetting.setCheckDesc(QualityBehaviorType.getByType((int)setting).getDesc());
            behaviorSetting.setCheckValue(setting);
            behaviorSetting.setCheckStatus(Integer.valueOf(0));
            behaviorSetting.setSenderType(QualitySenderType.WEWORK_USER.getType());
            behaviorSetting.setCreateTime(new Date());
            behaviorSetting.setCreateBy(Long.valueOf(-1L));
            behaviorSetting.setNum(this.idGen.getNum());
            this.qualityCheckBehaviorSettingMapper.insertSelective((Object)behaviorSetting);
        }
    }

    private void initWeworkTabSetting(Long bizId, String corpId) {
        String[] tabSettings = new String[]{"\u5ba2\u6237\u8be6\u60c5", "\u5f85\u529e\u4e8b\u9879", "\u5feb\u6377\u56de\u590d"};
        for (int i = 0; i < tabSettings.length; ++i) {
            String tabName = tabSettings[i];
            if (!StringUtils.isNotBlank((CharSequence)tabName)) continue;
            WeworkTabSetting querySetting = this.tabSettingMapper.querySetting(corpId, tabName);
            if (Objects.isNull(querySetting)) {
                WeworkTabSetting weworkTabSetting = new WeworkTabSetting();
                weworkTabSetting.setNum(this.idGen.getNum());
                weworkTabSetting.setBizId(bizId);
                weworkTabSetting.setCorpId(corpId);
                weworkTabSetting.setTabName(tabName);
                weworkTabSetting.setTabSeq(Integer.valueOf(i + 1));
                weworkTabSetting.setTabType(Integer.valueOf(1));
                weworkTabSetting.setStatus(Integer.valueOf(1));
                weworkTabSetting.setCreateBy(Long.valueOf(-1L));
                weworkTabSetting.setCreateTime(new Date());
                this.tabSettingMapper.insertSelective((Object)weworkTabSetting);
                log.info("initSystemTab insert tabName: {}, corpId: {}", (Object)tabName, (Object)corpId);
                continue;
            }
            log.info("initSystemTab tabName: {} is exit, corpId: {}", (Object)tabName, (Object)corpId);
        }
    }

    private void initRadarGroupTab(Long bizId, String corpId) {
        String[] groupList = new String[]{"\u5168\u90e8\u5206\u7ec4", "\u9ed8\u8ba4\u5206\u7ec4"};
        for (int i = 0; i < groupList.length; ++i) {
            String groupName = groupList[i];
            List radarGroups = this.marketingRadarGroupMapper.queryAllGroup(corpId, groupName);
            if (CollectionUtils.isEmpty((Collection)radarGroups)) {
                MarketingRadarGroup radarGroup = new MarketingRadarGroup();
                if (groupName.equals("\u9ed8\u8ba4\u5206\u7ec4")) {
                    radarGroup.setNum(this.idGen.getNum());
                } else {
                    radarGroup.setNum("");
                }
                radarGroup.setBizId(bizId);
                radarGroup.setCorpId(corpId);
                radarGroup.setCreateby("");
                radarGroup.setCreateTime(new Date());
                radarGroup.setUpdateTime(new Date());
                radarGroup.setIsDeleted(Integer.valueOf(0));
                radarGroup.setGroupName(groupName);
                radarGroup.setType(Integer.valueOf(1));
                this.marketingRadarGroupMapper.insert((Object)radarGroup);
                log.info("initRadarGroupTab insert groupName: {} corpId: {}", (Object)groupName, (Object)corpId);
                continue;
            }
            log.info("initRadarGroupTab groupName: {} is exit, corpId: {}", (Object)groupName, (Object)corpId);
        }
    }
}

