/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.synctask.service.impl;

import cn.kinyun.wework.sdk.api.external.ExternalTagApi;
import cn.kinyun.wework.sdk.entity.external.croptag.CorpTag;
import cn.kinyun.wework.sdk.entity.external.croptag.CorpTagGroup;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.CustomizedAppDevStatus;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.addfriend.mapper.AddFriendConfigTagMapper;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.transfer.dto.ContactQueryParams;
import com.kuaike.scrm.dal.weworktag.entity.WeworkTag;
import com.kuaike.scrm.dal.weworktag.entity.WeworkTagGroup;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagGroupMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.synctask.service.ExternalTagSyncService;
import com.kuaike.scrm.synctask.service.SyncTaskService;
import com.kuaike.scrm.synctask.service.enums.SyncTaskType;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.base.Objects;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExternalTagSyncServiceImpl
implements ExternalTagSyncService {
    private static final Logger log = LoggerFactory.getLogger(ExternalTagSyncServiceImpl.class);
    private static final String TAG_GROUP = "tag_group";
    private static final String TAG = "tag";
    @Autowired
    private IdGen idGen;
    @Autowired
    private ExternalTagApi externalTagApi;
    @Autowired
    private WeworkTagGroupMapper weworkTagGroupMapper;
    @Autowired
    private WeworkTagMapper weworkTagMapper;
    @Autowired
    private WeworkContactTagMapper weworkContactTagMapper;
    @Autowired
    private AddFriendConfigTagMapper addFriendConfigTagMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Autowired
    private SyncTaskService syncTaskService;
    @Autowired
    private ContactOpService contactOpService;

    @Override
    public Long sync() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"user not login");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        Long operatorId = user.getId();
        Integer devStatus = this.customizedTokenService.getAuthStatus(bizId);
        if (devStatus == null) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        if (devStatus.intValue() != CustomizedAppDevStatus.DONE.getValue()) {
            log.warn("\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210");
        }
        return this.syncTaskService.start(bizId, corpId, SyncTaskType.EXTERNAL_TAG, operatorId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void fetch(String corpId) {
        List fetchList;
        log.info("fetch external tag, corpId:{}", (Object)corpId);
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (accessToken == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        try {
            fetchList = this.externalTagApi.list(accessToken, null, null);
            log.info("fetch tag group, count:{}", (Object)fetchList.size());
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}", (Object)e.getMessage(), (Object)corpId);
            throw e;
        }
        catch (Exception e) {
            log.error("fetch tag list failed, corpId:{}", (Object)corpId, (Object)e);
            throw e;
        }
        String format = "%s##%s";
        List existsGroupList = this.weworkTagGroupMapper.queryTagGroupList(corpId);
        Map<Object, Object> existsGroupMap = CollectionUtils.isNotEmpty((Collection)existsGroupList) ? existsGroupList.stream().collect(Collectors.toMap(it -> it.getGroupId(), it -> it)) : Collections.emptyMap();
        List existsTagList = this.weworkTagMapper.queryByCorpId(corpId);
        Map<Object, Object> existsTagMap = CollectionUtils.isNotEmpty((Collection)existsTagList) ? existsTagList.stream().collect(Collectors.toMap(it -> String.format(format, it.getGroupId(), it.getTagId()), it -> it)) : Collections.emptyMap();
        if (CollectionUtils.isEmpty((Collection)fetchList)) {
            this.delExistsTagGroup(bizId, corpId, existsGroupMap.values());
            this.delExistsTag(bizId, corpId, existsTagMap.values());
            return;
        }
        ArrayList addGroupList = Lists.newArrayList();
        ArrayList addTagList = Lists.newArrayList();
        for (CorpTagGroup group : fetchList) {
            String groupId = group.getGroupId();
            log.info("tag group, id:{}, name:{}, order:{}, createTime:{}", new Object[]{group.getGroupId(), group.getGroupName(), group.getOrder(), group.getCreateTime()});
            WeworkTagGroup existGroup = (WeworkTagGroup)existsGroupMap.remove(groupId);
            if (this.diffTagGroup(existGroup, group)) {
                addGroupList.add(this.newTagGroup(bizId, corpId, group));
            }
            List tagList = group.getTagList();
            for (CorpTag tag : tagList) {
                String tagId = tag.getId();
                log.info("tag, id:{}, name:{}, order:{}, createTime:{}", new Object[]{tag.getId(), tag.getName(), tag.getOrder(), tag.getCreateTime()});
                String key = String.format(format, groupId, tagId);
                WeworkTag existTag = (WeworkTag)existsTagMap.remove(key);
                if (!this.diffTag(existTag, tag)) continue;
                addTagList.add(this.newTag(bizId, corpId, groupId, tag));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addGroupList)) {
            log.info("save tag groups, corpId:{}, list:{}", (Object)corpId, (Object)addGroupList);
            Lists.partition((List)addGroupList, (int)200).forEach(groups -> this.weworkTagGroupMapper.batchInsert((Collection)groups));
        }
        if (CollectionUtils.isNotEmpty((Collection)addTagList)) {
            log.info("save tags, corpId:{}, list:{}", (Object)corpId, (Object)addTagList);
            Lists.partition((List)addTagList, (int)200).forEach(tags -> this.weworkTagMapper.batchInsert((Collection)tags));
        }
        this.delExistsTagGroup(bizId, corpId, existsGroupMap.values());
        this.delExistsTag(bizId, corpId, existsTagMap.values());
        log.info("fetch tag finished, corpId:{}", (Object)corpId);
    }

    private boolean diffTagGroup(WeworkTagGroup exist, CorpTagGroup group) {
        if (exist == null) {
            log.info("tag group not exist, groupId:{}", (Object)group.getGroupId());
            return true;
        }
        if (!Objects.equal((Object)group.getGroupName(), (Object)exist.getGroupName())) {
            log.info("tag group updated, groupId:{}, name:{}", (Object)group.getGroupId(), (Object)group.getGroupName());
            return true;
        }
        if (!Objects.equal((Object)group.getOrder(), (Object)exist.getOrder())) {
            log.info("tag group updated, groupId:{}, order:{}", (Object)group.getGroupId(), (Object)group.getOrder());
            return true;
        }
        Long timestamp = null;
        if (exist.getAddTime() != null) {
            timestamp = exist.getAddTime().getTime() / 1000L;
        }
        if (!Objects.equal((Object)group.getCreateTime(), timestamp)) {
            log.info("tag group updated, groupId:{}, createTime:{}", (Object)group.getGroupId(), (Object)group.getCreateTime());
            return true;
        }
        return false;
    }

    private boolean diffTag(WeworkTag exist, CorpTag tag) {
        if (exist == null) {
            log.info("tag not exist, tagId:{}", (Object)tag.getId());
            return true;
        }
        if (!Objects.equal((Object)tag.getName(), (Object)exist.getName())) {
            log.info("tag updated, tagId:{}, name:{}", (Object)tag.getId(), (Object)tag.getName());
            return true;
        }
        if (!Objects.equal((Object)tag.getOrder(), (Object)exist.getOrder())) {
            log.info("tag updated, tagId:{}, order:{}", (Object)tag.getId(), (Object)tag.getOrder());
            return true;
        }
        Long timestamp = null;
        if (exist.getAddTime() != null) {
            timestamp = exist.getAddTime().getTime() / 1000L;
        }
        if (!Objects.equal((Object)tag.getCreateTime(), timestamp)) {
            log.info("tag updated, tagId:{}, createTime:{}", (Object)tag.getId(), (Object)tag.getCreateTime());
            return true;
        }
        return false;
    }

    private WeworkTagGroup newTagGroup(Long bizId, String corpId, CorpTagGroup tagGroup) {
        WeworkTagGroup weworkTagGroup = new WeworkTagGroup();
        weworkTagGroup.setBizId(bizId);
        weworkTagGroup.setCorpId(corpId);
        weworkTagGroup.setNum(this.idGen.getNum());
        weworkTagGroup.setGroupId(tagGroup.getGroupId());
        weworkTagGroup.setGroupName(tagGroup.getGroupName());
        weworkTagGroup.setOrder(tagGroup.getOrder());
        weworkTagGroup.setAddTime(new Date(tagGroup.getCreateTime() * 1000L));
        weworkTagGroup.setIsSysCreate(Integer.valueOf(0));
        weworkTagGroup.setCreateBy(Long.valueOf(-1L));
        weworkTagGroup.setUpdateBy(Long.valueOf(-1L));
        weworkTagGroup.setCreateTime(new Date());
        weworkTagGroup.setUpdateTime(new Date());
        return weworkTagGroup;
    }

    private WeworkTag newTag(Long bizId, String corpId, String groupId, CorpTag tag) {
        WeworkTag weworkTag = new WeworkTag();
        weworkTag.setBizId(bizId);
        weworkTag.setCorpId(corpId);
        weworkTag.setNum(this.idGen.getNum());
        weworkTag.setGroupId(groupId);
        weworkTag.setTagId(tag.getId());
        weworkTag.setName(tag.getName());
        weworkTag.setOrder(tag.getOrder());
        weworkTag.setAddTime(new Date(tag.getCreateTime() * 1000L));
        weworkTag.setIsSysCreate(Integer.valueOf(0));
        weworkTag.setCreateBy(Long.valueOf(-1L));
        weworkTag.setUpdateBy(Long.valueOf(-1L));
        weworkTag.setCreateTime(new Date());
        weworkTag.setUpdateTime(new Date());
        return weworkTag;
    }

    private void delExistsTagGroup(Long bizId, String corpId, Collection<WeworkTagGroup> groups) {
        if (CollectionUtils.isNotEmpty(groups)) {
            Set existsGroupIds = groups.stream().map(it -> it.getGroupId()).collect(Collectors.toSet());
            log.info("delete exists tag group, corpId:{}, groupIds:{}", (Object)corpId, existsGroupIds);
            this.weworkTagGroupMapper.delTagGroup(bizId, corpId, existsGroupIds, Long.valueOf(-1L));
        }
    }

    private void delExistsTag(Long bizId, String corpId, Collection<WeworkTag> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Set existsTagIds = list.stream().map(it -> it.getTagId()).collect(Collectors.toSet());
            log.info("delete exists tag, corpId:{}, tagIds:{}", (Object)corpId, existsTagIds);
            this.weworkTagMapper.delWeworkTagByTagId(bizId, corpId, existsTagIds, Long.valueOf(-1L));
            this.addFriendConfigTagMapper.logicDeleteCorpTags(corpId, existsTagIds, Long.valueOf(-1L));
        }
    }

    @Override
    public void modify(String accessToken, String corpId, String changeType, String type, String id, Long timestamp) {
        List tagGroupList;
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null");
            return;
        }
        if ("shuffle".equals(changeType)) {
            if (StringUtils.isEmpty((CharSequence)id)) {
                tagGroupList = this.externalTagApi.list(accessToken, null, null);
                ArrayList addGroupList = Lists.newArrayList();
                for (CorpTagGroup group : tagGroupList) {
                    addGroupList.add(this.newTagGroup(bizId, corpId, group));
                }
                Lists.partition((List)addGroupList, (int)200).forEach(groups -> this.weworkTagGroupMapper.batchInsert((Collection)groups));
            } else {
                tagGroupList = this.externalTagApi.list(accessToken, Collections.singletonList(id), null);
                CorpTagGroup group = (CorpTagGroup)tagGroupList.get(0);
                List tagList = group.getTagList();
                ArrayList addTagList = Lists.newArrayList();
                for (CorpTag tag : tagList) {
                    addTagList.add(this.newTag(bizId, corpId, group.getGroupId(), tag));
                }
                Lists.partition((List)addTagList, (int)200).forEach(tags -> this.weworkTagMapper.batchInsert((Collection)tags));
            }
        } else {
            switch (type) {
                case "tag_group": {
                    tagGroupList = this.externalTagApi.list(accessToken, Collections.singletonList(id), null);
                    CorpTagGroup group = (CorpTagGroup)tagGroupList.get(0);
                    WeworkTagGroup weworkTagGroup = this.newTagGroup(bizId, corpId, group);
                    this.weworkTagGroupMapper.batchInsert(Collections.singleton(weworkTagGroup));
                    break;
                }
                case "tag": {
                    tagGroupList = this.externalTagApi.list(accessToken, null, Collections.singletonList(id));
                    CorpTagGroup group = (CorpTagGroup)tagGroupList.get(0);
                    CorpTag tag = (CorpTag)group.getTagList().get(0);
                    WeworkTag weworkTag = this.newTag(bizId, corpId, group.getGroupId(), tag);
                    this.weworkTagMapper.batchInsert(Collections.singleton(weworkTag));
                    break;
                }
                default: {
                    return;
                }
            }
        }
        log.info("update tag:{}", (Object)tagGroupList);
    }

    @Override
    public void delete(String corpId, String type, String id, Long timestamp) {
        log.info("delete_external_tag, corpId:{}, type:{}, id:{}", new Object[]{corpId, type, id});
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null");
            return;
        }
        switch (type) {
            case "tag_group": {
                List tagIds = this.weworkTagMapper.queryExistTagIds(corpId, id);
                this.addFriendConfigTagMapper.logicDeleteCorpTags(corpId, (Collection)tagIds, Long.valueOf(-1L));
                this.weworkContactTagMapper.logicDeleteByTagIds(corpId, (Collection)tagIds, Long.valueOf(-1L));
                this.weworkTagGroupMapper.logicDeleteByGroupId(corpId, id, Long.valueOf(-1L));
                this.weworkTagMapper.logicDeleteByGroupId(corpId, id, Long.valueOf(-1L));
                ContactQueryParams queryParams = new ContactQueryParams();
                queryParams.setCorpId(corpId);
                queryParams.setTagIds((Set)Sets.newHashSet((Iterable)tagIds));
                List weworkContactTagList = this.weworkContactTagMapper.selectByContactQueryParams(queryParams);
                Set<String> keys = weworkContactTagList.stream().map(a -> String.format("%s##%s##%s", a.getCorpId(), a.getWeworkUserId(), a.getContactId())).collect(Collectors.toSet());
                keys.forEach(a -> {
                    String[] arr = a.split("##");
                    this.contactOpService.updateTagCount(arr[0], arr[1], arr[2]);
                });
                break;
            }
            case "tag": {
                this.weworkTagMapper.logicDeleteByTagId(corpId, id, Long.valueOf(-1L));
                this.weworkContactTagMapper.logicDeleteByTagIds(corpId, Collections.singleton(id), Long.valueOf(-1L));
                this.addFriendConfigTagMapper.logicDeleteCorpTags(corpId, Collections.singleton(id), Long.valueOf(-1L));
                List weworkContactTagList = this.weworkContactTagMapper.queryInfoByCorpAndTagId(corpId, id);
                Set<String> keys = weworkContactTagList.stream().map(a -> String.format("%s##%s##%s", a.getCorpId(), a.getWeworkUserId(), a.getContactId())).collect(Collectors.toSet());
                keys.forEach(a -> {
                    String[] arr = a.split("##");
                    this.contactOpService.updateTagCount(arr[0], arr[1], arr[2]);
                });
                break;
            }
        }
    }
}

