/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.setting.service.impl;

import cn.kinyun.wework.sdk.api.AccessTokenApi;
import cn.kinyun.wework.sdk.entity.AccessToken;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.accesstoken.entity.CorpContactToken;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpContactTokenMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.setting.dto.req.SetCorpSecretReq;
import com.kuaike.scrm.setting.dto.resp.GetCorpTokenCfg;
import com.kuaike.scrm.setting.service.SettingContactService;
import com.kuaike.scrm.token.service.RefreshTokenService;
import com.kuaike.scrm.token.utils.TokenGen;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class SettingContactServiceImpl
implements SettingContactService {
    private static final Logger log = LoggerFactory.getLogger(SettingContactServiceImpl.class);
    @Value(value="http://${qyapi.domain.scrm-callback}/contact/")
    private String callbackUrl;
    @Autowired
    private AccessTokenApi accessTokenApi;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private CorpContactTokenMapper corpContactTokenMapper;
    @Autowired
    private RefreshTokenService refreshTokenService;

    @Override
    public boolean set(SetCorpSecretReq params) {
        log.info("set secret, params:{}, operatorId:{}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((user.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)user.getCorpId()), (Object)"corpId\u4e3a\u7a7a");
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getSecret()), (Object)"secret\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        String secret = params.getSecret();
        Date now = new Date();
        boolean flag = false;
        CorpContactToken corpContactToken = this.corpContactTokenMapper.getAccessToken(corpId);
        if (corpContactToken == null) {
            AccessToken accessToken = this.getAccessToken(corpId, secret);
            corpContactToken = new CorpContactToken();
            corpContactToken.setBizId(bizId);
            corpContactToken.setCorpId(corpId);
            corpContactToken.setSecret(secret);
            corpContactToken.setAccessToken(accessToken.getAccessToken());
            corpContactToken.setExpireTime(new Date(now.getTime() + accessToken.getExpires() * 1000L));
            corpContactToken.setCreateTime(now);
            corpContactToken.setUpdateTime(now);
            log.info("insert secret:{}", (Object)corpContactToken);
            this.corpContactTokenMapper.insertSelective((Object)corpContactToken);
            flag = true;
        } else {
            if (secret.equals(corpContactToken.getSecret())) {
                log.info("secret not changed");
                return false;
            }
            AccessToken accessToken = this.getAccessToken(corpId, secret);
            corpContactToken.setSecret(secret);
            if (!accessToken.getAccessToken().equals(corpContactToken.getAccessToken())) {
                log.info("update access_token");
                corpContactToken.setAccessToken(accessToken.getAccessToken());
                corpContactToken.setExpireTime(new Date(now.getTime() + accessToken.getExpires() * 1000L));
            }
            corpContactToken.setUpdateTime(now);
            log.info("update secret:{}", (Object)corpContactToken);
            this.corpContactTokenMapper.updateByPrimaryKeySelective((Object)corpContactToken);
            this.refreshTokenService.freshContactAccessToken(corpId, accessToken);
            flag = true;
        }
        return flag;
    }

    private AccessToken getAccessToken(String corpId, String secret) {
        AccessToken accessToken = null;
        try {
            accessToken = this.accessTokenApi.getAccessToken(corpId, secret);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}, secret:{}", new Object[]{e.getMessage(), corpId, secret});
        }
        catch (Exception e) {
            log.error("Failed getting accessToken, corpId:{}, secret:{}", new Object[]{e, corpId, secret});
        }
        Preconditions.checkArgument((accessToken != null ? 1 : 0) != 0, (Object)"\u65e0\u6548\u7684secret");
        return accessToken;
    }

    @Override
    public GetCorpTokenCfg detail() {
        log.info("get token detail, operatorId:{}", (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((user.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)user.getCorpId()), (Object)"corpId\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        WeworkCorp corp = this.weworkCorpMapper.getByCorpId(corpId);
        Preconditions.checkArgument((corp != null ? 1 : 0) != 0, (Object)"corp\u4e3a\u7a7a");
        CorpContactToken corpContactToken = this.corpContactTokenMapper.queryByCorpId(corpId);
        if (corpContactToken == null) {
            corpContactToken = new CorpContactToken();
            corpContactToken.setBizId(bizId);
            corpContactToken.setCorpId(corpId);
            corpContactToken.setToken(TokenGen.getRandomToken());
            corpContactToken.setAesKey(TokenGen.getRandomAESKey());
            corpContactToken.setCreateTime(new Date());
            corpContactToken.setUpdateTime(new Date());
            log.info("insert secret:{}", (Object)corpContactToken);
            this.corpContactTokenMapper.insertSelective((Object)corpContactToken);
        }
        GetCorpTokenCfg result = new GetCorpTokenCfg();
        result.setSecret(corpContactToken.getSecret());
        result.setCallbackUrl(this.callbackUrl + corp.getNum());
        result.setAeskey(corpContactToken.getAesKey());
        result.setToken(corpContactToken.getToken());
        return result;
    }

    @Override
    public String rndAeskey() {
        log.info("generate random aeskey, operatorId:{}", (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((user.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)user.getCorpId()), (Object)"corpId\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        CorpContactToken corpContactToken = this.corpContactTokenMapper.getCryptToken(corpId);
        if (corpContactToken == null) {
            corpContactToken = new CorpContactToken();
            corpContactToken.setBizId(bizId);
            corpContactToken.setCorpId(corpId);
            corpContactToken.setAesKey(TokenGen.getRandomAESKey());
            corpContactToken.setCreateTime(new Date());
            corpContactToken.setUpdateTime(new Date());
            log.info("insert aeskey:{}", (Object)corpContactToken);
            this.corpContactTokenMapper.insertSelective((Object)corpContactToken);
        } else {
            corpContactToken.setAesKey(TokenGen.getRandomAESKey());
            corpContactToken.setUpdateTime(new Date());
            log.info("update aeskey:{}", (Object)corpContactToken);
            this.corpContactTokenMapper.updateByPrimaryKeySelective((Object)corpContactToken);
        }
        return corpContactToken.getAesKey();
    }

    @Override
    public String rndToken() {
        log.info("generate random token, operatorId:{}", (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((user.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)user.getCorpId()), (Object)"corpId\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        CorpContactToken corpContactToken = this.corpContactTokenMapper.getCryptToken(corpId);
        if (corpContactToken == null) {
            corpContactToken = new CorpContactToken();
            corpContactToken.setBizId(bizId);
            corpContactToken.setCorpId(corpId);
            corpContactToken.setToken(TokenGen.getRandomToken());
            corpContactToken.setCreateTime(new Date());
            corpContactToken.setUpdateTime(new Date());
            log.info("insert token:{}", (Object)corpContactToken);
            this.corpContactTokenMapper.insertSelective((Object)corpContactToken);
        } else {
            corpContactToken.setToken(TokenGen.getRandomToken());
            corpContactToken.setUpdateTime(new Date());
            log.info("update token:{}", (Object)corpContactToken);
            this.corpContactTokenMapper.updateByPrimaryKeySelective((Object)corpContactToken);
        }
        return corpContactToken.getToken();
    }
}

