/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.token.service.impl;

import cn.kinyun.wework.sdk.api.AccessTokenApi;
import cn.kinyun.wework.sdk.entity.AccessToken;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.kuaike.scrm.dal.accesstoken.entity.CorpAgentToken;
import com.kuaike.scrm.dal.accesstoken.entity.CorpContactToken;
import com.kuaike.scrm.dal.accesstoken.entity.CorpExternalContactToken;
import com.kuaike.scrm.dal.accesstoken.entity.CorpMiniProgramToken;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpAgentTokenMapper;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpContactTokenMapper;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpExternalContactTokenMapper;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpMiniProgramTokenMapper;
import com.kuaike.scrm.dal.agent.entity.AgentToken;
import com.kuaike.scrm.dal.agent.mapper.AgentTokenMapper;
import com.kuaike.scrm.dal.chat.entity.WeworkChatSecret;
import com.kuaike.scrm.dal.chat.mapper.WeworkChatSecretMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.token.service.RefreshTokenService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RefreshTokenServiceImpl
implements RefreshTokenService {
    private static final Logger log = LoggerFactory.getLogger(RefreshTokenServiceImpl.class);
    @Autowired
    private AccessTokenApi accessTokenApi;
    @Autowired
    private WeworkChatSecretMapper weworkChatSecretMapper;
    @Autowired
    private CorpContactTokenMapper corpContactTokenMapper;
    @Autowired
    private CorpExternalContactTokenMapper corpExternalContactTokenMapper;
    @Autowired
    private CorpAgentTokenMapper corpAgentTokenMapper;
    @Autowired
    private AgentTokenMapper agentTokenMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private CorpMiniProgramTokenMapper corpMiniProgramTokenMapper;

    @Override
    public void refreshAgentToken() {
        List corpIds = this.weworkCorpMapper.selectAllAuthedCorpIds();
        if (CollectionUtils.isEmpty((Collection)corpIds)) {
            return;
        }
        List tokenList = this.corpAgentTokenMapper.queryByCorpIds((Collection)corpIds);
        if (CollectionUtils.isEmpty((Collection)tokenList)) {
            return;
        }
        log.info("refresh corp_agent_token, size={}", (Object)tokenList.size());
        for (CorpAgentToken agentToken : tokenList) {
            this.freshAgentToken(agentToken);
        }
    }

    private void freshAgentToken(CorpAgentToken corpAgentToken) {
        String corpSecret = corpAgentToken.getSecret();
        String corpId = corpAgentToken.getCorpId();
        if (StringUtils.isBlank((CharSequence)corpAgentToken.getSecret()) && StringUtils.isNotBlank((CharSequence)corpAgentToken.getErrBizMsg())) {
            return;
        }
        AccessToken accessToken = this.getAgentToken(corpSecret, corpId);
        this.freshCorpAgentAccessToken(corpId, accessToken);
    }

    @Override
    public void freshCorpAgentAccessToken(String corpId, AccessToken accessToken) {
        if (accessToken == null) {
            return;
        }
        CorpAgentToken agentToken = this.corpAgentTokenMapper.queryByCorpId(corpId);
        String token = accessToken.getAccessToken();
        Date now = new Date();
        Long expires = accessToken.getExpires();
        Date expireTime = new Date(now.getTime() + expires * 1000L);
        this.corpAgentTokenMapper.updateAccessToken(agentToken.getId(), token, expireTime, now, null, Integer.valueOf(0), null, null);
    }

    @Override
    public void freshAgent2AccessToken(String corpId, AccessToken accessToken) {
        if (accessToken == null) {
            return;
        }
        AgentToken agentToken = this.agentTokenMapper.queryByCorpId(corpId);
        String token = accessToken.getAccessToken();
        Date now = new Date();
        Long expires = accessToken.getExpires();
        Date expireTime = new Date(now.getTime() + expires * 1000L);
        this.agentTokenMapper.updateAccessToken(agentToken.getId(), token, expireTime, now, null, Integer.valueOf(0), null, null);
    }

    @Override
    public AccessToken getAgentToken(String corpSecret, String corpId) {
        Date now = new Date();
        if (StringUtils.isBlank((CharSequence)corpSecret)) {
            this.corpAgentTokenMapper.updateErrBizMsg(corpId, "\u672a\u8bbe\u7f6esecret", now, now);
            return null;
        }
        AccessToken accessToken = null;
        try {
            log.info("getAgentToken with corpId={}", (Object)corpId);
            accessToken = this.accessTokenApi.getAccessToken(corpId, corpSecret);
        }
        catch (WeworkException e) {
            log.error("{}, corpId={}", (Object)e.getMessage(), (Object)corpId);
            if (this.isWXServerUnavailable(e.getErrorCode())) {
                log.info("server not available,corpId={},accessToken={}", (Object)corpId, (Object)accessToken);
                return null;
            }
            this.corpAgentTokenMapper.updateWhenWxError(corpId, e.getErrorCode(), e.getErrorMsg(), now, now);
            return null;
        }
        catch (Exception e) {
            log.error("get AgentToken with error,corpId={}", (Object)corpId, (Object)e);
            String errBizMessage = StringUtils.abbreviate((String)e.getMessage(), (int)32);
            this.corpAgentTokenMapper.updateErrBizMsg(corpId, errBizMessage, now, now);
            return null;
        }
        return accessToken;
    }

    @Override
    public AccessToken getAgent2Token(String corpSecret, String corpId) {
        Date now = new Date();
        if (StringUtils.isBlank((CharSequence)corpSecret)) {
            this.agentTokenMapper.updateErrBizMsg(corpId, "\u672a\u8bbe\u7f6esecret", now, now);
            return null;
        }
        AccessToken accessToken = null;
        try {
            log.info("getAgentToken with corpId={}", (Object)corpId);
            accessToken = this.accessTokenApi.getAccessToken(corpId, corpSecret);
        }
        catch (WeworkException e) {
            log.error("{}, corpId={}", (Object)e.getMessage(), (Object)corpId);
            if (this.isWXServerUnavailable(e.getErrorCode())) {
                log.info("server not available,corpId={},accessToken={}", (Object)corpId, (Object)accessToken);
                return null;
            }
            this.agentTokenMapper.updateWhenWxError(corpId, e.getErrorCode(), e.getErrorMsg(), now, now);
            return null;
        }
        catch (Exception e) {
            log.error("get AgentToken with error,corpId={}", (Object)corpId, (Object)e);
            String errBizMessage = StringUtils.abbreviate((String)e.getMessage(), (int)32);
            this.agentTokenMapper.updateErrBizMsg(corpId, errBizMessage, now, now);
            return null;
        }
        return accessToken;
    }

    private boolean isWXServerUnavailable(Integer code) {
        if (code == null) {
            return false;
        }
        return code == -1 || code == 6000;
    }

    @Override
    public void refreshChatToken() {
        List chatSecrets = this.weworkChatSecretMapper.queryAll();
        if (CollectionUtils.isEmpty((Collection)chatSecrets)) {
            return;
        }
        log.info("refresh chat_token, size={}", (Object)chatSecrets.size());
        for (WeworkChatSecret chatSecret : chatSecrets) {
            this.freshChatSecret(chatSecret);
        }
    }

    private void freshChatSecret(WeworkChatSecret weworkChatSecret) {
        String corpSecret = weworkChatSecret.getSecret();
        String corpId = weworkChatSecret.getCorpId();
        if (StringUtils.isBlank((CharSequence)weworkChatSecret.getSecret()) && StringUtils.isNotBlank((CharSequence)weworkChatSecret.getErrBizMsg())) {
            return;
        }
        AccessToken accessToken = this.getChatAccessToken(corpSecret, corpId);
        this.freshChatAccessToken(corpId, accessToken);
    }

    @Override
    public void freshChatAccessToken(String corpId, AccessToken accessToken) {
        if (accessToken == null) {
            return;
        }
        WeworkChatSecret chatSecret = this.weworkChatSecretMapper.queryByCorpId(corpId);
        String token = accessToken.getAccessToken();
        Date now = new Date();
        Long expires = accessToken.getExpires();
        Date expireTime = new Date(now.getTime() + expires * 1000L);
        this.weworkChatSecretMapper.updateAccessToken(chatSecret.getId(), token, expireTime, now, null, Integer.valueOf(0), null, null);
    }

    @Override
    public AccessToken getChatAccessToken(String chatSecret, String corpId) {
        Date now = new Date();
        if (StringUtils.isBlank((CharSequence)chatSecret)) {
            this.weworkChatSecretMapper.updateErrBizMsg(corpId, "\u672a\u8bbe\u7f6esecret", now, now);
            return null;
        }
        AccessToken accessToken = null;
        try {
            log.info("getChatAccessToken with corpId={}", (Object)corpId);
            accessToken = this.accessTokenApi.getAccessToken(corpId, chatSecret);
        }
        catch (WeworkException e) {
            log.error("{}, corpId={}", (Object)e.getMessage(), (Object)corpId);
            if (this.isWXServerUnavailable(e.getErrorCode())) {
                log.info("server not available,corpId={},accessToken={}", (Object)corpId, (Object)accessToken);
                return null;
            }
            this.weworkChatSecretMapper.updateWhenWxError(corpId, e.getErrorCode(), e.getErrorMsg(), now, now);
            return null;
        }
        catch (Exception e) {
            log.error("get chatToken with error,corpId={}", (Object)corpId, (Object)e);
            String errBizMessage = StringUtils.abbreviate((String)e.getMessage(), (int)32);
            this.weworkChatSecretMapper.updateErrBizMsg(corpId, errBizMessage, now, now);
            return null;
        }
        return accessToken;
    }

    @Override
    public void refreshContactToken() {
        List corpIds = this.weworkCorpMapper.selectAllAuthedCorpIds();
        if (CollectionUtils.isEmpty((Collection)corpIds)) {
            return;
        }
        List corpContactTokenList = this.corpContactTokenMapper.queryByCorpIds((Collection)corpIds);
        if (CollectionUtils.isEmpty((Collection)corpContactTokenList)) {
            return;
        }
        log.info("refresh corp_contact_token, size={}", (Object)corpContactTokenList.size());
        for (CorpContactToken corpContactToken : corpContactTokenList) {
            this.freshContactToken(corpContactToken);
        }
    }

    @Override
    public void refreshMiniProgramToken() {
        List corpMiniProgramTokenList = this.corpMiniProgramTokenMapper.queryList();
        if (CollectionUtils.isEmpty((Collection)corpMiniProgramTokenList)) {
            return;
        }
        log.info("refresh corp_mini_program, size={}", (Object)corpMiniProgramTokenList.size());
        for (CorpMiniProgramToken miniProgramToken : corpMiniProgramTokenList) {
            this.freshMiniProgramToken(miniProgramToken);
        }
    }

    private void freshMiniProgramToken(CorpMiniProgramToken corpMiniProgramToken) {
        String corpSecret = corpMiniProgramToken.getSecret();
        String corpId = corpMiniProgramToken.getCorpId();
        if (StringUtils.isBlank((CharSequence)corpMiniProgramToken.getSecret()) && StringUtils.isNotBlank((CharSequence)corpMiniProgramToken.getErrBizMsg())) {
            return;
        }
        AccessToken accessToken = this.getMiniProgramAccessToken(corpSecret, corpId);
        this.freshMiniProgramAccessToken(corpId, accessToken);
    }

    private void freshContactToken(CorpContactToken contactToken) {
        String corpSecret = contactToken.getSecret();
        String corpId = contactToken.getCorpId();
        if (StringUtils.isBlank((CharSequence)contactToken.getSecret()) && StringUtils.isNotBlank((CharSequence)contactToken.getErrBizMsg())) {
            return;
        }
        AccessToken accessToken = this.getContactAccessToken(corpSecret, corpId);
        this.freshContactAccessToken(corpId, accessToken);
    }

    @Override
    public void freshContactAccessToken(String corpId, AccessToken accessToken) {
        if (accessToken == null) {
            return;
        }
        CorpContactToken contactToken = this.corpContactTokenMapper.queryByCorpId(corpId);
        String token = accessToken.getAccessToken();
        Date now = new Date();
        Long expires = accessToken.getExpires();
        Date expireTime = new Date(now.getTime() + expires * 1000L);
        this.corpContactTokenMapper.updateAccessToken(contactToken.getId(), token, expireTime, now, null, Integer.valueOf(0), null, null);
    }

    @Override
    public void freshMiniProgramAccessToken(String corpId, AccessToken accessToken) {
        if (accessToken == null) {
            return;
        }
        CorpMiniProgramToken miniProgramToken = this.corpMiniProgramTokenMapper.queryByCorpId(corpId);
        String token = accessToken.getAccessToken();
        Date now = new Date();
        Long expires = accessToken.getExpires();
        Date expireTime = new Date(now.getTime() + expires * 1000L);
        this.corpMiniProgramTokenMapper.updateAccessToken(miniProgramToken.getId(), token, expireTime, now, null, Integer.valueOf(0), null, null);
    }

    @Override
    public AccessToken getContactAccessToken(String corpSecret, String corpId) {
        Date now = new Date();
        if (StringUtils.isBlank((CharSequence)corpSecret)) {
            this.corpContactTokenMapper.updateErrBizMsg(corpId, "\u672a\u8bbe\u7f6esecret", now, now);
            return null;
        }
        AccessToken accessToken = null;
        try {
            log.info("getContactAccessToken with corpId={}", (Object)corpId);
            accessToken = this.accessTokenApi.getAccessToken(corpId, corpSecret);
        }
        catch (WeworkException e) {
            log.error("{}, corpId={}", (Object)e.getMessage(), (Object)corpId);
            if (this.isWXServerUnavailable(e.getErrorCode())) {
                log.info("server not available,corpId={},accessToken={}", (Object)corpId, (Object)accessToken);
                return null;
            }
            this.corpContactTokenMapper.updateWhenWxError(corpId, e.getErrorCode(), e.getErrorMsg(), now, now);
            return null;
        }
        catch (Exception e) {
            log.error("get contactToken with error,corpId={}", (Object)corpId, (Object)e);
            String errBizMessage = StringUtils.abbreviate((String)e.getMessage(), (int)32);
            this.corpContactTokenMapper.updateErrBizMsg(corpId, errBizMessage, now, now);
            return null;
        }
        return accessToken;
    }

    @Override
    public AccessToken getMiniProgramAccessToken(String corpSecret, String corpId) {
        Date now = new Date();
        if (StringUtils.isBlank((CharSequence)corpSecret)) {
            this.corpMiniProgramTokenMapper.updateErrBizMsg(corpId, "\u672a\u8bbe\u7f6esecret", now, now);
            return null;
        }
        AccessToken accessToken = null;
        try {
            log.info("getMiniProgramToken with corpId={}", (Object)corpId);
            accessToken = this.accessTokenApi.getAccessToken(corpId, corpSecret);
        }
        catch (WeworkException e) {
            log.error("{}, corpId={}", (Object)e.getMessage(), (Object)corpId);
            if (this.isWXServerUnavailable(e.getErrorCode())) {
                log.info("server not available,corpId={},accessToken={}", (Object)corpId, (Object)accessToken);
                return null;
            }
            this.corpMiniProgramTokenMapper.updateWhenWxError(corpId, e.getErrorCode(), e.getErrorMsg(), now, now);
            return null;
        }
        catch (Exception e) {
            log.error("get contactToken with error,corpId={}", (Object)corpId, (Object)e);
            String errBizMessage = StringUtils.abbreviate((String)e.getMessage(), (int)32);
            this.corpMiniProgramTokenMapper.updateErrBizMsg(corpId, errBizMessage, now, now);
            return null;
        }
        return accessToken;
    }

    @Override
    public void refreshExternalContactToken() {
        List corpIds = this.weworkCorpMapper.selectAllAuthedCorpIds();
        if (CollectionUtils.isEmpty((Collection)corpIds)) {
            return;
        }
        List externalContactTokenList = this.corpExternalContactTokenMapper.queryByCorpIds((Collection)corpIds);
        if (CollectionUtils.isEmpty((Collection)externalContactTokenList)) {
            return;
        }
        log.info("refresh corp_external_contact_token, size={}", (Object)externalContactTokenList.size());
        for (CorpExternalContactToken corpExternalContactToken : externalContactTokenList) {
            this.freshExternalContactToken(corpExternalContactToken);
        }
    }

    private void freshExternalContactToken(CorpExternalContactToken externalContactToken) {
        String corpSecret = externalContactToken.getSecret();
        String corpId = externalContactToken.getCorpId();
        if (StringUtils.isBlank((CharSequence)externalContactToken.getSecret()) && StringUtils.isNotBlank((CharSequence)externalContactToken.getErrBizMsg())) {
            return;
        }
        AccessToken accessToken = this.getExternalContactAccessToken(corpSecret, corpId);
        this.freshExternalContactAccessToken(corpId, accessToken);
    }

    @Override
    public void freshExternalContactAccessToken(String corpId, AccessToken accessToken) {
        if (accessToken == null) {
            return;
        }
        CorpExternalContactToken externalContactToken = this.corpExternalContactTokenMapper.queryByCorpId(corpId);
        String token = accessToken.getAccessToken();
        Date now = new Date();
        Long expires = accessToken.getExpires();
        Date expireTime = new Date(now.getTime() + expires * 1000L);
        this.corpExternalContactTokenMapper.updateAccessToken(externalContactToken.getId(), token, expireTime, now, null, Integer.valueOf(0), null, null);
    }

    @Override
    public AccessToken getExternalContactAccessToken(String corpSecret, String corpId) {
        Date now = new Date();
        if (StringUtils.isBlank((CharSequence)corpSecret)) {
            this.corpExternalContactTokenMapper.updateErrBizMsg(corpId, "\u672a\u8bbe\u7f6esecret", now, now);
            return null;
        }
        AccessToken accessToken = null;
        try {
            log.info("getExternalAccessToken with corpId={}", (Object)corpId);
            accessToken = this.accessTokenApi.getAccessToken(corpId, corpSecret);
        }
        catch (WeworkException e) {
            log.error("{}, corpId={}", (Object)e.getMessage(), (Object)corpId);
            if (this.isWXServerUnavailable(e.getErrorCode())) {
                log.info("server not available,corpId={},accessToken={}", (Object)corpId, (Object)accessToken);
                return null;
            }
            this.corpExternalContactTokenMapper.updateWhenWxError(corpId, e.getErrorCode(), e.getErrorMsg(), now, now);
            return null;
        }
        catch (Exception e1) {
            log.error("get externalContactToken with error,corpId={}", (Object)corpId, (Object)e1);
            String errBizMessage = StringUtils.abbreviate((String)e1.getMessage(), (int)32);
            this.corpExternalContactTokenMapper.updateErrBizMsg(corpId, errBizMessage, now, now);
            return null;
        }
        return accessToken;
    }
}

