/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.token.service.impl;

import cn.kinyun.wework.sdk.api.ProviderApi;
import cn.kinyun.wework.sdk.api.SuiteApi;
import cn.kinyun.wework.sdk.callback.suite.auth.SuiteTicket;
import cn.kinyun.wework.sdk.entity.provider.ProviderToken;
import cn.kinyun.wework.sdk.entity.suite.SuiteToken;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.kuaike.scrm.dal.accesstoken.entity.QyapiProviderToken;
import com.kuaike.scrm.dal.accesstoken.entity.QyapiSuiteToken;
import com.kuaike.scrm.dal.accesstoken.mapper.QyapiProviderTokenMapper;
import com.kuaike.scrm.dal.accesstoken.mapper.QyapiSuiteTokenMapper;
import com.kuaike.scrm.token.service.ProviderTokenService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProviderTokenServiceImpl
implements ProviderTokenService {
    private static final Logger log = LoggerFactory.getLogger(ProviderTokenServiceImpl.class);
    @Value(value="${qyapi.corp.id}")
    private String corpId;
    @Value(value="${qyapi.suite.id}")
    private String suiteId;
    @Autowired
    private SuiteApi suiteApi;
    @Autowired
    private ProviderApi providerApi;
    @Autowired
    private QyapiProviderTokenMapper qyapiProviderTokenMapper;
    @Autowired
    private QyapiSuiteTokenMapper qyapiSuiteTokenMapper;

    @Override
    public String getProviderToken() {
        return this.getProviderToken(this.corpId);
    }

    @Override
    public String getProviderToken(String corpId) {
        QyapiProviderToken existRecord = this.qyapiProviderTokenMapper.getAccessToken(corpId);
        if (existRecord == null) {
            log.warn("qyapi_provider_token not found, corpId:{}", (Object)corpId);
            return null;
        }
        Date now = new Date();
        String token = existRecord.getAccessToken();
        Date expireTime = existRecord.getExpireTime();
        if (StringUtils.isNotBlank((CharSequence)token) && expireTime != null && expireTime.after(now)) {
            return token;
        }
        String corpSecret = existRecord.getProviderSecret();
        ProviderToken accessToken = this.providerApi.getProviderToken(corpId, corpSecret);
        token = accessToken.getProviderAccessToken();
        Long expires = accessToken.getExpires();
        expireTime = new Date(now.getTime() + expires * 1000L);
        QyapiProviderToken qyapiProviderToken = new QyapiProviderToken();
        qyapiProviderToken.setId(existRecord.getId());
        qyapiProviderToken.setAccessToken(token);
        qyapiProviderToken.setExpireTime(expireTime);
        qyapiProviderToken.setUpdateTime(now);
        this.qyapiProviderTokenMapper.updateByPrimaryKeySelective((Object)qyapiProviderToken);
        return token;
    }

    @Override
    public String getSuiteId() {
        return this.suiteId;
    }

    @Override
    public String getSuiteAccessToken() {
        return this.getSuiteAccessToken(this.suiteId);
    }

    @Override
    public String getSuiteAccessToken(String suiteId) {
        QyapiSuiteToken existRecord = this.qyapiSuiteTokenMapper.getAccessToken(suiteId);
        if (existRecord == null) {
            log.warn("Suite not found, suiteId:{}", (Object)suiteId);
            return null;
        }
        Date now = new Date();
        String token = existRecord.getAccessToken();
        Date expireTime = existRecord.getAccessTokenExpireTime();
        if (StringUtils.isNotBlank((CharSequence)token) && expireTime != null && expireTime.after(now)) {
            return token;
        }
        String suiteTicket = existRecord.getSuiteTicket();
        String suiteSecret = existRecord.getSuiteSecret();
        SuiteToken suiteToken = null;
        try {
            suiteToken = this.suiteApi.getSuiteToken(suiteId, suiteSecret, suiteTicket);
        }
        catch (WeworkException e) {
            log.error("get suiteToken with weworkException,corpId={}", (Object)this.corpId, (Object)e);
            return null;
        }
        catch (Exception e) {
            log.error("get CorpSuiteToken with error,corpId={}", (Object)this.corpId, (Object)e);
            return null;
        }
        token = suiteToken.getSuiteAccessToken();
        Long expires = suiteToken.getExpires();
        expireTime = new Date(now.getTime() + expires * 1000L);
        QyapiSuiteToken qyapiSuiteToken = new QyapiSuiteToken();
        qyapiSuiteToken.setId(existRecord.getId());
        qyapiSuiteToken.setAccessToken(token);
        qyapiSuiteToken.setAccessTokenExpireTime(expireTime);
        qyapiSuiteToken.setUpdateTime(now);
        this.qyapiSuiteTokenMapper.updateByPrimaryKeySelective((Object)qyapiSuiteToken);
        return token;
    }

    @Override
    public void setSuiteTicket(SuiteTicket suiteTicket) {
        String suiteId = suiteTicket.getSuiteId();
        String ticket = suiteTicket.getSuiteTicket();
        Long timestamp = suiteTicket.getTimestamp();
        Date suiteTicketUpdateTime = new Date(timestamp * 1000L);
        QyapiSuiteToken suiteToken = this.qyapiSuiteTokenMapper.getAccessToken(suiteId);
        if (suiteToken == null) {
            log.info("save suite_ticket, suiteId:{}, suiteTicket:{}", (Object)suiteId, (Object)ticket);
            QyapiSuiteToken qyapiSuiteToken = new QyapiSuiteToken();
            qyapiSuiteToken.setSuiteId(suiteId);
            qyapiSuiteToken.setSuiteTicket(ticket);
            qyapiSuiteToken.setSuiteTicketUpdateTime(suiteTicketUpdateTime);
            qyapiSuiteToken.setCreateTime(new Date());
            qyapiSuiteToken.setUpdateTime(new Date());
            this.qyapiSuiteTokenMapper.insertSelective((Object)qyapiSuiteToken);
        } else {
            log.info("update suite_ticket, suiteId:{}, suiteTicket:{}", (Object)suiteId, (Object)ticket);
            QyapiSuiteToken qyapiSuiteToken = new QyapiSuiteToken();
            qyapiSuiteToken.setId(suiteToken.getId());
            qyapiSuiteToken.setSuiteTicket(ticket);
            qyapiSuiteToken.setSuiteTicketUpdateTime(new Date());
            qyapiSuiteToken.setUpdateTime(new Date());
            this.qyapiSuiteTokenMapper.updateByPrimaryKeySelective((Object)qyapiSuiteToken);
        }
    }
}

