/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.websocket.session;

import com.google.common.collect.Lists;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.utils.RedisDistributedLock;
import com.kuaike.scrm.websocket.model.WebSocketClientSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisSessionManager {
    private static final Logger log = LoggerFactory.getLogger(RedisSessionManager.class);
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private RedisDistributedLock lock;
    @Value(value="${spring.redis.key.prefix}${sessionKey.account:ws-session-account}")
    private String accountKey;
    @Value(value="${spring.cloud.client.ip-address}")
    private String host;
    @Value(value="${server.port}")
    private Integer port;
    private static final int PAGE_SIZE = 200;

    public void initialize() {
        this.clear(this.host);
    }

    public WebSocketClientSession getSession(String account) {
        Object obj = this.redisTemplate.opsForHash().get((Object)this.accountKey, (Object)account);
        return this.toClientSession(obj);
    }

    public void register(WebSocketClientSession session) {
        session.setIp(this.host);
        session.setPort(this.port);
        String account = session.getAccount();
        String hostKey = this.accountKey + ":" + this.host;
        try {
            String json;
            WebSocketClientSession existSession;
            String existIp;
            HashOperations ipTable = this.redisTemplate.opsForHash();
            SetOperations accountSet = this.redisTemplate.opsForSet();
            Object existObj = ipTable.get((Object)this.accountKey, (Object)account);
            if (this.isNotNull(existObj) && !this.host.equals(existIp = (existSession = (WebSocketClientSession)JacksonUtil.str2Obj((String)(json = String.valueOf(existObj)), WebSocketClientSession.class)).getIp())) {
                accountSet.remove((Object)(this.accountKey + ":" + existIp), new Object[]{account});
                log.info("remove account={} from exist host={}", (Object)account, (Object)existIp);
            }
            json = JacksonUtil.obj2Str((Object)session);
            ipTable.put((Object)this.accountKey, (Object)account, (Object)json);
            accountSet.add((Object)hostKey, (Object[])new String[]{account});
            log.info("register account={} to host={}", (Object)account, (Object)json);
        }
        catch (Exception e) {
            log.error("Failed to register account:{}", (Object)account, (Object)e);
        }
    }

    public void unregister(String account) {
        String hostKey = this.accountKey + ":" + this.host;
        try {
            log.info("try unregister account={} from host={}", (Object)account, (Object)this.host);
            HashOperations ipTable = this.redisTemplate.opsForHash();
            SetOperations accountSet = this.redisTemplate.opsForSet();
            ipTable.delete((Object)this.accountKey, new Object[]{account});
            accountSet.remove((Object)hostKey, new Object[]{account});
            log.info("unregister account={} from host={}", (Object)account, (Object)this.host);
        }
        catch (Exception e) {
            log.error("Failed to unregister account:{}", (Object)account, (Object)e);
        }
    }

    public void terminate() {
        this.clear(this.host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String host) {
        log.info("clear host:{} session in redis.", (Object)host);
        String hostKey = this.accountKey + ":" + host;
        String lockKey = this.accountKey + ":CLEAR_LOCK:" + host;
        try {
            this.lock.lock(lockKey, 300, 30L, 100L);
            List<WebSocketClientSession> sessionList = this.getClientSessionList(host);
            if (sessionList.isEmpty()) {
                log.info("no members to clear on host:{}", (Object)host);
            } else {
                HashSet accounts = new HashSet();
                sessionList.forEach(it -> accounts.add(it.getAccount()));
                log.info("clear host:{}, members:{}", (Object)host, accounts);
                this.redisTemplate.opsForHash().delete((Object)this.accountKey, accounts.toArray(new Object[0]));
            }
            this.redisTemplate.delete((Object)hostKey);
        }
        catch (Exception e) {
            log.error("Failed clean redis.", (Throwable)e);
        }
        finally {
            this.lock.unlock(lockKey);
        }
    }

    private boolean isNotNull(Object obj) {
        if (obj == null) {
            return false;
        }
        String val = String.valueOf(obj);
        return !"null".equals(val) && !"NULL".equals(val);
    }

    public List<String> getOnlineAccount(List<String> accounts) {
        if (CollectionUtils.isEmpty(accounts)) {
            log.info("accounts is empty");
            return Collections.emptyList();
        }
        List accountList = accounts.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(accountList)) {
            log.info("accounts is empty");
            return Collections.emptyList();
        }
        long size = this.redisTemplate.opsForHash().size((Object)this.accountKey);
        if (size <= 0L) {
            log.info("online account size=0");
            return Collections.emptyList();
        }
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        ArrayList result = Lists.newArrayListWithCapacity((int)accountList.size());
        for (List keys : Lists.partition(accountList, (int)200)) {
            try {
                List list = hashOperations.multiGet((Object)this.accountKey, (Collection)keys);
                if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                for (int i = 0; i < keys.size(); ++i) {
                    if (list.get(i) == null) continue;
                    result.add(keys.get(i));
                }
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u5728\u7ebf\u8d26\u53f7\u5931\u8d25, keys:{}", (Object)keys, (Object)e);
            }
        }
        return result;
    }

    public List<WebSocketClientSession> getClientSessionList() {
        return this.getClientSessionList(null);
    }

    public List<WebSocketClientSession> getClientSessionList(String host) {
        boolean ignoreHost = StringUtils.isBlank((CharSequence)host);
        HashOperations ipTable = this.redisTemplate.opsForHash();
        long size = ipTable.size((Object)this.accountKey);
        if (size <= 0L) {
            return Collections.emptyList();
        }
        ArrayList<WebSocketClientSession> list = new ArrayList<WebSocketClientSession>((int)size);
        ScanOptions scanOptions = ScanOptions.scanOptions().count(200L).build();
        try (Cursor cursor = ipTable.scan((Object)this.accountKey, scanOptions);){
            while (cursor.hasNext()) {
                Map.Entry entry = (Map.Entry)cursor.next();
                WebSocketClientSession session = this.toClientSession(entry.getValue());
                if (session == null || !ignoreHost && !host.equalsIgnoreCase(session.getIp())) continue;
                list.add(session);
            }
        }
        catch (IOException e) {
            log.error("\u626b\u63cfredis\u5931\u8d25");
        }
        return list;
    }

    private WebSocketClientSession toClientSession(Object value) {
        if (value == null) {
            return null;
        }
        String json = String.valueOf(value);
        try {
            return (WebSocketClientSession)JacksonUtil.str2Obj((String)json, WebSocketClientSession.class);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790json\u5931\u8d25:{}", (Object)json, (Object)e);
            return null;
        }
    }
}

