/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.websocket.service.impl;

import com.kuaike.scrm.websocket.handler.WebSocketHandler;
import com.kuaike.scrm.websocket.service.HostService;
import com.kuaike.scrm.websocket.service.WebSocketService;
import com.kuaike.scrm.websocket.session.RedisSessionManager;
import com.kuaike.scrm.websocket.session.SessionManager;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.stream.ChunkedWriteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WebSocketServiceImpl
implements WebSocketService {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServiceImpl.class);
    @Value(value="${websocket.port:8066}")
    private Integer webSocketPort;
    @Autowired
    private RedisSessionManager redisSessionManager;
    @Autowired
    private HostService hostService;

    @Override
    public void start() {
        log.info("WebSocket server is starting.");
        this.redisSessionManager.initialize();
        SessionManager.init(this.redisSessionManager);
        try {
            this.hostService.init();
        }
        catch (Exception e) {
            log.error("HostService init failed", (Throwable)e);
        }
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) throws Exception {
                ChannelPipeline pipeline = socketChannel.pipeline();
                pipeline.addLast("http-codec", (ChannelHandler)new HttpServerCodec());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                pipeline.addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast(new ChannelHandler[]{new WebSocketHandler()});
            }
        }).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        Channel channel = b.bind(this.webSocketPort.intValue()).channel();
        log.info("WebSocket server is listening on port:{}", (Object)this.webSocketPort);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.lambda$start$0((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup, channel)));
        try {
            channel.closeFuture().sync();
            log.info("WebSocket server channel is closed.");
        }
        catch (InterruptedException e) {
            log.error("WebSocket channel sync", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private /* synthetic */ void lambda$start$0(EventLoopGroup bossGroup, EventLoopGroup workerGroup, Channel channel) {
        log.info("WebSocket server is shutdown.");
        bossGroup.shutdownGracefully();
        workerGroup.shutdownGracefully();
        channel.close();
        this.redisSessionManager.terminate();
        this.hostService.clearRemain();
        this.hostService.exit();
    }
}

