/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.websocket.service.impl;

import com.google.common.collect.Maps;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.websocket.model.WebSocketClientSession;
import com.kuaike.scrm.websocket.model.WebSocketServerNode;
import com.kuaike.scrm.websocket.service.HostService;
import com.kuaike.scrm.websocket.session.RedisSessionManager;
import com.kuaike.scrm.websocket.session.SessionManager;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.shaded.com.google.common.collect.Sets;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HostServiceImpl
implements HostService,
PathChildrenCacheListener {
    private static final Logger log = LoggerFactory.getLogger(HostServiceImpl.class);
    @Autowired
    private RedisSessionManager redisSessionManager;
    @Autowired
    private CuratorFramework curatorFramework;
    private PathChildrenCache nodeCache;
    @Value(value="${spring.profiles.active:}")
    private String profile;
    @Value(value="${spring.cloud.client.ip-address}")
    private String host;
    @Value(value="${server.port}")
    private int port;
    @Value(value="${websocket.root:/scrm-websocket}")
    private String root;
    private String rootPath;
    private String nodePath;
    private static final AtomicBoolean IS_RUNNING = new AtomicBoolean(true);
    private Set<String> webSocketServerIds = Sets.newHashSet();
    private Map<String, WebSocketServerNode> webSocketServerNodeMap = new HashMap<String, WebSocketServerNode>();
    private final ScheduledExecutorService scheduleService = Executors.newScheduledThreadPool(1);
    private final Map<String, Integer> cache = new HashMap<String, Integer>();
    private boolean initialized;

    @Override
    public void init() throws Exception {
        if (!this.initialized) {
            this.rootPath = this.root + (StringUtils.isBlank((CharSequence)this.profile) ? "" : "-" + this.profile);
            this.nodePath = this.rootPath + "/" + SessionManager.WEB_SOCKET_SERVER_ID;
            this.cache.clear();
            this.cache.putAll(this.getAll());
            log.info("Initialized with hosts:{}", this.cache);
            this.clearRemain();
            this.registerAndListen();
            this.scheduleService.scheduleWithFixedDelay(() -> {
                try {
                    if (!this.registerHaveContains()) {
                        this.registerAndListen();
                    }
                }
                catch (Exception e) {
                    log.error("schedule with error ", (Throwable)e);
                }
            }, 60L, 60L, TimeUnit.SECONDS);
        }
        this.initialized = true;
    }

    @Override
    public void clearRemain() {
        Set<String> cachedHosts = this.getCachedHosts();
        Set<String> currentHosts = this.cache.keySet();
        cachedHosts.removeAll(currentHosts);
        if (CollectionUtils.isNotEmpty(cachedHosts)) {
            log.info("Clean cached hosts: {}", cachedHosts);
            for (String ip : cachedHosts) {
                this.redisSessionManager.clear(ip);
            }
        }
    }

    public Set<String> update(List<WebSocketServerNode> list) {
        HashMap<String, Integer> target = new HashMap<String, Integer>();
        list.forEach(serverNode -> target.put(serverNode.getIp(), serverNode.getPort()));
        HashMap<String, Integer> origin = new HashMap<String, Integer>(this.cache);
        log.info("Update hosts from {} to {}", origin, target);
        if (target.isEmpty()) {
            log.info("Hosts all down.");
            this.down(origin);
            return this.cache.keySet();
        }
        HashMap<String, Integer> added = new HashMap<String, Integer>();
        target.forEach((ip, p) -> {
            if (origin.containsKey(ip)) {
                origin.remove(ip);
            } else {
                added.put((String)ip, (Integer)p);
            }
        });
        if (added.isEmpty() && origin.isEmpty()) {
            log.info("Hosts no change.");
            return this.cache.keySet();
        }
        if (!added.isEmpty()) {
            this.up(added);
        }
        if (!origin.isEmpty()) {
            this.down(origin);
        }
        return this.cache.keySet();
    }

    private void down(Map<String, Integer> removed) {
        if (removed == null || removed.size() == 0) {
            return;
        }
        log.info("Hosts down:{}", removed);
        for (String ip : removed.keySet()) {
            this.cache.remove(ip);
            this.redisSessionManager.clear(ip);
        }
    }

    private void up(Map<String, Integer> added) {
        if (added == null || added.size() == 0) {
            return;
        }
        log.info("Hosts up:{}", added);
        this.cache.putAll(added);
    }

    private Set<String> getCachedHosts() {
        List<WebSocketClientSession> sessionList = this.redisSessionManager.getClientSessionList();
        if (CollectionUtils.isEmpty(sessionList)) {
            return Collections.emptySet();
        }
        return sessionList.stream().map(WebSocketClientSession::getIp).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getHosts() {
        return this.cache.keySet();
    }

    public void register() throws Exception {
        WebSocketServerNode node = this.thisNode();
        byte[] data = this.encode(node);
        ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(this.nodePath, data);
        this.webSocketServerIds.add(node.getId());
        this.webSocketServerNodeMap.put(node.getId(), node);
        log.info("register node:{}", (Object)node);
    }

    public void initWatcher() {
        this.nodeCache = new PathChildrenCache(this.curatorFramework, this.rootPath, true);
        try {
            this.nodeCache.start();
            this.nodeCache.getListenable().addListener((Object)this);
        }
        catch (Exception e) {
            log.error("\u76d1\u542c\u8282\u70b9\u53d8\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    public WebSocketServerNode thisNode() {
        WebSocketServerNode serverNode = new WebSocketServerNode();
        serverNode.setId(SessionManager.WEB_SOCKET_SERVER_ID);
        serverNode.setIp(this.host);
        serverNode.setPort(this.port);
        return serverNode;
    }

    @Override
    public int nodeCount() {
        return this.webSocketServerIds.size();
    }

    public void registerAndListen() throws Exception {
        log.info("register WebSocket server node");
        if (!IS_RUNNING.get()) {
            log.warn("server is not running");
            return;
        }
        this.register();
        this.initWatcher();
    }

    public boolean registerHaveContains() {
        boolean flag = this.webSocketServerIds.contains(SessionManager.WEB_SOCKET_SERVER_ID);
        if (!flag) {
            log.info("allServerIds={}, thisServerId={}", this.webSocketServerIds, (Object)SessionManager.WEB_SOCKET_SERVER_ID);
        }
        return flag;
    }

    @Override
    public void exit() {
        try {
            log.info("EpochManager pre to destroy");
            IS_RUNNING.getAndSet(false);
            this.scheduleService.shutdownNow();
            this.curatorFramework.close();
            log.info(" has destroy");
        }
        catch (Exception e) {
            log.error("exit with error", (Throwable)e);
        }
    }

    private byte[] encode(WebSocketServerNode node) {
        return JacksonUtil.obj2Str((Object)node).getBytes(StandardCharsets.UTF_8);
    }

    private WebSocketServerNode decode(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        String json = new String(data, StandardCharsets.UTF_8);
        log.info("json={}", (Object)json);
        try {
            return (WebSocketServerNode)JacksonUtil.str2Obj((String)json, WebSocketServerNode.class);
        }
        catch (IOException e) {
            log.error("decode error", (Throwable)e);
            return null;
        }
    }

    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
        log.info("event={}, client.state={}", (Object)event.getType(), (Object)client.getState());
        List<WebSocketServerNode> list = this.getAllNode();
        this.update(list);
        if (event.getData() == null || event.getData().getPath() == null || event.getData().getData() == null) {
            return;
        }
        byte[] data = event.getData().getData();
        WebSocketServerNode watchNode = this.decode(data);
        if (client.getState() == CuratorFrameworkState.STOPPED) {
            log.info("some client is stopped,path={}", (Object)event.getData().getPath());
            if (this.thisNode().isSameInstance(watchNode)) {
                log.info("stopped client is this instance");
                this.nodeCache.close();
                log.info("cancel path listener");
                return;
            }
        }
        if (event.getType().equals((Object)PathChildrenCacheEvent.Type.CHILD_REMOVED)) {
            log.info("\u5b9e\u4f8b\u8282\u70b9\u79fb\u9664,data={}", (Object)event.getData());
            if (watchNode != null) {
                this.redisSessionManager.clear(watchNode.getIp());
                this.webSocketServerIds.remove(watchNode.getId());
                this.webSocketServerNodeMap.remove(watchNode.getId());
            }
        }
        HashSet ids = Sets.newHashSet();
        HashMap map = Maps.newHashMap();
        list.forEach(serverNode -> {
            try {
                ids.add(serverNode.getId());
                map.put(serverNode.getId(), serverNode);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u8282\u70b9\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            }
        });
        this.webSocketServerIds = ids;
        this.webSocketServerNodeMap = map;
    }

    public Map<String, Integer> getAll() {
        HashMap<String, Integer> hostsMap = new HashMap<String, Integer>();
        List<WebSocketServerNode> list = this.getAllNode();
        HashSet ids = Sets.newHashSet();
        list.forEach(serverNode -> {
            ids.add(serverNode.getId());
            hostsMap.put(serverNode.getIp(), serverNode.getPort());
        });
        return hostsMap;
    }

    private List<WebSocketServerNode> getAllNode() {
        ArrayList<WebSocketServerNode> list = new ArrayList<WebSocketServerNode>();
        try {
            List paths = (List)this.curatorFramework.getChildren().forPath(this.rootPath);
            log.info("instanceIds {}", (Object)paths);
            paths.forEach(path -> {
                try {
                    byte[] nodeData = (byte[])this.curatorFramework.getData().forPath(this.rootPath + "/" + path);
                    WebSocketServerNode serverNode = this.decode(nodeData);
                    list.add(serverNode);
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u8282\u70b9\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8282\u70b9\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return list;
    }

    @Override
    public WebSocketServerNode getServerNode(String serverId) {
        return this.webSocketServerNodeMap.get(serverId);
    }
}

