/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.websocket.message.handler;

import com.kuaike.scrm.common.utils.JacksonUtils;
import com.kuaike.scrm.websocket.enums.WebSocketCmd;
import com.kuaike.scrm.websocket.message.AbstractMessageHandler;
import com.kuaike.scrm.websocket.model.WebSocketClientSession;
import com.kuaike.scrm.websocket.service.dto.SignInRequest;
import com.kuaike.scrm.websocket.service.dto.WebSocketMessageDto;
import com.kuaike.scrm.websocket.session.SessionManager;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SignInMessageHandler
extends AbstractMessageHandler {
    @Override
    public void handleMessage(WebSocketMessageDto message, ChannelHandlerContext ctx) {
        if (!CollectionUtils.isEmpty((Map)message.getContent())) {
            SignInRequest signInRequest = (SignInRequest)JacksonUtils.getInstance().readValue(message.getContent(), SignInRequest.class);
            if (signInRequest == null || StringUtils.isBlank((CharSequence)signInRequest.getAccount())) {
                this.sendErrorCodeAndClose(ctx, WebSocketCmd.SIGN_IN_RESPONSE.getCmd(), "\u65e0\u6548\u7684\u767b\u5f55\u8bf7\u6c42");
                return;
            }
            String account = signInRequest.getAccount();
            WebSocketClientSession session = new WebSocketClientSession(account, ctx.channel(), true);
            session.setServerId(SessionManager.WEB_SOCKET_SERVER_ID);
            SessionManager.getInstance().register(session);
            this.sendSuccessResponse(ctx, WebSocketCmd.SIGN_IN_RESPONSE.getCmd());
        } else {
            this.sendErrorCodeAndClose(ctx, WebSocketCmd.SIGN_IN_RESPONSE.getCmd(), "\u65e0\u6548\u7684\u767b\u5f55\u8bf7\u6c42");
        }
    }

    @Override
    public int getMessageType() {
        return WebSocketCmd.SIGN_IN_REQUEST.getCmd();
    }
}

