/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.websocket.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.websocket.model.WebSocketClientSession;
import com.kuaike.scrm.websocket.service.WsSessionService;
import com.kuaike.scrm.websocket.service.dto.AccountInfo;
import com.kuaike.scrm.websocket.session.RedisSessionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wsSessionService")
public class WsSessionServiceImpl
implements WsSessionService {
    private static final Logger log = LoggerFactory.getLogger(WsSessionServiceImpl.class);
    @Autowired
    private RedisSessionManager redisSessionManager;

    public List<String> getOnlineUserAccounts(Collection<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            log.info("userIds is empty");
            return Collections.emptyList();
        }
        List<String> accounts = userIds.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList());
        return this.redisSessionManager.getOnlineAccount(accounts);
    }

    public List<String> queryAllAccountInfos() {
        List<WebSocketClientSession> list = this.redisSessionManager.getClientSessionList();
        if (CollectionUtils.isEmpty(list)) {
            log.info("online account size=0");
            return Collections.emptyList();
        }
        return list.stream().map(WebSocketClientSession::getAccount).collect(Collectors.toList());
    }

    public List<AccountInfo> queryAccountInfos(List<String> accounts) {
        if (CollectionUtils.isEmpty(accounts)) {
            return Collections.emptyList();
        }
        List<String> onlineAccounts = this.redisSessionManager.getOnlineAccount(accounts);
        HashSet<String> onlineSet = new HashSet<String>(onlineAccounts);
        ArrayList result = Lists.newArrayListWithCapacity((int)accounts.size());
        for (String account : accounts) {
            result.add(new AccountInfo(account, onlineSet.contains(account)));
        }
        return result;
    }
}

