/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.websocket.session;

import com.kuaike.scrm.websocket.model.WebSocketClientSession;
import com.kuaike.scrm.websocket.session.RedisSessionManager;
import io.netty.channel.Channel;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SessionManager {
    private static final Logger log = LoggerFactory.getLogger(SessionManager.class);
    private static final SessionManager instance = new SessionManager();
    private static Boolean initialized = false;
    public static final String WEB_SOCKET_SERVER_ID = UUID.randomUUID().toString();
    private RedisSessionManager redisSessionManager;
    private final Map<String, WebSocketClientSession> accountSessionMap = new ConcurrentHashMap<String, WebSocketClientSession>();
    private final Map<Channel, WebSocketClientSession> channelSessionMap = new ConcurrentHashMap<Channel, WebSocketClientSession>();

    public static void init(RedisSessionManager redisSessionManager) {
        if (!initialized.booleanValue() && redisSessionManager != null) {
            SessionManager.instance.redisSessionManager = redisSessionManager;
            initialized = true;
        }
    }

    public static SessionManager getInstance() {
        return instance;
    }

    public void register(WebSocketClientSession session) {
        log.info("register, session={}", (Object)session);
        this.accountSessionMap.put(session.getAccount(), session);
        this.channelSessionMap.put(session.getChannel(), session);
        if (this.redisSessionManager != null) {
            this.redisSessionManager.register(session);
        }
    }

    public void unRegister(Channel channel) {
        WebSocketClientSession session = this.channelSessionMap.remove(channel);
        log.info("unregister channel={}, session={}", (Object)channel, (Object)session);
        if (session != null) {
            this.accountSessionMap.remove(session.getAccount());
            if (this.redisSessionManager != null) {
                this.redisSessionManager.unregister(session.getAccount());
            }
        }
    }

    public boolean isOnline(String account) {
        WebSocketClientSession session = this.accountSessionMap.get(account);
        return session != null && session.isValid();
    }

    public WebSocketClientSession getSession(String account) {
        return this.accountSessionMap.get(account);
    }

    public WebSocketClientSession getSession(Channel channel) {
        return this.channelSessionMap.get(channel);
    }
}

