/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.websocket.service.impl;

import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.websocket.model.WebSocketClientSession;
import com.kuaike.scrm.websocket.model.WebSocketServerNode;
import com.kuaike.scrm.websocket.service.HostService;
import com.kuaike.scrm.websocket.service.WsPushService;
import com.kuaike.scrm.websocket.service.WsPushServiceFeign;
import com.kuaike.scrm.websocket.service.dto.WebSocketMessageDto;
import com.kuaike.scrm.websocket.service.dto.WsPushReq;
import com.kuaike.scrm.websocket.service.dto.WsRestResponse;
import com.kuaike.scrm.websocket.session.RedisSessionManager;
import com.kuaike.scrm.websocket.session.SessionManager;
import feign.Feign;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.openfeign.FeignClientsConfiguration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="wsPushService")
@Import(value={FeignClientsConfiguration.class})
public class WsPushServiceImpl
implements WsPushService {
    private static final Logger log = LoggerFactory.getLogger(WsPushServiceImpl.class);
    @Autowired
    private HostService hostService;
    @Autowired
    private RedisSessionManager redisSessionManager;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisPrefix;
    @Value(value="${websocket.token.prefix:ws-push-token:}")
    private String tokenPrefix;
    private static final String HTTP_BASE = "http://%s:%d";
    private final WsPushServiceFeign client;

    private String getTokenKey(String token) {
        return this.redisPrefix + this.tokenPrefix + token;
    }

    @Autowired
    public WsPushServiceImpl(Encoder encoder, Decoder decoder) {
        this.client = (WsPushServiceFeign)Feign.builder().encoder(encoder).decoder(decoder).target((Target)Target.EmptyTarget.create(WsPushServiceFeign.class));
    }

    public WsRestResponse<String> push(WsPushReq request) {
        log.info("push request: {}", (Object)request);
        if (request == null) {
            log.info("request is null");
            return new WsRestResponse().code(400L).msg("request is null");
        }
        if (StringUtils.isBlank((CharSequence)request.getAccount())) {
            log.info("account is blank");
            return new WsRestResponse().code(400L).msg("account is blank");
        }
        if (request.getMessage() == null) {
            log.info("message is null");
            return new WsRestResponse().code(400L).msg("message is null");
        }
        WebSocketClientSession session = SessionManager.getInstance().getSession(request.getAccount());
        if (StringUtils.isNotBlank((CharSequence)request.getToken())) {
            log.info("token is not blank");
            if (this.checkToken(request.getToken().trim())) {
                return this.innerPush(session, request.getMessage());
            }
            return new WsRestResponse().code(401L).msg("\u65e0\u6548\u7684\u63a8\u9001\u4ee4\u724c");
        }
        if (SessionManager.getInstance().isOnline(request.getAccount())) {
            log.info("{} is online", (Object)request.getAccount());
            return this.innerPush(session, request.getMessage());
        }
        if (this.hostService.nodeCount() <= 1) {
            log.info("server node count <= 1, ignore redirect");
            return this.innerPush(session, request.getMessage());
        }
        try {
            String account = request.getAccount();
            WebSocketClientSession cachedSession = this.redisSessionManager.getSession(account);
            if (cachedSession == null) {
                log.warn("\u6839\u636eaccount:{}\u672a\u83b7\u53d6\u5230cachedSession", (Object)account);
                return new WsRestResponse().badRequest().msg("\u7528\u6237\u4e0d\u5728\u7ebf");
            }
            WebSocketServerNode serverNode = this.hostService.getServerNode(cachedSession.getServerId());
            if (serverNode == null) {
                log.warn("serverNode is null, session:{}", (Object)cachedSession);
                return new WsRestResponse().badRequest().msg("\u7528\u6237\u4e0d\u5728\u7ebf");
            }
            if (SessionManager.WEB_SOCKET_SERVER_ID.equals(cachedSession.getServerId())) {
                return this.innerPush(session, request.getMessage());
            }
            return this.redirectPush(serverNode, request);
        }
        catch (Exception e) {
            log.error("remoteInvoke with error", (Throwable)e);
            return new WsRestResponse(500L, "\u53d1\u9001\u5931\u8d25", (Serializable)((Object)""));
        }
    }

    private String createToken() {
        String token = UUID.randomUUID().toString();
        String tokenKey = this.getTokenKey(token);
        this.redisTemplate.opsForValue().set((Object)tokenKey, (Object)"1", 10L, TimeUnit.SECONDS);
        return token;
    }

    private boolean checkToken(String token) {
        String tokenKey = this.getTokenKey(token);
        String value = (String)this.redisTemplate.opsForValue().get((Object)tokenKey);
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        this.redisTemplate.delete((Object)tokenKey);
        return true;
    }

    private WsRestResponse<String> redirectPush(WebSocketServerNode serverNode, WsPushReq request) {
        URI uri;
        log.info("redirect push, serverNode={}, request={}", (Object)serverNode, (Object)request);
        String url = String.format(HTTP_BASE, serverNode.getIp(), serverNode.getPort());
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            log.error("\u6784\u9020URI\u5931\u8d25, url={}", (Object)url, (Object)e);
            return new WsRestResponse(500L, "\u7cfb\u7edf\u5f02\u5e38", (Serializable)((Object)""));
        }
        request.setToken(this.createToken());
        return this.client.push(uri, request);
    }

    private WsRestResponse<String> innerPush(WebSocketClientSession session, WebSocketMessageDto message) {
        log.info("receive push message={}, session={}", (Object)message, (Object)session);
        if (session == null || !session.isValid()) {
            log.warn("session is null or invalid, session:{}", (Object)session);
            return new WsRestResponse().badRequest().msg("\u7528\u6237\u4e0d\u5728\u7ebf");
        }
        ChannelFuture future = session.getChannel().writeAndFlush((Object)new TextWebSocketFrame(JacksonUtil.obj2Str((Object)message)));
        future.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            if (!channelFuture.isSuccess()) {
                log.error("Push to account={} failed.", (Object)session.getAccount(), (Object)channelFuture.cause());
            }
        }));
        return WsRestResponse.ok((Serializable)((Object)""));
    }
}

