/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wallet.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.sms.entity.PartnerInfo;
import com.kuaike.scrm.wallet.dto.WalletRespDto;
import com.kuaike.scrm.wallet.service.WalletService;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class WalletServiceImpl
implements WalletService {
    private static final Logger log = LoggerFactory.getLogger(WalletServiceImpl.class);
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Value(value="${app.wallet.accountInfo.url}")
    private String accountInfo;
    @Value(value="${app.wallet.wxPayQrcode.url}")
    private String wxPayQrCode;
    @Value(value="${app.wallet.getPayStatus.url}")
    private String getPayStatus;
    @Value(value="${app.wallet.payOffline.url}")
    private String payOffLine;
    @Value(value="${app.wallet.consumeStatisticsByMonth.url}")
    private String consumeStatisticsByMonth;
    @Value(value="${app.wallet.getBankVirtualAccount.url}")
    private String getBankVirtualAccount;
    @Value(value="${app.wallet.exprotConsumeStatisticsByMonth.url}")
    private String exportConsumeStatisticsByMonth;
    @Value(value="${app.wallet.getRevenueList.url}")
    private String getRevenueList;
    @Value(value="${app.wallet.exportRevenueList.url}")
    private String exportRevenueList;
    @Value(value="${app.wallet.getBillList.url}")
    private String getBillList;
    @Value(value="${app.wallet.exportBillList.url}")
    private String exportBillList;
    @Value(value="${app.wallet.getConfirmationList.url}")
    private String getConfirmationList;
    @Value(value="${app.wallet.confirm.url}")
    private String confirm;

    @Override
    public Object accountInfo(Map<String, String> map) {
        log.info("accountInfo map:{}", map);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUser), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkAndCreate(currentUser);
        return this.bjyPartnerService.bjyPost(this.accountInfo, map, this.bjyPartnerService.getBjyHeader(currentUser.getBizId(), currentUser.getCorpId()));
    }

    @Override
    public Object wxPayQrcode(Map<String, String> map) {
        log.info("wxPayQrcode map:{}", map);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUser), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkAndCreate(currentUser);
        return this.bjyPartnerService.bjyPost(this.wxPayQrCode, map, this.bjyPartnerService.getBjyHeader(currentUser.getBizId(), currentUser.getCorpId()));
    }

    @Override
    public Object getPayStatus(Map<String, String> map) {
        log.info("getPayStatus map:{}", map);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUser), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkAndCreate(currentUser);
        return this.bjyPartnerService.bjyPost(this.getPayStatus, map, this.bjyPartnerService.getBjyHeader(currentUser.getBizId(), currentUser.getCorpId()));
    }

    @Override
    public Object payOffline(Map<String, String> map) {
        log.info("payOffline map:{}", map);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUser), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        PartnerInfo partnerInfo = this.checkAndCreate(currentUser);
        if (!ObjectUtils.isEmpty((Object)partnerInfo) && !StringUtils.isEmpty((Object)partnerInfo.getBankAccount())) {
            return WalletRespDto.from(partnerInfo);
        }
        return this.bjyPartnerService.bjyPost(this.payOffLine, map, this.bjyPartnerService.getBjyHeader(currentUser.getBizId(), currentUser.getCorpId()));
    }

    @Override
    public Object consumeStatisticsByMonth(Map<String, String> map) {
        log.info("consumeStatisticsByMonth map:{}", map);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUser), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkAndCreate(currentUser);
        return this.bjyPartnerService.bjyPost(this.consumeStatisticsByMonth, map, this.bjyPartnerService.getBjyHeader(currentUser.getBizId(), currentUser.getCorpId()));
    }

    @Override
    public Object getBankVirtualAccount(Map<String, String> map) {
        log.info("getBankVirtualAccount map:{}", map);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUser), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkAndCreate(currentUser);
        return this.bjyPartnerService.bjyPost(this.getBankVirtualAccount, map, this.bjyPartnerService.getBjyHeader(currentUser.getBizId(), currentUser.getCorpId()));
    }

    @Override
    public void exprotConsumeStatisticsByMonth(Map<String, String> map, HttpServletResponse response) {
        log.info("exprotConsumeStatisticsByMonth map:{}", map);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUser), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkAndCreate(currentUser);
        map.put("render", "json");
        JSONObject jsonObject = this.bjyPartnerService.bjyPost(this.exportConsumeStatisticsByMonth, map, this.bjyPartnerService.getBjyHeader(currentUser.getBizId(), currentUser.getCorpId()));
        JSONObject data = jsonObject.getJSONObject("data");
        JSONArray list = data.getJSONArray("list");
        List dataList = (List)JSONArray.parseObject((String)list.toJSONString(), List.class);
        JSONObject header = data.getJSONObject("header");
        this.export(header, dataList, data.getString("title"), "\u6d88\u8d39\u8bb0\u5f55", response);
    }

    @Override
    public Object getRevenueList(Map<String, String> map) {
        log.info("getRevenueList map:{}", map);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUser), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkAndCreate(currentUser);
        return this.bjyPartnerService.bjyPost(this.getRevenueList, map, this.bjyPartnerService.getBjyHeader(currentUser.getBizId(), currentUser.getCorpId()));
    }

    @Override
    public void exportRevenueList(Map<String, String> map, HttpServletResponse response) {
        log.info("exportRevenueList map:{}", map);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUser), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkAndCreate(currentUser);
        map.put("render", "json");
        JSONObject jsonObject = this.bjyPartnerService.bjyPost(this.exportRevenueList, map, this.bjyPartnerService.getBjyHeader(currentUser.getBizId(), currentUser.getCorpId()));
        JSONObject data = jsonObject.getJSONObject("data");
        JSONArray list = data.getJSONArray("list");
        List dataList = (List)JSONArray.parseObject((String)list.toJSONString(), List.class);
        JSONObject header = data.getJSONObject("header");
        this.export(header, dataList, data.getString("title"), "\u6536\u652f\u660e\u7ec6", response);
    }

    @Override
    public Object getBillList(Map<String, String> map) {
        log.info("getBillList map:{}", map);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUser), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkAndCreate(currentUser);
        return this.bjyPartnerService.bjyPost(this.getBillList, map, this.bjyPartnerService.getBjyHeader(currentUser.getBizId(), currentUser.getCorpId()));
    }

    @Override
    public void exportBillList(Map<String, String> map, HttpServletResponse response) {
        log.info("accountInfo map:{}", map);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUser), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkAndCreate(currentUser);
        map.put("render", "json");
        JSONObject jsonObject = this.bjyPartnerService.bjyPost(this.exportBillList, map, this.bjyPartnerService.getBjyHeader(currentUser.getBizId(), currentUser.getCorpId()));
        JSONObject data = jsonObject.getJSONObject("data");
        JSONArray list = data.getJSONArray("list");
        List dataList = (List)JSONArray.parseObject((String)list.toJSONString(), List.class);
        JSONObject header = data.getJSONObject("header");
        this.export(header, dataList, data.getString("title"), "\u8d26\u5355\u8d39\u7528", response);
    }

    @Override
    public Object getConfirmationList(Map<String, String> map) {
        log.info("getConfirmationList map:{}", map);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUser), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkAndCreate(currentUser);
        return this.bjyPartnerService.bjyPost(this.getConfirmationList, map, this.bjyPartnerService.getBjyHeader(currentUser.getBizId(), currentUser.getCorpId()));
    }

    @Override
    public Object confirm(Map<String, String> map) {
        log.info("confirm map:{}", map);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUser), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkAndCreate(currentUser);
        return this.bjyPartnerService.bjyPost(this.confirm, map, this.bjyPartnerService.getBjyHeader(currentUser.getBizId(), currentUser.getCorpId()));
    }

    private void export(JSONObject heads, List<Map<String, String>> data, String title, String sheetName, HttpServletResponse response) {
        if (CollectionUtils.isEmpty((Map)heads)) {
            return;
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(sheetName);
        HSSFRow row = sheet.createRow(0);
        row.setZeroHeight(false);
        row.setHeight((short)360);
        HSSFCellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFFont headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)12);
        headerCellStyle.setFont((Font)headerFont);
        int size = heads.size();
        String[] headers = new String[size];
        ArrayList<String> fields = new ArrayList<String>(size);
        int headIndex = 0;
        for (Map.Entry head : heads.entrySet()) {
            headers[headIndex] = String.valueOf(head.getValue());
            fields.add(String.valueOf(head.getKey()));
            ++headIndex;
        }
        for (int i = 0; i < headers.length; ++i) {
            sheet.setColumnWidth(i, 6400);
            HSSFCell cell = row.createCell(i);
            cell.setCellStyle(headerCellStyle);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
        }
        if (!CollectionUtils.isEmpty(data)) {
            int rowNum = 1;
            for (Map<String, String> map : data) {
                HSSFRow ssRow = sheet.createRow(rowNum);
                this.createAndSetCell(ssRow, map, fields);
                ++rowNum;
            }
        }
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(title, "UTF-8"));
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.flushBuffer();
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            log.error("\u4fdd\u5b58excel\u5931\u8d25", (Throwable)e);
        }
    }

    private void createAndSetCell(HSSFRow ssRow, Map<String, String> map, List<String> fields) {
        for (int i = 0; i < fields.size(); ++i) {
            ssRow.createCell(i).setCellValue(String.valueOf(map.get(fields.get(i))));
        }
    }

    private PartnerInfo checkAndCreate(CurrentUserInfo currentUser) {
        return this.bjyPartnerService.validPartner(currentUser.getBizId());
    }
}

