/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.service.impl;

import cn.kinyun.link.common_dto.dto.BaseResponse;
import cn.kinyun.link.common_dto.dto.ResponseCodeType;
import cn.kinyun.link.common_dto.enums.OpPlatform;
import cn.kinyun.link.service.MessageService;
import cn.kinyun.link.service.push.request.ClickLoadResourceReq;
import cn.kinyun.link.service.push.request.RevokeMsgReq;
import cn.kinyun.scrm.vip.dto.ContactDetailReq;
import cn.kinyun.scrm.vip.dto.VipWeworkMsgReq;
import cn.kinyun.scrm.vip.dto.VipWeworkSendMsgBatchReq;
import cn.kinyun.scrm.vip.dto.req.SyncLoadReq;
import cn.kinyun.scrm.vip.dto.req.VipRevokeMsgReq;
import cn.kinyun.scrm.vip.enums.MsgReportStatus;
import cn.kinyun.scrm.vip.service.PushMsgService;
import cn.kinyun.scrm.vip.service.RequestIdCacheService;
import cn.kinyun.scrm.vip.service.VipWeworkMessageService;
import cn.kinyun.scrm.vip.service.impl.MessageConvertSupport;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.MessageListRespDto;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.vip.entity.VipWeworkAccount;
import com.kuaike.scrm.dal.vip.entity.VipWeworkContact;
import com.kuaike.scrm.dal.vip.entity.VipWeworkReportChatRoom;
import com.kuaike.scrm.dal.vip.mapper.VipMerchantCallbackTalkMsgMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAccountMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkContactMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkConversationMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkReportChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.vip.dto.model.WeworkMessage;
import com.kuaike.scrm.vip.service.WeworkCommonMessageService;
import com.kuaike.scrm.vip.service.impl.WeworkMessageCondition;
import com.kuaike.scrm.wework.contact.dto.ContactRelationDetailDto;
import com.kuaike.scrm.wework.contact.dto.ContactRelationDetailParams;
import com.kuaike.scrm.wework.contact.service.ContactRelationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VipWeworkMsgServiceImpl
implements VipWeworkMessageService {
    private static final Logger log = LoggerFactory.getLogger(VipWeworkMsgServiceImpl.class);
    @Autowired
    private WeworkCommonMessageService weworkCommonMessageService;
    @Autowired
    private VipWeworkAccountMapper vipWeworkAccountMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private MessageConvertSupport messageConvertSupport;
    @Autowired
    private PushMsgService pushMsgService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private ContactRelationService contactRelationService;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private VipWeworkReportChatRoomMapper vipWeworkReportChatRoomMapper;
    @Autowired
    private VipWeworkContactMapper vipWeworkContactMapper;
    @Autowired
    private RequestIdCacheService requestIdCacheService;
    @Autowired
    private VipMerchantCallbackTalkMsgMapper vipMerchantCallbackTalkMsgMapper;
    @Autowired
    private VipWeworkConversationMapper vipWeworkConversationMapper;

    @Override
    public List<String> sendMessageBatch(VipWeworkSendMsgBatchReq params) {
        CurrentUserInfo info = LoginUtils.getCurrentUser();
        log.info("sendMessage params={}, operatorId={}", (Object)params, (Object)info.getId());
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getWeworkId()), (Object)"weworkId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getTalkerId()), (Object)"talkerId");
        Preconditions.checkArgument((params.getTalkerType() != null ? 1 : 0) != 0, (Object)"talkerType\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getTalkerType() == 0 || params.getTalkerType() == 1 ? 1 : 0) != 0, (Object)"talkerType\u4e0d\u5408\u6cd5");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(params.getMessageList()), (Object)"messageList\u4e0d\u80fd\u4e3a\u7a7a");
        Long bizId = info.getBizId();
        VipWeworkAccount account = this.vipWeworkAccountMapper.getWeworkAccount(bizId, params.getWeworkId());
        Preconditions.checkNotNull((Object)account, (Object)"weworkId\u4e0d\u5b58\u5728");
        if (params.getTalkerType() == 0) {
            this.validateWeworkInContact(bizId, params.getWeworkId(), params.getTalkerId());
        } else if (params.getTalkerType() == 1) {
            this.validateWeworkInChatRoom(bizId, params.getWeworkId(), params.getTalkerId());
        }
        BaseResponse resp = this.pushMsgService.push(params.getWeworkId(), bizId, account.getCorpId(), params.getTalkerId(), params.getTalkerType(), params.getAtMembers(), params.getMessageList());
        if (resp == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "\u53d1\u9001\u5931\u8d25");
        }
        ArrayList messageRequestIds = Lists.newArrayList();
        if (resp.getCode() == 0L) {
            List sendResults = (List)resp.getData();
            for (BaseResponse sendResult : sendResults) {
                messageRequestIds.add(sendResult.getRequestId());
            }
        } else {
            log.error("\u53d1\u9001\u5931\u8d25: resp={}", (Object)resp);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, resp.getMsg());
        }
        this.requestIdCacheService.cacheRequestIds((List)messageRequestIds);
        return messageRequestIds;
    }

    private void validateWeworkInContact(Long bizId, String weworkId, String contactId) {
        VipWeworkContact vipWeworkContact = this.vipWeworkContactMapper.queryByWeworkIdAndContactId(weworkId, contactId, bizId);
        if (vipWeworkContact == null) {
            log.warn("\u8054\u7cfb\u4eba\u8fd8\u6ca1\u6709\u4e0a\u62a5\u5230\u670d\u52a1\u5668, bizId:{}, weworkId:{}, contactId:{}", new Object[]{bizId, weworkId, contactId});
            return;
        }
        if (Objects.equals(vipWeworkContact.getIsDeleted(), 1)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bf9\u8bdd\u53cc\u65b9\u4e0d\u662f\u597d\u53cb");
        }
    }

    private void validateWeworkInChatRoom(Long bizId, String weworkId, String chatRoomId) {
        String[] memberWechatIdArr;
        VipWeworkReportChatRoom reportChatRoom = this.vipWeworkReportChatRoomMapper.queryByWeworkIdChatRoomId(bizId, weworkId, chatRoomId);
        if (reportChatRoom == null) {
            log.warn("\u7fa4\u8fd8\u6ca1\u6709\u4e0a\u62a5\u5230\u670d\u52a1\u5668, bizId:{}, weworkId:{}, chatRoomId:{}", new Object[]{bizId, weworkId, chatRoomId});
            return;
        }
        if (Objects.equals(reportChatRoom.getIsDeleted(), 1)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u7fa4\u5df2\u5220\u9664");
        }
        boolean inChatRoom = false;
        String memberList = reportChatRoom.getMemberList();
        if (StringUtils.isNotBlank((CharSequence)memberList) && (memberWechatIdArr = memberList.split(";")).length > 0) {
            for (String memberWechatId : memberWechatIdArr) {
                if (!memberWechatId.equals(weworkId)) continue;
                inChatRoom = true;
                break;
            }
        }
        if (!inChatRoom) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6b64\u5fae\u4fe1\u5df2\u9000\u7fa4");
        }
    }

    @Override
    public MessageListRespDto messageList(VipWeworkMsgReq req) {
        log.info("messageList params,req:{}", (Object)JSON.toJSONString((Object)req));
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getWeworkUserId()), (Object)"\u6210\u5458id\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getConversationId()), (Object)"\u4f1a\u8bddid\u4e3a\u7a7a");
        StopWatchDto timer = new StopWatchDto("messageList", true, log);
        Date sendTime = null;
        if (StringUtils.isNotBlank((CharSequence)req.getMsgId())) {
            timer.start("es\u5355\u70b9\u67e5\u8be2");
            WeworkMessage chatMsg = this.weworkCommonMessageService.selectByPrimaryKeyFromES(req.getMsgId());
            if (Objects.nonNull(chatMsg)) {
                sendTime = chatMsg.getSendTime();
            }
            timer.stop();
        }
        timer.start("es\u5217\u8868\u67e5\u8be2");
        String weworkDigitId = this.weworkUserMapper.queryWeworkDigitIdByNum(req.getWeworkUserId());
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)weworkDigitId), (Object)("\u5f53\u524d\u6210\u5458\uff1a" + req.getWeworkUserId() + "\u672a\u5f00\u901a\u589e\u5f3a\u7248\u529f\u80fd"));
        VipWeworkAccount vipWeworkAccount = this.vipWeworkAccountMapper.getWeworkAccount(bizId, weworkDigitId);
        if (Objects.isNull(vipWeworkAccount)) {
            log.warn("messageList: vipWeworkAccount is null, req:{}", (Object)req);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5f53\u524d\u6210\u5458\uff1a" + req.getWeworkUserId() + "\u672a\u5f00\u901a\u589e\u5f3a\u7248\u529f\u80fd");
        }
        String conId = req.getConversationId().replace(weworkDigitId, "").replace("$$", "");
        WeworkMessageCondition param = new WeworkMessageCondition();
        param.setCorpId(vipWeworkAccount.getCorpId());
        param.setWeworkId(vipWeworkAccount.getWeworkId());
        param.setSendTime(sendTime);
        param.setConId(conId);
        if (req.getDirection() == null) {
            param.setDirection(Boolean.valueOf(true));
        } else {
            param.setDirection(req.getDirection());
        }
        param.setCount(req.getCount());
        List messageList = this.weworkCommonMessageService.selectVipMsgByCondition(param);
        timer.stop();
        timer.print();
        MessageListRespDto respDto = new MessageListRespDto();
        respDto.setWeworkId(weworkDigitId);
        respDto.setWeworkUserId(req.getWeworkUserId());
        respDto.setTalkerId(conId);
        Integer talkerType = this.vipWeworkConversationMapper.queryTalkerTypeByTalkerId(vipWeworkAccount.getCorpId(), weworkDigitId, conId);
        respDto.setTalkerType(talkerType);
        if (CollectionUtils.isEmpty((Collection)messageList)) {
            return respDto;
        }
        List msgRespDto = this.messageConvertSupport.convertMessageList(bizId, weworkDigitId, req.getWeworkUserId(), conId, messageList);
        respDto.setTalkerMsgList(msgRespDto);
        return respDto;
    }

    @Override
    public ContactRelationDetailDto contactDetail(ContactDetailReq req) {
        log.info("contact detail params: {}", (Object)req);
        req.validate();
        Long bizId = LoginUtils.getCurrentUserBizId();
        Map contactIdMap = this.weworkContactMapper.queryContactIdByWeworkDigitId(bizId, (Collection)Lists.newArrayList((Object[])new String[]{req.getTalkerId()}));
        if (StringUtils.isBlank((CharSequence)((CharSequence)contactIdMap.get(req.getTalkerId())))) {
            return null;
        }
        ContactRelationDetailParams params = new ContactRelationDetailParams();
        params.setWeworkUserId(req.getWeworkUserId());
        params.setContactId((String)contactIdMap.get(req.getTalkerId()));
        return this.contactRelationService.detail(params);
    }

    @Override
    public String syncLoad(SyncLoadReq req) {
        log.info("sync load req: {}", (Object)req);
        req.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        VipWeworkAccount vipWeworkAccount = this.vipWeworkAccountMapper.getWeworkAccount(bizId, req.getWeworkId());
        if (Objects.isNull(vipWeworkAccount)) {
            log.info("syncLoad: vipWeworkAccount is null, req:{}", (Object)req);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5f53\u524d\u673a\u5668\u4eba\uff1a" + req.getWeworkId() + "\u672a\u5f00\u901a\u589e\u5f3a\u7248\u529f\u80fd");
        }
        ClickLoadResourceReq params = new ClickLoadResourceReq();
        params.setOpPlatform(Integer.valueOf(OpPlatform.WEB.getType()));
        params.setBizId(vipWeworkAccount.getBizId());
        params.setCorpId(vipWeworkAccount.getCorpId());
        params.setWeworkId(req.getWeworkId());
        params.setMsgRequestId(req.getMsgRequestId());
        BaseResponse baseResponse = this.messageService.clickLoadResource(params);
        return baseResponse.getRequestId();
    }

    @Override
    public void clearRecord() {
        long begin = System.currentTimeMillis();
        Date date = DateUtils.addWeeks((Date)new Date(), (int)-2);
        int count = this.vipMerchantCallbackTalkMsgMapper.clearMsgRecord(date, MsgReportStatus.SUCCCESS.getStatus());
        long wasteTime = System.currentTimeMillis() - begin;
        log.info("clear talk msg record finished, count:{}, takes time:{}", (Object)count, (Object)wasteTime);
    }

    @Override
    public String revokeMsg(VipRevokeMsgReq req) {
        log.info("revokeMsg req: {}", (Object)req);
        req.validate();
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        String weworkDigitId = this.weworkUserMapper.queryWeworkDigitIdByNum(req.getWeworkUserId());
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)weworkDigitId), (Object)("\u5f53\u524d\u6210\u5458\uff1a" + req.getWeworkUserId() + "\u672a\u5f00\u901a\u589e\u5f3a\u7248\u529f\u80fd"));
        VipWeworkAccount vipWeworkAccount = this.vipWeworkAccountMapper.getWeworkAccount(bizId, weworkDigitId);
        if (Objects.isNull(vipWeworkAccount)) {
            log.info("revokeMsg: vipWeworkAccount is null, req:{}", (Object)req);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5f53\u524d\u6210\u5458\uff1a" + req.getWeworkUserId() + "\u672a\u5f00\u901a\u589e\u5f3a\u7248\u529f\u80fd");
        }
        RevokeMsgReq revokeMsgReq = new RevokeMsgReq();
        revokeMsgReq.setOpPlatform(Integer.valueOf(OpPlatform.MANAGER.getType()));
        revokeMsgReq.setBizId(vipWeworkAccount.getBizId());
        revokeMsgReq.setCorpId(vipWeworkAccount.getCorpId());
        revokeMsgReq.setWeworkId(weworkDigitId);
        revokeMsgReq.setMsgRequestId(req.getMsgRequestId());
        revokeMsgReq.setTargetId(req.getTalkerId());
        revokeMsgReq.setType(req.getTalkerType().intValue());
        BaseResponse baseResponse = null;
        try {
            baseResponse = this.messageService.revokeMsg(revokeMsgReq);
        }
        catch (Exception e) {
            log.error("revokeMsg: \u8c03\u7528link\u63a5\u53e3\u5f02\u5e38\uff0ce = ", (Throwable)e);
            return null;
        }
        if (baseResponse == null) {
            log.warn("revokeMsg: baseResponse is null, req:{}", (Object)req);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "\u64a4\u56de\u5931\u8d25");
        }
        log.info("revokeMsg: link\u8fd4\u56de\u7ed3\u679c, baseResponse: {}", (Object)baseResponse);
        if ((long)ResponseCodeType.SUCCESS.getCode() == baseResponse.getCode()) {
            this.weworkCommonMessageService.updateRevokeByRequestIds(vipWeworkAccount.getCorpId(), (Collection)Lists.newArrayList((Object[])new String[]{req.getMsgRequestId()}));
            return baseResponse.getRequestId();
        }
        log.error("\u64a4\u56de\u5931\u8d25: resp={}", (Object)baseResponse);
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, baseResponse.getMsg());
    }
}

