/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.service.impl;

import cn.kinyun.link.common_dto.dto.BaseResponse;
import cn.kinyun.link.common_dto.dto.ResponseCodeType;
import cn.kinyun.link.common_dto.enums.OpPlatform;
import cn.kinyun.link.service.MessageService;
import cn.kinyun.link.service.OperateService;
import cn.kinyun.link.service.push.request.ClearBubbleReq;
import cn.kinyun.link.service.push.request.ConTopReq;
import cn.kinyun.link.service.response.WeworkStatusInfo;
import cn.kinyun.scrm.vip.dto.req.ConversationIdReq;
import cn.kinyun.scrm.vip.dto.req.ConversationListReq;
import cn.kinyun.scrm.vip.dto.req.ConversationSearchDetailReq;
import cn.kinyun.scrm.vip.dto.req.ConversationSearchReq;
import cn.kinyun.scrm.vip.dto.req.ConversationTopReq;
import cn.kinyun.scrm.vip.dto.req.MessageAroundListReq;
import cn.kinyun.scrm.vip.dto.req.VipWeworkListReq;
import cn.kinyun.scrm.vip.dto.resp.ConversationMsgResp;
import cn.kinyun.scrm.vip.dto.resp.ConversationSearchResp;
import cn.kinyun.scrm.vip.dto.resp.ConversationUnreadResp;
import cn.kinyun.scrm.vip.dto.resp.SearchContactResp;
import cn.kinyun.scrm.vip.dto.resp.SearchMsgResp;
import cn.kinyun.scrm.vip.dto.resp.SearchRoomResp;
import cn.kinyun.scrm.vip.dto.resp.VipConversationResp;
import cn.kinyun.scrm.vip.dto.resp.VipWeworkUserResp;
import cn.kinyun.scrm.vip.enums.TalkerType;
import cn.kinyun.scrm.vip.service.VipConversationService;
import cn.kinyun.scrm.vip.service.impl.MessageConvertSupport;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.vip.dto.ChatRoomBasicInfoDto;
import com.kuaike.scrm.dal.vip.entity.VipWeworkAccount;
import com.kuaike.scrm.dal.vip.entity.VipWeworkChatRoomRelation;
import com.kuaike.scrm.dal.vip.entity.VipWeworkContact;
import com.kuaike.scrm.dal.vip.entity.VipWeworkConversation;
import com.kuaike.scrm.dal.vip.entity.VipWeworkReportChatRoom;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAccountMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAuthorizeAccountMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkContactMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkConversationMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkReportChatRoomMapper;
import com.kuaike.scrm.dal.wework.dto.QueryWeworkUserListDto;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.vip.dto.QueryMsgCondition;
import com.kuaike.scrm.vip.dto.model.WeworkMessage;
import com.kuaike.scrm.vip.service.WeworkCommonMessageService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class VipConversationServiceImpl
implements VipConversationService {
    private static final Logger log = LoggerFactory.getLogger(VipConversationServiceImpl.class);
    @Autowired
    private VipWeworkConversationMapper vipWeworkConversationMapper;
    @Autowired
    private VipWeworkAccountMapper vipWeworkAccountMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private VipWeworkContactMapper vipWeworkContactMapper;
    @Autowired
    private VipWeworkReportChatRoomMapper vipWeworkReportChatRoomMapper;
    @Autowired
    private VipWeworkChatRoomRelationMapper vipWeworkChatRoomRelationMapper;
    @Autowired
    private WeworkCommonMessageService weworkCommonMessageService;
    private static final String CONVERSATION_SPLIT_LABEL = "$$";
    @Autowired
    private WeworkUserService weworkUserService;
    @Autowired
    private MessageConvertSupport messageConvertSupport;
    @Autowired
    private VipWeworkAuthorizeAccountMapper vipWeworkAuthorizeAccountMapper;
    @Autowired
    private OperateService operateService;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private MessageService messageService;

    @Override
    public List<VipWeworkUserResp> weworkUserList(VipWeworkListReq params) {
        Long bizId = LoginUtils.getCurrentUserBizId();
        String corpId = LoginUtils.getCurrentUserCorpId();
        Set queryWeworkUserIds = this.weworkUserService.queryCurManagerWeworkUser();
        List vipUserList = this.vipWeworkAuthorizeAccountMapper.queryBizVipUserStatus(bizId);
        if (CollectionUtils.isNotEmpty((Collection)vipUserList)) {
            List vipWeworkUserIds = this.weworkUserMapper.queryWeworkUserIdByNums((Collection)vipUserList);
            queryWeworkUserIds = Sets.intersection((Set)queryWeworkUserIds, (Set)Sets.newHashSet((Iterable)vipWeworkUserIds));
        } else {
            queryWeworkUserIds = Sets.newHashSet();
        }
        QueryWeworkUserListDto queryParams = new QueryWeworkUserListDto();
        queryParams.setCorpId(corpId);
        queryParams.setQuery(params.getQuery());
        queryParams.setWeworkUserIds(queryWeworkUserIds);
        queryParams.setPageDto(params.getPageDto());
        queryParams.setVipType(Integer.valueOf(1));
        queryParams.setUseWeworkUserRange(Boolean.valueOf(true));
        log.info("queryParams: {}", (Object)queryParams);
        if (params.getPageDto() != null) {
            int total = this.weworkUserMapper.queryVipWeworkUserCount(queryParams);
            params.getPageDto().setCount(Integer.valueOf(total));
        }
        List list = this.weworkUserMapper.queryVipWeworkUserList(queryParams);
        List<String> weworkDigitIds = list.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getWeworkDigitId())).map(it -> it.getWeworkDigitId()).collect(Collectors.toList());
        Map<String, Integer> weworkOnlineMap = this.getWeworkIdOnlineMap(bizId, weworkDigitIds);
        ArrayList result = Lists.newArrayList();
        for (WeworkUser weworkUser : list) {
            VipWeworkUserResp userListDto = new VipWeworkUserResp();
            userListDto.setWeworkUserId(weworkUser.getNum());
            userListDto.setName(weworkUser.getName());
            userListDto.setAvatar(weworkUser.getAvatar());
            userListDto.setWeworkId(weworkUser.getWeworkDigitId());
            userListDto.setStatus(weworkOnlineMap.getOrDefault(weworkUser.getWeworkDigitId(), 0));
            result.add(userListDto);
        }
        return result;
    }

    @Override
    public List<VipConversationResp> conversationList(ConversationListReq params) {
        log.info("conversation list params: {}", (Object)params);
        params.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        VipWeworkAccount weworkAccount = this.getVipWeworkAccount(bizId, params.getWeworkUserId());
        String weworkId = weworkAccount.getWeworkId();
        String digitCorpId = weworkAccount.getCorpId();
        List conversationList = Lists.newArrayList();
        PageDto pageDto = params.getPageDto();
        if (pageDto != null) {
            Page page = PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize()).doSelectPage(() -> this.vipWeworkConversationMapper.weworkConversationList(digitCorpId, weworkId, params.getTalkerType()));
            pageDto.setCount(Integer.valueOf((int)page.getTotal()));
            conversationList = page.getResult();
        }
        if (CollectionUtils.isEmpty((Collection)conversationList)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        Set talkIds = conversationList.stream().map(VipWeworkConversation::getTalkerId).collect(Collectors.toSet());
        HashMap<String, VipWeworkContact> vipContactMap = new HashMap<String, VipWeworkContact>();
        List vipWeworkContacts = this.vipWeworkContactMapper.queryContactCorpInfo(bizId, weworkId, talkIds);
        for (VipWeworkContact vipWeworkContact : vipWeworkContacts) {
            vipContactMap.put(vipWeworkContact.getContactId(), vipWeworkContact);
        }
        HashMap<String, ChatRoomBasicInfoDto> vipChatRoomMap = new HashMap<String, ChatRoomBasicInfoDto>();
        List chatRoomBasicInfoDtos = this.vipWeworkReportChatRoomMapper.queryByWeworkIdAndChatRoomIds(weworkId, talkIds, digitCorpId, bizId);
        for (ChatRoomBasicInfoDto chatRoom : chatRoomBasicInfoDtos) {
            vipChatRoomMap.put(chatRoom.getChatRoomId(), chatRoom);
        }
        HashMap<String, List> roomMemberMap = new HashMap<String, List>();
        List vipWeworkChatRoomRelations = this.vipWeworkChatRoomRelationMapper.queryWeworkRoomRelations(talkIds);
        for (VipWeworkChatRoomRelation roomRelation : vipWeworkChatRoomRelations) {
            List memList = roomMemberMap.getOrDefault(roomRelation.getChatRoomId(), Lists.newArrayList());
            memList.add(roomRelation.getMemberId());
            roomMemberMap.put(roomRelation.getChatRoomId(), memList);
        }
        for (VipWeworkConversation conversation : conversationList) {
            ChatRoomBasicInfoDto room;
            VipConversationResp resp = new VipConversationResp();
            String conversationId = conversation.getWeworkId() + CONVERSATION_SPLIT_LABEL + conversation.getTalkerId();
            resp.setConversationId(conversationId);
            resp.setTalkerId(conversation.getTalkerId());
            resp.setTalkerType(conversation.getTalkerType());
            if (conversation.getTalkerType().intValue() == TalkerType.CONTACT.getValue()) {
                VipWeworkContact contact = (VipWeworkContact)vipContactMap.get(conversation.getTalkerId());
                if (contact != null) {
                    resp.setTalkerName(contact.getRealName());
                    if (StringUtils.isEmpty((CharSequence)resp.getTalkerName())) {
                        resp.setTalkerName(contact.getNickname());
                    }
                    resp.setTalkerRemark(contact.getRemark());
                    resp.setAvatar(contact.getAvatar());
                    resp.setCorpName(contact.getCorpName());
                    resp.setCorpFullName(contact.getCorpName());
                    resp.setIsZombieFans(contact.getIsZombieFans());
                    resp.setIsDeleted(contact.getIsDeleted());
                }
            } else if (conversation.getTalkerType().intValue() == TalkerType.CHATROOM.getValue() && (room = (ChatRoomBasicInfoDto)vipChatRoomMap.get(conversation.getTalkerId())) != null) {
                resp.setTalkerName(room.getNickname());
                resp.setAvatar(room.getAvatar());
                resp.setIsDismiss(room.getWasDeleted());
                List memList = (List)roomMemberMap.get(room.getChatRoomId());
                if (CollectionUtils.isNotEmpty((Collection)memList)) {
                    if (memList.contains(conversation.getWeworkId())) {
                        resp.setIsLevel(0);
                    } else {
                        resp.setIsLevel(1);
                    }
                }
            }
            resp.setSenderName(conversation.getDigestUser());
            resp.setLastMsgDigest(conversation.getDigest());
            resp.setLastMsgSendTime(conversation.getLastMsgTime());
            if (resp.getIsDeleted() == null) {
                resp.setIsDeleted(conversation.getIsDeleted());
            }
            resp.setExternalType(conversation.getExternalType());
            resp.setIsTop(conversation.getIsTop());
            resp.setWeworkUserId(params.getWeworkUserId());
            result.add(resp);
        }
        return result;
    }

    @Override
    public ConversationSearchResp conversationSearch(ConversationSearchReq params) {
        log.info("conversationSearch params: {}", (Object)params);
        params.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        VipWeworkAccount weworkAccount = this.getVipWeworkAccount(bizId, params.getWeworkUserId());
        String weworkId = weworkAccount.getWeworkId();
        String digitCorpId = weworkAccount.getCorpId();
        ConversationSearchResp resp = new ConversationSearchResp();
        List vipWeworkContacts = this.vipWeworkContactMapper.searchByQuery(bizId, weworkId, params.getQuery());
        Map<String, VipWeworkConversation> conversationMap = this.getVipWeworkConversationMap(weworkAccount.getCorpId(), weworkId, TalkerType.CONTACT.getValue());
        ArrayList contactList = Lists.newArrayList();
        for (VipWeworkContact contact : vipWeworkContacts) {
            SearchContactResp contactResp = new SearchContactResp();
            contactResp.setTalkerId(contact.getContactId());
            contactResp.setTalkerName(contact.getNickname());
            contactResp.setTalkerRemark(contact.getRemark());
            contactResp.setTalkerType(0);
            contactResp.setAvatar(contact.getAvatar());
            contactResp.setRemark(contact.getRemark());
            contactResp.setCorpName(contact.getCorpName());
            contactResp.setCorpFullName(contact.getCorpName());
            contactResp.setExternalType(contact.getExternalFlag());
            contactResp.setConversationId(weworkId + CONVERSATION_SPLIT_LABEL + contact.getContactId());
            VipWeworkConversation conversation = conversationMap.get(contact.getContactId());
            if (conversation != null) {
                contactResp.setLastMsgDigest(conversation.getDigest());
                contactResp.setLastMsgSendTime(conversation.getLastMsgTime());
            }
            contactList.add(contactResp);
        }
        resp.setContactList(contactList);
        List vipWeworkChatRooms = this.vipWeworkReportChatRoomMapper.searchQuery(bizId, weworkId, params.getQuery());
        Map<String, VipWeworkConversation> chatRoomConversationMap = this.getVipWeworkConversationMap(weworkAccount.getCorpId(), weworkId, TalkerType.CHATROOM.getValue());
        ArrayList weworkRoomList = Lists.newArrayList();
        for (VipWeworkReportChatRoom weworkChatRoom : vipWeworkChatRooms) {
            SearchRoomResp roomResp = new SearchRoomResp();
            roomResp.setTalkerId(weworkChatRoom.getChatRoomId());
            roomResp.setTalkerName(weworkChatRoom.getNickname());
            roomResp.setTalkerType(1);
            roomResp.setExternalType(weworkChatRoom.getExternalFlag());
            roomResp.setAvatar(weworkChatRoom.getAvatar());
            VipWeworkConversation conversation = chatRoomConversationMap.get(weworkChatRoom.getChatRoomId());
            if (conversation != null) {
                roomResp.setLastMsgDigest(conversation.getDigest());
                roomResp.setLastMsgSendTime(conversation.getLastMsgTime());
            }
            roomResp.setConversationId(weworkId + CONVERSATION_SPLIT_LABEL + weworkChatRoom.getChatRoomId());
            weworkRoomList.add(roomResp);
        }
        resp.setWeworkRoomList(weworkRoomList);
        List messageList = this.weworkCommonMessageService.queryList(weworkAccount.getCorpId(), weworkId, params.getQuery());
        HashMap conversationMsgMap = Maps.newHashMap();
        HashSet contactIds = Sets.newHashSet();
        HashSet chatRoomIds = Sets.newHashSet();
        for (WeworkMessage message : messageList) {
            String talkerId = message.getConId();
            List values = conversationMsgMap.getOrDefault(talkerId, Lists.newArrayList());
            values.add(message);
            conversationMsgMap.put(talkerId, values);
            if (message.getConType().intValue() == TalkerType.CONTACT.getValue()) {
                contactIds.add(talkerId);
                continue;
            }
            if (message.getConType().intValue() != TalkerType.CHATROOM.getValue()) continue;
            chatRoomIds.add(talkerId);
        }
        List msgContacts = this.vipWeworkContactMapper.queryContactCorpInfo(bizId, weworkId, (Collection)contactIds);
        List msgChatRooms = this.vipWeworkReportChatRoomMapper.queryByWeworkIdAndChatRoomIds(weworkId, (Collection)chatRoomIds, digitCorpId, bizId);
        HashMap vipContactMap = Maps.newHashMap();
        for (Object contact : msgContacts) {
            vipContactMap.put(contact.getContactId(), contact);
        }
        HashMap vipChatRoomMap = Maps.newHashMap();
        for (ChatRoomBasicInfoDto chatRoom : msgChatRooms) {
            vipChatRoomMap.put(chatRoom.getChatRoomId(), chatRoom);
        }
        ArrayList msgList = Lists.newArrayList();
        Map<String, VipWeworkConversation> msgConversationMap = this.getVipWeworkConversationMap(weworkAccount.getCorpId(), weworkId, null);
        for (Map.Entry entry : conversationMsgMap.entrySet()) {
            ChatRoomBasicInfoDto chatRoom;
            SearchMsgResp msgResp = new SearchMsgResp();
            msgResp.setConversationId(weworkId + CONVERSATION_SPLIT_LABEL + (String)entry.getKey());
            VipWeworkConversation conversation = msgConversationMap.get(entry.getKey());
            List values = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)values)) continue;
            WeworkMessage message = (WeworkMessage)values.get(0);
            if (message.getConType().intValue() == TalkerType.CONTACT.getValue()) {
                VipWeworkContact contact = (VipWeworkContact)vipContactMap.get(entry.getKey());
                if (contact != null) {
                    msgResp.setCorpName(contact.getCorpName());
                    msgResp.setTalkerName(contact.getNickname());
                    msgResp.setTalkerRemark(contact.getRemark());
                    msgResp.setTalkerType(TalkerType.CONTACT.getValue());
                    msgResp.setMatchCount(values.size());
                    msgResp.setAvatar(contact.getAvatar());
                    msgResp.setExternalType(contact.getExternalFlag());
                }
            } else if (message.getConType().intValue() == TalkerType.CHATROOM.getValue() && (chatRoom = (ChatRoomBasicInfoDto)vipChatRoomMap.get(entry.getKey())) != null) {
                msgResp.setTalkerName(chatRoom.getNickname());
                msgResp.setTalkerType(TalkerType.CHATROOM.getValue());
                msgResp.setMatchCount(values.size());
                msgResp.setAvatar(chatRoom.getAvatar());
                msgResp.setExternalType(chatRoom.getExternalType());
            }
            if (conversation != null) {
                msgResp.setLastMsgDigest(conversation.getDigest());
                msgResp.setLastMsgSendTime(conversation.getLastMsgTime());
            }
            msgList.add(msgResp);
        }
        resp.setMessageList(msgList);
        return resp;
    }

    @Override
    public List<ConversationUnreadResp> unreadCountList(ConversationIdReq params) {
        log.info("unread count list: {}", (Object)params);
        if (CollectionUtils.isEmpty(params.getConversationIds())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4f1a\u8bddid\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList result = Lists.newArrayList();
        for (String conversationId : params.getConversationIds()) {
            Object count = this.redisTemplate.opsForValue().get((Object)this.getConversationKey(conversationId));
            ConversationUnreadResp resp = new ConversationUnreadResp();
            resp.setConversationId(conversationId);
            if (count != null) {
                resp.setCount(Integer.parseInt(String.valueOf(count)));
            } else {
                resp.setCount(null);
            }
            result.add(resp);
        }
        return result;
    }

    @Override
    public void clearUnreadCount(ConversationIdReq params) {
        log.info("clear unread count params: {}", (Object)params);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)params.getConversationId()), (Object)"ConversationId is not empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)params.getWeworkUserId()), (Object)"weworkId is not empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)params.getTalkerId()), (Object)"talkerId is not empty");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        VipWeworkAccount weworkAccount = this.getVipWeworkAccount(bizId, params.getWeworkUserId());
        String weworkId = weworkAccount.getWeworkId();
        String digitCorpId = weworkAccount.getCorpId();
        String talkerId = params.getConversationId().replace(weworkId, "").replace(CONVERSATION_SPLIT_LABEL, "");
        if (!params.getTalkerId().equals(talkerId)) {
            log.info("clear unread count params \u6839\u636e\u4f1a\u8bdd\u67e5\u8be2\u7684\u5ba2\u6237ID \u4e0e\u4f20\u53c2\u4e0d\u7b26\u3002 param TalkerId: {}, ConversationId: {}", (Object)params.getTalkerId(), (Object)params.getConversationId());
            Preconditions.checkArgument((boolean)params.getTalkerId().equals(talkerId), (Object)"\u6839\u636e\u4f1a\u8bdd\u67e5\u8be2\u7684\u5ba2\u6237ID \u4e0e\u4f20\u53c2talkerId\u4e0d\u7b26");
        }
        log.info("clear unread count params get weworkId: {}, digitCorpId: {}", (Object)weworkId, (Object)digitCorpId);
        if (StringUtils.isEmpty((CharSequence)weworkId) || StringUtils.isEmpty((CharSequence)digitCorpId)) {
            log.info("clear unread count params get weworkId is empty or digitCorpId is empty");
            return;
        }
        try {
            ClearBubbleReq bubbleReq = new ClearBubbleReq();
            bubbleReq.setBizId(bizId);
            bubbleReq.setCorpId(digitCorpId);
            bubbleReq.setOpPlatform(Integer.valueOf(OpPlatform.MANAGER.getType()));
            bubbleReq.setWeworkId(weworkId);
            bubbleReq.setTargetId(params.getTalkerId());
            BaseResponse baseResponse = this.messageService.clearBubble(bubbleReq);
            String requestId = baseResponse.getRequestId();
            log.info(" \u8c03\u7528link param:{} \u8fd4\u56de\u7ed3\u679c\uff1a:{}, requestId: {}", new Object[]{JSON.toJSONString((Object)params), JSON.toJSONString((Object)baseResponse), requestId});
            long code = baseResponse.getCode();
            if ((long)ResponseCodeType.SUCCESS.getCode() == code) {
                this.redisTemplate.delete((Object)this.getConversationKey(params.getConversationId()));
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528 messageService.clearBubble error: param:{},", (Object)JSON.toJSONString((Object)params), (Object)e);
        }
    }

    private String getConversationKey(String conversationId) {
        return this.redisKeyPrefix + ":" + conversationId;
    }

    @Override
    public ConversationMsgResp conversationSearchMessageDetail(ConversationSearchDetailReq params) {
        log.info("conversion search message detail params: {}", (Object)params);
        params.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        VipWeworkAccount weworkAccount = this.getVipWeworkAccount(bizId, params.getWeworkUserId());
        String weworkId = weworkAccount.getWeworkId();
        String digitCorpId = weworkAccount.getCorpId();
        List splitList = Splitter.on((String)CONVERSATION_SPLIT_LABEL).splitToList((CharSequence)params.getConversationId());
        Preconditions.checkArgument((splitList.size() == 2 ? 1 : 0) != 0, (Object)"\u4f1a\u8bdd\u53c2\u6570\u4e0d\u5bf9");
        String talkerId = (String)splitList.get(1);
        QueryMsgCondition condition = new QueryMsgCondition();
        condition.setCorpId(digitCorpId);
        condition.setWeworkId(weworkId);
        condition.setConId(talkerId);
        condition.setQuery(params.getQuery());
        condition.setContentTypes(params.getContentTypes());
        List messageList = this.weworkCommonMessageService.queryList(condition);
        List talkerMsgList = this.messageConvertSupport.convertMessageList(bizId, weworkId, params.getWeworkUserId(), talkerId, messageList);
        ConversationMsgResp resp = new ConversationMsgResp();
        resp.setWeworkId(weworkId);
        resp.setTalkerId(talkerId);
        resp.setWeworkUserId(params.getWeworkUserId());
        resp.setTalkerMsgList(talkerMsgList);
        return resp;
    }

    @Override
    public ConversationMsgResp messageAroundList(MessageAroundListReq params) {
        log.info("message around list: {}", (Object)params);
        params.validate();
        ConversationMsgResp resp = new ConversationMsgResp();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        VipWeworkAccount weworkAccount = this.getVipWeworkAccount(bizId, params.getWeworkUserId());
        String digitCorpId = weworkAccount.getCorpId();
        List splitList = Splitter.on((String)CONVERSATION_SPLIT_LABEL).splitToList((CharSequence)params.getConversationId());
        Preconditions.checkArgument((splitList.size() == 2 ? 1 : 0) != 0, (Object)"\u4f1a\u8bdd\u53c2\u6570\u4e0d\u5bf9");
        String weworkId = (String)splitList.get(0);
        String talkerId = (String)splitList.get(1);
        WeworkMessage message = this.weworkCommonMessageService.selectByPrimaryKeyFromES(params.getMsgId());
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"\u6d88\u606fid\u4e0d\u5bf9\u627e\u4e0d\u5230\u6d88\u606f");
        QueryMsgCondition queryMsgCondition = new QueryMsgCondition();
        queryMsgCondition.setCorpId(digitCorpId);
        queryMsgCondition.setWeworkId(weworkId);
        queryMsgCondition.setConId(talkerId);
        queryMsgCondition.setSearchDirection(Integer.valueOf(1));
        queryMsgCondition.setSendTime(Long.valueOf(message.getSendTime().getTime()));
        queryMsgCondition.setSearchCount(params.getCount());
        List beforePage = this.weworkCommonMessageService.queryListBySendTime(queryMsgCondition);
        queryMsgCondition.setSearchDirection(Integer.valueOf(2));
        List afterPage = this.weworkCommonMessageService.queryListBySendTime(queryMsgCondition);
        ArrayList messageList = Lists.newArrayList();
        for (int i = beforePage.size() - 1; i >= 0; --i) {
            messageList.add(beforePage.get(i));
        }
        messageList.add(message);
        messageList.addAll(afterPage);
        resp.setWeworkId(weworkId);
        resp.setTalkerId(talkerId);
        resp.setWeworkUserId(params.getWeworkUserId());
        List talkerMsgList = this.messageConvertSupport.convertMessageList(bizId, weworkId, params.getWeworkUserId(), talkerId, (List)messageList);
        resp.setTalkerMsgList(talkerMsgList);
        return resp;
    }

    private VipWeworkAccount getVipWeworkAccount(Long bizId, String weworkUserId) {
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(weworkUserId);
        Preconditions.checkArgument((weworkUser != null ? 1 : 0) != 0, (Object)"\u627e\u4e0d\u5230\u6210\u5458");
        if (StringUtils.isBlank((CharSequence)weworkUser.getWeworkDigitId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230digitId");
        }
        String weworkId = weworkUser.getWeworkDigitId();
        VipWeworkAccount weworkAccount = this.vipWeworkAccountMapper.getWeworkAccount(bizId, weworkId);
        Preconditions.checkArgument((weworkAccount != null ? 1 : 0) != 0, (Object)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684vip\u6210\u5458");
        return weworkAccount;
    }

    private Map<String, VipWeworkConversation> getVipWeworkConversationMap(String digitCorpId, String weworkId, Integer talkerType) {
        List conversationList = this.vipWeworkConversationMapper.weworkConversationList(digitCorpId, weworkId, talkerType);
        HashMap result = Maps.newHashMap();
        for (VipWeworkConversation conversation : conversationList) {
            result.put(conversation.getTalkerId(), conversation);
        }
        return result;
    }

    private Map<String, Integer> getWeworkIdOnlineMap(Long bizId, List<String> weworkDigitIds) {
        BaseResponse weworksStatus;
        HashMap weworkOnlineMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(weworkDigitIds) && (weworksStatus = this.operateService.queryWeworksStatus(bizId, weworkDigitIds)) != null && weworksStatus.getCode() == 0L) {
            List statusData = (List)weworksStatus.getData();
            if (CollectionUtils.isEmpty((Collection)statusData)) {
                log.warn("wework online status is empty");
            } else {
                for (WeworkStatusInfo statusInfo : statusData) {
                    weworkOnlineMap.put(statusInfo.getWeworkId(), statusInfo.isOnline() ? 1 : 0);
                }
            }
        }
        return weworkOnlineMap;
    }

    @Override
    public void conversationTop(ConversationTopReq req) {
        log.info("conversationTop req: {}", (Object)req);
        req.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        VipWeworkAccount weworkAccount = this.getVipWeworkAccount(bizId, req.getWeworkUserId());
        String weworkId = weworkAccount.getWeworkId();
        String digitCorpId = weworkAccount.getCorpId();
        log.info("conversationTop get weworkId: {}, digitCorpId: {}", (Object)weworkId, (Object)digitCorpId);
        if (StringUtils.isEmpty((CharSequence)weworkId) || StringUtils.isEmpty((CharSequence)digitCorpId)) {
            log.info("conversationTop get weworkId is empty or digitCorpId is empty");
            return;
        }
        Integer conversationType = this.vipWeworkConversationMapper.queryTalkerTypeByTalkerId(digitCorpId, weworkId, req.getTalkerId());
        log.info("conversationTop conversationType: {}", (Object)conversationType);
        if (conversationType == null) {
            return;
        }
        if (conversationType == 0) {
            VipWeworkContact vipWeworkContact = this.vipWeworkContactMapper.queryByWeworkIdAndContactId(weworkId, req.getTalkerId(), bizId);
            if (vipWeworkContact == null) {
                log.info("conversationTop get vipWeworkContact is empty");
                return;
            }
            if (vipWeworkContact.getIsDeleted() == 1 || vipWeworkContact.getIsZombieFans() == 1) {
                this.vipWeworkConversationMapper.updateVipWeworkConTop(digitCorpId, weworkId, req.getTalkerId(), req.getIsTop());
                log.info("conversationTop updateVipWeworkConTop talkerId: {}", (Object)req.getTalkerId());
                return;
            }
        }
        if (conversationType == 1) {
            VipWeworkReportChatRoom chatRoom = this.vipWeworkReportChatRoomMapper.queryByWeworkIdChatRoomId(bizId, weworkId, req.getTalkerId());
            if (chatRoom == null) {
                log.info("conversationTop get chatRoom is empty");
                return;
            }
            if (chatRoom.getIsDeleted() == 1) {
                this.vipWeworkConversationMapper.updateVipWeworkConTop(digitCorpId, weworkId, req.getTalkerId(), req.getIsTop());
                log.info("conversationTop updateVipWeworkConTop talkerId: {}", (Object)req.getTalkerId());
                return;
            }
        }
        try {
            ConTopReq topReq = new ConTopReq();
            topReq.setBizId(bizId);
            topReq.setCorpId(digitCorpId);
            topReq.setOpPlatform(Integer.valueOf(OpPlatform.MANAGER.getType()));
            topReq.setWeworkId(weworkId);
            topReq.setTargetId(req.getTalkerId());
            topReq.setIsTop(req.getIsTop());
            topReq.setType(conversationType.intValue());
            BaseResponse baseResponse = this.messageService.conTop(topReq);
            String requestId = baseResponse.getRequestId();
            log.info(" \u8c03\u7528link param:{} \u8fd4\u56de\u7ed3\u679c\uff1a:{}, requestId: {}", new Object[]{JSON.toJSONString((Object)req), JSON.toJSONString((Object)baseResponse), requestId});
            long code = baseResponse.getCode();
            if ((long)ResponseCodeType.SUCCESS.getCode() == code) {
                this.vipWeworkConversationMapper.updateVipWeworkConTop(digitCorpId, weworkId, req.getTalkerId(), req.getIsTop());
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528 messageService.conTop error: param:{},", (Object)JSON.toJSONString((Object)req), (Object)e);
        }
    }
}

