/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.service.impl;

import cn.kinyun.link.common_dto.dto.OpBaseResponse;
import cn.kinyun.scrm.vip.service.OnOffLineMsgService;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.OnOffLineRecordDto;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.vip.entity.VipWeworkAccount;
import com.kuaike.scrm.dal.vip.entity.VipWeworkAuthorizeAccount;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAccountMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAuthorizeAccountMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.websocket.enums.WebSocketCmd;
import com.kuaike.scrm.websocket.service.WsPushService;
import com.kuaike.scrm.websocket.service.WsSessionService;
import com.kuaike.scrm.websocket.service.dto.WebSocketMessageDto;
import com.kuaike.scrm.websocket.service.dto.WsPushReq;
import com.kuaike.scrm.websocket.service.dto.WsRestResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OnOffLineMsgServiceImpl
implements OnOffLineMsgService {
    private static final Logger log = LoggerFactory.getLogger(OnOffLineMsgServiceImpl.class);
    @Value(value="${scrm.vip.elasticsearch.onOffLineMsg}")
    private String index;
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private VipWeworkAuthorizeAccountMapper accountMapper;
    @Autowired
    private VipWeworkAccountMapper vipWeworkAccountMapper;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private WsPushService wsPushService;
    @Autowired
    private WsSessionService wsSessionService;
    private ExecutorService executorService;

    @PostConstruct
    public void init() {
        this.executorService = new ThreadPoolExecutor(2, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("OnOffLineMsgPushService"), new ThreadPoolExecutor.CallerRunsPolicy());
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.executorService);
    }

    @Override
    public void insertIntoEs(OpBaseResponse resp) {
        log.info("insertIntoEs resp={}", (Object)resp);
        if (resp == null || StringUtils.isEmpty((CharSequence)resp.getBody())) {
            log.info("resp is null or body is empty");
            return;
        }
        try {
            IndexRequest request;
            if (StringUtils.isNotBlank((CharSequence)resp.getRequestId())) {
                String id = resp.getRequestId();
                request = new IndexRequest(this.index, "doc", id);
            } else {
                request = new IndexRequest(this.index, "doc");
            }
            request.source(resp.getBody(), XContentType.JSON);
            IndexResponse indexResponse = this.restHighLevelClient.index(request, new Header[0]);
            Integer status = indexResponse.status().getStatus();
            log.info("insert es resp: {}", (Object)status);
        }
        catch (Exception e) {
            log.error("insert onOffLine into ES with error", (Throwable)e);
        }
    }

    @Override
    public void handleOnline(String body) {
        if (StringUtils.isBlank((CharSequence)body)) {
            log.info("handleOnline body is empty");
            return;
        }
        OnOffLineRecordDto recordDto = null;
        try {
            recordDto = (OnOffLineRecordDto)JacksonUtil.str2Obj((String)body, OnOffLineRecordDto.class);
        }
        catch (Exception e) {
            log.error("parse error ", (Throwable)e);
        }
        if (recordDto == null) {
            log.info("handleOnline recordDto is null");
            return;
        }
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByDigitId(recordDto.getWeworkId());
        if (weworkUser == null) {
            log.info("handleOnline weworkUser is null");
            return;
        }
        VipWeworkAuthorizeAccount authorizeAccount = this.accountMapper.queryOpenVipUser(weworkUser.getBizId(), weworkUser.getNum());
        if (authorizeAccount != null) {
            this.accountMapper.updateOnline(authorizeAccount.getNum(), Integer.valueOf(recordDto.getType()));
        }
        this.noticeOnline(recordDto);
    }

    private void noticeOnline(OnOffLineRecordDto recordDto) {
        log.info("\u901a\u77e5\u4e0a\u4e0b\u7ebf:{}", (Object)recordDto);
        try {
            VipWeworkAccount vipWeworkAccount = this.vipWeworkAccountMapper.getWeworkAccount(recordDto.getBizId(), recordDto.getWeworkId());
            Long userId = vipWeworkAccount.getUserId();
            Set userIds = this.userRoleCommonService.queryManagerUserIds(userId);
            List accounts = this.wsSessionService.getOnlineUserAccounts((Collection)userIds);
            if (CollectionUtils.isEmpty((Collection)accounts)) {
                log.info("\u6ca1\u6709\u5728\u7ebf\u7528\u6237\uff0c\u4e0d\u6267\u884c\u63a8\u9001\u3002");
                return;
            }
            HashMap<String, Object> content = new HashMap<String, Object>();
            content.put("weworkId", recordDto.getWeworkId());
            content.put("type", recordDto.getType());
            content.put("time", recordDto.getTime());
            WebSocketMessageDto webSocketMessageDto = new WebSocketMessageDto();
            webSocketMessageDto.setCmd(WebSocketCmd.WEWORK_ONLINE_STATUS.getCmd());
            webSocketMessageDto.setContent(content);
            for (String account : accounts) {
                this.asyncPush(account, webSocketMessageDto);
            }
        }
        catch (Exception e) {
            log.error("\u901a\u77e5\u4e0a\u4e0b\u7ebf\u5931\u8d25", (Throwable)e);
        }
    }

    private void asyncPush(String account, WebSocketMessageDto message) {
        this.executorService.submit(() -> {
            WsPushReq wsPushReq = new WsPushReq();
            wsPushReq.setAccount(account);
            wsPushReq.setMessage(message);
            try {
                WsRestResponse resp = this.wsPushService.push(wsPushReq);
                if (resp != null && resp.getCode() == 0L) {
                    log.info("\u901a\u77e5\u4e0a\u4e0b\u7ebf\u6d88\u606f\u6210\u529f:{}", (Object)account);
                } else {
                    log.info("\u901a\u77e5\u4e0a\u4e0b\u7ebf\u6d88\u606f\u5931\u8d25:{}, resp:{}", (Object)account, (Object)resp);
                }
            }
            catch (Exception e) {
                log.error("\u901a\u77e5\u4e0a\u4e0b\u7ebf\u6d88\u606f\u5f02\u5e38:{}", (Object)account, (Object)e);
            }
        });
    }
}

