/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.service.impl;

import cn.kinyun.link.common_dto.dto.BaseResponse;
import cn.kinyun.link.common_dto.enums.OpPlatform;
import cn.kinyun.link.service.ContactService;
import cn.kinyun.link.service.contact.request.AddFriendByPhoneReq;
import com.alibaba.fastjson.JSON;
import com.kuaike.scrm.common.enums.TelAddFriendStatus;
import com.kuaike.scrm.common.enums.addfriend.AddFriendsTaskType;
import com.kuaike.scrm.dal.teladdfriend.entity.TelAddFriendTaskDetail;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskDetailMapper;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AddFriendLinkSupport {
    private static final Logger log = LoggerFactory.getLogger(AddFriendLinkSupport.class);
    @Autowired
    ContactService contactService;
    @Resource
    private TelAddFriendTaskDetailMapper telAddFriendTaskDetailMapper;
    private static final String DEFAULT_APPLY_CONTENT = "\u8bf7\u6c42\u6dfb\u52a0\u4f60\u4e3a\u597d\u53cb";

    public void addFriend(List<TelAddFriendTaskDetail> taskDetails) {
        CompletableFuture.runAsync(() -> this.addFriendByPhoneLis(taskDetails));
    }

    public void addFriendByPhoneLis(List<TelAddFriendTaskDetail> taskDetails) {
        for (TelAddFriendTaskDetail detail : taskDetails) {
            if (Objects.nonNull(detail.getTaskType()) && detail.getTaskType().intValue() != AddFriendsTaskType.ENHANCE_ADD.getValue()) {
                return;
            }
            AddFriendByPhoneReq req = null;
            try {
                req = new AddFriendByPhoneReq();
                req.setCorpId(detail.getCorpId());
                req.setBizId(detail.getBizId());
                req.setApplyContent(detail.getWeworkUserName());
                req.setOpPlatform(Integer.valueOf(OpPlatform.MANAGER.getType()));
                req.setDeadline(detail.getExpireTime());
                req.setWeworkId(detail.getUserDigitId());
                req.setPhoneNum(detail.getTel());
                req.setApplyContent(detail.getWeworkUserName() + DEFAULT_APPLY_CONTENT);
                BaseResponse baseResponse = this.contactService.addFriendByPhone(req);
                log.info(" \u8c03\u7528link param:{} \u8fd4\u56de\u7ed3\u679c\uff1a:{}", (Object)JSON.toJSONString((Object)req), (Object)JSON.toJSONString((Object)baseResponse));
                TelAddFriendTaskDetail update = new TelAddFriendTaskDetail();
                update.setId(detail.getId());
                update.setStatus(Integer.valueOf(TelAddFriendStatus.APPLY_ING.getStatus()));
                this.telAddFriendTaskDetailMapper.updateByPrimaryKeySelective((Object)update);
            }
            catch (Exception e) {
                log.error("\u8c03\u7528 contactService.addFriendByPhone error: param:{},", (Object)JSON.toJSONString((Object)req), (Object)e);
            }
        }
    }
}

