/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.dto;

import cn.kinyun.scrm.vip.dto.IdAndNameAvatarDto;
import cn.kinyun.scrm.vip.dto.TagAndLevelDto;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.dal.vip.entity.VipWeworkAliasInfo;
import com.kuaike.scrm.dal.vip.entity.VipWeworkChatRoomRelation;
import com.kuaike.scrm.dal.vip.entity.VipWeworkReportChatRoom;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class WechatChatRoomDetailRespDto
implements Serializable {
    private static final long serialVersionUID = -3543960608579545584L;
    private String chatRoomId;
    private String chatRoomNickName;
    private String qrcode;
    private String chatRoomAvatar;
    private String chatRoomNotice;
    private Integer wasDeleted;
    private String owner;
    private Boolean isRobotOwner;
    private List<TagAndLevelDto> chatRoomTagList;
    private List<IdAndNameAvatarDto> memberList;
    private int memberCount;
    private Integer groupValidation;
    private static final Set<Integer> groupValidationValues = Sets.newHashSet((Object[])new Integer[]{2, 0});

    public static WechatChatRoomDetailRespDto fromEntity(VipWeworkReportChatRoom chatRoom, List<VipWeworkChatRoomRelation> chatRoomRelations, List<VipWeworkAliasInfo> vipWeworkAliasInfos, List<TagAndLevelDto> tagIds) {
        WechatChatRoomDetailRespDto chatRoomDetail = new WechatChatRoomDetailRespDto();
        chatRoomDetail.setChatRoomId(chatRoom.getChatRoomId());
        chatRoomDetail.setChatRoomAvatar(chatRoom.getAvatar());
        chatRoomDetail.setChatRoomNotice(chatRoom.getNotice());
        chatRoomDetail.setChatRoomNickName(chatRoom.getNickname());
        chatRoomDetail.setOwner(chatRoom.getOwner());
        chatRoomDetail.setQrcode(chatRoom.getQrcode());
        chatRoomDetail.setChatRoomTagList(tagIds);
        chatRoomDetail.setGroupValidation(null);
        chatRoomDetail.setWasDeleted(chatRoom.getIsDeleted());
        HashMap aliasInfoMap = Maps.newHashMap();
        for (VipWeworkAliasInfo aliasInfo : vipWeworkAliasInfos) {
            aliasInfoMap.put(aliasInfo.getWeworkId(), aliasInfo);
        }
        if (CollectionUtils.isNotEmpty(chatRoomRelations)) {
            List<IdAndNameAvatarDto> dtoList = chatRoomRelations.stream().filter(item -> item.getIsDeleted() == 0).map(item -> {
                VipWeworkAliasInfo aliasInfo = (VipWeworkAliasInfo)aliasInfoMap.get(item.getMemberId());
                IdAndNameAvatarDto dto = new IdAndNameAvatarDto();
                Integer isOwner = chatRoom.getOwner().equals(item.getMemberId()) ? YnEnum.YES.getValue() : YnEnum.NO.getValue();
                dto.setIsOwner(isOwner);
                if (aliasInfo != null) {
                    dto.setMemberAvatar(aliasInfo.getAvatar());
                    dto.setMemberName(aliasInfo.getNickname());
                    dto.setMemberProvince(aliasInfo.getProvince());
                    dto.setMemberCity(aliasInfo.getCity());
                }
                dto.setMemberRemark(item.getMemberRemark());
                dto.setMemberWechatId(item.getMemberId());
                return dto;
            }).collect(Collectors.toList());
            chatRoomDetail.setMemberList(dtoList);
        }
        return chatRoomDetail;
    }

    public String getChatRoomId() {
        return this.chatRoomId;
    }

    public String getChatRoomNickName() {
        return this.chatRoomNickName;
    }

    public String getQrcode() {
        return this.qrcode;
    }

    public String getChatRoomAvatar() {
        return this.chatRoomAvatar;
    }

    public String getChatRoomNotice() {
        return this.chatRoomNotice;
    }

    public Integer getWasDeleted() {
        return this.wasDeleted;
    }

    public String getOwner() {
        return this.owner;
    }

    public Boolean getIsRobotOwner() {
        return this.isRobotOwner;
    }

    public List<TagAndLevelDto> getChatRoomTagList() {
        return this.chatRoomTagList;
    }

    public List<IdAndNameAvatarDto> getMemberList() {
        return this.memberList;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public Integer getGroupValidation() {
        return this.groupValidation;
    }

    public void setChatRoomId(String chatRoomId) {
        this.chatRoomId = chatRoomId;
    }

    public void setChatRoomNickName(String chatRoomNickName) {
        this.chatRoomNickName = chatRoomNickName;
    }

    public void setQrcode(String qrcode) {
        this.qrcode = qrcode;
    }

    public void setChatRoomAvatar(String chatRoomAvatar) {
        this.chatRoomAvatar = chatRoomAvatar;
    }

    public void setChatRoomNotice(String chatRoomNotice) {
        this.chatRoomNotice = chatRoomNotice;
    }

    public void setWasDeleted(Integer wasDeleted) {
        this.wasDeleted = wasDeleted;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setIsRobotOwner(Boolean isRobotOwner) {
        this.isRobotOwner = isRobotOwner;
    }

    public void setChatRoomTagList(List<TagAndLevelDto> chatRoomTagList) {
        this.chatRoomTagList = chatRoomTagList;
    }

    public void setMemberList(List<IdAndNameAvatarDto> memberList) {
        this.memberList = memberList;
    }

    public void setMemberCount(int memberCount) {
        this.memberCount = memberCount;
    }

    public void setGroupValidation(Integer groupValidation) {
        this.groupValidation = groupValidation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WechatChatRoomDetailRespDto)) {
            return false;
        }
        WechatChatRoomDetailRespDto other = (WechatChatRoomDetailRespDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMemberCount() != other.getMemberCount()) {
            return false;
        }
        Integer this$wasDeleted = this.getWasDeleted();
        Integer other$wasDeleted = other.getWasDeleted();
        if (this$wasDeleted == null ? other$wasDeleted != null : !((Object)this$wasDeleted).equals(other$wasDeleted)) {
            return false;
        }
        Boolean this$isRobotOwner = this.getIsRobotOwner();
        Boolean other$isRobotOwner = other.getIsRobotOwner();
        if (this$isRobotOwner == null ? other$isRobotOwner != null : !((Object)this$isRobotOwner).equals(other$isRobotOwner)) {
            return false;
        }
        Integer this$groupValidation = this.getGroupValidation();
        Integer other$groupValidation = other.getGroupValidation();
        if (this$groupValidation == null ? other$groupValidation != null : !((Object)this$groupValidation).equals(other$groupValidation)) {
            return false;
        }
        String this$chatRoomId = this.getChatRoomId();
        String other$chatRoomId = other.getChatRoomId();
        if (this$chatRoomId == null ? other$chatRoomId != null : !this$chatRoomId.equals(other$chatRoomId)) {
            return false;
        }
        String this$chatRoomNickName = this.getChatRoomNickName();
        String other$chatRoomNickName = other.getChatRoomNickName();
        if (this$chatRoomNickName == null ? other$chatRoomNickName != null : !this$chatRoomNickName.equals(other$chatRoomNickName)) {
            return false;
        }
        String this$qrcode = this.getQrcode();
        String other$qrcode = other.getQrcode();
        if (this$qrcode == null ? other$qrcode != null : !this$qrcode.equals(other$qrcode)) {
            return false;
        }
        String this$chatRoomAvatar = this.getChatRoomAvatar();
        String other$chatRoomAvatar = other.getChatRoomAvatar();
        if (this$chatRoomAvatar == null ? other$chatRoomAvatar != null : !this$chatRoomAvatar.equals(other$chatRoomAvatar)) {
            return false;
        }
        String this$chatRoomNotice = this.getChatRoomNotice();
        String other$chatRoomNotice = other.getChatRoomNotice();
        if (this$chatRoomNotice == null ? other$chatRoomNotice != null : !this$chatRoomNotice.equals(other$chatRoomNotice)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        List<TagAndLevelDto> this$chatRoomTagList = this.getChatRoomTagList();
        List<TagAndLevelDto> other$chatRoomTagList = other.getChatRoomTagList();
        if (this$chatRoomTagList == null ? other$chatRoomTagList != null : !((Object)this$chatRoomTagList).equals(other$chatRoomTagList)) {
            return false;
        }
        List<IdAndNameAvatarDto> this$memberList = this.getMemberList();
        List<IdAndNameAvatarDto> other$memberList = other.getMemberList();
        return !(this$memberList == null ? other$memberList != null : !((Object)this$memberList).equals(other$memberList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WechatChatRoomDetailRespDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMemberCount();
        Integer $wasDeleted = this.getWasDeleted();
        result = result * 59 + ($wasDeleted == null ? 43 : ((Object)$wasDeleted).hashCode());
        Boolean $isRobotOwner = this.getIsRobotOwner();
        result = result * 59 + ($isRobotOwner == null ? 43 : ((Object)$isRobotOwner).hashCode());
        Integer $groupValidation = this.getGroupValidation();
        result = result * 59 + ($groupValidation == null ? 43 : ((Object)$groupValidation).hashCode());
        String $chatRoomId = this.getChatRoomId();
        result = result * 59 + ($chatRoomId == null ? 43 : $chatRoomId.hashCode());
        String $chatRoomNickName = this.getChatRoomNickName();
        result = result * 59 + ($chatRoomNickName == null ? 43 : $chatRoomNickName.hashCode());
        String $qrcode = this.getQrcode();
        result = result * 59 + ($qrcode == null ? 43 : $qrcode.hashCode());
        String $chatRoomAvatar = this.getChatRoomAvatar();
        result = result * 59 + ($chatRoomAvatar == null ? 43 : $chatRoomAvatar.hashCode());
        String $chatRoomNotice = this.getChatRoomNotice();
        result = result * 59 + ($chatRoomNotice == null ? 43 : $chatRoomNotice.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        List<TagAndLevelDto> $chatRoomTagList = this.getChatRoomTagList();
        result = result * 59 + ($chatRoomTagList == null ? 43 : ((Object)$chatRoomTagList).hashCode());
        List<IdAndNameAvatarDto> $memberList = this.getMemberList();
        result = result * 59 + ($memberList == null ? 43 : ((Object)$memberList).hashCode());
        return result;
    }

    public String toString() {
        return "WechatChatRoomDetailRespDto(chatRoomId=" + this.getChatRoomId() + ", chatRoomNickName=" + this.getChatRoomNickName() + ", qrcode=" + this.getQrcode() + ", chatRoomAvatar=" + this.getChatRoomAvatar() + ", chatRoomNotice=" + this.getChatRoomNotice() + ", wasDeleted=" + this.getWasDeleted() + ", owner=" + this.getOwner() + ", isRobotOwner=" + this.getIsRobotOwner() + ", chatRoomTagList=" + this.getChatRoomTagList() + ", memberList=" + this.getMemberList() + ", memberCount=" + this.getMemberCount() + ", groupValidation=" + this.getGroupValidation() + ")";
    }
}

