/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.cache.service.impl;

import cn.kinyun.scrm.vip.cache.dto.CachedReplyData;
import cn.kinyun.scrm.vip.cache.dto.MatchedResult;
import cn.kinyun.scrm.vip.cache.service.KeywordCache;
import cn.kinyun.scrm.vip.cache.service.VersionedCache;
import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKeywordCache<T>
extends VersionedCache
implements KeywordCache<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractKeywordCache.class);
    protected Map<T, CachedReplyData> cachedReplyData = Maps.newConcurrentMap();

    @Override
    public Map<T, CachedReplyData> getCache() {
        return this.cachedReplyData;
    }

    @Override
    public CachedReplyData getCache(T key) {
        return this.cachedReplyData.get(key);
    }

    @Override
    public MatchedResult match(T key, String message) {
        log.info("Matching {} keyword with key:{}, text:{}", new Object[]{this.getClass().getSimpleName(), key, message});
        CachedReplyData cache = this.cachedReplyData.get(key);
        if (cache == null) {
            log.info("Cache not found for {} key:{}", (Object)this.getClass().getSimpleName(), key);
            return MatchedResult.EMPTY;
        }
        return cache.match(message);
    }
}

