/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.cache.dto;

import cn.kinyun.scrm.vip.cache.dto.CachedReplyMsg;
import java.util.Comparator;
import java.util.List;

public class WordHit {
    private String word;
    private List<CachedReplyMsg> list;
    private static final Comparator<CachedReplyMsg> ORDER_BY_UPDATE_TIME_DESC = (o1, o2) -> {
        if (o1.getUpdateTime() == null && o2.getUpdateTime() == null) {
            return 0;
        }
        if (o2.getUpdateTime() == null) {
            return -1;
        }
        if (o1.getUpdateTime() == null) {
            return 1;
        }
        return o2.getUpdateTime().compareTo(o1.getUpdateTime());
    };

    public WordHit(String word, List<CachedReplyMsg> list) {
        this.word = word;
        this.list = list;
        if (list != null && list.size() > 1) {
            list.sort(ORDER_BY_UPDATE_TIME_DESC);
        }
    }

    public CachedReplyMsg first() {
        if (this.list != null && this.list.size() > 0) {
            return this.list.get(0);
        }
        return null;
    }

    public String getWord() {
        return this.word;
    }

    public List<CachedReplyMsg> getList() {
        return this.list;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public void setList(List<CachedReplyMsg> list) {
        this.list = list;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WordHit)) {
            return false;
        }
        WordHit other = (WordHit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$word = this.getWord();
        String other$word = other.getWord();
        if (this$word == null ? other$word != null : !this$word.equals(other$word)) {
            return false;
        }
        List<CachedReplyMsg> this$list = this.getList();
        List<CachedReplyMsg> other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WordHit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $word = this.getWord();
        result = result * 59 + ($word == null ? 43 : $word.hashCode());
        List<CachedReplyMsg> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    public String toString() {
        return "WordHit(word=" + this.getWord() + ", list=" + this.getList() + ")";
    }
}

